/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.util.AccumulatorV2;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class AccumulatorContext$
implements Logging {
    public static final AccumulatorContext$ MODULE$ = new AccumulatorContext$();
    private static final ConcurrentHashMap<Object, WeakReference<AccumulatorV2<?, ?>>> originals;
    private static final AtomicLong nextId;
    private static final Some<Object> someOfMinusOne;
    private static final Some<Object> someOfZero;
    private static final String SQL_ACCUM_IDENTIFIER;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        originals = new ConcurrentHashMap();
        nextId = new AtomicLong(0L);
        someOfMinusOne = new Some((Object)BoxesRunTime.boxToLong((long)-1L));
        someOfZero = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        SQL_ACCUM_IDENTIFIER = "sql";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentHashMap<Object, WeakReference<AccumulatorV2<?, ?>>> originals() {
        return originals;
    }

    public long newId() {
        return nextId.getAndIncrement();
    }

    public int numAccums() {
        return this.originals().size();
    }

    public void register(AccumulatorV2<?, ?> a) {
        this.originals().putIfAbsent(BoxesRunTime.boxToLong((long)a.id()), new WeakReference(a));
    }

    public void remove(long id) {
        this.originals().remove(BoxesRunTime.boxToLong((long)id));
    }

    public Option<AccumulatorV2<?, ?>> get(long id) {
        AccumulatorV2 acc;
        block1: {
            WeakReference<AccumulatorV2<?, ?>> ref = this.originals().get(BoxesRunTime.boxToLong((long)id));
            if (ref == null) {
                return None$.MODULE$;
            }
            acc = (AccumulatorV2)ref.get();
            if (acc != null) break block1;
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to access garbage collected accumulator "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.ACCUMULATOR_ID$.MODULE$, (Object)BoxesRunTime.boxToLong((long)id))})))));
        }
        return Option$.MODULE$.apply((Object)acc);
    }

    public void clear() {
        this.originals().clear();
    }

    public Option<Object> internOption(Option<Object> value) {
        boolean bl = false;
        Some some = null;
        Option<Object> option = value;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Object object = some.value();
            if (BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)0L), (Object)object)) {
                return someOfZero;
            }
        }
        if (bl) {
            Object object = some.value();
            if (BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)object)) {
                return someOfMinusOne;
            }
        }
        return value;
    }

    public String SQL_ACCUM_IDENTIFIER() {
        return SQL_ACCUM_IDENTIFIER;
    }

    private AccumulatorContext$() {
    }
}

