/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class HealthTracker$
implements Logging {
    public static final HealthTracker$ MODULE$ = new HealthTracker$();
    private static final String DEFAULT_TIMEOUT;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DEFAULT_TIMEOUT = "1h";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Clock $lessinit$greater$default$4() {
        return new SystemClock();
    }

    private String DEFAULT_TIMEOUT() {
        return DEFAULT_TIMEOUT;
    }

    public boolean isExcludeOnFailureEnabled(SparkConf conf) {
        Option option = ((Option)conf.get(package$.MODULE$.EXCLUDE_ON_FAILURE_ENABLED_APPLICATION())).orElse((Function0 & Serializable)() -> (Option)conf.get(package$.MODULE$.EXCLUDE_ON_FAILURE_ENABLED()));
        if (option instanceof Some) {
            Some some = (Some)option;
            boolean enabled = BoxesRunTime.unboxToBoolean((Object)some.value());
            return enabled;
        }
        if (None$.MODULE$.equals(option)) {
            String legacyKey = package$.MODULE$.EXCLUDE_ON_FAILURE_LEGACY_TIMEOUT_CONF().key();
            return ((Option)conf.get(package$.MODULE$.EXCLUDE_ON_FAILURE_LEGACY_TIMEOUT_CONF())).exists((Function1)(JFunction1.mcZJ.sp & Serializable)legacyTimeout -> {
                if (legacyTimeout == 0L) {
                    MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Turning off excludeOnFailure due to legacy configuration: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " == 0"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG$.MODULE$, (Object)legacyKey)})))));
                    return false;
                }
                MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Turning on excludeOnFailure due to legacy configuration: "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " > 0"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG$.MODULE$, (Object)legacyKey)})))));
                return true;
            });
        }
        throw new MatchError((Object)option);
    }

    public long getExcludeOnFailureTimeout(SparkConf conf) {
        return BoxesRunTime.unboxToLong((Object)((Option)conf.get(package$.MODULE$.EXCLUDE_ON_FAILURE_TIMEOUT_CONF())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)((Option)conf.get(package$.MODULE$.EXCLUDE_ON_FAILURE_LEGACY_TIMEOUT_CONF())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> Utils$.MODULE$.timeStringAsMs(MODULE$.DEFAULT_TIMEOUT())))));
    }

    public void validateExcludeOnFailureConfs(SparkConf conf) {
        new .colon.colon(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_EXECUTOR(), (List)new .colon.colon(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE(), (List)new .colon.colon(package$.MODULE$.MAX_FAILURES_PER_EXEC_STAGE(), (List)new .colon.colon(package$.MODULE$.MAX_FAILED_EXEC_PER_NODE_STAGE(), (List)new .colon.colon(package$.MODULE$.MAX_FAILURES_PER_EXEC(), (List)new .colon.colon(package$.MODULE$.MAX_FAILED_EXEC_PER_NODE(), (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable)config -> {
            HealthTracker$.$anonfun$validateExcludeOnFailureConfs$1(conf, config);
            return BoxedUnit.UNIT;
        });
        long timeout = this.getExcludeOnFailureTimeout(conf);
        if (timeout <= 0L) {
            Option option = (Option)conf.get(package$.MODULE$.EXCLUDE_ON_FAILURE_TIMEOUT_CONF());
            if (option instanceof Some) {
                HealthTracker$.mustBePos$1(package$.MODULE$.EXCLUDE_ON_FAILURE_TIMEOUT_CONF().key(), Long.toString(timeout));
            } else if (None$.MODULE$.equals(option)) {
                HealthTracker$.mustBePos$1(package$.MODULE$.EXCLUDE_ON_FAILURE_LEGACY_TIMEOUT_CONF().key(), Long.toString(timeout));
            } else {
                throw new MatchError((Object)option);
            }
        }
        int maxTaskFailures = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.TASK_MAX_FAILURES()));
        int maxNodeAttempts = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE()));
        if (maxNodeAttempts >= maxTaskFailures) {
            throw new IllegalArgumentException(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE().key() + " ( = " + maxNodeAttempts + ") was >= " + package$.MODULE$.TASK_MAX_FAILURES().key() + " ( = " + maxTaskFailures + " ). Though excludeOnFailure is enabled, with this configuration, Spark will not be robust to one bad node. Decrease " + package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE().key() + ", increase " + package$.MODULE$.TASK_MAX_FAILURES().key() + ", or disable excludeOnFailure with " + package$.MODULE$.EXCLUDE_ON_FAILURE_ENABLED().key());
        }
    }

    private static final void mustBePos$1(String k, String v) {
        throw new IllegalArgumentException(k + " was " + v + ", but must be > 0.");
    }

    public static final /* synthetic */ void $anonfun$validateExcludeOnFailureConfs$1(SparkConf conf$3, ConfigEntry config) {
        int v = BoxesRunTime.unboxToInt(conf$3.get(config));
        if (v <= 0) {
            HealthTracker$.mustBePos$1(config.key(), Integer.toString(v));
            return;
        }
    }

    private HealthTracker$() {
    }
}

