/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.io;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Locale;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.LZ4CompressionCodec;
import org.apache.spark.io.LZFCompressionCodec;
import org.apache.spark.io.SnappyCompressionCodec;
import org.apache.spark.io.ZStdCompressionCodec;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class CompressionCodec$ {
    public static final CompressionCodec$ MODULE$ = new CompressionCodec$();
    private static final String LZ4 = "lz4";
    private static final String LZF = "lzf";
    private static final String SNAPPY = "snappy";
    private static final String ZSTD = "zstd";
    private static final Map<String, String> shortCompressionCodecNames = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.LZ4()), (Object)LZ4CompressionCodec.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.LZF()), (Object)LZFCompressionCodec.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.SNAPPY()), (Object)SnappyCompressionCodec.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.ZSTD()), (Object)ZStdCompressionCodec.class.getName())}));
    private static final String FALLBACK_COMPRESSION_CODEC = MODULE$.SNAPPY();
    private static final Seq<String> ALL_COMPRESSION_CODECS = MODULE$.shortCompressionCodecNames().values().toSeq();

    public boolean supportsConcatenationOfSerializedStreams(CompressionCodec codec) {
        return codec instanceof SnappyCompressionCodec || codec instanceof LZFCompressionCodec || codec instanceof LZ4CompressionCodec || codec instanceof ZStdCompressionCodec;
    }

    public String LZ4() {
        return LZ4;
    }

    public String LZF() {
        return LZF;
    }

    public String SNAPPY() {
        return SNAPPY;
    }

    public String ZSTD() {
        return ZSTD;
    }

    public Map<String, String> shortCompressionCodecNames() {
        return shortCompressionCodecNames;
    }

    public String getCodecName(SparkConf conf) {
        return conf.get(package$.MODULE$.IO_COMPRESSION_CODEC());
    }

    public CompressionCodec createCodec(SparkConf conf) {
        return this.createCodec(conf, this.getCodecName(conf));
    }

    public CompressionCodec createCodec(SparkConf conf, String codecName) {
        None$ none$;
        String codecClass = (String)this.shortCompressionCodecNames().getOrElse((Object)codecName.toLowerCase(Locale.ROOT), (Function0 & Serializable)() -> codecName);
        try {
            Constructor ctor = Utils$.MODULE$.classForName(codecClass, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructor(SparkConf.class);
            none$ = new Some(ctor.newInstance(conf));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof IllegalArgumentException) {
                none$ = None$.MODULE$;
            }
            throw throwable;
        }
        None$ codec = none$;
        return (CompressionCodec)codec.getOrElse((Function0 & Serializable)() -> {
            throw SparkCoreErrors$.MODULE$.codecNotAvailableError(codecName);
        });
    }

    public String getShortName(String codecName) {
        String lowercasedCodec = codecName.toLowerCase(Locale.ROOT);
        if (this.shortCompressionCodecNames().contains((Object)lowercasedCodec)) {
            return lowercasedCodec;
        }
        return (String)this.shortCompressionCodecNames().collectFirst((PartialFunction)new Serializable(codecName){
            private static final long serialVersionUID = 0L;
            private final String codecName$2;

            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String v;
                    String k = (String)A1._1();
                    String string = v = (String)A1._2();
                    String string2 = this.codecName$2;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return (B1)k;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                Tuple2<String, String> tuple2 = x1;
                if (tuple2 != null) {
                    String v;
                    String string = v = (String)tuple2._2();
                    String string2 = this.codecName$2;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.codecName$2 = codecName$2;
            }
        }).getOrElse((Function0 & Serializable)() -> {
            throw new SparkIllegalArgumentException("CODEC_SHORT_NAME_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"codecName"), (Object)codecName)})));
        });
    }

    public String FALLBACK_COMPRESSION_CODEC() {
        return FALLBACK_COMPRESSION_CODEC;
    }

    public Seq<String> ALL_COMPRESSION_CODECS() {
        return ALL_COMPRESSION_CODECS;
    }

    private CompressionCodec$() {
    }
}

