/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.CompactedEventLogFileWriter;
import org.apache.spark.deploy.history.CompactionResult;
import org.apache.spark.deploy.history.CompactionResultCode$;
import org.apache.spark.deploy.history.EventFilter;
import org.apache.spark.deploy.history.EventFilter$;
import org.apache.spark.deploy.history.EventFilterBuilder;
import org.apache.spark.deploy.history.EventLogFileReader$;
import org.apache.spark.deploy.history.EventLogFileWriter$;
import org.apache.spark.deploy.history.RollingEventLogFilesWriter$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.scheduler.ReplayListenerBus;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.util.JsonProtocol;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\t\u0012\u0001qA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\"B#\u0001\t\u00031\u0005b\u0002(\u0001\u0005\u0004%Ia\u0014\u0005\u0007-\u0002\u0001\u000b\u0011\u0002)\t\u000b]\u0003A\u0011\u0001-\t\u000b5\u0004A\u0011\u00028\t\u000bM\u0004A\u0011\u0002;\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004!A\u00111\u0006\u0001\u0005\u0002E\ti\u0003C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V\t)RI^3oi2{wMR5mK\u000e{W\u000e]1di>\u0014(B\u0001\n\u0014\u0003\u001dA\u0017n\u001d;pefT!\u0001F\u000b\u0002\r\u0011,\u0007\u000f\\8z\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\n\u0004\u0001u\u0019\u0003C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g\r\u0005\u0002%O5\tQE\u0003\u0002'+\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002)K\t9Aj\\4hS:<\u0017!C:qCJ\\7i\u001c8g!\tYC&D\u0001\u0016\u0013\tiSCA\u0005Ta\u0006\u00148nQ8oM\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u0005A*T\"A\u0019\u000b\u0005I\u001a\u0014\u0001B2p]\u001aT!\u0001N\f\u0002\r!\fGm\\8q\u0013\t1\u0014GA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0003MN\u0004\"!O\u001e\u000e\u0003iR!aN\u001a\n\u0005qR$A\u0003$jY\u0016\u001c\u0016p\u001d;f[\u0006\u0001R.\u0019=GS2,7\u000fV8SKR\f\u0017N\u001c\t\u0003=}J!\u0001Q\u0010\u0003\u0007%sG/\u0001\rd_6\u0004\u0018m\u0019;j_:$\u0006N]3tQ>dGmU2pe\u0016\u0004\"AH\"\n\u0005\u0011{\"A\u0002#pk\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0007\u000f&S5\nT'\u0011\u0005!\u0003Q\"A\t\t\u000b%2\u0001\u0019\u0001\u0016\t\u000b92\u0001\u0019A\u0018\t\u000b]2\u0001\u0019\u0001\u001d\t\u000bu2\u0001\u0019\u0001 \t\u000b\u00053\u0001\u0019\u0001\"\u0002\u0019)\u001cxN\u001c)s_R|7m\u001c7\u0016\u0003A\u0003\"!\u0015+\u000e\u0003IS!aU\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003+J\u0013ABS:p]B\u0013x\u000e^8d_2\fQB[:p]B\u0013x\u000e^8d_2\u0004\u0013aB2p[B\f7\r\u001e\u000b\u00033r\u0003\"\u0001\u0013.\n\u0005m\u000b\"\u0001E\"p[B\f7\r^5p]J+7/\u001e7u\u0011\u0015i\u0016\u00021\u0001_\u00035)g/\u001a8u\u0019><g)\u001b7fgB\u0019ql\u001a6\u000f\u0005\u0001,gBA1e\u001b\u0005\u0011'BA2\u001c\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002g?\u00059\u0001/Y2lC\u001e,\u0017B\u00015j\u0005\r\u0019V-\u001d\u0006\u0003M~\u0001\"!O6\n\u00051T$A\u0003$jY\u0016\u001cF/\u0019;vg\u0006\u0011\u0012m]:feR\u0004&/Z2p]\u0012LG/[8o)\ty'\u000f\u0005\u0002\u001fa&\u0011\u0011o\b\u0002\u0005+:LG\u000fC\u0003^\u0015\u0001\u0007a,\u0001\nj]&$\u0018.\u00197ju\u0016\u0014U/\u001b7eKJ\u001cHcA;zuB\u0019ql\u001a<\u0011\u0005!;\u0018B\u0001=\u0012\u0005I)e/\u001a8u\r&dG/\u001a:Ck&dG-\u001a:\t\u000b]Z\u0001\u0019\u0001\u001d\t\u000bm\\\u0001\u0019\u0001?\u0002\u000b\u0019LG.Z:\u0011\u0007};W\u0010\u0005\u0002:}&\u0011qP\u000f\u0002\u0005!\u0006$\b.\u0001\bdC2\u001cW\u000f\\1uKN\u001bwN]3\u0015\u0007\t\u000b)\u0001C\u0004\u0002\b1\u0001\r!!\u0003\u0002\u000bM$\u0018\r^:\u0011\t\u0005-\u0011Q\u0005\b\u0005\u0003\u001b\t\tC\u0004\u0003\u0002\u0010\u0005}a\u0002BA\t\u0003;qA!a\u0005\u0002\u001c9!\u0011QCA\r\u001d\r\t\u0017qC\u0005\u00025%\u0011\u0001$G\u0005\u0003-]I!\u0001F\u000b\n\u0005I\u0019\u0012bAA\u0012#\u0005YQI^3oi\u001aKG\u000e^3s\u0013\u0011\t9#!\u000b\u0003!\u0019KG\u000e^3s'R\fG/[:uS\u000e\u001c(bAA\u0012#\u00059!/Z<sSR,GCBA\u0018\u0003\u007f\tY\u0005\u0005\u0003\u00022\u0005eb\u0002BA\u001a\u0003k\u0001\"!Y\u0010\n\u0007\u0005]r$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003w\tiD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003oy\u0002bBA!\u001b\u0001\u0007\u00111I\u0001\bM&dG/\u001a:t!\u0011yv-!\u0012\u0011\u0007!\u000b9%C\u0002\u0002JE\u00111\"\u0012<f]R4\u0015\u000e\u001c;fe\")Q,\u0004a\u0001=\u0006)2\r\\3b]V\u00048i\\7qC\u000e$X\r\u001a$jY\u0016\u001cHcA8\u0002R!)1P\u0004a\u0001=\u0006\u0011b-\u001b8e\r&dWm\u001d+p\u0007>l\u0007/Y2u)\rq\u0016q\u000b\u0005\u0006;>\u0001\rA\u0018")
public class EventLogFileCompactor
implements Logging {
    private final SparkConf sparkConf;
    private final Configuration hadoopConf;
    private final FileSystem fs;
    private final int maxFilesToRetain;
    private final double compactionThresholdScore;
    private final JsonProtocol jsonProtocol;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private JsonProtocol jsonProtocol() {
        return this.jsonProtocol;
    }

    public CompactionResult compact(Seq<FileStatus> eventLogFiles) {
        this.assertPrecondition(eventLogFiles);
        if (eventLogFiles.length() < this.maxFilesToRetain) {
            return new CompactionResult(CompactionResultCode$.MODULE$.NOT_ENOUGH_FILES(), (Option<Object>)None$.MODULE$);
        }
        Seq<FileStatus> filesToCompact = this.findFilesToCompact(eventLogFiles);
        if (filesToCompact.isEmpty()) {
            return new CompactionResult(CompactionResultCode$.MODULE$.NOT_ENOUGH_FILES(), (Option<Object>)None$.MODULE$);
        }
        Seq<EventFilterBuilder> builders = this.initializeBuilders(this.fs, (Seq<Path>)((Seq)filesToCompact.map((Function1 & Serializable)x$1 -> x$1.getPath())));
        Seq filters = (Seq)builders.map((Function1 & Serializable)x$2 -> x$2.createFilter());
        double minScore = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)filters.flatMap((Function1 & Serializable)x$3 -> x$3.statistics())).map((Function1 & Serializable)stats -> BoxesRunTime.boxToDouble((double)this.calculateScore(stats)))).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
        if (minScore < this.compactionThresholdScore) {
            return new CompactionResult(CompactionResultCode$.MODULE$.LOW_SCORE_FOR_COMPACTION(), (Option<Object>)None$.MODULE$);
        }
        this.rewrite((Seq<EventFilter>)filters, filesToCompact);
        this.cleanupCompactedFiles(filesToCompact);
        return new CompactionResult(CompactionResultCode$.MODULE$.SUCCESS(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)RollingEventLogFilesWriter$.MODULE$.getEventLogFileIndex(((FileStatus)filesToCompact.last()).getPath().getName()))));
    }

    private void assertPrecondition(Seq<FileStatus> eventLogFiles) {
        Seq idxCompactedFiles = (Seq)((IterableOps)eventLogFiles.zipWithIndex()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EventLogFileCompactor.$anonfun$assertPrecondition$1(x0$1)));
        Predef$.MODULE$.require(idxCompactedFiles.size() < 2 && idxCompactedFiles.headOption().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)EventLogFileCompactor.$anonfun$assertPrecondition$2(x$4))), (Function0 & Serializable)() -> "The number of compact files should be at most 1, and should be placed first if exists.");
    }

    private Seq<EventFilterBuilder> initializeBuilders(FileSystem fs, Seq<Path> files) {
        ReplayListenerBus bus = new ReplayListenerBus(this.jsonProtocol());
        Seq builders = CollectionConverters$.MODULE$.IterableHasAsScala(ServiceLoader.load(EventFilterBuilder.class, Utils$.MODULE$.getContextOrSparkClassLoader())).asScala().toSeq();
        builders.foreach((Function1 & Serializable)listener -> {
            bus.addListener(listener);
            return BoxedUnit.UNIT;
        });
        files.foreach((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)EventLogFileCompactor.$anonfun$initializeBuilders$2(fs, bus, log)));
        return builders;
    }

    private double calculateScore(EventFilter.FilterStatistics stats) {
        return (double)(stats.totalTasks() - stats.liveTasks()) * 1.0 / (double)stats.totalTasks();
    }

    public String rewrite(Seq<EventFilter> filters, Seq<FileStatus> eventLogFiles) {
        Predef$.MODULE$.require(eventLogFiles.nonEmpty());
        Path lastIndexEventLogPath = ((FileStatus)eventLogFiles.last()).getPath();
        CompactedEventLogFileWriter logWriter = new CompactedEventLogFileWriter(lastIndexEventLogPath, "dummy", (Option<String>)None$.MODULE$, lastIndexEventLogPath.getParent().toUri(), this.sparkConf, this.hadoopConf);
        long startTime = System.currentTimeMillis();
        logWriter.start();
        eventLogFiles.foreach((Function1 & Serializable)file -> {
            EventFilter$.MODULE$.applyFilterToFile(this.fs, (Seq<EventFilter>)filters, file.getPath(), this.jsonProtocol(), (Function2<String, SparkListenerEvent, BoxedUnit>)(Function2 & Serializable)(line, x$5) -> {
                logWriter$1.writeEvent(line, true);
                return BoxedUnit.UNIT;
            }, (Function2<String, SparkListenerEvent, BoxedUnit>)(Function2 & Serializable)(x$6, x$7) -> {
                EventLogFileCompactor.$anonfun$rewrite$3(x$6, x$7);
                return BoxedUnit.UNIT;
            }, (Function1<String, BoxedUnit>)(Function1 & Serializable)line -> {
                logWriter$1.writeEvent(line, true);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        logWriter.stop();
        long duration = System.currentTimeMillis() - startTime;
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Finished rewriting eventLog files to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)logWriter.logPath())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" took ", " ms."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TOTAL_TIME$.MODULE$, (Object)BoxesRunTime.boxToLong((long)duration))})))));
        return logWriter.logPath();
    }

    private void cleanupCompactedFiles(Seq<FileStatus> files) {
        files.foreach((Function1 & Serializable)file -> {
            EventLogFileCompactor.$anonfun$cleanupCompactedFiles$1(this, file);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<FileStatus> findFilesToCompact(Seq<FileStatus> eventLogFiles) {
        int numNormalEventLogFiles;
        int n = numNormalEventLogFiles = EventLogFileWriter$.MODULE$.isCompacted(((FileStatus)eventLogFiles.head()).getPath()) ? eventLogFiles.length() - 1 : eventLogFiles.length();
        if (numNormalEventLogFiles > this.maxFilesToRetain) {
            return (Seq)eventLogFiles.dropRight(this.maxFilesToRetain);
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static final /* synthetic */ boolean $anonfun$assertPrecondition$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            FileStatus file = (FileStatus)tuple2._1();
            return EventLogFileWriter$.MODULE$.isCompacted(file.getPath());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$assertPrecondition$2(Tuple2 x$4) {
        return x$4._2$mcI$sp() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$initializeBuilders$2(FileSystem fs$1, ReplayListenerBus bus$1, Path log) {
        return BoxesRunTime.unboxToBoolean(Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> EventLogFileReader$.MODULE$.openEventLog(log, fs$1), (Function1 & Serializable)in -> BoxesRunTime.boxToBoolean((boolean)bus$1.replay(in, log.getName(), bus$1.replay$default$3(), bus$1.replay$default$4()))));
    }

    public static final /* synthetic */ void $anonfun$rewrite$3(String x$6, SparkListenerEvent x$7) {
    }

    public static final /* synthetic */ void $anonfun$cleanupCompactedFiles$1(EventLogFileCompactor $this, FileStatus file) {
        boolean deleted = false;
        try {
            deleted = $this.fs.delete(file.getPath(), true);
        }
        catch (IOException iOException) {}
        if (!deleted) {
            $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to remove ", " / skip removing."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)file.getPath())}))));
            return;
        }
    }

    public EventLogFileCompactor(SparkConf sparkConf, Configuration hadoopConf, FileSystem fs, int maxFilesToRetain, double compactionThresholdScore) {
        this.sparkConf = sparkConf;
        this.hadoopConf = hadoopConf;
        this.fs = fs;
        this.maxFilesToRetain = maxFilesToRetain;
        this.compactionThresholdScore = compactionThresholdScore;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(maxFilesToRetain > 0, (Function0 & Serializable)() -> "Max event log files to retain should be higher than 0.");
        this.jsonProtocol = new JsonProtocol(sparkConf);
    }
}

