/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.ui.JettyUtils$;
import org.apache.spark.ui.WebUI;
import org.apache.spark.util.logging.RollingFileAppender$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class Utils$
implements Logging {
    public static final Utils$ MODULE$ = new Utils$();
    private static final int DEFAULT_BYTES;
    private static final Set<String> SUPPORTED_LOG_TYPES;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DEFAULT_BYTES = 102400;
        SUPPORTED_LOG_TYPES = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"stderr", "stdout", "out"}));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int DEFAULT_BYTES() {
        return DEFAULT_BYTES;
    }

    public Set<String> SUPPORTED_LOG_TYPES() {
        return SUPPORTED_LOG_TYPES;
    }

    public void addRenderLogHandler(WebUI page, SparkConf conf) {
        page.attachHandler(JettyUtils$.MODULE$.createServletHandler("/log", JettyUtils$.MODULE$.textResponderToServlet((Function1<HttpServletRequest, String>)(Function1 & Serializable)request -> MODULE$.renderLog((HttpServletRequest)request, conf)), conf, JettyUtils$.MODULE$.createServletHandler$default$4()));
    }

    private String renderLog(HttpServletRequest request, SparkConf conf) {
        int byteLength;
        Option offset;
        String logType;
        String logDir = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"SPARK_LOG_DIR", (Function0 & Serializable)() -> "logs/");
        Tuple4<String, Object, Object, Object> tuple4 = this.getLog(conf, logDir, logType = request.getParameter("logType"), (Option<Object>)(offset = Option$.MODULE$.apply((Object)request.getParameter("offset")).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$1))))), byteLength = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)request.getParameter("byteLength")).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> MODULE$.DEFAULT_BYTES())));
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        String logText = (String)tuple4._1();
        long startByte = BoxesRunTime.unboxToLong((Object)tuple4._2());
        long endByte = BoxesRunTime.unboxToLong((Object)tuple4._3());
        long logLength = BoxesRunTime.unboxToLong((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)logText, (Object)BoxesRunTime.boxToLong((long)startByte), (Object)BoxesRunTime.boxToLong((long)endByte), (Object)BoxesRunTime.boxToLong((long)logLength));
        String logText2 = (String)tuple42._1();
        long startByte2 = BoxesRunTime.unboxToLong((Object)tuple42._2());
        long endByte2 = BoxesRunTime.unboxToLong((Object)tuple42._3());
        long logLength2 = BoxesRunTime.unboxToLong((Object)tuple42._4());
        String pre = "==== Bytes " + startByte2 + "-" + endByte2 + " of " + logLength2 + " of " + logDir + logType + " ====\n";
        return pre + logText2;
    }

    public Tuple4<String, Object, Object, Object> getLog(SparkConf conf, String logDirectory, String logType, Option<Object> offsetOption, int byteLength) {
        Tuple4 tuple4;
        if (!this.SUPPORTED_LOG_TYPES().contains((Object)logType)) {
            return new Tuple4((Object)("Error: Log type must be one of " + this.SUPPORTED_LOG_TYPES().mkString(", ")), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L));
        }
        try {
            String string;
            if (logType.equals("out")) {
                URI normalizedUri = new File(logDirectory).toURI().normalize();
                File normalizedLogDir = new File(normalizedUri.getPath());
                string = (String)ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])normalizedLogDir.listFiles()), (Function1 & Serializable)x$4 -> x$4.getName(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.endsWith(".out"))))).getOrElse((Function0 & Serializable)() -> logType);
            } else {
                string = logType;
            }
            String fileName = string;
            Seq<File> files = RollingFileAppender$.MODULE$.getSortedRolledOverFiles(logDirectory, fileName);
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Sorted log files of type " + logType + " in " + logDirectory + ":\n" + files.mkString("\n"));
            Seq fileLengths = (Seq)files.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)org.apache.spark.util.Utils$.MODULE$.getFileLength(x$6, conf)));
            long totalLength = BoxesRunTime.unboxToLong((Object)fileLengths.sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long offset = BoxesRunTime.unboxToLong((Object)offsetOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> totalLength - (long)byteLength));
            long startIndex = offset < 0L ? 0L : (offset > totalLength ? totalLength : offset);
            long endIndex = package$.MODULE$.min(startIndex + (long)byteLength, totalLength);
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Getting log from " + startIndex + " to " + endIndex);
            String logText = org.apache.spark.util.Utils$.MODULE$.offsetBytes(files, (Seq<Object>)fileLengths, startIndex, endIndex);
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Got log of length " + logText.length() + " bytes");
            tuple4 = new Tuple4((Object)logText, (Object)BoxesRunTime.boxToLong((long)startIndex), (Object)BoxesRunTime.boxToLong((long)endIndex), (Object)BoxesRunTime.boxToLong((long)totalLength));
        }
        catch (Exception e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Error getting ", " logs from "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.LOG_TYPE$.MODULE$, (Object)logType)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"directory ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PATH$.MODULE$, (Object)logDirectory)})))), (Throwable)e);
            tuple4 = new Tuple4((Object)("Error getting logs due to exception: " + e.getMessage()), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L));
        }
        return tuple4;
    }

    private Utils$() {
    }
}

