/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Map;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.RuntimeEnhancer;
import org.datanucleus.util.CommandLine;

public class DataNucleusClassFileTransformer
implements ClassFileTransformer {
    protected RuntimeEnhancer enhancer;
    private CommandLine cmd = new CommandLine();

    public DataNucleusClassFileTransformer(String arguments, Map contextProps) {
        String val;
        String api;
        this.cmd.addOption("api", "api", "api", "api");
        this.cmd.addOption("generatePK", "generatePK", "<generate-pk>", "Generate PK class where needed?");
        this.cmd.addOption("generateConstructor", "generateConstructor", "<generate-constructor>", "Generate default constructor where needed?");
        this.cmd.addOption("detachListener", "detachListener", "<detach-listener>", "Use Detach Listener?");
        if (arguments != null) {
            this.cmd.parse(arguments.split("[\\s,=]+"));
        }
        String string = api = this.cmd.getOptionArg("api") != null ? this.cmd.getOptionArg("api") : null;
        if (api == null) {
            api = "JDO";
            DataNucleusEnhancer.LOGGER.debug("ClassFileTransformer API not specified so falling back to JDO. You should specify '-api={API}' when specifying the javaagent");
        }
        this.enhancer = new RuntimeEnhancer(api, contextProps);
        if (this.cmd.hasOption("generateConstructor") && (val = this.cmd.getOptionArg("generateConstructor")).equalsIgnoreCase("false")) {
            this.enhancer.unsetClassEnhancerOption("generate-default-constructor");
        }
        if (this.cmd.hasOption("generatePK") && (val = this.cmd.getOptionArg("generatePK")).equalsIgnoreCase("false")) {
            this.enhancer.unsetClassEnhancerOption("generate-primary-key");
        }
        if (this.cmd.hasOption("detachListener") && (val = this.cmd.getOptionArg("detachListener")).equalsIgnoreCase("true")) {
            this.enhancer.setClassEnhancerOption("generate-detach-listener");
        }
    }

    public static void premain(String agentArguments, Instrumentation instrumentation) {
        instrumentation.addTransformer(new DataNucleusClassFileTransformer(agentArguments, null));
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String name = className.replace('/', '.');
        if (name.startsWith("java.")) {
            return null;
        }
        if (name.startsWith("javax.")) {
            return null;
        }
        if (name.startsWith("org.datanucleus.") && !name.startsWith("org.datanucleus.samples") && !name.startsWith("org.datanucleus.test")) {
            return null;
        }
        if (this.cmd.getDefaultArgs() != null && this.cmd.getDefaultArgs().length > 0) {
            String[] classes = this.cmd.getDefaultArgs();
            for (int i = 0; i < classes.length; ++i) {
                if (!name.startsWith(classes[i])) continue;
                return this.enhancer.enhance(name, classfileBuffer, loader);
            }
            return null;
        }
        return this.enhancer.enhance(name, classfileBuffer, loader);
    }
}

