/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog.constraints;

import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.constraints.Check;
import org.apache.spark.sql.connector.catalog.constraints.ForeignKey;
import org.apache.spark.sql.connector.catalog.constraints.PrimaryKey;
import org.apache.spark.sql.connector.catalog.constraints.Unique;
import org.apache.spark.sql.connector.expressions.NamedReference;

@Evolving
public interface Constraint {
    public String name();

    public boolean enforced();

    public ValidationStatus validationStatus();

    public boolean rely();

    public String toDDL();

    public static Check.Builder check(String name) {
        return new Check.Builder(name);
    }

    public static Unique.Builder unique(String name, NamedReference[] columns) {
        return new Unique.Builder(name, columns);
    }

    public static PrimaryKey.Builder primaryKey(String name, NamedReference[] columns) {
        return new PrimaryKey.Builder(name, columns);
    }

    public static ForeignKey.Builder foreignKey(String name, NamedReference[] columns, Identifier refTable, NamedReference[] refColumns) {
        return new ForeignKey.Builder(name, columns, refTable, refColumns);
    }

    public static enum ValidationStatus {
        VALID,
        INVALID,
        UNVALIDATED;

    }
}

