/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import javax.annotation.Nullable;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.catalog.ColumnDefaultValue;
import org.apache.spark.sql.connector.catalog.IdentityColumnSpec;
import org.apache.spark.sql.internal.connector.ColumnImpl;
import org.apache.spark.sql.types.DataType;

@Evolving
public interface Column {
    public static Column create(String name, DataType dataType) {
        return Column.create(name, dataType, true);
    }

    public static Column create(String name, DataType dataType, boolean nullable) {
        return Column.create(name, dataType, nullable, null, null);
    }

    public static Column create(String name, DataType dataType, boolean nullable, String comment, String metadataInJSON) {
        return new ColumnImpl(name, dataType, nullable, comment, null, null, null, metadataInJSON);
    }

    public static Column create(String name, DataType dataType, boolean nullable, String comment, ColumnDefaultValue defaultValue, String metadataInJSON) {
        return new ColumnImpl(name, dataType, nullable, comment, defaultValue, null, null, metadataInJSON);
    }

    public static Column create(String name, DataType dataType, boolean nullable, String comment, String generationExpression, String metadataInJSON) {
        return new ColumnImpl(name, dataType, nullable, comment, null, generationExpression, null, metadataInJSON);
    }

    public static Column create(String name, DataType dataType, boolean nullable, String comment, IdentityColumnSpec identityColumnSpec, String metadataInJSON) {
        return new ColumnImpl(name, dataType, nullable, comment, null, null, identityColumnSpec, metadataInJSON);
    }

    public String name();

    public DataType dataType();

    public boolean nullable();

    @Nullable
    public String comment();

    @Nullable
    public ColumnDefaultValue defaultValue();

    @Nullable
    public String generationExpression();

    @Nullable
    public IdentityColumnSpec identityColumnSpec();

    @Nullable
    public String metadataInJSON();
}

