/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.ToTime$;
import org.apache.spark.sql.catalyst.expressions.ToTimeParser;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.TimeType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str[, format]) - Parses the `str` expression with the `format` expression to a time.\n    If `format` is malformed or its application does not result in a well formed time, the function\n    raises an error. By default, it follows casting rules to a time if the `format` is omitted.\n  ", arguments="\n    Arguments:\n      * str - A string to be parsed to time.\n      * format - Time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n                 time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('00:12:00');\n       00:12:00\n      > SELECT _FUNC_('12.10.05', 'HH.mm.ss');\n       12:10:05\n  ", group="datetime_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\u0005eh\u0001B\u0011#\u0001>B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005a!Aq\n\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005U\u0001\tE\t\u0015!\u0003R\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015)\u0006\u0001\"\u0001[\u0011\u0015)\u0006\u0001\"\u0001^\u0011\u0015y\u0006\u0001\"\u0003a\u0011\u001d\t\b!%A\u0005\nIDq! \u0001\u0012\u0002\u0013%a\u0010C\u0005\u0002\u0002\u0001A)\u0019!C!\u001b\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0001bBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\b\u00033\u0001A\u0011IA\u000e\u0011\u001d\ti\u0002\u0001C)\u0003?A\u0011\"a\u000b\u0001\u0003\u0003%\t!!\f\t\u0013\u0005M\u0002!%A\u0005\u0002\u0005U\u0002\"CA\u001d\u0001E\u0005I\u0011AA\u001e\u0011%\ty\u0004AA\u0001\n\u0003\n\t\u0005C\u0005\u0002R\u0001\t\t\u0011\"\u0001\u0002T!I\u00111\f\u0001\u0002\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003S\u0002\u0011\u0011!C!\u0003WB\u0011\"!\u001f\u0001\u0003\u0003%\t!a\u001f\t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001d\u0005\"CAF\u0001\u0005\u0005I\u0011IAG\u000f%\t)LIA\u0001\u0012\u0003\t9L\u0002\u0005\"E\u0005\u0005\t\u0012AA]\u0011\u0019)6\u0004\"\u0001\u0002R\"I\u00111[\u000e\u0002\u0002\u0013\u0015\u0013Q\u001b\u0005\n\u0003/\\\u0012\u0011!CA\u00033D\u0011\"a8\u001c\u0003\u0003%\t)!9\t\u0013\u0005=8$!A\u0005\n\u0005E(A\u0002+p)&lWM\u0003\u0002$I\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)c%\u0001\u0005dCR\fG._:u\u0015\t9\u0003&A\u0002tc2T!!\u000b\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u0005-b\u0013AB1qC\u000eDWMC\u0001.\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\u0007N\u001c;\u0001B\u0011\u0011GM\u0007\u0002E%\u00111G\t\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u00196\u0013\t1$E\u0001\nSk:$\u0018.\\3SKBd\u0017mY3bE2,\u0007CA\u00199\u0013\tI$EA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002B\u0013:\u0011!i\u0012\b\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b:\na\u0001\u0010:p_Rt\u0014\"A\u001f\n\u0005!c\u0014a\u00029bG.\fw-Z\u0005\u0003\u0015.\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0013\u001f\u0002\u0007M$(/F\u00011\u0003\u0011\u0019HO\u001d\u0011\u0002\r\u0019|'/\\1u+\u0005\t\u0006cA\u001eSa%\u00111\u000b\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u000f\u0019|'/\\1uA\u00051A(\u001b8jiz\"2a\u0016-Z!\t\t\u0004\u0001C\u0003M\u000b\u0001\u0007\u0001\u0007C\u0003P\u000b\u0001\u0007\u0011\u000bF\u0002X7rCQ\u0001\u0014\u0004A\u0002ABQa\u0014\u0004A\u0002A\"\"a\u00160\t\u000b1;\u0001\u0019\u0001\u0019\u0002\u0019%tgo\\6f!\u0006\u00148/\u001a:\u0015\u0007A\nG\u000eC\u0004c\u0011A\u0005\t\u0019A2\u0002\u0007\u0019lG\u000fE\u0002<%\u0012\u0004\"!Z5\u000f\u0005\u0019<\u0007CA\"=\u0013\tAG(\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u00015=\u0011\u001di\u0007\u0002%AA\u00029\f\u0011\"\u0019:hk6,g\u000e^:\u0011\u0007\u0005{\u0007'\u0003\u0002q\u0017\n\u00191+Z9\u0002-%tgo\\6f!\u0006\u00148/\u001a:%I\u00164\u0017-\u001e7uIE*\u0012a\u001d\u0016\u0003GR\\\u0013!\u001e\t\u0003mnl\u0011a\u001e\u0006\u0003qf\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005id\u0014AC1o]>$\u0018\r^5p]&\u0011Ap\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AF5om>\\W\rU1sg\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003}T#A\u001c;\u0002\u0017I,\u0007\u000f\\1dK6,g\u000e^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA\u0004!\u0011\tu.!\u0003\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004'\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\u0019\"!\u0004\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017A\u00039sKR$\u0018PT1nKV\tA-\u0001\u0005dQ&dGM]3o+\u0005q\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\r\u0001\u0014\u0011\u0005\u0005\b\u0003Gy\u0001\u0019AA\u0013\u0003-qWm^\"iS2$'/\u001a8\u0011\t\u0005\u000b9\u0003M\u0005\u0004\u0003SY%AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)\u00159\u0016qFA\u0019\u0011\u001da\u0005\u0003%AA\u0002ABqa\u0014\t\u0011\u0002\u0003\u0007\u0011+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005]\"F\u0001\u0019u\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u0010+\u0005E#\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002DA!\u0011QIA(\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001\u00027b]\u001eT!!!\u0014\u0002\t)\fg/Y\u0005\u0004U\u0006\u001d\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA+!\rY\u0014qK\u0005\u0004\u00033b$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA0\u0003K\u00022aOA1\u0013\r\t\u0019\u0007\u0010\u0002\u0004\u0003:L\b\"CA4+\u0005\u0005\t\u0019AA+\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u000e\t\u0007\u0003_\n)(a\u0018\u000e\u0005\u0005E$bAA:y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0014\u0011\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002~\u0005\r\u0005cA\u001e\u0002\u0000%\u0019\u0011\u0011\u0011\u001f\u0003\u000f\t{w\u000e\\3b]\"I\u0011qM\f\u0002\u0002\u0003\u0007\u0011qL\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002D\u0005%\u0005\"CA41\u0005\u0005\t\u0019AA+\u0003\u0019)\u0017/^1mgR!\u0011QPAH\u0011%\t9'GA\u0001\u0002\u0004\ty\u0006\u000b\f\u0001\u0003'\u000bI*a'n\u0003?\u000b\u0019+!*\u0002*\u0006-\u0016qVAY!\r\t\u0014QS\u0005\u0004\u0003/\u0013#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003;\u000b!q\n\u0006!A\u0001\u0002sLR+O\u0007~C3\u000f\u001e:\\Y\u00012wN]7bivK\u0003%\f\u0011QCJ\u001cXm\u001d\u0011uQ\u0016\u0004\u0003m\u001d;sA\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011xSRD\u0007\u0005\u001e5fA\u00014wN]7bi\u0002\u0004S\r\u001f9sKN\u001c\u0018n\u001c8!i>\u0004\u0013\r\t;j[\u0016t#\u0002\t\u0011!A%3\u0007\u0005\u00194pe6\fG\u000f\u0019\u0011jg\u0002j\u0017\r\u001c4pe6,G\rI8sA%$8\u000fI1qa2L7-\u0019;j_:\u0004Cm\\3tA9|G\u000f\t:fgVdG\u000fI5oA\u0005\u0004s/\u001a7mA\u0019|'/\\3eAQLW.\u001a\u0017!i\",\u0007EZ;oGRLwN\u001c\u0006!A\u0001\u0002#/Y5tKN\u0004\u0013M\u001c\u0011feJ|'O\f\u0011Cs\u0002\"WMZ1vYRd\u0003%\u001b;!M>dGn\\<tA\r\f7\u000f^5oO\u0002\u0012X\u000f\\3tAQ|\u0007%\u0019\u0011uS6,\u0007%\u001b4!i\",\u0007\u0005\u00194pe6\fG\u000f\u0019\u0011jg\u0002zW.\u001b;uK\u0012t#\u0002\t\u0011\"\u0005\u0005\u0005\u0016Aa\u0004\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aHO\u001d\u0011.A\u0005\u00033\u000f\u001e:j]\u001e\u0004Co\u001c\u0011cK\u0002\u0002\u0018M]:fI\u0002\"x\u000e\t;j[\u0016t#\u0002\t\u0011!A\u0001\u0002#\u0006\t4pe6\fG\u000fI\u0017!)&lW\r\t4pe6\fG\u000f\t9biR,'O\u001c\u0011u_\u00022w\u000e\u001c7po:\u00023+Z3!y\u0005\u0004\u0003N]3g{\tBG\u000f\u001e9tu=z3\u000f]1sW:\n\u0007/Y2iK:z'oZ\u0018e_\u000e\u001cx\u0006\\1uKN$xf]9m[I,g-\f3bi\u0016$\u0018.\\3.a\u0006$H/\u001a:o]!$X\u000e\u001c\u0012?\t\u0006$X\r^5nK\u0002\u0002\u0016\r\u001e;fe:\u001cHhL1?A\u0019|'\u000f\t<bY&$'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!i&lW\r\t4pe6\fG\u000f\t9biR,'O\\:/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u001d\u0016!a\u0002\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0002\u0004GO\u00193uA\u0002t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!aAR\u0014G\r\u001e1a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u001a/cAr\u0003'N\u0014-A\u001dB\u0005JL7n]M\u001cx%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cIR\u0014\u0007\r\u001e1k)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002.\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAZ\u0003\u0015!d&\r\u00181\u0003\u0019!v\u000eV5nKB\u0011\u0011gG\n\u00067\u0005m\u0016q\u0019\t\b\u0003{\u000b\u0019\rM)X\u001b\t\tyLC\u0002\u0002Br\nqA];oi&lW-\u0003\u0003\u0002F\u0006}&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011\u0011ZAh\u001b\t\tYM\u0003\u0003\u0002N\u0006-\u0013AA5p\u0013\rQ\u00151\u001a\u000b\u0003\u0003o\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0007\nQ!\u00199qYf$RaVAn\u0003;DQ\u0001\u0014\u0010A\u0002ABQa\u0014\u0010A\u0002E\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002d\u0006-\b\u0003B\u001eS\u0003K\u0004RaOAtaEK1!!;=\u0005\u0019!V\u000f\u001d7fe!A\u0011Q^\u0010\u0002\u0002\u0003\u0007q+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a=\u0011\t\u0005\u0015\u0013Q_\u0005\u0005\u0003o\f9E\u0001\u0004PE*,7\r\u001e")
public class ToTime
extends Expression
implements RuntimeReplaceable,
ExpectsInputTypes,
Serializable {
    private Expression replacement;
    private final Expression str;
    private final Option<Expression> format;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(ToTime x$0) {
        return ToTime$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Option<Expression>>, ToTime> tupled() {
        return ToTime$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, ToTime>> curried() {
        return ToTime$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ToTime toTime = this;
        synchronized (toTime) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression str() {
        return this.str;
    }

    public Option<Expression> format() {
        return this.format;
    }

    private Expression invokeParser(Option<String> fmt, Seq<Expression> arguments) {
        return new Invoke(Literal$.MODULE$.create(new ToTimeParser(fmt), (DataType)new ObjectType(ToTimeParser.class)), "parse", (DataType)TimeType$.MODULE$.apply(), arguments, (Seq<AbstractDataType>)((Seq)arguments.map((Function1 & Serializable)x$1 -> x$1.dataType())), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
    }

    private Option<String> invokeParser$default$1() {
        return None$.MODULE$;
    }

    private Seq<Expression> invokeParser$default$2() {
        return this.children();
    }

    private Expression replacement$lzycompute() {
        ToTime toTime = this;
        synchronized (toTime) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Some some;
                Expression expr;
                Option<Expression> option = this.format();
                this.replacement = None$.MODULE$.equals(option) ? this.invokeParser(this.invokeParser$default$1(), this.invokeParser$default$2()) : (option instanceof Some && (expr = (Expression)(some = (Some)option).value()).foldable() ? (Expression)Option$.MODULE$.apply(expr.eval(expr.eval$default$1())).map((Function1 & Serializable)f -> this.invokeParser((Option<String>)new Some((Object)f.toString()), (Seq<Expression>)new .colon.colon((Object)this.str(), (List)Nil$.MODULE$))).getOrElse((Function0 & Serializable)() -> new Literal(null, expr.dataType())) : this.invokeParser(this.invokeParser$default$1(), this.invokeParser$default$2()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$).$plus$plus((IterableOnce)this.format().map((Function1 & Serializable)x$2 -> StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3())));
    }

    @Override
    public String prettyName() {
        return "to_time";
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.str();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (this.format().isDefined()) {
            return this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()));
        }
        return this.copy((Expression)newChildren.head(), this.copy$default$2());
    }

    public ToTime copy(Expression str, Option<Expression> format) {
        return new ToTime(str, format);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    @Override
    public String productPrefix() {
        return "ToTime";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.format();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ToTime;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "format";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ToTime)) return false;
        boolean bl = true;
        if (!bl) return false;
        ToTime toTime = (ToTime)x$1;
        Expression expression = this.str();
        Expression expression2 = toTime.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = toTime.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!toTime.canEqual(this)) return false;
        return true;
    }

    public ToTime(Expression str, Option<Expression> format) {
        this.str = str;
        this.format = format;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public ToTime(Expression str, Expression format) {
        this(str, (Option<Expression>)Option$.MODULE$.apply((Object)format));
    }

    public ToTime(Expression str) {
        this(str, (Option<Expression>)None$.MODULE$);
    }
}

