/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.ExpressionBuilder;
import org.apache.spark.sql.catalyst.expressions.Base64$;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.Decode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hex;
import org.apache.spark.sql.catalyst.expressions.ToCharacter;
import org.apache.spark.sql.catalyst.plans.logical.FunctionBuilderBase;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DatetimeType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr, format) - Convert `expr` to a string based on the `format`.\n      Throws an exception if the conversion fails. The format can consist of the following\n      characters, case insensitive:\n        '0' or '9': Specifies an expected digit between 0 and 9. A sequence of 0 or 9 in the format\n          string matches a sequence of digits in the input value, generating a result string of the\n          same length as the corresponding sequence in the format string. The result string is\n          left-padded with zeros if the 0/9 sequence comprises more digits than the matching part of\n          the decimal value, starts with 0, and is before the decimal point. Otherwise, it is\n          padded with spaces.\n        '.' or 'D': Specifies the position of the decimal point (optional, only allowed once).\n        ',' or 'G': Specifies the position of the grouping (thousands) separator (,). There must be\n          a 0 or 9 to the left and right of each grouping separator.\n        '$': Specifies the location of the $ currency sign. This character may only be specified\n          once.\n        'S' or 'MI': Specifies the position of a '-' or '+' sign (optional, only allowed once at\n          the beginning or end of the format string). Note that 'S' prints '+' for positive values\n          but 'MI' prints a space.\n        'PR': Only allowed at the end of the format string; specifies that the result string will be\n          wrapped by angle brackets if the input value is negative.\n          ('<1>').\n      If `expr` is a datetime, `format` shall be a valid datetime pattern, see <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a>.\n      If `expr` is a binary, it is converted to a string in one of the formats:\n        'base64': a base 64 string.\n        'hex': a string in the hexadecimal format.\n        'utf-8': the input binary is decoded to UTF-8 string.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(454, '999');\n       454\n      > SELECT _FUNC_(454.00, '000D00');\n       454.00\n      > SELECT _FUNC_(12454, '99G999');\n       12,454\n      > SELECT _FUNC_(78.12, '$99.99');\n       $78.12\n      > SELECT _FUNC_(-12454.8, '99G999D9S');\n       12,454.8-\n      > SELECT _FUNC_(date'2016-04-08', 'y');\n       2016\n      > SELECT _FUNC_(x'537061726b2053514c', 'base64');\n       U3BhcmsgU1FM\n      > SELECT _FUNC_(x'537061726b2053514c', 'hex');\n       537061726B2053514C\n      > SELECT _FUNC_(encode('abc', 'utf-8'), 'utf-8');\n       abc\n  ", since="3.4.0", group="string_funcs")
public final class ToCharacterBuilder$
implements ExpressionBuilder {
    public static final ToCharacterBuilder$ MODULE$ = new ToCharacterBuilder$();

    static {
        FunctionBuilderBase.$init$(MODULE$);
    }

    @Override
    public Option<FunctionSignature> functionSignature() {
        return FunctionBuilderBase.functionSignature$(this);
    }

    @Override
    public Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName) {
        return FunctionBuilderBase.rearrange$(this, expectedSignature, providedArguments, functionName);
    }

    @Override
    public boolean supportsLambda() {
        return FunctionBuilderBase.supportsLambda$(this);
    }

    @Override
    public Expression build(String funcName, Seq<Expression> expressions) {
        int numArgs = expressions.length();
        if (numArgs == 2) {
            Tuple2 tuple2 = new Tuple2(expressions.apply(0), expressions.apply(1));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression inputExpr = (Expression)tuple2._1();
            Expression format = (Expression)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)inputExpr, (Object)format);
            Expression inputExpr2 = (Expression)tuple22._1();
            Expression format2 = (Expression)tuple22._2();
            DataType dataType = inputExpr2.dataType();
            if (dataType instanceof DatetimeType) {
                return new DateFormatClass(inputExpr2, format2, DateFormatClass$.MODULE$.apply$default$3());
            }
            if (dataType instanceof BinaryType) {
                if (!(format2.dataType() instanceof StringType) || !format2.foldable()) {
                    throw QueryCompilationErrors$.MODULE$.nonFoldableArgumentError(funcName, "format", format2.dataType());
                }
                Object fmt = format2.eval(format2.eval$default$1());
                if (fmt == null) {
                    throw QueryCompilationErrors$.MODULE$.nullArgumentError(funcName, "format");
                }
                String string = ((UTF8String)fmt).toString().toLowerCase(Locale.ROOT).trim();
                switch (string == null ? 0 : string.hashCode()) {
                    case -1396204209: {
                        if (!"base64".equals(string)) break;
                        return Base64$.MODULE$.apply(inputExpr2);
                    }
                    case 103195: {
                        if (!"hex".equals(string)) break;
                        return new Hex(inputExpr2);
                    }
                    case 111607186: {
                        if (!"utf-8".equals(string)) break;
                        return new Decode((Seq<Expression>)new .colon.colon((Object)inputExpr2, (List)new .colon.colon((Object)format2, (List)Nil$.MODULE$)));
                    }
                }
                throw QueryCompilationErrors$.MODULE$.binaryFormatError(funcName, string);
            }
            return new ToCharacter(inputExpr2, format2);
        }
        throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(funcName, (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}))), numArgs, QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
    }

    private ToCharacterBuilder$() {
    }
}

