/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.MessageDigestAlgorithms;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Sha2$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, bitLength) - Returns a checksum of SHA-2 family as a hex string of `expr`.\n      SHA-224, SHA-256, SHA-384, and SHA-512 are supported. Bit length of 0 is equivalent to 256.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark', 256);\n       529bc3b07127ecb7e53a4dcf1991d9152c24537d919178022b2c42657f79a26b\n  ", since="1.5.0", group="hash_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\"Aa\n\u0001BK\u0002\u0013\u0005\u0011\n\u0003\u0005P\u0001\tE\t\u0015!\u0003K\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015Q\u0006\u0001\"\u0011W\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u00151\u0007\u0001\"\u0015h\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u0015q\b\u0001\"\u0015\u0000\u0011%\tI\u0001AA\u0001\n\u0003\tY\u0001C\u0005\u0002\u0012\u0001\t\n\u0011\"\u0001\u0002\u0014!I\u0011\u0011\u0006\u0001\u0012\u0002\u0013\u0005\u00111\u0003\u0005\n\u0003W\u0001\u0011\u0011!C!\u0003[A\u0011\"a\u0010\u0001\u0003\u0003%\t!!\u0011\t\u0013\u0005%\u0003!!A\u0005\u0002\u0005-\u0003\"CA)\u0001\u0005\u0005I\u0011IA*\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j!I\u0011Q\u000e\u0001\u0002\u0002\u0013\u0005\u0013qN\u0004\n\u0003's\u0012\u0011!E\u0001\u0003+3\u0001\"\b\u0010\u0002\u0002#\u0005\u0011q\u0013\u0005\u0007!^!\t!a,\t\u0013\u0005Ev#!A\u0005F\u0005M\u0006\"CA[/\u0005\u0005I\u0011QA\\\u0011%\tilFA\u0001\n\u0003\u000by\fC\u0005\u0002R^\t\t\u0011\"\u0003\u0002T\n!1\u000b[13\u0015\ty\u0002%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0011#\u0003!\u0019\u0017\r^1msN$(BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO\u000e\u00011C\u0002\u0001-aM\nE\t\u0005\u0002.]5\ta$\u0003\u00020=\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003[EJ!A\r\u0010\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001\u000e \u000f\u0005UZdB\u0001\u001c:\u001b\u00059$B\u0001\u001d+\u0003\u0019a$o\\8u}%\t!(A\u0003tG\u0006d\u0017-\u0003\u0002={\u00059\u0001/Y2lC\u001e,'\"\u0001\u001e\n\u0005}\u0002%\u0001D*fe&\fG.\u001b>bE2,'B\u0001\u001f>!\ti#)\u0003\u0002D=\t\u0001C)\u001a4bk2$8\u000b\u001e:j]\u001e\u0004&o\u001c3vG&tw-\u0012=qe\u0016\u001c8/[8o!\t)e)D\u0001>\u0013\t9UHA\u0004Qe>$Wo\u0019;\u0002\t1,g\r^\u000b\u0002\u0015B\u0011QfS\u0005\u0003\u0019z\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2AU*U!\ti\u0003\u0001C\u0003I\u000b\u0001\u0007!\nC\u0003O\u000b\u0001\u0007!*\u0001\bok2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u0016\u0003]\u0003\"!\u0012-\n\u0005ek$a\u0002\"p_2,\u0017M\\\u0001\t]VdG.\u00192mK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003u\u00032\u0001\u000e0a\u0013\ty\u0006IA\u0002TKF\u0004\"!\u00193\u000e\u0003\tT!a\u0019\u0012\u0002\u000bQL\b/Z:\n\u0005\u0015\u0014'\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007!\\W\u000e\u0005\u0002FS&\u0011!.\u0010\u0002\u0004\u0003:L\b\"\u00027\n\u0001\u0004A\u0017AB5oaV$\u0018\u0007C\u0003o\u0013\u0001\u0007\u0001.\u0001\u0004j]B,HOM\u0001\nI><UM\\\"pI\u0016$2!]<}!\t\u0011X/D\u0001t\u0015\t!h$A\u0004d_\u0012,w-\u001a8\n\u0005Y\u001c(\u0001C#yaJ\u001cu\u000eZ3\t\u000baT\u0001\u0019A=\u0002\u0007\r$\b\u0010\u0005\u0002su&\u00111p\u001d\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u0015i(\u00021\u0001r\u0003\t)g/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR)!+!\u0001\u0002\u0006!1\u00111A\u0006A\u0002)\u000bqA\\3x\u0019\u00164G\u000f\u0003\u0004\u0002\b-\u0001\rAS\u0001\t]\u0016<(+[4ii\u0006!1m\u001c9z)\u0015\u0011\u0016QBA\b\u0011\u001dAE\u0002%AA\u0002)CqA\u0014\u0007\u0011\u0002\u0003\u0007!*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U!f\u0001&\u0002\u0018-\u0012\u0011\u0011\u0004\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003%)hn\u00195fG.,GMC\u0002\u0002$u\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9#!\b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0003\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\t1\fgn\u001a\u0006\u0003\u0003s\tAA[1wC&!\u0011QHA\u001a\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\t\t\u0004\u000b\u0006\u0015\u0013bAA${\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0001.!\u0014\t\u0013\u0005=\u0013#!AA\u0002\u0005\r\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002VA)\u0011qKA/Q6\u0011\u0011\u0011\f\u0006\u0004\u00037j\u0014AC2pY2,7\r^5p]&!\u0011qLA-\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007]\u000b)\u0007\u0003\u0005\u0002PM\t\t\u00111\u0001i\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005=\u00121\u000e\u0005\n\u0003\u001f\"\u0012\u0011!a\u0001\u0003\u0007\na!Z9vC2\u001cHcA,\u0002r!A\u0011qJ\u000b\u0002\u0002\u0003\u0007\u0001\u000eK\n\u0001\u0003k\nY(! \u0002\u0002\u0006\r\u0015qQAE\u0003\u001b\u000by\tE\u0002.\u0003oJ1!!\u001f\u001f\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a \u0002\u0003\u0007S\u0001\u0005\t\u0011!?\u001a+fjQ0)Kb\u0004(\u000f\f\u0011cSRdUM\\4uQ&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011bA\rDWmY6tk6\u0004sN\u001a\u0011T\u0011\u0006k#\u0007\t4b[&d\u0017\u0010I1tA\u0005\u0004\u0003.\u001a=!gR\u0014\u0018N\\4!_\u001a\u0004\u0003-\u001a=qe\u0002t#\u0002\t\u0011!A\u0001\u00023\u000bS!.eI\"D\u0006I*I\u00036\u0012TG\u000e\u0017!'\"\u000bUf\r\u001d5Y\u0001\ng\u000e\u001a\u0011T\u0011\u0006kS'\r\u001a!CJ,\u0007e];qa>\u0014H/\u001a3/A\tKG\u000f\t7f]\u001e$\b\u000eI8gAA\u0002\u0013n\u001d\u0011fcVLg/\u00197f]R\u0004Co\u001c\u00113kYr#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\"\u0002}*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u00159be.<C\u0006\t\u001a6m%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u000e\u001a:E\u000e\u001c$\rM\u001c2e]*7MY\u001cfkM\nG\u0007Z2gceJ\u0014\u0007Z\u001d2kI\u001a'\u0007N\u001b4o\u0011L\u0014'O\u00198qA\u0012$G\u0019\u001adiI2Tg\u000e48s\u0005\u0014dG\u0019\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111R\u0001\u0006c9*d\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003#\u000b!\u0002[1tQ~3WO\\2t\u0003\u0011\u0019\u0006.\u0019\u001a\u0011\u00055:2#B\f\u0002\u001a\u0006\u0015\u0006cBAN\u0003CS%JU\u0007\u0003\u0003;S1!a(>\u0003\u001d\u0011XO\u001c;j[\u0016LA!a)\u0002\u001e\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005\u001d\u0016QV\u0007\u0003\u0003SSA!a+\u00028\u0005\u0011\u0011n\\\u0005\u0004\u007f\u0005%FCAAK\u0003!!xn\u0015;sS:<GCAA\u0018\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0011\u0016\u0011XA^\u0011\u0015A%\u00041\u0001K\u0011\u0015q%\u00041\u0001K\u0003\u001d)h.\u00199qYf$B!!1\u0002NB)Q)a1\u0002H&\u0019\u0011QY\u001f\u0003\r=\u0003H/[8o!\u0015)\u0015\u0011\u001a&K\u0013\r\tY-\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005=7$!AA\u0002I\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t)\u000e\u0005\u0003\u00022\u0005]\u0017\u0002BAm\u0003g\u0011aa\u00142kK\u000e$\b")
public class Sha2
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable,
DefaultStringProducingExpression {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Sha2 x$0) {
        return Sha2$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, Sha2> tupled() {
        return Sha2$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Sha2>> curried() {
        return Sha2$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        int bitLength = BoxesRunTime.unboxToInt((Object)input2);
        byte[] input = (byte[])input1;
        int n = bitLength;
        switch (n) {
            case 224: {
                return UTF8String.fromString((String)new DigestUtils("SHA-224").digestAsHex(input));
            }
            case 0: 
            case 256: {
                return UTF8String.fromString((String)DigestUtils.sha256Hex((byte[])input));
            }
            case 384: {
                return UTF8String.fromString((String)DigestUtils.sha384Hex((byte[])input));
            }
            case 512: {
                return UTF8String.fromString((String)DigestUtils.sha512Hex((byte[])input));
            }
        }
        return null;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String digestUtils = DigestUtils.class.getName();
        String messageDigestAlgorithms = MessageDigestAlgorithms.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(eval1, eval2) -> "\n        if (" + eval2 + " == 224) {\n          " + ev.value() + " = UTF8String.fromString(\n                          new " + digestUtils + "(" + messageDigestAlgorithms + ".SHA_224).digestAsHex(" + eval1 + "));\n        } else if (" + eval2 + " == 256 || " + eval2 + " == 0) {\n          " + ev.value() + " =\n            UTF8String.fromString(" + digestUtils + ".sha256Hex(" + eval1 + "));\n        } else if (" + eval2 + " == 384) {\n          " + ev.value() + " =\n            UTF8String.fromString(" + digestUtils + ".sha384Hex(" + eval1 + "));\n        } else if (" + eval2 + " == 512) {\n          " + ev.value() + " =\n            UTF8String.fromString(" + digestUtils + ".sha512Hex(" + eval1 + "));\n        } else {\n          " + ev.isNull() + " = true;\n        }\n      ");
    }

    @Override
    public Sha2 withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public Sha2 copy(Expression left, Expression right) {
        return new Sha2(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Sha2";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sha2;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sha2)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sha2 sha2 = (Sha2)x$1;
        Expression expression = this.left();
        Expression expression2 = sha2.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = sha2.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sha2.canEqual(this)) return false;
        return true;
    }

    public Sha2(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
    }
}

