/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractAll$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractBase$;
import org.apache.spark.sql.catalyst.expressions.RegExpUtils$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Growable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp[, idx]) - Extract all strings in the `str` that match the `regexp`\n    expression and corresponding to the regex group index.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser, see the unescaping rules at <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#string-literal\">String Literal</a>.\n          For example, to match \"\\abc\", a regular expression for `regexp` can be \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".<br><br>\n          It's recommended to use a raw string literal (with the `r` prefix) to avoid escaping\n          special characters in the pattern string if exists.\n      * idx - an integer expression that representing the group index. The regex may contains\n          multiple groups. `idx` indicates which regex group to extract. The group index should\n          be non-negative. The minimum value of `idx` is 0, which means matching the entire\n          regular expression. If `idx` is not specified, the default group index value is 1. The\n          `idx` parameter is the Java regex Matcher group() method index.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200, 300-400', '(\\\\d+)-(\\\\d+)', 1);\n       [\"100\",\"300\"]\n      > SELECT _FUNC_('100-200, 300-400', r'(\\d+)-(\\d+)', 1);\n       [\"100\",\"300\"]\n  ", since="3.1.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mh\u0001\u0002\u0011\"\u0001:B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u00031\u0005\u0002\u0003(\u0001\u0005#\u0005\u000b\u0011B$\t\u000b=\u0003A\u0011\u0001)\t\u000b=\u0003A\u0011A+\t\u000bi\u0003A\u0011I.\t\u000b\r\u0004A\u0011\t3\t\u000b-\u0004A\u0011\t7\t\u000bU\u0004A\u0011\u000b<\t\u000f\u0005%\u0001\u0001\"\u0015\u0002\f!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00111\u0004\u0005\n\u0003G\u0001\u0011\u0013!C\u0001\u0003KA\u0011\"a\u000f\u0001#\u0003%\t!!\n\t\u0013\u0005u\u0002!%A\u0005\u0002\u0005\u0015\u0002\"CA \u0001\u0005\u0005I\u0011IA!\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019\u0006C\u0005\u0002\\\u0001\t\t\u0011\"\u0001\u0002^!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003g\u0002\u0011\u0011!C\u0001\u0003kB\u0011\"a \u0001\u0003\u0003%\t%!!\t\u0013\u0005\u0015\u0005!!A\u0005B\u0005\u001du!CAYC\u0005\u0005\t\u0012AAZ\r!\u0001\u0013%!A\t\u0002\u0005U\u0006BB(\u001b\t\u0003\ti\rC\u0005\u0002Pj\t\t\u0011\"\u0012\u0002R\"I\u00111\u001b\u000e\u0002\u0002\u0013\u0005\u0015Q\u001b\u0005\n\u0003;T\u0012\u0011!CA\u0003?D\u0011\"!=\u001b\u0003\u0003%I!a=\u0003!I+w-\u0012=q\u000bb$(/Y2u\u00032d'B\u0001\u0012$\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0011*\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001y3'\u000f\t\u0003aEj\u0011!I\u0005\u0003e\u0005\u0012\u0011CU3h\u000bb\u0004X\t\u001f;sC\u000e$()Y:f!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u000f\"\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 .\u0003\u0019a$o\\8u}%\ta'\u0003\u0002Bk\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\tU'A\u0004tk\nTWm\u0019;\u0016\u0003\u001d\u0003\"\u0001\r%\n\u0005%\u000b#AC#yaJ,7o]5p]\u0006A1/\u001e2kK\u000e$\b%\u0001\u0004sK\u001e,\u0007\u0010]\u0001\be\u0016<W\r\u001f9!\u0003\rIG\r_\u0001\u0005S\u0012D\b%\u0001\u0004=S:LGO\u0010\u000b\u0005#J\u001bF\u000b\u0005\u00021\u0001!)Qi\u0002a\u0001\u000f\")1j\u0002a\u0001\u000f\")Qj\u0002a\u0001\u000fR\u0019\u0011K\u0016-\t\u000b]C\u0001\u0019A$\u0002\u0003MDQ!\u0017\u0005A\u0002\u001d\u000b\u0011A]\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u00059~\u0003'\r\u0005\u00025;&\u0011a,\u000e\u0002\u0004\u0003:L\b\"B,\n\u0001\u0004a\u0006\"B1\n\u0001\u0004a\u0016!\u00019\t\u000beK\u0001\u0019\u0001/\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q\u0016\nQ\u0001^=qKNL!A[4\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\u0002\u001d:fiRLh*Y7f+\u0005i\u0007C\u00018s\u001d\ty\u0007\u000f\u0005\u0002=k%\u0011\u0011/N\u0001\u0007!J,G-\u001a4\n\u0005M$(AB*ue&twM\u0003\u0002rk\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0005ov\f)\u0001\u0005\u0002yw6\t\u0011P\u0003\u0002{C\u000591m\u001c3fO\u0016t\u0017B\u0001?z\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u0002@\r\u0001\u0004y\u0018aA2uqB\u0019\u00010!\u0001\n\u0007\u0005\r\u0011P\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005\u001dA\u00021\u0001x\u0003\t)g/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR9\u0011+!\u0004\u0002\u0012\u0005U\u0001BBA\b\u001b\u0001\u0007q)\u0001\u0005oK^4\u0015N]:u\u0011\u0019\t\u0019\"\u0004a\u0001\u000f\u0006Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0007\u0003/i\u0001\u0019A$\u0002\u00119,w\u000f\u00165je\u0012\fAaY8qsR9\u0011+!\b\u0002 \u0005\u0005\u0002bB#\u000f!\u0003\u0005\ra\u0012\u0005\b\u0017:\u0001\n\u00111\u0001H\u0011\u001die\u0002%AA\u0002\u001d\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002()\u001aq)!\u000b,\u0005\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u000e6\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\tyCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001b\nAA[1wC&\u00191/a\u0012\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005U\u0003c\u0001\u001b\u0002X%\u0019\u0011\u0011L\u001b\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007q\u000by\u0006C\u0005\u0002bQ\t\t\u00111\u0001\u0002V\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001a\u0011\u000b\u0005%\u0014q\u000e/\u000e\u0005\u0005-$bAA7k\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00141\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002x\u0005u\u0004c\u0001\u001b\u0002z%\u0019\u00111P\u001b\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011\r\f\u0002\u0002\u0003\u0007A,\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA\"\u0003\u0007C\u0011\"!\u0019\u0018\u0003\u0003\u0005\r!!\u0016\u0002\r\u0015\fX/\u00197t)\u0011\t9(!#\t\u0011\u0005\u0005\u0004$!AA\u0002qCs\u0003AAG\u0003'\u000b)*!'\u0002\u001c\u0006}\u0015\u0011UAS\u0003O\u000bY+!,\u0011\u0007A\ny)C\u0002\u0002\u0012\u0006\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002\u0018\u0006\t\tD\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO\u001d\u0017!e\u0016<W\r\u001f9\\Y\u0001JG\r_/*A5\u0002S\t\u001f;sC\u000e$\b%\u00197mAM$(/\u001b8hg\u0002Jg\u000e\t;iK\u0002\u00027\u000f\u001e:aAQD\u0017\r\u001e\u0011nCR\u001c\u0007\u000e\t;iK\u0002\u0002'/Z4fqB\u0004'\u0002\t\u0011!A\u0015D\bO]3tg&|g\u000eI1oI\u0002\u001awN\u001d:fgB|g\u000eZ5oO\u0002\"x\u000e\t;iK\u0002\u0012XmZ3yA\u001d\u0014x.\u001e9!S:$W\r\u001f\u0018\u000bA\u0001\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005u\u0015a#\u0006\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u001aHO\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004S\r\u001f9sKN\u001c\u0018n\u001c8/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u0012XmZ3ya\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011sKB\u0014Xm]3oi&tw\rI1!e\u0016<W\u000f\\1sA\u0015D\bO]3tg&|gN\f\u0011UQ\u0016\u0004#/Z4fq\u0002\u001aHO]5oO\u0002\u001a\bn\\;mI\u0002\u0012W\rI1\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#*\u0019<bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018=EJtDH\u0019:?\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003eU5oG\u0016\u00043\u000b]1sW\u0002\u0012d\u0006\r\u0017!gR\u0014\u0018N\\4!Y&$XM]1mg\u0002B\u0013N\\2mk\u0012Lgn\u001a\u0011sK\u001e,\u0007\u0010\t9biR,'O\\:*A\u0005\u0014X\rI;oKN\u001c\u0017\r]3eA%t\u0007e\\;sAM\u000bFJ\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AA\f'o]3sY\u0001\u001aX-\u001a\u0011uQ\u0016\u0004SO\\3tG\u0006\u0004\u0018N\\4!eVdWm\u001d\u0011bi\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tc2l#/\u001a4.Y&$XM]1mg:BG/\u001c7$gR\u0014\u0018N\\4.Y&$XM]1mEy\u001aFO]5oO\u0002b\u0015\u000e^3sC2dt&\u0019 /\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002Co\u001c\u0011nCR\u001c\u0007\u000e\t\u0012]C\n\u001c'\u0005\f\u0011bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011g_J\u0004\u0003M]3hKb\u0004\b\rI2b]\u0002\u0012W\r\t\u0012_9r\u000b'm\u0019\u0013#]q\u0012'O\u0010\u001fcezR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0014X\rI5tA\u0005\u00043+\u0015'!G>tg-[4!OM\u0004\u0018M]6/gFdg\u0006]1sg\u0016\u0014h&Z:dCB,Gm\u0015;sS:<G*\u001b;fe\u0006d7o\n\u0011uQ\u0006$\beY1oA\t,\u0007%^:fI\u0002\"xN\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0019\fG\u000e\u001c2bG.\u0004Co\u001c\u0011uQ\u0016\u00043\u000b]1sW\u0002\ndF\u000e\u0011cK\"\fg/[8sAI,w-\u0019:eS:<\u0007e\u001d;sS:<\u0007\u0005\\5uKJ\fG\u000e\t9beNLgn\u001a\u0018!\r>\u0014\b%\u001a=b[BdW\r\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001Jg\r\t;iK\u0002\u001awN\u001c4jO\u0002J7\u000fI3oC\ndW\r\u001a\u0017!i\",\u0007\u0005\u0019:fO\u0016D\b\u000f\u0019\u0011uQ\u0006$\beY1oA5\fGo\u00195!Eq\u000b'm\u0019\u0012!SN\u0004#E\u0018/bE\u000e$#E\f\u001fcezb$M\u001d \u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013\n^\u0014tAI,7m\\7nK:$W\r\u001a\u0011u_\u0002*8/\u001a\u0011bAI\fw\u000fI:ue&tw\r\t7ji\u0016\u0014\u0018\r\u001c\u0011)o&$\b\u000e\t;iK\u0002\u0002'\u000f\u0019\u0011qe\u00164\u0017\u000e_\u0015!i>\u0004\u0013M^8jI\u0002*7oY1qS:<'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!gB,7-[1mA\rD\u0017M]1di\u0016\u00148\u000fI5oAQDW\r\t9biR,'O\u001c\u0011tiJLgn\u001a\u0011jM\u0002*\u00070[:ug:R\u0001\u0005\t\u0011!A\u0001R\u0003%\u001b3yA5\u0002\u0013M\u001c\u0011j]R,w-\u001a:!Kb\u0004(/Z:tS>t\u0007\u0005\u001e5bi\u0002\u0012X\r\u001d:fg\u0016tG/\u001b8hAQDW\rI4s_V\u0004\b%\u001b8eKbt\u0003\u0005\u00165fAI,w-\u001a=![\u0006L\beY8oi\u0006Lgn\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001jW\u000f\u001c;ja2,\u0007e\u001a:pkB\u001ch\u0006\t1jIb\u0004\u0007%\u001b8eS\u000e\fG/Z:!o\"L7\r\u001b\u0011sK\u001e,\u0007\u0010I4s_V\u0004\b\u0005^8!Kb$(/Y2u]\u0001\"\u0006.\u001a\u0011he>,\b\u000fI5oI\u0016D\be\u001d5pk2$'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!E\u0016\u0004cn\u001c8.]\u0016<\u0017\r^5wK:\u0002C\u000b[3![&t\u0017.\\;nAY\fG.^3!_\u001a\u0004\u0003-\u001b3yA\u0002J7\u000f\t\u0019-A]D\u0017n\u00195![\u0016\fgn\u001d\u0011nCR\u001c\u0007.\u001b8hAQDW\rI3oi&\u0014XM\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018!\u0013\u001a\u0004\u0003-\u001b3yA\u0002J7\u000f\t8pi\u0002\u001a\b/Z2jM&,G\r\f\u0011uQ\u0016\u0004C-\u001a4bk2$\be\u001a:pkB\u0004\u0013N\u001c3fq\u00022\u0018\r\\;fA%\u001c\b%\r\u0018!)\",'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A&$\u0007\u0010\u0019\u0011qCJ\fW.\u001a;fe\u0002J7\u000f\t;iK\u0002R\u0015M^1!e\u0016<W\r\u001f\u0011NCR\u001c\u0007.\u001a:!OJ|W\u000f\u001d\u0015*A5,G\u000f[8eA%tG-\u001a=/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\r\u0016!!\u001d\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n\u0004\u0007M\u00173aAb\u0003e\r\u00191[Q\u0002\u0004g\n\u0017!O!bF\fZ\u0016*[!bF\fZ\u0016*O1\u0002\u0013'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\n\n\u0004\u0007\r\u0012-EM\u0002\u0004GI/\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n\u0004\u0007M\u00173aAb\u0003e\r\u00191[Q\u0002\u0004g\n\u0017!e\u001eBC\fZ\u0016*[!bFmK\u0015(Y\u0001\n\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\EE\u0002\u0004G\t\u0017#gA\u0002$%\u0018\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011\u0011V\u0001\u0006g9\nd\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003_\u000bAb\u001d;sS:<wLZ;oGN\f\u0001CU3h\u000bb\u0004X\t\u001f;sC\u000e$\u0018\t\u001c7\u0011\u0005AR2#\u0002\u000e\u00028\u0006\r\u0007\u0003CA]\u0003\u007f;uiR)\u000e\u0005\u0005m&bAA_k\u00059!/\u001e8uS6,\u0017\u0002BAa\u0003w\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\t)-a3\u000e\u0005\u0005\u001d'\u0002BAe\u0003\u0017\n!![8\n\u0007\r\u000b9\r\u0006\u0002\u00024\u0006AAo\\*ue&tw\r\u0006\u0002\u0002D\u0005)\u0011\r\u001d9msR9\u0011+a6\u0002Z\u0006m\u0007\"B#\u001e\u0001\u00049\u0005\"B&\u001e\u0001\u00049\u0005\"B'\u001e\u0001\u00049\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003C\fi\u000fE\u00035\u0003G\f9/C\u0002\u0002fV\u0012aa\u00149uS>t\u0007C\u0002\u001b\u0002j\u001e;u)C\u0002\u0002lV\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAx=\u0005\u0005\t\u0019A)\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002vB!\u0011QIA|\u0013\u0011\tI0a\u0012\u0003\r=\u0013'.Z2u\u0001")
public class RegExpExtractAll
extends RegExpExtractBase
implements Serializable {
    private final Expression subject;
    private final Expression regexp;
    private final Expression idx;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(RegExpExtractAll x$0) {
        return RegExpExtractAll$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, RegExpExtractAll> tupled() {
        return RegExpExtractAll$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, RegExpExtractAll>>> curried() {
        return RegExpExtractAll$.MODULE$.curried();
    }

    @Override
    public Expression subject() {
        return this.subject;
    }

    @Override
    public Expression regexp() {
        return this.regexp;
    }

    @Override
    public Expression idx() {
        return this.idx;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r) {
        Matcher m = this.getLastMatcher(s, p);
        ArrayBuffer matchResults = new ArrayBuffer();
        while (m.find()) {
            MatchResult mr = m.toMatchResult();
            int index = BoxesRunTime.unboxToInt((Object)r);
            RegExpExtractBase$.MODULE$.checkGroupIndex(this.prettyName(), mr.groupCount(), index);
            String group = mr.group(index);
            Growable growable = group == null ? matchResults.$plus$eq((Object)UTF8String.EMPTY_UTF8) : matchResults.$plus$eq((Object)UTF8String.fromString((String)group));
        }
        return new GenericArrayData((Object[])matchResults.toArray(ClassTag$.MODULE$.apply(UTF8String.class)));
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(this.subject().dataType());
    }

    @Override
    public String prettyName() {
        return "regexp_extract_all";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String classNameRegExpExtractBase = RegExpExtractBase.class.getCanonicalName();
        String arrayClass = GenericArrayData.class.getName();
        String matcher = ctx.freshName("matcher");
        String matchResult = ctx.freshName("matchResult");
        String matchResults = ctx.freshName("matchResults");
        String setEvNotNull = this.nullable() ? ev.isNull() + " = false;" : "";
        return this.nullSafeCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(subject, regexp, idx) -> "\n         | " + RegExpUtils$.MODULE$.initLastMatcherCode(ctx, (String)subject, (String)regexp, matcher, this.prettyName(), this.collationId()) + "\n         | java.util.ArrayList " + matchResults + " = new java.util.ArrayList<UTF8String>();\n         | while (" + matcher + ".find()) {\n         |   java.util.regex.MatchResult " + matchResult + " = " + matcher + ".toMatchResult();\n         |   " + classNameRegExpExtractBase + ".checkGroupIndex(\n         |     \"" + this.prettyName() + "\",\n         |     " + matchResult + ".groupCount(),\n         |     " + idx + ");\n         |   if (" + matchResult + ".group(" + idx + ") == null) {\n         |     " + matchResults + ".add(UTF8String.EMPTY_UTF8);\n         |   } else {\n         |     " + matchResults + ".add(UTF8String.fromString(" + matchResult + ".group(" + idx + ")));\n         |   }\n         | }\n         | " + ev.value() + " =\n         |   new " + arrayClass + "(" + matchResults + ".toArray(new UTF8String[" + matchResults + ".size()]));\n         | " + setEvNotNull + "\n         ");
    }

    @Override
    public RegExpExtractAll withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public RegExpExtractAll copy(Expression subject, Expression regexp, Expression idx) {
        return new RegExpExtractAll(subject, regexp, idx);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.idx();
    }

    @Override
    public String productPrefix() {
        return "RegExpExtractAll";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.subject();
            }
            case 1: {
                return this.regexp();
            }
            case 2: {
                return this.idx();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpExtractAll;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "subject";
            }
            case 1: {
                return "regexp";
            }
            case 2: {
                return "idx";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpExtractAll)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpExtractAll regExpExtractAll = (RegExpExtractAll)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpExtractAll.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpExtractAll.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.idx();
        Expression expression6 = regExpExtractAll.idx();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!regExpExtractAll.canEqual(this)) return false;
        return true;
    }

    public RegExpExtractAll(Expression subject, Expression regexp, Expression idx) {
        this.subject = subject;
        this.regexp = regexp;
        this.idx = idx;
    }

    public RegExpExtractAll(Expression s, Expression r) {
        this(s, r, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

