/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.HiveHasher;
import org.apache.spark.sql.catalyst.expressions.InterpretedHashFunction;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HiveHashFunction$
extends InterpretedHashFunction {
    public static final HiveHashFunction$ MODULE$ = new HiveHashFunction$();
    private static final int HIVE_DECIMAL_MAX_PRECISION = 38;
    private static final int HIVE_DECIMAL_MAX_SCALE = 38;

    @Override
    public long hashInt(int i, long seed) {
        return HiveHasher.hashInt((int)i);
    }

    @Override
    public long hashLong(long l, long seed) {
        return HiveHasher.hashLong((long)l);
    }

    @Override
    public long hashUnsafeBytes(Object base, long offset, int len, long seed) {
        return HiveHasher.hashUnsafeBytes((Object)base, (long)offset, (int)len);
    }

    private int HIVE_DECIMAL_MAX_PRECISION() {
        return HIVE_DECIMAL_MAX_PRECISION;
    }

    private int HIVE_DECIMAL_MAX_SCALE() {
        return HIVE_DECIMAL_MAX_SCALE;
    }

    public BigDecimal normalizeDecimal(BigDecimal input) {
        BigDecimal result;
        block2: {
            if (input == null) {
                return null;
            }
            result = HiveHashFunction$.trimDecimal$1(input);
            int intDigits = result.precision() - result.scale();
            if (intDigits > this.HIVE_DECIMAL_MAX_PRECISION()) {
                return null;
            }
            int maxScale = Math.min(this.HIVE_DECIMAL_MAX_SCALE(), Math.min(this.HIVE_DECIMAL_MAX_PRECISION() - intDigits, result.scale()));
            if (result.scale() <= maxScale) break block2;
            result = result.setScale(maxScale, RoundingMode.HALF_UP);
            result = HiveHashFunction$.trimDecimal$1(result);
        }
        return result;
    }

    public long hashTimestamp(long timestamp) {
        long timestampInSeconds = TimeUnit.MICROSECONDS.toSeconds(timestamp);
        long nanoSecondsPortion = timestamp % 1000000L * 1000L;
        long result = timestampInSeconds;
        result <<= 30;
        return (int)((result |= nanoSecondsPortion) >>> 32 ^ result);
    }

    public long hashCalendarInterval(CalendarInterval calendarInterval) {
        long totalMicroSeconds = (long)calendarInterval.days * 86400000000L + calendarInterval.microseconds;
        long totalSeconds = totalMicroSeconds / 1000000L;
        int result = 629 + (int)(totalSeconds ^ totalSeconds >> 32);
        int nanoSeconds = (int)(totalMicroSeconds - totalSeconds * 1000000L) * 1000;
        return result * 37 + nanoSeconds;
    }

    @Override
    public long hash(Object value, DataType dataType, long seed) {
        Object object = value;
        if (object == null) {
            return 0L;
        }
        if (object instanceof ArrayData) {
            DataType dataType2;
            ArrayData arrayData = (ArrayData)object;
            DataType dataType3 = dataType;
            if (dataType3 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType3;
                dataType2 = ((ArrayType)userDefinedType.sqlType()).elementType();
            } else if (dataType3 instanceof ArrayType) {
                DataType et;
                ArrayType arrayType = (ArrayType)dataType3;
                dataType2 = et = arrayType.elementType();
            } else {
                throw new MatchError((Object)dataType3);
            }
            DataType elementType = dataType2;
            int result = 0;
            int length = arrayData.numElements();
            for (int i = 0; i < length; ++i) {
                result = 31 * result + (int)this.hash(arrayData.get(i, elementType), elementType, 0L);
            }
            return result;
        }
        if (object instanceof MapData) {
            Tuple2 tuple2;
            MapData mapData = (MapData)object;
            DataType dataType4 = dataType;
            if (dataType4 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType4;
                MapType mapType = (MapType)userDefinedType.sqlType();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapType.keyType()), (Object)mapType.valueType());
            } else if (dataType4 instanceof MapType) {
                MapType mapType = (MapType)dataType4;
                DataType _kt = mapType.keyType();
                DataType _vt = mapType.valueType();
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)_kt), (Object)_vt);
            } else {
                throw new MatchError((Object)dataType4);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            DataType kt = (DataType)tuple22._1();
            DataType vt = (DataType)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)kt, (Object)vt);
            DataType kt2 = (DataType)tuple23._1();
            DataType vt2 = (DataType)tuple23._2();
            ArrayData keys = mapData.keyArray();
            ArrayData values = mapData.valueArray();
            int result = 0;
            int length = mapData.numElements();
            for (int i = 0; i < length; ++i) {
                result += (int)this.hash(keys.get(i, kt2), kt2, 0L) ^ (int)this.hash(values.get(i, vt2), vt2, 0L);
            }
            return result;
        }
        if (object instanceof InternalRow) {
            DataType[] dataTypeArray;
            InternalRow internalRow = (InternalRow)object;
            DataType dataType5 = dataType;
            if (dataType5 instanceof UserDefinedType) {
                UserDefinedType userDefinedType = (UserDefinedType)dataType5;
                dataTypeArray = (DataType[])((IterableOnceOps)((StructType)userDefinedType.sqlType()).map((Function1 & Serializable)x$12 -> x$12.dataType())).toArray(ClassTag$.MODULE$.apply(DataType.class));
            } else if (dataType5 instanceof StructType) {
                StructType structType = (StructType)dataType5;
                StructField[] fields = structType.fields();
                dataTypeArray = (DataType[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Function1 & Serializable)x$13 -> x$13.dataType(), ClassTag$.MODULE$.apply(DataType.class));
            } else {
                throw new MatchError((Object)dataType5);
            }
            DataType[] types = dataTypeArray;
            int result = 0;
            int length = internalRow.numFields();
            for (int i = 0; i < length; ++i) {
                result = 31 * result + (int)this.hash(internalRow.get(i, types[i]), types[i], 0L);
            }
            return result;
        }
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            return this.normalizeDecimal(decimal.toJavaBigDecimal()).hashCode();
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            if (dataType instanceof TimestampType) {
                return this.hashTimestamp(l);
            }
        }
        if (object instanceof CalendarInterval) {
            CalendarInterval calendarInterval = (CalendarInterval)object;
            return this.hashCalendarInterval(calendarInterval);
        }
        return super.hash(value, dataType, 0L);
    }

    private static final BigDecimal trimDecimal$1(BigDecimal input) {
        BigDecimal result;
        block1: {
            block0: {
                result = input;
                if (result.compareTo(BigDecimal.ZERO) != 0) break block0;
                result = BigDecimal.ZERO;
                break block1;
            }
            if ((result = result.stripTrailingZeros()).scale() >= 0) break block1;
            result = result.setScale(0);
        }
        return result;
    }

    private HiveHashFunction$() {
    }
}

