/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.csv;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.csv.CSVExprUtils$;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001\u0002\r\u001a\u0001\u0019B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u001d1\u0006A1A\u0005\n]Ca\u0001\u0017\u0001!\u0002\u0013a\u0005bB-\u0001\u0005\u0004%Ia\u0016\u0005\u00075\u0002\u0001\u000b\u0011\u0002'\t\u000fm\u0003\u0001\u0019!C\u00059\"91\r\u0001a\u0001\n\u0013!\u0007B\u00026\u0001A\u0003&Q\fC\u0004l\u0001\u0001\u0007I\u0011\u00017\t\u000fE\u0004\u0001\u0019!C\u0001e\"1A\u000f\u0001Q!\n5DQ!\u001e\u0001\u0005\nYDQ!\u001e\u0001\u0005\u0002eDa!\u001e\u0001\u0005\u0002ea\bbB;\u0001\t\u0003I\u0012\u0011E\u0004\n\u0003wI\u0012\u0011!E\u0001\u0003{1\u0001\u0002G\r\u0002\u0002#\u0005\u0011q\b\u0005\u0007\u001fV!\t!!\u0011\t\u0013\u0005\rS#%A\u0005\u0002\u0005\u0015#\u0001E\"T-\"+\u0017\rZ3s\u0007\",7m[3s\u0015\tQ2$A\u0002dgZT!\u0001H\u000f\u0002\u0011\r\fG/\u00197zgRT!AH\u0010\u0002\u0007M\fHN\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011a&M\u0007\u0002_)\u0011\u0001gH\u0001\tS:$XM\u001d8bY&\u0011!g\f\u0002\b\u0019><w-\u001b8h\u0003\u0019\u00198\r[3nCB\u0011Q\u0007O\u0007\u0002m)\u0011q'H\u0001\u0006if\u0004Xm]\u0005\u0003sY\u0012!b\u0015;sk\u000e$H+\u001f9f\u0003\u001dy\u0007\u000f^5p]N\u0004\"\u0001P\u001f\u000e\u0003eI!AP\r\u0003\u0015\r\u001bfk\u00149uS>t7/\u0001\u0004t_V\u00148-\u001a\t\u0003\u0003\"s!A\u0011$\u0011\u0005\rKS\"\u0001#\u000b\u0005\u0015+\u0013A\u0002\u001fs_>$h(\u0003\u0002HS\u00051\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9\u0015&A\u0007jgN#\u0018M\u001d;PM\u001aKG.\u001a\t\u0003Q5K!AT\u0015\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"R!\u0015*T)V\u0003\"\u0001\u0010\u0001\t\u000bM*\u0001\u0019\u0001\u001b\t\u000bi*\u0001\u0019A\u001e\t\u000b}*\u0001\u0019\u0001!\t\u000f-+\u0001\u0013!a\u0001\u0019\u0006i1-Y:f'\u0016t7/\u001b;jm\u0016,\u0012\u0001T\u0001\u000fG\u0006\u001cXmU3og&$\u0018N^3!\u00035)gNZ8sG\u0016\u001c6\r[3nC\u0006qQM\u001c4pe\u000e,7k\u00195f[\u0006\u0004\u0013!\u00055fC\u0012,'oQ8mk6tg*Y7fgV\tQ\fE\u0002)=\u0002L!aX\u0015\u0003\r=\u0003H/[8o!\rA\u0013\rQ\u0005\u0003E&\u0012Q!\u0011:sCf\fQ\u0003[3bI\u0016\u00148i\u001c7v[:t\u0015-\\3t?\u0012*\u0017\u000f\u0006\u0002fQB\u0011\u0001FZ\u0005\u0003O&\u0012A!\u00168ji\"9\u0011nCA\u0001\u0002\u0004i\u0016a\u0001=%c\u0005\u0011\u0002.Z1eKJ\u001cu\u000e\\;n]:\u000bW.Z:!\u0003}\u0019X\r\u001e%fC\u0012,'OR8s'&tw\r\\3WCJL\u0017M\u001c;D_2,XN\\\u000b\u0002[B\u0019\u0001F\u00188\u0011\t!zW,Z\u0005\u0003a&\u0012\u0011BR;oGRLwN\\\u0019\u0002GM,G\u000fS3bI\u0016\u0014hi\u001c:TS:<G.\u001a,be&\fg\u000e^\"pYVlgn\u0018\u0013fcR\u0011Qm\u001d\u0005\bS:\t\t\u00111\u0001n\u0003\u0001\u001aX\r\u001e%fC\u0012,'OR8s'&tw\r\\3WCJL\u0017M\u001c;D_2,XN\u001c\u0011\u0002-\rDWmY6IK\u0006$WM]\"pYVlgNT1nKN$\"!Z<\t\u000ba\u0004\u0002\u0019\u00011\u0002\u0017\r|G.^7o\u001d\u0006lWm\u001d\u000b\u0003KjDQa_\tA\u0002\u0001\u000bA\u0001\\5oKR\u0011Q- \u0005\u0006}J\u0001\ra`\u0001\ni>\\WM\\5{KJ\u0004b!!\u0001\u0002\u0014\u0005]QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\r\r|W.\\8o\u0015\u0011\tI!a\u0003\u0002\u000fA\f'o]3sg*!\u0011QBA\b\u0003%)h.\u001b<pG&$\u0018P\u0003\u0002\u0002\u0012\u0005\u00191m\\7\n\t\u0005U\u00111\u0001\u0002\u000f\u0003\n\u001cHO]1diB\u000b'o]3s!\u0011\tI\"!\b\u000e\u0005\u0005m!b\u0001\u000e\u0002\b%!\u0011qDA\u000e\u0005E\u00195O\u001e)beN,'oU3ui&twm\u001d\u000b\u0006K\u0006\r\u0012\u0011\b\u0005\b\u0003K\u0019\u0002\u0019AA\u0014\u0003\u0015a\u0017N\\3t!\u0015\tI#a\rA\u001d\u0011\tY#a\f\u000f\u0007\r\u000bi#C\u0001+\u0013\r\t\t$K\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)$a\u000e\u0003\u0011%#XM]1u_JT1!!\r*\u0011\u0015q8\u00031\u0001\u0000\u0003A\u00195K\u0016%fC\u0012,'o\u00115fG.,'\u000f\u0005\u0002=+M\u0011Qc\n\u000b\u0003\u0003{\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAA$U\ra\u0015\u0011J\u0016\u0003\u0003\u0017\u0002B!!\u0014\u0002X5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&A\u0005v]\u000eDWmY6fI*\u0019\u0011QK\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002Z\u0005=#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class CSVHeaderChecker
implements Logging {
    private final StructType schema;
    private final CSVOptions options;
    private final String source;
    private final boolean isStartOfFile;
    private final boolean caseSensitive;
    private final boolean enforceSchema;
    private Option<String[]> headerColumnNames;
    private Option<Function1<Option<String[]>, BoxedUnit>> setHeaderForSingleVariantColumn;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$4() {
        return CSVHeaderChecker$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean caseSensitive() {
        return this.caseSensitive;
    }

    private boolean enforceSchema() {
        return this.enforceSchema;
    }

    private Option<String[]> headerColumnNames() {
        return this.headerColumnNames;
    }

    private void headerColumnNames_$eq(Option<String[]> x$1) {
        this.headerColumnNames = x$1;
    }

    public Option<Function1<Option<String[]>, BoxedUnit>> setHeaderForSingleVariantColumn() {
        return this.setHeaderForSingleVariantColumn;
    }

    public void setHeaderForSingleVariantColumn_$eq(Option<Function1<Option<String[]>, BoxedUnit>> x$1) {
        this.setHeaderForSingleVariantColumn = x$1;
    }

    private void checkHeaderColumnNames(String[] columnNames) {
        if (columnNames != null) {
            if (this.options.singleVariantColumn().isDefined()) {
                this.headerColumnNames_$eq((Option<String[]>)new Some((Object)columnNames));
                return;
            }
            IndexedSeq fieldNames = ((IterableOnceOps)this.schema.map((Function1 & Serializable)x$1 -> x$1.name())).toIndexedSeq();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(columnNames.length, fieldNames.length());
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int headerLen = sp2._1$mcI$sp();
            int schemaSize = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(headerLen, schemaSize);
            int headerLen2 = sp3._1$mcI$sp();
            int schemaSize2 = sp3._2$mcI$sp();
            None$ errorMessage = None$.MODULE$;
            if (headerLen2 == schemaSize2) {
                for (int i = 0; errorMessage.isEmpty() && i < headerLen2; ++i) {
                    Tuple2 tuple2 = new Tuple2(fieldNames.apply(i), (Object)columnNames[i]);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String nameInSchema = (String)tuple2._1();
                    String nameInHeader = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)nameInSchema, (Object)nameInHeader);
                    String nameInSchema2 = (String)tuple22._1();
                    String nameInHeader2 = (String)tuple22._2();
                    if (!this.caseSensitive()) {
                        nameInSchema2 = nameInSchema2.toLowerCase();
                        nameInHeader2 = nameInHeader2.toLowerCase();
                    }
                    String string = nameInHeader2;
                    String string2 = nameInSchema2;
                    if (!(string == null ? string2 != null : !string.equals(string2))) continue;
                    errorMessage = new Some((Object)this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"|CSV header does not conform to the schema.\n                    | Header: ", "\n                    | Schema: ", "\n                    |Expected: ", " but found: ", "\n                    |", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CSV_HEADER_COLUMN_NAMES$.MODULE$, (Object)Predef$.MODULE$.wrapRefArray((Object[])columnNames).mkString(", ")), new MDC((LogKey)LogKeys.CSV_SCHEMA_FIELD_NAMES$.MODULE$, (Object)fieldNames.mkString(", ")), new MDC((LogKey)LogKeys.CSV_SCHEMA_FIELD_NAME$.MODULE$, fieldNames.apply(i)), new MDC((LogKey)LogKeys.CSV_HEADER_COLUMN_NAME$.MODULE$, (Object)columnNames[i]), new MDC((LogKey)LogKeys.CSV_SOURCE$.MODULE$, (Object)this.source)})).stripMargin());
                }
            } else {
                errorMessage = new Some((Object)this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"|Number of column in CSV header is not equal to number of fields in the schema:\n                | Header length: ", ", schema size: ", "\n                |", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CSV_HEADER_LENGTH$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)headerLen2)), new MDC((LogKey)LogKeys.NUM_COLUMNS$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)schemaSize2)), new MDC((LogKey)LogKeys.CSV_SOURCE$.MODULE$, (Object)this.source)})).stripMargin());
            }
            errorMessage.foreach((Function1 & Serializable)msg -> {
                CSVHeaderChecker.$anonfun$checkHeaderColumnNames$2(this, msg);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void checkHeaderColumnNames(String line) {
        if (this.options.headerFlag()) {
            CsvParser parser = new CsvParser(this.options.asParserSettings());
            this.checkHeaderColumnNames(parser.parseLine(line));
            return;
        }
    }

    public void checkHeaderColumnNames(AbstractParser<CsvParserSettings> tokenizer) {
        Predef$.MODULE$.assert(this.options.multiLine(), (Function0 & Serializable)() -> "This method should be executed with multiLine.");
        if (this.options.headerFlag()) {
            String[] firstRecord = tokenizer.parseNext();
            this.checkHeaderColumnNames(firstRecord);
        }
        this.setHeaderForSingleVariantColumn().foreach((Function1 & Serializable)f -> {
            f.apply(this.headerColumnNames());
            return BoxedUnit.UNIT;
        });
    }

    public void checkHeaderColumnNames(Iterator<String> lines, AbstractParser<CsvParserSettings> tokenizer) {
        Predef$.MODULE$.assert(!this.options.multiLine(), (Function0 & Serializable)() -> "This method should not be executed with multiline.");
        if (this.options.headerFlag() && this.isStartOfFile) {
            CSVExprUtils$.MODULE$.extractHeader(lines, this.options).foreach((Function1 & Serializable)header -> {
                this.checkHeaderColumnNames(tokenizer.parseLine(header));
                return BoxedUnit.UNIT;
            });
        }
        this.setHeaderForSingleVariantColumn().foreach((Function1 & Serializable)f -> {
            f.apply(this.headerColumnNames());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkHeaderColumnNames$2(CSVHeaderChecker $this, MessageWithContext msg) {
        if ($this.enforceSchema()) {
            $this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> msg));
            return;
        }
        throw new SparkIllegalArgumentException("_LEGACY_ERROR_TEMP_3241", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)msg.message())})));
    }

    public CSVHeaderChecker(StructType schema, CSVOptions options, String source, boolean isStartOfFile) {
        this.schema = schema;
        this.options = options;
        this.source = source;
        this.isStartOfFile = isStartOfFile;
        Logging.$init$((Logging)this);
        this.caseSensitive = SQLConf$.MODULE$.get().caseSensitiveAnalysis();
        this.enforceSchema = options.enforceSchema();
        this.headerColumnNames = None$.MODULE$;
        this.setHeaderForSingleVariantColumn = None$.MODULE$;
    }
}

