/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.AliasIdentifier;
import org.apache.spark.sql.catalyst.analysis.RelationResolution;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.resolver.AnalyzerBridgeState;
import org.apache.spark.sql.catalyst.analysis.resolver.BridgedRelationMetadataProvider$TestOnly$;
import org.apache.spark.sql.catalyst.analysis.resolver.RelationId;
import org.apache.spark.sql.catalyst.analysis.resolver.RelationMetadataProvider;
import org.apache.spark.sql.catalyst.analysis.resolver.ViewResolver;
import org.apache.spark.sql.catalyst.catalog.UnresolvedCatalogRelation;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.LookupCatalog;
import org.apache.spark.sql.connector.catalog.LookupCatalog$AsTableIdentifier$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$CatalogAndIdentifier$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$CatalogAndMultipartIdentifier$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$CatalogAndNamespace$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$NonSessionCatalogAndIdentifier$;
import org.apache.spark.sql.connector.catalog.LookupCatalog$SessionCatalogAndIdentifier$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\n\u0015\u0001\rB\u0001B\f\u0001\u0003\u0006\u0004%\te\f\u0005\tq\u0001\u0011\t\u0011)A\u0005a!A\u0011\b\u0001BC\u0002\u0013\u0005#\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003<\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b!\u0003A\u0011A%\t\u000f=\u0003!\u0019!C!!\"1A\r\u0001Q\u0001\nECQ!\u001a\u0001\u0005B\u0019DQ\u0001\u001c\u0001\u0005\n5DQA\u001c\u0001\u0005\n=DQA\u001d\u0001\u0005\nMDQ!\u001e\u0001\u0005\nY<qa \u0001\t\u0002i\t\tA\u0002\u0005\u0002\u0006\u0001A\tAGA\u0004\u0011\u0019A\u0005\u0003\"\u0001\u0002\n!9\u00111\u0002\t\u0005\u0002\u00055!a\b\"sS\u0012<W\r\u001a*fY\u0006$\u0018n\u001c8NKR\fG-\u0019;b!J|g/\u001b3fe*\u0011QCF\u0001\te\u0016\u001cx\u000e\u001c<fe*\u0011q\u0003G\u0001\tC:\fG._:jg*\u0011\u0011DG\u0001\tG\u0006$\u0018\r\\=ti*\u00111\u0004H\u0001\u0004gFd'BA\u000f\u001f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\n\u0016\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g!\tYC&D\u0001\u0015\u0013\tiCC\u0001\rSK2\fG/[8o\u001b\u0016$\u0018\rZ1uCB\u0013xN^5eKJ\fabY1uC2|w-T1oC\u001e,'/F\u00011!\t\td'D\u00013\u0015\t\u0019D'A\u0004dCR\fGn\\4\u000b\u0005UR\u0012!C2p]:,7\r^8s\u0013\t9$G\u0001\bDCR\fGn\\4NC:\fw-\u001a:\u0002\u001f\r\fG/\u00197pO6\u000bg.Y4fe\u0002\n!C]3mCRLwN\u001c*fg>dW\u000f^5p]V\t1\b\u0005\u0002={5\ta#\u0003\u0002?-\t\u0011\"+\u001a7bi&|gNU3t_2,H/[8o\u0003M\u0011X\r\\1uS>t'+Z:pYV$\u0018n\u001c8!\u0003M\tg.\u00197zu\u0016\u0014(I]5eO\u0016\u001cF/\u0019;f!\tY#)\u0003\u0002D)\t\u0019\u0012I\\1msj,'O\u0011:jI\u001e,7\u000b^1uK\u0006aa/[3x%\u0016\u001cx\u000e\u001c<feB\u00111FR\u0005\u0003\u000fR\u0011ABV5foJ+7o\u001c7wKJ\fa\u0001P5oSRtD#\u0002&L\u00196s\u0005CA\u0016\u0001\u0011\u0015qs\u00011\u00011\u0011\u0015It\u00011\u0001<\u0011\u0015\u0001u\u00011\u0001B\u0011\u0015!u\u00011\u0001F\u0003u\u0011X\r\\1uS>t7oV5uQJ+7o\u001c7wK\u0012lU\r^1eCR\fW#A)\u0011\tI;\u0016\fX\u0007\u0002'*\u0011A+V\u0001\u0005kRLGNC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&a\u0002%bg\"l\u0015\r\u001d\t\u0003WiK!a\u0017\u000b\u0003\u0015I+G.\u0019;j_:LE\r\u0005\u0002^E6\taL\u0003\u0002`A\u00069An\\4jG\u0006d'BA1\u0019\u0003\u0015\u0001H.\u00198t\u0013\t\u0019gLA\u0006M_\u001eL7-\u00197QY\u0006t\u0017A\b:fY\u0006$\u0018n\u001c8t/&$\bNU3t_24X\rZ'fi\u0006$\u0017\r^1!\u0003\u001d\u0011Xm]8mm\u0016$\"a\u001a6\u0011\u0005\u0015B\u0017BA5'\u0005\u0011)f.\u001b;\t\u000b-T\u0001\u0019\u0001/\u0002\u001dUt'/Z:pYZ,G\r\u00157b]\u0006\u0019S\u000f\u001d3bi\u0016\u0014V\r\\1uS>t7oV5uQJ+7o\u001c7wK\u0012lU\r^1eCR\fG#A4\u0002GQ\u0014\u0018pQ8om\u0016\u0014H/\u00168sKN|GN^3e\u0007\u0006$\u0018\r\\8h%\u0016d\u0017\r^5p]R\u0011A\f\u001d\u0005\u0006c2\u0001\r\u0001X\u0001\te\u0016d\u0017\r^5p]\u0006YBO]=D_:4XM\u001d;ISZ,G+\u00192mKJ+G.\u0019;j_:$\"\u0001\u0018;\t\u000bEl\u0001\u0019\u0001/\u0002/YL7/\u001b;V]\u0012,'oU;ccV,'/_!mS\u0006\u001cHCA<~)\ta\u0006\u0010C\u0003z\u001d\u0001\u0007!0A\u0004wSNLGo\u001c:\u0011\t\u0015ZH\fX\u0005\u0003y\u001a\u0012\u0011BR;oGRLwN\\\u0019\t\u000byt\u0001\u0019\u0001/\u0002\u0011=\u0004XM]1u_J\f\u0001\u0002V3ti>sG.\u001f\t\u0004\u0003\u0007\u0001R\"\u0001\u0001\u0003\u0011Q+7\u000f^(oYf\u001c\"\u0001\u0005\u0013\u0015\u0005\u0005\u0005\u0011\u0001I4fiJ+G.\u0019;j_:\u001cx+\u001b;i%\u0016\u001cx\u000e\u001c<fI6+G/\u00193bi\u0006,\"!a\u0004\u0011\t\u0005\r\u0011\u0011C\u0005\u0004\u0003'a#!\b*fY\u0006$\u0018n\u001c8t/&$\bNU3t_24X\rZ'fi\u0006$\u0017\r^1")
public class BridgedRelationMetadataProvider
implements RelationMetadataProvider {
    private volatile BridgedRelationMetadataProvider$TestOnly$ TestOnly$module;
    private final CatalogManager catalogManager;
    private final RelationResolution relationResolution;
    private final AnalyzerBridgeState analyzerBridgeState;
    private final ViewResolver viewResolver;
    private final HashMap<RelationId, LogicalPlan> relationsWithResolvedMetadata;
    private volatile LookupCatalog$CatalogAndMultipartIdentifier$ CatalogAndMultipartIdentifier$module;
    private volatile LookupCatalog$SessionCatalogAndIdentifier$ SessionCatalogAndIdentifier$module;
    private volatile LookupCatalog$NonSessionCatalogAndIdentifier$ NonSessionCatalogAndIdentifier$module;
    private volatile LookupCatalog$CatalogAndNamespace$ CatalogAndNamespace$module;
    private volatile LookupCatalog$CatalogAndIdentifier$ CatalogAndIdentifier$module;
    private volatile LookupCatalog$AsTableIdentifier$ AsTableIdentifier$module;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Option<LogicalPlan> getRelationWithResolvedMetadata(UnresolvedRelation unresolvedRelation) {
        return RelationMetadataProvider.getRelationWithResolvedMetadata$(this, unresolvedRelation);
    }

    @Override
    public RelationId relationIdFromUnresolvedRelation(UnresolvedRelation unresolvedRelation) {
        return RelationMetadataProvider.relationIdFromUnresolvedRelation$(this, unresolvedRelation);
    }

    @Override
    public CatalogPlugin currentCatalog() {
        return LookupCatalog.currentCatalog$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public BridgedRelationMetadataProvider$TestOnly$ TestOnly() {
        if (this.TestOnly$module == null) {
            this.TestOnly$lzycompute$1();
        }
        return this.TestOnly$module;
    }

    @Override
    public LookupCatalog$CatalogAndMultipartIdentifier$ org$apache$spark$sql$connector$catalog$LookupCatalog$$CatalogAndMultipartIdentifier() {
        if (this.CatalogAndMultipartIdentifier$module == null) {
            this.org$apache$spark$sql$connector$catalog$LookupCatalog$$CatalogAndMultipartIdentifier$lzycompute$1();
        }
        return this.CatalogAndMultipartIdentifier$module;
    }

    @Override
    public LookupCatalog$SessionCatalogAndIdentifier$ SessionCatalogAndIdentifier() {
        if (this.SessionCatalogAndIdentifier$module == null) {
            this.SessionCatalogAndIdentifier$lzycompute$1();
        }
        return this.SessionCatalogAndIdentifier$module;
    }

    @Override
    public LookupCatalog$NonSessionCatalogAndIdentifier$ NonSessionCatalogAndIdentifier() {
        if (this.NonSessionCatalogAndIdentifier$module == null) {
            this.NonSessionCatalogAndIdentifier$lzycompute$1();
        }
        return this.NonSessionCatalogAndIdentifier$module;
    }

    @Override
    public LookupCatalog$CatalogAndNamespace$ CatalogAndNamespace() {
        if (this.CatalogAndNamespace$module == null) {
            this.CatalogAndNamespace$lzycompute$1();
        }
        return this.CatalogAndNamespace$module;
    }

    @Override
    public LookupCatalog$CatalogAndIdentifier$ CatalogAndIdentifier() {
        if (this.CatalogAndIdentifier$module == null) {
            this.CatalogAndIdentifier$lzycompute$1();
        }
        return this.CatalogAndIdentifier$module;
    }

    @Override
    public LookupCatalog$AsTableIdentifier$ AsTableIdentifier() {
        if (this.AsTableIdentifier$module == null) {
            this.AsTableIdentifier$lzycompute$1();
        }
        return this.AsTableIdentifier$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    @Override
    public RelationResolution relationResolution() {
        return this.relationResolution;
    }

    @Override
    public HashMap<RelationId, LogicalPlan> relationsWithResolvedMetadata() {
        return this.relationsWithResolvedMetadata;
    }

    @Override
    public void resolve(LogicalPlan unresolvedPlan) {
        this.updateRelationsWithResolvedMetadata();
    }

    private void updateRelationsWithResolvedMetadata() {
        this.analyzerBridgeState.relationsWithResolvedMetadata().forEach((bridgeRelationId, relationWithResolvedMetadata) -> {
            Object object = $this.viewResolver.getCatalogAndNamespace().getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
            Seq<String> seq = bridgeRelationId.catalogAndNamespace();
            if (!(object != null ? !object.equals(seq) : seq != null)) {
                this.relationsWithResolvedMetadata().put(this.relationIdFromUnresolvedRelation(bridgeRelationId.unresolvedRelation()), this.visitUnderSubqueryAlias((LogicalPlan)relationWithResolvedMetadata, (Function1<LogicalPlan, LogicalPlan>)(Function1 & Serializable)relation -> this.tryConvertHiveTableRelation(this.tryConvertUnresolvedCatalogRelation((LogicalPlan)relation))));
                return;
            }
        });
    }

    private LogicalPlan tryConvertUnresolvedCatalogRelation(LogicalPlan relation) {
        LogicalPlan logicalPlan = relation;
        if (logicalPlan instanceof UnresolvedCatalogRelation) {
            UnresolvedCatalogRelation unresolvedCatalogRelation = (UnresolvedCatalogRelation)logicalPlan;
            return this.analyzerBridgeState.catalogRelationsWithResolvedMetadata().getOrDefault(unresolvedCatalogRelation, unresolvedCatalogRelation);
        }
        return relation;
    }

    private LogicalPlan tryConvertHiveTableRelation(LogicalPlan relation) {
        LogicalPlan logicalPlan = relation;
        if (logicalPlan instanceof LeafNode) {
            LeafNode leafNode = (LeafNode)((Object)logicalPlan);
            return (LogicalPlan)this.analyzerBridgeState.getLogicalRelationForHiveRelation((LogicalPlan)((Object)leafNode)).getOrElse((Function0 & Serializable)() -> leafNode);
        }
        return relation;
    }

    private LogicalPlan visitUnderSubqueryAlias(LogicalPlan operator, Function1<LogicalPlan, LogicalPlan> visitor) {
        LogicalPlan logicalPlan = operator;
        if (logicalPlan instanceof SubqueryAlias) {
            SubqueryAlias subqueryAlias = (SubqueryAlias)logicalPlan;
            AliasIdentifier id = subqueryAlias.identifier();
            LogicalPlan child = subqueryAlias.child();
            if (child != null) {
                LogicalPlan logicalPlan2 = child;
                return new SubqueryAlias(id, (LogicalPlan)visitor.apply((Object)logicalPlan2));
            }
        }
        return (LogicalPlan)visitor.apply((Object)operator);
    }

    private final void TestOnly$lzycompute$1() {
        BridgedRelationMetadataProvider bridgedRelationMetadataProvider = this;
        synchronized (bridgedRelationMetadataProvider) {
            if (this.TestOnly$module == null) {
                this.TestOnly$module = new BridgedRelationMetadataProvider$TestOnly$(this);
            }
        }
    }

    private final void org$apache$spark$sql$connector$catalog$LookupCatalog$$CatalogAndMultipartIdentifier$lzycompute$1() {
        BridgedRelationMetadataProvider bridgedRelationMetadataProvider = this;
        synchronized (bridgedRelationMetadataProvider) {
            if (this.CatalogAndMultipartIdentifier$module == null) {
                this.CatalogAndMultipartIdentifier$module = new LookupCatalog$CatalogAndMultipartIdentifier$(this);
            }
        }
    }

    private final void SessionCatalogAndIdentifier$lzycompute$1() {
        BridgedRelationMetadataProvider bridgedRelationMetadataProvider = this;
        synchronized (bridgedRelationMetadataProvider) {
            if (this.SessionCatalogAndIdentifier$module == null) {
                this.SessionCatalogAndIdentifier$module = new LookupCatalog$SessionCatalogAndIdentifier$(this);
            }
        }
    }

    private final void NonSessionCatalogAndIdentifier$lzycompute$1() {
        BridgedRelationMetadataProvider bridgedRelationMetadataProvider = this;
        synchronized (bridgedRelationMetadataProvider) {
            if (this.NonSessionCatalogAndIdentifier$module == null) {
                this.NonSessionCatalogAndIdentifier$module = new LookupCatalog$NonSessionCatalogAndIdentifier$(this);
            }
        }
    }

    private final void CatalogAndNamespace$lzycompute$1() {
        BridgedRelationMetadataProvider bridgedRelationMetadataProvider = this;
        synchronized (bridgedRelationMetadataProvider) {
            if (this.CatalogAndNamespace$module == null) {
                this.CatalogAndNamespace$module = new LookupCatalog$CatalogAndNamespace$(this);
            }
        }
    }

    private final void CatalogAndIdentifier$lzycompute$1() {
        BridgedRelationMetadataProvider bridgedRelationMetadataProvider = this;
        synchronized (bridgedRelationMetadataProvider) {
            if (this.CatalogAndIdentifier$module == null) {
                this.CatalogAndIdentifier$module = new LookupCatalog$CatalogAndIdentifier$(this);
            }
        }
    }

    private final void AsTableIdentifier$lzycompute$1() {
        BridgedRelationMetadataProvider bridgedRelationMetadataProvider = this;
        synchronized (bridgedRelationMetadataProvider) {
            if (this.AsTableIdentifier$module == null) {
                this.AsTableIdentifier$module = new LookupCatalog$AsTableIdentifier$(this);
            }
        }
    }

    public BridgedRelationMetadataProvider(CatalogManager catalogManager, RelationResolution relationResolution, AnalyzerBridgeState analyzerBridgeState, ViewResolver viewResolver) {
        this.catalogManager = catalogManager;
        this.relationResolution = relationResolution;
        this.analyzerBridgeState = analyzerBridgeState;
        this.viewResolver = viewResolver;
        Logging.$init$((Logging)this);
        LookupCatalog.$init$(this);
        RelationMetadataProvider.$init$(this);
        this.relationsWithResolvedMetadata = new HashMap();
    }
}

