/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.BinaryArithmeticWithDatetimeResolver$;
import org.apache.spark.sql.catalyst.analysis.resolver.BinaryArithmeticResolver$;
import org.apache.spark.sql.catalyst.analysis.resolver.CoercesExpressionTypes;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionTreeTraversal;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionTreeTraversalStack;
import org.apache.spark.sql.catalyst.analysis.resolver.ProducesUnresolvedSubtree;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvesExpressionChildren;
import org.apache.spark.sql.catalyst.analysis.resolver.TimezoneAwareExpressionResolver$;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateAdd;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.SubtractDates$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005m4Aa\u0005\u000b\u0001G!AQ\b\u0001B\u0001B\u0003%a\bC\u0003B\u0001\u0011\u0005!\tC\u0004F\u0001\t\u0007I\u0011\u0002$\t\r)\u0003\u0001\u0015!\u0003H\u0011\u001dY\u0005A1A\u0005R1Ca\u0001\u0016\u0001!\u0002\u0013i\u0005bB+\u0001\u0005\u0004%\t\u0006\u0014\u0005\u0007-\u0002\u0001\u000b\u0011B'\t\u000b]\u0003A\u0011\t-\t\u000bm\u0003A\u0011\u0002/\t\u000b}\u0003A\u0011\u00021\b\u000b\r$\u0002\u0012\u00013\u0007\u000bM!\u0002\u0012A3\t\u000b\u0005kA\u0011\u00014\t\u000f\u001dl!\u0019!C\u0005Q\"1\u00010\u0004Q\u0001\n%Dq!_\u0007C\u0002\u0013%\u0001\u000e\u0003\u0004{\u001b\u0001\u0006I!\u001b\u0002\u0019\u0005&t\u0017M]=Be&$\b.\\3uS\u000e\u0014Vm]8mm\u0016\u0014(BA\u000b\u0017\u0003!\u0011Xm]8mm\u0016\u0014(BA\f\u0019\u0003!\tg.\u00197zg&\u001c(BA\r\u001b\u0003!\u0019\u0017\r^1msN$(BA\u000e\u001d\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003;y\tQa\u001d9be.T!a\b\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0013aA8sO\u000e\u00011#\u0002\u0001%U]R\u0004CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0003,Y9\"T\"\u0001\u000b\n\u00055\"\"\u0001\u0005+sK\u0016tu\u000eZ3SKN|GN^3s!\ty#'D\u00011\u0015\t\t\u0004$A\u0006fqB\u0014Xm]:j_:\u001c\u0018BA\u001a1\u0005A\u0011\u0015N\\1ss\u0006\u0013\u0018\u000e\u001e5nKRL7\r\u0005\u00020k%\u0011a\u0007\r\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u00169\u0013\tIDCA\rQe>$WoY3t+:\u0014Xm]8mm\u0016$7+\u001e2ue\u0016,\u0007CA\u0016<\u0013\taDC\u0001\fD_\u0016\u00148-Z:FqB\u0014Xm]:j_:$\u0016\u0010]3t\u0003I)\u0007\u0010\u001d:fgNLwN\u001c*fg>dg/\u001a:\u0011\u0005-z\u0014B\u0001!\u0015\u0005I)\u0005\u0010\u001d:fgNLwN\u001c*fg>dg/\u001a:\u0002\rqJg.\u001b;?)\t\u0019E\t\u0005\u0002,\u0001!)QH\u0001a\u0001}\u0005QAO]1wKJ\u001c\u0018\r\\:\u0016\u0003\u001d\u0003\"a\u000b%\n\u0005%#\"\u0001H#yaJ,7o]5p]R\u0013X-\u001a+sCZ,'o]1m'R\f7m[\u0001\fiJ\fg/\u001a:tC2\u001c\b%A\nb]NLGK]1og\u001a|'/\\1uS>t7/F\u0001N!\tq\u0015K\u0004\u0002,\u001f&\u0011\u0001\u000bF\u0001\u0017\u0007>,'oY3t\u000bb\u0004(/Z:tS>tG+\u001f9fg&\u0011!k\u0015\u0002\u0010)J\fgn\u001d4pe6\fG/[8og*\u0011\u0001\u000bF\u0001\u0015C:\u001c\u0018\u000e\u0016:b]N4wN]7bi&|gn\u001d\u0011\u0002-9|g.\u00118tSR\u0013\u0018M\\:g_Jl\u0017\r^5p]N\fqC\\8o\u0003:\u001c\u0018\u000e\u0016:b]N4wN]7bi&|gn\u001d\u0011\u0002\u000fI,7o\u001c7wKR\u0011A'\u0017\u0005\u00065&\u0001\rAL\u0001\u001bk:\u0014Xm]8mm\u0016$')\u001b8bef\f%/\u001b;i[\u0016$\u0018nY\u0001\u001eiJ\fgn\u001d4pe6\u0014\u0015N\\1ss\u0006\u0013\u0018\u000e\u001e5nKRL7MT8eKR\u0011A'\u0018\u0005\u0006=*\u0001\rAL\u0001\u0011E&t\u0017M]=Be&$\b.\\3uS\u000e\fqB]3qY\u0006\u001cW\rR1uKRK\b/\u001a\u000b\u0003i\u0005DQAY\u0006A\u0002Q\n!\"\u001a=qe\u0016\u001c8/[8o\u0003a\u0011\u0015N\\1ss\u0006\u0013\u0018\u000e\u001e5nKRL7MU3t_24XM\u001d\t\u0003W5\u0019\"!\u0004\u0013\u0015\u0003\u0011\fQ\u0004V-Q\u000b~\u001bu*\u0012*D\u0013>su\f\u0016*B\u001dN3uJU'B)&{ejU\u000b\u0002SB\u0019!N];\u000f\u0005-\u0004hB\u00017p\u001b\u0005i'B\u00018#\u0003\u0019a$o\\8u}%\tq%\u0003\u0002rM\u00059\u0001/Y2lC\u001e,\u0017BA:u\u0005\r\u0019V-\u001d\u0006\u0003c\u001a\u0002B!\n<5i%\u0011qO\n\u0002\n\rVt7\r^5p]F\na\u0004V-Q\u000b~\u001bu*\u0012*D\u0013>su\f\u0016*B\u001dN3uJU'B)&{ej\u0015\u0011\u0002E\u0005s5+S0U3B+ulQ(F%\u000eKuJT0U%\u0006s5KR(S\u001b\u0006#\u0016j\u0014(T\u0003\r\nejU%`)f\u0003ViX\"P\u000bJ\u001b\u0015j\u0014(`)J\u000bej\u0015$P%6\u000bE+S(O'\u0002\u0002")
public class BinaryArithmeticResolver
implements TreeNodeResolver<BinaryArithmetic, Expression>,
ProducesUnresolvedSubtree,
CoercesExpressionTypes {
    private final ExpressionResolver expressionResolver;
    private final ExpressionTreeTraversalStack traversals;
    private final Seq<Function1<Expression, Expression>> ansiTransformations;
    private final Seq<Function1<Expression, Expression>> nonAnsiTransformations;

    @Override
    public Expression coerceExpressionTypes(Expression expression, ExpressionTreeTraversal expressionTreeTraversal) {
        return CoercesExpressionTypes.coerceExpressionTypes$(this, expression, expressionTreeTraversal);
    }

    @Override
    public Expression withResolvedSubtree(Expression expression, Function1<Expression, Expression> expressionResolver, Function0<Expression> body) {
        return ProducesUnresolvedSubtree.withResolvedSubtree$(this, expression, expressionResolver, body);
    }

    @Override
    public boolean tryPopSinglePassSubtreeBoundary(Expression unresolvedExpression) {
        return ProducesUnresolvedSubtree.tryPopSinglePassSubtreeBoundary$(this, unresolvedExpression);
    }

    @Override
    public Expression withResolvedChildren(UnaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(BinaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(TernaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(QuaternaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(Expression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$resolver$CoercesExpressionTypes$_setter_$ansiTransformations_$eq(Seq<Function1<Expression, Expression>> x$1) {
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$resolver$CoercesExpressionTypes$_setter_$nonAnsiTransformations_$eq(Seq<Function1<Expression, Expression>> x$1) {
    }

    private ExpressionTreeTraversalStack traversals() {
        return this.traversals;
    }

    @Override
    public Seq<Function1<Expression, Expression>> ansiTransformations() {
        return this.ansiTransformations;
    }

    @Override
    public Seq<Function1<Expression, Expression>> nonAnsiTransformations() {
        return this.nonAnsiTransformations;
    }

    @Override
    public Expression resolve(BinaryArithmetic unresolvedBinaryArithmetic) {
        BinaryArithmetic binaryArithmeticWithResolvedChildren = (BinaryArithmetic)this.withResolvedChildren(unresolvedBinaryArithmetic, (Function1<Expression, Expression>)(Function1 & Serializable)unresolvedExpression -> $this.expressionResolver.resolve((Expression)unresolvedExpression));
        Expression binaryArithmeticWithResolvedSubtree = this.withResolvedSubtree(binaryArithmeticWithResolvedChildren, (Function1<Expression, Expression>)(Function1 & Serializable)unresolvedExpression -> $this.expressionResolver.resolve((Expression)unresolvedExpression), (Function0<Expression>)(Function0 & Serializable)() -> this.transformBinaryArithmeticNode(binaryArithmeticWithResolvedChildren));
        return TimezoneAwareExpressionResolver$.MODULE$.resolveTimezone(binaryArithmeticWithResolvedSubtree, this.traversals().current().sessionLocalTimeZone());
    }

    private Expression transformBinaryArithmeticNode(BinaryArithmetic binaryArithmetic) {
        Expression binaryArithmeticWithDateTypeReplaced = this.replaceDateType(binaryArithmetic);
        Expression binaryArithmeticWithTypeCoercion = this.coerceExpressionTypes(binaryArithmeticWithDateTypeReplaced, this.traversals().current());
        Tuple2 tuple2 = new Tuple2((Object)((Expression)binaryArithmetic.left()).dataType(), (Object)((Expression)binaryArithmetic.right()).dataType());
        if (tuple2 != null && tuple2._1() instanceof DateType && tuple2._2() instanceof StringType) {
            Expression expression = binaryArithmeticWithTypeCoercion;
            if (expression instanceof Add) {
                Add add = (Add)expression;
                return new DateAdd(add.left(), add.right());
            }
            if (expression instanceof Subtract) {
                Subtract subtract = (Subtract)expression;
                return SubtractDates$.MODULE$.apply(subtract.left(), subtract.right());
            }
            return expression;
        }
        return binaryArithmeticWithTypeCoercion;
    }

    private Expression replaceDateType(Expression expression) {
        Expression expression2 = expression;
        if (expression2 instanceof Add ? true : (expression2 instanceof Subtract ? true : (expression2 instanceof Multiply ? true : expression2 instanceof Divide))) {
            return BinaryArithmeticWithDatetimeResolver$.MODULE$.resolve(expression2);
        }
        return expression2;
    }

    public BinaryArithmeticResolver(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ResolvesExpressionChildren.$init$(this);
        ProducesUnresolvedSubtree.$init$(this);
        CoercesExpressionTypes.$init$(this);
        this.traversals = expressionResolver.getExpressionTreeTraversals();
        this.ansiTransformations = BinaryArithmeticResolver$.MODULE$.org$apache$spark$sql$catalyst$analysis$resolver$BinaryArithmeticResolver$$ANSI_TYPE_COERCION_TRANSFORMATIONS();
        this.nonAnsiTransformations = BinaryArithmeticResolver$.MODULE$.org$apache$spark$sql$catalyst$analysis$resolver$BinaryArithmeticResolver$$TYPE_COERCION_TRANSFORMATIONS();
    }
}

