/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.analysis.CollationStrength;
import org.apache.spark.sql.catalyst.analysis.CollationStrength$Default$;
import org.apache.spark.sql.catalyst.analysis.CollationStrength$Explicit$;
import org.apache.spark.sql.catalyst.analysis.CollationStrength$Implicit$;
import org.apache.spark.sql.catalyst.analysis.CollationStrength$Indeterminate$;
import org.apache.spark.sql.catalyst.analysis.CollationTypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.StringTypeWithContext;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.ArrayAppend;
import org.apache.spark.sql.catalyst.expressions.ArrayContains;
import org.apache.spark.sql.catalyst.expressions.ArrayExcept;
import org.apache.spark.sql.catalyst.expressions.ArrayIntersect;
import org.apache.spark.sql.catalyst.expressions.ArrayJoin;
import org.apache.spark.sql.catalyst.expressions.ArrayPosition;
import org.apache.spark.sql.catalyst.expressions.ArrayRemove;
import org.apache.spark.sql.catalyst.expressions.ArrayUnion;
import org.apache.spark.sql.catalyst.expressions.ArraysOverlap;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.Collate;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.ConcatWs;
import org.apache.spark.sql.catalyst.expressions.Contains;
import org.apache.spark.sql.catalyst.expressions.CreateArray;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Elt;
import org.apache.spark.sql.catalyst.expressions.EndsWith;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FindInSet;
import org.apache.spark.sql.catalyst.expressions.GetMapValue;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Greatest;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSubquery;
import org.apache.spark.sql.catalyst.expressions.InitCap;
import org.apache.spark.sql.catalyst.expressions.Lag;
import org.apache.spark.sql.catalyst.expressions.Lead;
import org.apache.spark.sql.catalyst.expressions.Least;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Levenshtein;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Lower;
import org.apache.spark.sql.catalyst.expressions.Mask;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Overlay;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace;
import org.apache.spark.sql.catalyst.expressions.SplitPart;
import org.apache.spark.sql.catalyst.expressions.StartsWith;
import org.apache.spark.sql.catalyst.expressions.StringInstr;
import org.apache.spark.sql.catalyst.expressions.StringLPad;
import org.apache.spark.sql.catalyst.expressions.StringLocate;
import org.apache.spark.sql.catalyst.expressions.StringPredicate;
import org.apache.spark.sql.catalyst.expressions.StringRPad;
import org.apache.spark.sql.catalyst.expressions.StringReplace;
import org.apache.spark.sql.catalyst.expressions.StringSplitSQL;
import org.apache.spark.sql.catalyst.expressions.StringToMap;
import org.apache.spark.sql.catalyst.expressions.StringTranslate;
import org.apache.spark.sql.catalyst.expressions.StringTrim;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.expressions.SubstringIndex;
import org.apache.spark.sql.catalyst.expressions.ToNumber;
import org.apache.spark.sql.catalyst.expressions.TryToNumber;
import org.apache.spark.sql.catalyst.expressions.Upper;
import org.apache.spark.sql.catalyst.expressions.VariableReference;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.AggregateHint;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreeNodeTag;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IndeterminateStringType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

public final class CollationTypeCoercion$ {
    public static final CollationTypeCoercion$ MODULE$ = new CollationTypeCoercion$();
    private static final TreeNodeTag<DataType> org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$COLLATION_CONTEXT_TAG = new TreeNodeTag("collationContext");

    public TreeNodeTag<DataType> org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$COLLATION_CONTEXT_TAG() {
        return org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$COLLATION_CONTEXT_TAG;
    }

    public boolean org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$hasCollationContextTag(Expression expr) {
        return expr.getTagValue(this.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$COLLATION_CONTEXT_TAG()).isDefined();
    }

    public Expression apply(Expression expression) {
        CreateMap createMap;
        CaseWhen caseWhen;
        Expression expression2 = expression;
        if (this.shouldFailWithIndeterminateCollation(expression2)) {
            throw package$.MODULE$.AnalysisErrorAt(expression2).failAnalysis("INDETERMINATE_COLLATION_IN_EXPRESSION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)TypeUtils$.MODULE$.toSQLExpr(expression2))}))));
        }
        if (expression2 instanceof CaseWhen && !TypeCoercion$.MODULE$.haveSameType((caseWhen = (CaseWhen)expression2).inputTypesForMerging())) {
            Option<DataType> outputStringType = this.findLeastCommonStringType((Seq<Expression>)((Seq)((IterableOps)caseWhen.branches().map((Function1 & Serializable)x$1 -> (Expression)x$1._2())).$plus$plus(caseWhen.elseValue())));
            Option<DataType> option = outputStringType;
            if (option instanceof Some) {
                Some some = (Some)option;
                DataType st = (DataType)some.value();
                Seq newBranches = (Seq)caseWhen.branches().map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Expression condition = (Expression)tuple2._1();
                        Expression value = (Expression)tuple2._2();
                        return new Tuple2((Object)condition, (Object)MODULE$.changeType(value, st));
                    }
                    throw new MatchError((Object)tuple2);
                });
                Option newElseValue = caseWhen.elseValue().map((Function1 & Serializable)e -> MODULE$.changeType((Expression)e, st));
                return new CaseWhen((Seq<Tuple2<Expression, Expression>>)newBranches, (Option<Expression>)newElseValue);
            }
            return caseWhen;
        }
        if (expression2 instanceof CreateMap && (createMap = (CreateMap)expression2).children().size() % 2 == 0) {
            Seq<Expression> newKeys = this.collateToSingleType(createMap, (Seq<Expression>)createMap.keys());
            Seq<Expression> newValues = this.collateToSingleType(createMap, (Seq<Expression>)createMap.values());
            return (Expression)createMap.withNewChildren((Seq)((IterableOps)newKeys.zip(newValues)).flatMap((Function1 & Serializable)pair -> new .colon.colon((Object)((Expression)pair._1()), (List)new .colon.colon((Object)((Expression)pair._2()), (List)Nil$.MODULE$))));
        }
        if (expression2 instanceof CreateNamedStruct) {
            CreateNamedStruct createNamedStruct = (CreateNamedStruct)expression2;
            return createNamedStruct;
        }
        if (expression2 instanceof GetMapValue) {
            GetMapValue getMapValue = (GetMapValue)expression2;
            Expression child = getMapValue.child();
            Expression key = getMapValue.key();
            DataType dataType = getMapValue.keyType();
            DataType dataType2 = key.dataType();
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                Literal literal;
                Expression expression3 = key;
                if (expression3 instanceof Literal && (literal = (Literal)expression3).dataType() instanceof StringType) {
                    return new GetMapValue(child, new Cast(key, getMapValue.keyType(), Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4()));
                }
                return getMapValue;
            }
        }
        if (expression2 instanceof In ? true : (expression2 instanceof InSubquery ? true : (expression2 instanceof CreateArray ? true : (expression2 instanceof ArrayJoin ? true : (expression2 instanceof Concat ? true : (expression2 instanceof Greatest ? true : (expression2 instanceof Least ? true : (expression2 instanceof Coalesce ? true : (expression2 instanceof ArrayContains ? true : (expression2 instanceof ArrayExcept ? true : (expression2 instanceof ConcatWs ? true : (expression2 instanceof Mask ? true : (expression2 instanceof StringReplace ? true : (expression2 instanceof StringTranslate ? true : (expression2 instanceof StringTrim ? true : (expression2 instanceof StringTrimLeft ? true : (expression2 instanceof StringTrimRight ? true : (expression2 instanceof ArrayAppend ? true : (expression2 instanceof ArrayIntersect ? true : (expression2 instanceof ArrayPosition ? true : (expression2 instanceof ArrayRemove ? true : (expression2 instanceof ArrayUnion ? true : (expression2 instanceof ArraysOverlap ? true : (expression2 instanceof Contains ? true : (expression2 instanceof EndsWith ? true : (expression2 instanceof EqualNullSafe ? true : (expression2 instanceof EqualTo ? true : (expression2 instanceof FindInSet ? true : (expression2 instanceof GreaterThan ? true : (expression2 instanceof GreaterThanOrEqual ? true : (expression2 instanceof LessThan ? true : (expression2 instanceof LessThanOrEqual ? true : (expression2 instanceof StartsWith ? true : (expression2 instanceof StringInstr ? true : (expression2 instanceof ToNumber ? true : (expression2 instanceof TryToNumber ? true : (expression2 instanceof StringToMap ? true : (expression2 instanceof Levenshtein ? true : (expression2 instanceof StringSplitSQL ? true : (expression2 instanceof SplitPart ? true : (expression2 instanceof Lag ? true : (expression2 instanceof Lead ? true : (expression2 instanceof RegExpReplace ? true : (expression2 instanceof StringRPad ? true : (expression2 instanceof StringLPad ? true : (expression2 instanceof Overlay ? true : (expression2 instanceof Elt ? true : (expression2 instanceof SubstringIndex ? true : (expression2 instanceof StringLocate ? true : expression2 instanceof If))))))))))))))))))))))))))))))))))))))))))))))))) {
            Seq<Expression> newChildren = this.collateToSingleType(expression2, expression2.children());
            return expression2.withNewChildren(newChildren);
        }
        return expression2;
    }

    public boolean org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$hasStringType(DataType dt) {
        return dt.existsRecursively((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CollationTypeCoercion$.$anonfun$hasStringType$1(x0$1)));
    }

    private Expression changeType(Expression expr, DataType newType) {
        Option<DataType> option = this.mergeTypes(expr.dataType(), newType);
        if (option instanceof Some) {
            DataType newDataType;
            Some some = (Some)option;
            DataType dataType = newDataType = (DataType)some.value();
            DataType dataType2 = expr.dataType();
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                Predef$.MODULE$.assert(!newDataType.existsRecursively((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CollationTypeCoercion$.$anonfun$changeType$1(x$2))));
                Expression expression = expr;
                if (expression instanceof Literal) {
                    Literal literal = (Literal)expression;
                    DataType x$1 = newDataType;
                    Object x$22 = literal.copy$default$1();
                    return literal.copy(x$22, x$1);
                }
                if (expression instanceof Cast) {
                    Cast cast = (Cast)expression;
                    DataType x$3 = newDataType;
                    Expression x$4 = cast.copy$default$1();
                    Option<String> x$5 = cast.copy$default$3();
                    Enumeration.Value x$6 = cast.copy$default$4();
                    return cast.copy(x$4, x$3, x$5, x$6);
                }
                if (expression instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)expression;
                    return this.changeTypeInSubquery(subqueryExpression, newType);
                }
                return new Cast(expr, newDataType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
            }
        }
        return expr;
    }

    private SubqueryExpression changeTypeInSubquery(SubqueryExpression subqueryExpression, DataType newType) {
        LogicalPlan logicalPlan;
        LogicalPlan logicalPlan2 = (LogicalPlan)subqueryExpression.plan();
        if (logicalPlan2 instanceof Project) {
            Project project = (Project)logicalPlan2;
            Seq newProjectList = (Seq)project.projectList().map((Function1 & Serializable)ex -> this.transformNamedExpressions$1((NamedExpression)ex, newType));
            logicalPlan = project.copy((Seq<NamedExpression>)newProjectList, project.copy$default$2());
        } else if (logicalPlan2 instanceof Aggregate) {
            Seq newAggregateExpressions;
            Aggregate aggregate = (Aggregate)logicalPlan2;
            Seq x$1 = newAggregateExpressions = (Seq)aggregate.aggregateExpressions().map((Function1 & Serializable)ex -> this.transformNamedExpressions$1((NamedExpression)ex, newType));
            Seq<Expression> x$2 = aggregate.copy$default$1();
            LogicalPlan x$3 = aggregate.copy$default$3();
            Option<AggregateHint> x$4 = aggregate.copy$default$4();
            logicalPlan = aggregate.copy(x$2, (Seq<NamedExpression>)x$1, x$3, x$4);
        } else {
            logicalPlan = logicalPlan2;
        }
        LogicalPlan newPlan = logicalPlan;
        return subqueryExpression.withNewPlan(newPlan);
    }

    private Option<DataType> mergeTypes(DataType inType, DataType castType) {
        Option<DataType> outType = this.mergeStructurally(inType, castType, (PartialFunction<Tuple2<DataType, DataType>, DataType>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<DataType, DataType>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    DataType right = (DataType)A1._2();
                    if (A1._1() instanceof StringType && right instanceof StringTypeWithContext) {
                        StringTypeWithContext stringTypeWithContext = (StringTypeWithContext)right;
                        return (B1)stringTypeWithContext.stringType();
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<DataType, DataType> x1) {
                Tuple2<DataType, DataType> tuple2 = x1;
                if (tuple2 != null) {
                    DataType right = (DataType)tuple2._2();
                    if (tuple2._1() instanceof StringType && right instanceof StringTypeWithContext) {
                        return true;
                    }
                }
                return false;
            }
        });
        return outType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Option<DataType> mergeStructurally(DataType leftType, DataType rightType, PartialFunction<Tuple2<DataType, DataType>, DataType> baseCase) {
        Option option;
        Object object = new Object();
        try {
            Tuple2 tuple2 = new Tuple2((Object)leftType, (Object)rightType);
            if (baseCase.isDefinedAt((Object)new Tuple2((Object)leftType, (Object)rightType))) {
                option = Option$.MODULE$.apply(baseCase.apply((Object)new Tuple2((Object)leftType, (Object)rightType)));
                return option;
            }
            DataType dataType = leftType;
            DataType dataType2 = rightType;
            if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                option = new Some((Object)leftType);
                return option;
            }
            if (tuple2 != null) {
                DataType dataType3 = (DataType)tuple2._1();
                DataType dataType4 = (DataType)tuple2._2();
                if (dataType3 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType3;
                    DataType leftElemType = arrayType.elementType();
                    boolean nullable = arrayType.containsNull();
                    if (dataType4 instanceof ArrayType) {
                        ArrayType arrayType2 = (ArrayType)dataType4;
                        DataType rightElemType = arrayType2.elementType();
                        option = this.mergeStructurally(leftElemType, rightElemType, baseCase).map((Function1 & Serializable)x$3 -> new ArrayType(x$3, nullable));
                        return option;
                    }
                }
            }
            if (tuple2 != null) {
                DataType dataType5 = (DataType)tuple2._1();
                DataType dataType6 = (DataType)tuple2._2();
                if (dataType5 instanceof MapType) {
                    MapType mapType = (MapType)dataType5;
                    DataType leftKey = mapType.keyType();
                    DataType leftValue = mapType.valueType();
                    boolean nullable = mapType.valueContainsNull();
                    if (dataType6 instanceof MapType) {
                        MapType mapType2 = (MapType)dataType6;
                        DataType rightKey = mapType2.keyType();
                        DataType rightValue = mapType2.valueType();
                        option = this.mergeStructurally(leftKey, rightKey, baseCase).flatMap((Function1 & Serializable)newKeyType -> MODULE$.mergeStructurally(leftValue, rightValue, baseCase).map((Function1 & Serializable)newValueType -> new MapType(newKeyType, newValueType, nullable)));
                        return option;
                    }
                }
            }
            if (tuple2 != null) {
                DataType dataType7 = (DataType)tuple2._1();
                DataType right = (DataType)tuple2._2();
                if (dataType7 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType7;
                    DataType elementType = arrayType.elementType();
                    boolean nullable = arrayType.containsNull();
                    option = this.mergeStructurally(elementType, right, baseCase).map((Function1 & Serializable)x$4 -> new ArrayType(x$4, nullable));
                    return option;
                }
            }
            if (tuple2 != null) {
                DataType left = (DataType)tuple2._1();
                DataType dataType8 = (DataType)tuple2._2();
                if (dataType8 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType8;
                    DataType elementType = arrayType.elementType();
                    option = this.mergeStructurally(left, elementType, baseCase);
                    return option;
                }
            }
            if (tuple2 != null) {
                DataType dataType9 = (DataType)tuple2._1();
                DataType dataType10 = (DataType)tuple2._2();
                if (dataType9 instanceof StructType) {
                    StructType structType = (StructType)dataType9;
                    StructField[] leftFields = structType.fields();
                    if (dataType10 instanceof StructType) {
                        StructType structType2 = (StructType)dataType10;
                        StructField[] rightFields = structType2.fields();
                        if (leftFields.length != rightFields.length) {
                            return None$.MODULE$;
                        }
                        StructField[] newFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])leftFields), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])rightFields))), (Function1 & Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 != null) {
                                StructField leftField = (StructField)tuple2._1();
                                StructField rightField = (StructField)tuple2._2();
                                Option<DataType> newType = MODULE$.mergeStructurally(leftField.dataType(), rightField.dataType(), baseCase);
                                if (newType.isEmpty()) {
                                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                                }
                                DataType x$1 = (DataType)newType.get();
                                String x$2 = leftField.copy$default$1();
                                boolean x$3 = leftField.copy$default$3();
                                Metadata x$4 = leftField.copy$default$4();
                                return leftField.copy(x$2, x$1, x$3, x$4);
                            }
                            throw new MatchError((Object)tuple2);
                        }, ClassTag$.MODULE$.apply(StructField.class));
                        option = new Some((Object)new StructType(newFields));
                        return option;
                    }
                }
            }
            option = None$.MODULE$;
            return option;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) throw ex;
            option = (Option)ex.value();
            return option;
        }
    }

    public Seq<Expression> collateToSingleType(Expression expression, Seq<Expression> children2) {
        Seq stringExpressions = (Seq)children2.filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)CollationTypeCoercion$.MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$hasStringType(e.dataType())));
        Option<DataType> lctOpt = this.findLeastCommonStringType((Seq<Expression>)stringExpressions);
        Option<DataType> option = lctOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            DataType lct = (DataType)some.value();
            this.checkIndeterminateCollation(expression, lct);
            return (Seq)children2.map((Function1 & Serializable)x0$1 -> {
                Expression expression = x0$1;
                if (MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$hasStringType(expression.dataType())) {
                    return MODULE$.changeType(expression, lct);
                }
                return expression;
            });
        }
        return children2;
    }

    private Option<DataType> findLeastCommonStringType(Seq<Expression> expressions) {
        if (!expressions.exists((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)SchemaUtils$.MODULE$.hasNonUTF8BinaryCollation(e.dataType())))) {
            return None$.MODULE$;
        }
        Option collationContextWinner = (Option)expressions.foldLeft(this.findCollationContext((Expression)expressions.head()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Option option;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Option option2 = (Option)tuple2._1();
                Expression right = (Expression)tuple2._2();
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    DataType left = (DataType)some.value();
                    return MODULE$.findCollationContext(right).flatMap((Function1 & Serializable)ctx -> MODULE$.mergeWinner(left, (DataType)ctx));
                }
            }
            if (tuple2 != null && None$.MODULE$.equals(option = (Option)tuple2._1())) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        });
        return collationContextWinner;
    }

    private Option<DataType> findCollationContext(Expression expr2) {
        Some some;
        Expression expression = expr2;
        if (this.collationStrengthBaseCases().isDefinedAt((Object)expr2)) {
            some = (Some)this.collationStrengthBaseCases().apply((Object)expr2);
        } else if (expression instanceof GetStructField) {
            Some some2;
            DataType struct;
            GetStructField getStructField = (GetStructField)expression;
            Option<DataType> childContext = this.findCollationContext(getStructField.child());
            Option<DataType> option = childContext;
            if (option instanceof Some && (struct = (DataType)(some2 = (Some)option).value()) instanceof StructType) {
                StructType structType = (StructType)struct;
                StructField field = structType.fields()[getStructField.ordinal()];
                some = new Some((Object)field.dataType());
            } else {
                some = None$.MODULE$;
            }
        } else if (expression instanceof GetMapValue) {
            Some some3;
            DataType dataType;
            GetMapValue getMapValue = (GetMapValue)expression;
            Option<DataType> option = this.findCollationContext(getMapValue.child());
            if (option instanceof Some && (dataType = (DataType)(some3 = (Some)option).value()) instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType valueType = mapType.valueType();
                some = this.mergeWinner(getMapValue.dataType(), valueType);
            } else {
                some = None$.MODULE$;
            }
        } else if (expression instanceof CreateNamedStruct) {
            CreateNamedStruct createNamedStruct = (CreateNamedStruct)expression;
            List childrenContexts = createNamedStruct.valExprs().map((Function1 & Serializable)expr -> MODULE$.findCollationContext((Expression)expr));
            if (childrenContexts.isEmpty()) {
                return None$.MODULE$;
            }
            StructField[] newFields = (StructField[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])createNamedStruct.dataType().fields()), (IterableOnce)childrenContexts)), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (option instanceof Some) {
                        DataType context;
                        Some some = (Some)option;
                        DataType x$1 = context = (DataType)some.value();
                        String x$2 = field.copy$default$1();
                        boolean x$3 = field.copy$default$3();
                        Metadata x$4 = field.copy$default$4();
                        return field.copy(x$2, x$1, x$3, x$4);
                    }
                }
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    Option option = (Option)tuple2._2();
                    if (None$.MODULE$.equals(option)) {
                        return field;
                    }
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(StructField.class));
            some = new Some((Object)new StructType(newFields));
        } else if (expression instanceof CreateMap) {
            CreateMap createMap = (CreateMap)expression;
            IndexedSeq keyContexts = (IndexedSeq)createMap.keys().flatMap((Function1 & Serializable)expr -> MODULE$.findCollationContext((Expression)expr));
            IndexedSeq valueContexts = (IndexedSeq)createMap.values().flatMap((Function1 & Serializable)expr -> MODULE$.findCollationContext((Expression)expr));
            if (keyContexts.length() + valueContexts.length() != createMap.children().length()) {
                return None$.MODULE$;
            }
            Option<DataType> keyContextWinner = this.mergeWinners(createMap.dataType().keyType(), (Seq<DataType>)keyContexts);
            Option<DataType> valueContextWinner = this.mergeWinners(createMap.dataType().valueType(), (Seq<DataType>)valueContexts);
            if (keyContextWinner.isEmpty() || valueContextWinner.isEmpty()) {
                return None$.MODULE$;
            }
            some = new Some((Object)MapType$.MODULE$.apply((DataType)keyContextWinner.get(), (DataType)valueContextWinner.get()));
        } else {
            Seq childContexts = (Seq)expr2.children().flatMap((Function1 & Serializable)expr -> MODULE$.findCollationContext((Expression)expr));
            some = this.mergeWinners(expr2.dataType(), (Seq<DataType>)childContexts);
        }
        Some contextOpt = some;
        contextOpt.foreach((Function1 & Serializable)x$5 -> {
            expr2.setTagValue(CollationTypeCoercion$.MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$COLLATION_CONTEXT_TAG(), x$5);
            return BoxedUnit.UNIT;
        });
        return contextOpt;
    }

    private PartialFunction<Expression, Option<DataType>> collationStrengthBaseCases() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (CollationTypeCoercion$.MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$hasCollationContextTag(A1)) {
                    return (B1)new Some(A1.getTagValue(CollationTypeCoercion$.MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$COLLATION_CONTEXT_TAG()).get());
                }
                if (!A1.dataType().existsRecursively((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)anonfun.collationStrengthBaseCases.1.$anonfun$applyOrElse$1(x$6)))) {
                    return (B1)None$.MODULE$;
                }
                if (A1 instanceof Collate) {
                    Collate collate = (Collate)A1;
                    return (B1)new Some((Object)CollationTypeCoercion$.MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$addContextToStringType(collate.dataType(), CollationStrength$Explicit$.MODULE$));
                }
                if (A1 instanceof Cast) {
                    Cast cast = (Cast)A1;
                    CollationStrength castStrength = CollationTypeCoercion$.MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$hasStringType(cast.child().dataType()) ? CollationStrength$Implicit$.MODULE$ : CollationStrength$Default$.MODULE$;
                    return (B1)new Some((Object)CollationTypeCoercion$.MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$addContextToStringType(cast.dataType(), castStrength));
                }
                if (A1 instanceof NamedExpression ? true : (A1 instanceof SubqueryExpression ? true : A1 instanceof VariableReference)) {
                    return (B1)new Some((Object)CollationTypeCoercion$.MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$addContextToStringType(A1.dataType(), CollationStrength$Implicit$.MODULE$));
                }
                if (A1 instanceof Literal) {
                    Literal literal = (Literal)A1;
                    return (B1)new Some((Object)CollationTypeCoercion$.MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$addContextToStringType(literal.dataType(), CollationStrength$Default$.MODULE$));
                }
                if (!A1.children().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)anonfun.collationStrengthBaseCases.1.$anonfun$applyOrElse$2(x$7)))) {
                    return (B1)new Some((Object)CollationTypeCoercion$.MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$addContextToStringType(A1.dataType(), CollationStrength$Default$.MODULE$));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                if (CollationTypeCoercion$.MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$hasCollationContextTag(expression)) {
                    return true;
                }
                if (!expression.dataType().existsRecursively((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)anonfun.collationStrengthBaseCases.1.$anonfun$isDefinedAt$1(x$6)))) {
                    return true;
                }
                if (expression instanceof Collate) {
                    return true;
                }
                if (expression instanceof Cast) {
                    return true;
                }
                if (expression instanceof NamedExpression ? true : (expression instanceof SubqueryExpression ? true : expression instanceof VariableReference)) {
                    return true;
                }
                if (expression instanceof Literal) {
                    return true;
                }
                return !expression.children().exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)anonfun.collationStrengthBaseCases.1.$anonfun$isDefinedAt$2(x$7)));
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(DataType x$6) {
                return x$6 instanceof StringType;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$3(DataType x$8) {
                return x$8 instanceof StringType;
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$2(Expression x$7) {
                return x$7.dataType().existsRecursively((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)anonfun.collationStrengthBaseCases.1.$anonfun$applyOrElse$3(x$8)));
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$1(DataType x$6) {
                return x$6 instanceof StringType;
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$3(DataType x$8) {
                return x$8 instanceof StringType;
            }

            public static final /* synthetic */ boolean $anonfun$isDefinedAt$2(Expression x$7) {
                return x$7.dataType().existsRecursively((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)anonfun.collationStrengthBaseCases.1.$anonfun$isDefinedAt$3(x$8)));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.types.DataType ), $anonfun$applyOrElse$2$adapted(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$3$adapted(org.apache.spark.sql.types.DataType ), $anonfun$isDefinedAt$1$adapted(org.apache.spark.sql.types.DataType ), $anonfun$isDefinedAt$2$adapted(org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$isDefinedAt$3$adapted(org.apache.spark.sql.types.DataType )}, serializedLambda);
            }
        };
    }

    public DataType org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$addContextToStringType(DataType dt, CollationStrength strength) {
        return dt.transformRecursively((PartialFunction)new Serializable(strength){
            private static final long serialVersionUID = 0L;
            private final CollationStrength strength$1;

            public final <A1 extends DataType, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof StringType) {
                    StringType stringType = (StringType)A1;
                    return (B1)new StringTypeWithContext(stringType, this.strength$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(DataType x1) {
                DataType dataType = x1;
                return dataType instanceof StringType;
            }
            {
                this.strength$1 = strength$1;
            }
        });
    }

    private Option<DataType> mergeWinners(DataType start, Seq<DataType> rest) {
        return (Option)rest.foldLeft((Object)Option$.MODULE$.apply((Object)start), (Function2 & Serializable)(x0$1, x1$1) -> {
            Option option;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Option option2 = (Option)tuple2._1();
                DataType childContext = (DataType)tuple2._2();
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    DataType acc = (DataType)some.value();
                    return MODULE$.mergeWinner(acc, childContext);
                }
            }
            if (tuple2 != null && None$.MODULE$.equals(option = (Option)tuple2._1())) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private Option<DataType> mergeWinner(DataType left, DataType right) {
        return this.mergeStructurally(left, right, (PartialFunction<Tuple2<DataType, DataType>, DataType>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<DataType, DataType>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    DataType left = (DataType)A1._1();
                    DataType right = (DataType)A1._2();
                    if (left instanceof StringTypeWithContext) {
                        StringTypeWithContext stringTypeWithContext = (StringTypeWithContext)left;
                        if (right instanceof StringTypeWithContext) {
                            StringTypeWithContext stringTypeWithContext2 = (StringTypeWithContext)right;
                            return (B1)CollationTypeCoercion$.MODULE$.org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$getWinningStringType(stringTypeWithContext, stringTypeWithContext2);
                        }
                    }
                }
                if (A1 != null) {
                    DataType right = (DataType)A1._2();
                    if (A1._1() instanceof StringType && right instanceof StringTypeWithContext) {
                        StringTypeWithContext stringTypeWithContext = (StringTypeWithContext)right;
                        return (B1)stringTypeWithContext;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<DataType, DataType> x1) {
                Tuple2<DataType, DataType> tuple2 = x1;
                if (tuple2 != null) {
                    DataType left = (DataType)tuple2._1();
                    DataType right = (DataType)tuple2._2();
                    if (left instanceof StringTypeWithContext && right instanceof StringTypeWithContext) {
                        return true;
                    }
                }
                if (tuple2 != null) {
                    DataType right = (DataType)tuple2._2();
                    if (tuple2._1() instanceof StringType && right instanceof StringTypeWithContext) {
                        return true;
                    }
                }
                return false;
            }
        });
    }

    public StringTypeWithContext org$apache$spark$sql$catalyst$analysis$CollationTypeCoercion$$getWinningStringType(StringTypeWithContext left, StringTypeWithContext right) {
        int rightPriority;
        int leftPriority;
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(left.strength().priority(), right.strength().priority());
        if (sp2 != null && (leftPriority = sp2._1$mcI$sp()) == (rightPriority = sp2._2$mcI$sp())) {
            if (left.sameType(right)) {
                return left;
            }
            return CollationTypeCoercion$.handleMismatch$1(left, right);
        }
        if (sp2 != null) {
            int rightPriority2;
            int leftPriority2 = sp2._1$mcI$sp();
            if (leftPriority2 < (rightPriority2 = sp2._2$mcI$sp())) {
                return left;
            }
            return right;
        }
        throw new MatchError((Object)sp2);
    }

    private void checkIndeterminateCollation(Expression expression, DataType newDataType) {
        if (this.shouldFailWithIndeterminateCollation(expression, newDataType)) {
            throw package$.MODULE$.AnalysisErrorAt(expression).failAnalysis("INDETERMINATE_COLLATION_IN_EXPRESSION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)TypeUtils$.MODULE$.toSQLExpr(expression))}))));
        }
    }

    private boolean shouldFailWithIndeterminateCollation(Expression expression) {
        return expression.children().exists((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)CollationTypeCoercion$.MODULE$.shouldFailWithIndeterminateCollation(expression, CollationTypeCoercion$.getDataTypeSafe$1(child))));
    }

    private boolean shouldFailWithIndeterminateCollation(Expression expression, DataType dataType) {
        return !this.canContainIndeterminateCollation(expression) && this.hasIndeterminateCollation(dataType);
    }

    private boolean hasIndeterminateCollation(DataType dataType) {
        return dataType.existsRecursively((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CollationTypeCoercion$.$anonfun$hasIndeterminateCollation$1(x0$1)));
    }

    private boolean canContainIndeterminateCollation(Expression expr) {
        Expression expression = expr;
        return !(expression instanceof BinaryComparison ? true : (expression instanceof StringPredicate ? true : (expression instanceof Upper ? true : (expression instanceof Lower ? true : (expression instanceof InitCap ? true : (expression instanceof FindInSet ? true : (expression instanceof StringInstr ? true : (expression instanceof StringReplace ? true : (expression instanceof StringLocate ? true : (expression instanceof SubstringIndex ? true : (expression instanceof StringTrim ? true : (expression instanceof StringTrimLeft ? true : (expression instanceof StringTrimRight ? true : (expression instanceof StringTranslate ? true : (expression instanceof StringSplitSQL ? true : (expression instanceof In ? true : (expression instanceof InSubquery ? true : expression instanceof FindInSet)))))))))))))))));
    }

    public static final /* synthetic */ boolean $anonfun$hasStringType$1(DataType x0$1) {
        DataType dataType = x0$1;
        return dataType instanceof StringType;
    }

    public static final /* synthetic */ boolean $anonfun$changeType$1(DataType x$2) {
        return x$2 instanceof StringTypeWithContext;
    }

    private final NamedExpression transformNamedExpressions$1(NamedExpression ex, DataType newType$1) {
        Expression expression = this.changeType((Expression)((Object)ex), newType$1);
        if (expression instanceof NamedExpression) {
            NamedExpression namedExpression = (NamedExpression)((Object)expression);
            return namedExpression;
        }
        Expression x$1 = expression;
        String x$2 = ex.name();
        ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
        Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
        Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
        Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
        return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    private static final StringTypeWithContext handleMismatch$1(StringTypeWithContext left$2, StringTypeWithContext right$1) {
        CollationStrength collationStrength = left$2.strength();
        CollationStrength$Explicit$ collationStrength$Explicit$ = CollationStrength$Explicit$.MODULE$;
        if (!(collationStrength != null ? !collationStrength.equals(collationStrength$Explicit$) : collationStrength$Explicit$ != null)) {
            throw QueryCompilationErrors$.MODULE$.explicitCollationMismatchError((Seq<StringType>)new .colon.colon((Object)left$2.stringType(), (List)new .colon.colon((Object)right$1.stringType(), (List)Nil$.MODULE$)));
        }
        return new StringTypeWithContext((StringType)IndeterminateStringType$.MODULE$, CollationStrength$Indeterminate$.MODULE$);
    }

    private static final DataType getDataTypeSafe$1(Expression e) {
        DataType dataType;
        try {
            dataType = e.dataType();
        }
        catch (Throwable throwable) {
            dataType = NullType$.MODULE$;
        }
        return dataType;
    }

    public static final /* synthetic */ boolean $anonfun$hasIndeterminateCollation$1(DataType x0$1) {
        StringTypeWithContext stringTypeWithContext;
        CollationStrength collationStrength;
        DataType dataType = x0$1;
        return IndeterminateStringType$.MODULE$.equals(dataType) ? true : dataType instanceof StringTypeWithContext && CollationStrength$Indeterminate$.MODULE$.equals(collationStrength = (stringTypeWithContext = (StringTypeWithContext)dataType).strength());
    }

    private CollationTypeCoercion$() {
    }
}

