/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.optimizer.lineage.LineageCtx;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class LineageState {
    private final Map<Path, Operator> dirToFop = new HashMap<Path, Operator>();
    private LineageCtx.Index index;
    private final LineageInfo linfo = new LineageInfo();

    public LineageState() {
        this.index = new LineageCtx.Index();
    }

    public void mapDirToOp(Path dir, Operator fop) {
        this.dirToFop.put(dir, fop);
    }

    public void setLineage(Path dir, LineageInfo.DataContainer dc, List<FieldSchema> cols) {
        Operator op = this.dirToFop.get(dir);
        if (op == null) {
            return;
        }
        ArrayList<ColumnInfo> signature = op.getSchema().getSignature();
        int i = 0;
        for (FieldSchema fs : cols) {
            this.linfo.putDependency(dc, fs, this.index.getDependency((Operator<? extends OperatorDesc>)op, (ColumnInfo)signature.get(i++)));
        }
    }

    public LineageInfo getLineageInfo() {
        return this.linfo;
    }

    public LineageCtx.Index getIndex() {
        return this.index;
    }

    public void clear() {
        this.dirToFop.clear();
        this.linfo.clear();
        this.index.clear();
    }
}

