/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public final class ValidationUtility {
    private ValidationUtility() {
    }

    public static void validateSkewedInformation(List<String> colNames, List<String> skewedColNames, List<List<String>> skewedColValues) throws SemanticException {
        if (skewedColNames.size() > 0) {
            ValidationUtility.validateSkewedColNames(colNames, skewedColNames);
            ValidationUtility.validateSkewedColumnNameUniqueness(skewedColNames);
            if (skewedColValues == null || skewedColValues.size() == 0) {
                throw new SemanticException(ErrorMsg.SKEWED_TABLE_SKEWED_COL_NAME_VALUE_MISMATCH_2.getMsg());
            }
            ValidationUtility.validateSkewedColNameValueNumberMatch(skewedColNames, skewedColValues);
        } else if (skewedColValues.size() > 0) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_SKEWED_COL_NAME_VALUE_MISMATCH_1.getMsg());
        }
    }

    public static void validateSkewedColNameValueNumberMatch(List<String> skewedColNames, List<List<String>> skewedColValues) throws SemanticException {
        for (List<String> colValue : skewedColValues) {
            if (colValue.size() == skewedColNames.size()) continue;
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_SKEWED_COL_NAME_VALUE_MISMATCH_3.getMsg() + skewedColNames.size() + " : " + colValue.size());
        }
    }

    public static void validateSkewedColNames(List<String> colNames, List<String> skewedColNames) throws SemanticException {
        ArrayList<String> copySkewedColNames = new ArrayList<String>(skewedColNames);
        copySkewedColNames.removeAll(colNames);
        if (copySkewedColNames.size() > 0) {
            StringBuilder invalidColNames = new StringBuilder();
            for (String name : copySkewedColNames) {
                invalidColNames.append(name);
                invalidColNames.append(" ");
            }
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_INVALID_COLUMN.getMsg(invalidColNames.toString()));
        }
    }

    public static void validateSkewedColumnNameUniqueness(List<String> names) throws SemanticException {
        HashSet<String> lookup = new HashSet<String>();
        for (String name : names) {
            if (lookup.contains(name)) {
                throw new SemanticException(ErrorMsg.SKEWED_TABLE_DUPLICATE_COLUMN_NAMES.getMsg(name));
            }
            lookup.add(name);
        }
    }
}

