/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache.loggers;

import coursierapi.shaded.coursier.cache.loggers.RefreshDisplay;
import coursierapi.shaded.coursier.cache.loggers.RefreshInfo;
import coursierapi.shaded.scala.Function0;
import coursierapi.shaded.scala.Function1;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Option$;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Some;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.IterableOnce;
import coursierapi.shaded.scala.collection.StringOps$;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.collection.immutable.Set;
import coursierapi.shaded.scala.concurrent.duration.Duration;
import coursierapi.shaded.scala.concurrent.duration.package;
import coursierapi.shaded.scala.concurrent.duration.package$;
import coursierapi.shaded.scala.runtime.BoxedUnit;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.ScalaRunTime$;
import java.io.Serializable;
import java.io.Writer;

public class FallbackRefreshDisplay
implements RefreshDisplay {
    private final boolean quiet;
    private Set<String> previous;
    private final Duration refreshInterval;
    private volatile Option<Object> lastInstantOpt;

    @Override
    public void sizeHint(int n) {
        RefreshDisplay.sizeHint$(this, n);
    }

    private Set<String> previous() {
        return this.previous;
    }

    private void previous_$eq(Set<String> x$1) {
        this.previous = x$1;
    }

    private Option<Object> lastInstantOpt() {
        return this.lastInstantOpt;
    }

    private void lastInstantOpt_$eq(Option<Object> x$1) {
        this.lastInstantOpt = x$1;
    }

    private String describe(RefreshInfo info) {
        String string;
        RefreshInfo refreshInfo = info;
        if (refreshInfo instanceof RefreshInfo.DownloadInfo) {
            RefreshInfo.DownloadInfo downloadInfo = (RefreshInfo.DownloadInfo)refreshInfo;
            Option<Object> pctOpt = downloadInfo.fraction().map(x$1 -> 100.0 * x$1);
            string = downloadInfo.length().isEmpty() && downloadInfo.downloaded() == 0L ? "" : new StringBuilder(2).append("(").append(Option$.MODULE$.option2Iterable(pctOpt.map((Function1<Object, String> & Serializable)pct -> FallbackRefreshDisplay.$anonfun$describe$2(BoxesRunTime.unboxToDouble(pct)))).mkString()).append(downloadInfo.downloaded()).append(Option$.MODULE$.option2Iterable(downloadInfo.length().map((Function1<Object, String> & Serializable)x$2 -> FallbackRefreshDisplay.$anonfun$describe$3(BoxesRunTime.unboxToLong(x$2)))).mkString()).append(")").toString();
        } else if (refreshInfo instanceof RefreshInfo.CheckUpdateInfo) {
            string = "Checking for updates";
        } else {
            throw new MatchError(refreshInfo);
        }
        return string;
    }

    @Override
    public Duration refreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public void newEntry(Writer out, String url, RefreshInfo info) {
        block4: {
            String string;
            this.lastInstantOpt_$eq(new Some<Object>(BoxesRunTime.boxToLong(System.currentTimeMillis())));
            if (this.quiet) break block4;
            RefreshInfo refreshInfo = info;
            if (refreshInfo instanceof RefreshInfo.DownloadInfo) {
                string = new StringBuilder(13).append("Downloading ").append(url).append("\n").toString();
            } else if (refreshInfo instanceof RefreshInfo.CheckUpdateInfo) {
                string = new StringBuilder(10).append("Checking ").append(url).append("\n").toString();
            } else {
                throw new MatchError(refreshInfo);
            }
            String msg = string;
            out.write(msg);
            out.flush();
        }
    }

    @Override
    public void removeEntry(Writer out, String url, RefreshInfo info) {
        block4: {
            String string;
            this.lastInstantOpt_$eq(new Some<Object>(BoxesRunTime.boxToLong(System.currentTimeMillis())));
            if (this.quiet) break block4;
            String prefix = info.watching() ? "(watching) " : "";
            RefreshInfo refreshInfo = info;
            if (refreshInfo instanceof RefreshInfo.DownloadInfo) {
                string = new StringBuilder(12).append("Downloaded ").append(url).append("\n").toString();
            } else if (refreshInfo instanceof RefreshInfo.CheckUpdateInfo) {
                string = new StringBuilder(9).append("Checked ").append(url).append("\n").toString();
            } else {
                throw new MatchError(refreshInfo);
            }
            String msg = string;
            out.write(new StringBuilder(0).append(prefix).append(msg).toString());
            out.flush();
        }
    }

    @Override
    public void update(Writer out, Seq<Tuple2<String, RefreshInfo>> done, Seq<Tuple2<String, RefreshInfo>> downloads, boolean changed) {
        Seq downloads0;
        long now = System.currentTimeMillis();
        if (this.lastInstantOpt().exists(x$3 -> now > x$3 + 5000L) && (downloads0 = (Seq)downloads.filter((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToBoolean(FallbackRefreshDisplay.$anonfun$update$2(this, x0$1)))).nonEmpty()) {
            out.write(new StringBuilder(18).append("Still downloading:").append(System.lineSeparator()).toString());
            downloads0.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(FallbackRefreshDisplay.$anonfun$update$3(check$ifrefutable$1))).foreach((Function1<Tuple2, Object> & Serializable)x$4 -> {
                FallbackRefreshDisplay.$anonfun$update$4(this, out, x$4);
                return BoxedUnit.UNIT;
            });
            out.write(System.lineSeparator());
            out.flush();
            this.lastInstantOpt_$eq(new Some<Object>(BoxesRunTime.boxToLong(now)));
        }
        this.previous_$eq((Set)this.previous().$plus$plus((IterableOnce)downloads.map((Function1<Tuple2, String> & Serializable)x$5 -> (String)x$5._1())));
    }

    @Override
    public void stop(Writer out) {
        this.previous_$eq((Set<String>)Predef$.MODULE$.Set().empty());
        this.lastInstantOpt_$eq(None$.MODULE$);
    }

    public static final /* synthetic */ String $anonfun$describe$2(double pct) {
        double arg$macro$1 = pct;
        return StringOps$.MODULE$.format$extension("%.2f %%, ", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(arg$macro$1)}));
    }

    public static final /* synthetic */ String $anonfun$describe$3(long x$2) {
        return new StringBuilder(3).append(" / ").append(x$2).toString();
    }

    public static final /* synthetic */ boolean $anonfun$update$2(FallbackRefreshDisplay $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String url = (String)tuple2._1();
        boolean bl = $this.previous().apply(url);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$update$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$update$4(FallbackRefreshDisplay $this, Writer out$1, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String url = (String)tuple2._1();
        RefreshInfo info = (RefreshInfo)tuple2._2();
        Predef$.MODULE$.assert(info != null, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(19).append("Incoherent state (").append(url).append(")").toString());
        out$1.write(new StringBuilder(0).append(new StringBuilder(1).append(url).append(" ").append($this.describe(info)).toString()).append(System.lineSeparator()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public FallbackRefreshDisplay(boolean quiet) {
        this.quiet = quiet;
        RefreshDisplay.$init$(this);
        this.previous = Predef$.MODULE$.Set().empty();
        this.lastInstantOpt = Option$.MODULE$.empty();
        this.refreshInterval = new package.DurationInt(package$.MODULE$.DurationInt(1)).second();
    }
}

