/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.cache;

import coursierapi.shaded.coursier.cache.CacheUrl;
import coursierapi.shaded.coursier.cache.CacheUrl$;
import coursierapi.shaded.coursier.core.Authentication;
import coursierapi.shaded.coursier.credentials.DirectCredentials;
import coursierapi.shaded.scala.MatchError;
import coursierapi.shaded.scala.None$;
import coursierapi.shaded.scala.Option;
import coursierapi.shaded.scala.Predef$;
import coursierapi.shaded.scala.Product;
import coursierapi.shaded.scala.Tuple2;
import coursierapi.shaded.scala.collection.Iterator;
import coursierapi.shaded.scala.collection.immutable.Seq;
import coursierapi.shaded.scala.runtime.BoxesRunTime;
import coursierapi.shaded.scala.runtime.Statics;
import java.io.Serializable;
import java.net.Proxy;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public final class ConnectionBuilder
implements Serializable,
Product {
    private final String url;
    private final Option<Authentication> authentication;
    private final long alreadyDownloaded;
    private final boolean followHttpToHttpsRedirections;
    private final boolean followHttpsToHttpRedirections;
    private final Seq<DirectCredentials> autoCredentials;
    private final Option<SSLSocketFactory> sslSocketFactoryOpt;
    private final Option<HostnameVerifier> hostnameVerifierOpt;
    private final String method;
    private final Option<Object> maxRedirectionsOpt;
    private final Option<Proxy> proxy;
    private final Seq<ClassLoader> classLoaders;

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public String url() {
        return this.url;
    }

    public Option<Authentication> authentication() {
        return this.authentication;
    }

    public long alreadyDownloaded() {
        return this.alreadyDownloaded;
    }

    public boolean followHttpToHttpsRedirections() {
        return this.followHttpToHttpsRedirections;
    }

    public boolean followHttpsToHttpRedirections() {
        return this.followHttpsToHttpRedirections;
    }

    public Seq<DirectCredentials> autoCredentials() {
        return this.autoCredentials;
    }

    public Option<SSLSocketFactory> sslSocketFactoryOpt() {
        return this.sslSocketFactoryOpt;
    }

    public Option<HostnameVerifier> hostnameVerifierOpt() {
        return this.hostnameVerifierOpt;
    }

    public String method() {
        return this.method;
    }

    public Option<Object> maxRedirectionsOpt() {
        return this.maxRedirectionsOpt;
    }

    public Option<Proxy> proxy() {
        return this.proxy;
    }

    public Seq<ClassLoader> classLoaders() {
        return this.classLoaders;
    }

    public URLConnection connection() {
        Tuple2<URLConnection, Object> tuple2 = this.connectionMaybePartial();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        URLConnection c = tuple2._1();
        boolean partial = tuple2._2$mcZ$sp();
        Tuple2<URLConnection, Boolean> tuple22 = new Tuple2<URLConnection, Boolean>(c, BoxesRunTime.boxToBoolean(partial));
        Tuple2<URLConnection, Boolean> tuple23 = tuple22;
        URLConnection c2 = tuple23._1();
        boolean partial2 = tuple23._2$mcZ$sp();
        Predef$.MODULE$.assert(!partial2);
        return c2;
    }

    public Tuple2<URLConnection, Object> connectionMaybePartial() {
        return CacheUrl$.MODULE$.urlConnectionMaybePartial(new CacheUrl.Args(this.url(), this.url(), this.authentication(), this.alreadyDownloaded(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.autoCredentials(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.proxy(), this.method(), None$.MODULE$, 0, this.maxRedirectionsOpt(), this.classLoaders()));
    }

    public ConnectionBuilder withAuthentication(Option<Authentication> authentication) {
        return new ConnectionBuilder(this.url(), authentication, this.alreadyDownloaded(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.autoCredentials(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.method(), this.maxRedirectionsOpt(), this.proxy(), this.classLoaders());
    }

    public ConnectionBuilder withAlreadyDownloaded(long alreadyDownloaded) {
        return new ConnectionBuilder(this.url(), this.authentication(), alreadyDownloaded, this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.autoCredentials(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.method(), this.maxRedirectionsOpt(), this.proxy(), this.classLoaders());
    }

    public ConnectionBuilder withFollowHttpToHttpsRedirections(boolean followHttpToHttpsRedirections) {
        return new ConnectionBuilder(this.url(), this.authentication(), this.alreadyDownloaded(), followHttpToHttpsRedirections, this.followHttpsToHttpRedirections(), this.autoCredentials(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.method(), this.maxRedirectionsOpt(), this.proxy(), this.classLoaders());
    }

    public ConnectionBuilder withFollowHttpsToHttpRedirections(boolean followHttpsToHttpRedirections) {
        return new ConnectionBuilder(this.url(), this.authentication(), this.alreadyDownloaded(), this.followHttpToHttpsRedirections(), followHttpsToHttpRedirections, this.autoCredentials(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.method(), this.maxRedirectionsOpt(), this.proxy(), this.classLoaders());
    }

    public ConnectionBuilder withAutoCredentials(Seq<DirectCredentials> autoCredentials) {
        return new ConnectionBuilder(this.url(), this.authentication(), this.alreadyDownloaded(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), autoCredentials, this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.method(), this.maxRedirectionsOpt(), this.proxy(), this.classLoaders());
    }

    public ConnectionBuilder withSslSocketFactoryOpt(Option<SSLSocketFactory> sslSocketFactoryOpt) {
        return new ConnectionBuilder(this.url(), this.authentication(), this.alreadyDownloaded(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.autoCredentials(), sslSocketFactoryOpt, this.hostnameVerifierOpt(), this.method(), this.maxRedirectionsOpt(), this.proxy(), this.classLoaders());
    }

    public ConnectionBuilder withHostnameVerifierOpt(Option<HostnameVerifier> hostnameVerifierOpt) {
        return new ConnectionBuilder(this.url(), this.authentication(), this.alreadyDownloaded(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.autoCredentials(), this.sslSocketFactoryOpt(), hostnameVerifierOpt, this.method(), this.maxRedirectionsOpt(), this.proxy(), this.classLoaders());
    }

    public ConnectionBuilder withMethod(String method) {
        return new ConnectionBuilder(this.url(), this.authentication(), this.alreadyDownloaded(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.autoCredentials(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), method, this.maxRedirectionsOpt(), this.proxy(), this.classLoaders());
    }

    public ConnectionBuilder withMaxRedirectionsOpt(Option<Object> maxRedirectionsOpt) {
        return new ConnectionBuilder(this.url(), this.authentication(), this.alreadyDownloaded(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.autoCredentials(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.method(), maxRedirectionsOpt, this.proxy(), this.classLoaders());
    }

    public ConnectionBuilder withClassLoaders(Seq<ClassLoader> classLoaders) {
        return new ConnectionBuilder(this.url(), this.authentication(), this.alreadyDownloaded(), this.followHttpToHttpsRedirections(), this.followHttpsToHttpRedirections(), this.autoCredentials(), this.sslSocketFactoryOpt(), this.hostnameVerifierOpt(), this.method(), this.maxRedirectionsOpt(), this.proxy(), classLoaders);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ConnectionBuilder(");
        b.append(String.valueOf(this.url()));
        b.append(", ");
        b.append(String.valueOf(this.authentication()));
        b.append(", ");
        b.append(String.valueOf(this.alreadyDownloaded()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpToHttpsRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.followHttpsToHttpRedirections()));
        b.append(", ");
        b.append(String.valueOf(this.autoCredentials()));
        b.append(", ");
        b.append(String.valueOf(this.sslSocketFactoryOpt()));
        b.append(", ");
        b.append(String.valueOf(this.hostnameVerifierOpt()));
        b.append(", ");
        b.append(String.valueOf(this.method()));
        b.append(", ");
        b.append(String.valueOf(this.maxRedirectionsOpt()));
        b.append(", ");
        b.append(String.valueOf(this.proxy()));
        b.append(", ");
        b.append(String.valueOf(this.classLoaders()));
        b.append(")");
        return b.toString();
    }

    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof ConnectionBuilder && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        ConnectionBuilder other = (ConnectionBuilder)obj;
        if (!true) return false;
        String string = this.url();
        String string2 = other.url();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<Authentication> option = this.authentication();
        Option<Authentication> option2 = other.authentication();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.alreadyDownloaded() != other.alreadyDownloaded()) return false;
        if (this.followHttpToHttpsRedirections() != other.followHttpToHttpsRedirections()) return false;
        if (this.followHttpsToHttpRedirections() != other.followHttpsToHttpRedirections()) return false;
        Seq<DirectCredentials> seq = this.autoCredentials();
        Seq<DirectCredentials> seq2 = other.autoCredentials();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<SSLSocketFactory> option3 = this.sslSocketFactoryOpt();
        Option<SSLSocketFactory> option4 = other.sslSocketFactoryOpt();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<HostnameVerifier> option5 = this.hostnameVerifierOpt();
        Option<HostnameVerifier> option6 = other.hostnameVerifierOpt();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        String string3 = this.method();
        String string4 = other.method();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Option<Object> option7 = this.maxRedirectionsOpt();
        Option<Object> option8 = other.maxRedirectionsOpt();
        if (option7 == null) {
            if (option8 != null) {
                return false;
            }
        } else if (!option7.equals(option8)) return false;
        Option<Proxy> option9 = this.proxy();
        Option<Proxy> option10 = other.proxy();
        if (option9 == null) {
            if (option10 != null) {
                return false;
            }
        } else if (!option9.equals(option10)) return false;
        Seq<ClassLoader> seq3 = this.classLoaders();
        Seq<ClassLoader> seq4 = other.classLoaders();
        if (seq3 == null) {
            if (seq4 == null) return true;
            return false;
        } else {
            if (!seq3.equals(seq4)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("ConnectionBuilder");
        code = 37 * code + Statics.anyHash(this.url());
        code = 37 * code + Statics.anyHash(this.authentication());
        code = 37 * code + Statics.longHash(this.alreadyDownloaded());
        code = 37 * code + (this.followHttpToHttpsRedirections() ? 1231 : 1237);
        code = 37 * code + (this.followHttpsToHttpRedirections() ? 1231 : 1237);
        code = 37 * code + Statics.anyHash(this.autoCredentials());
        code = 37 * code + Statics.anyHash(this.sslSocketFactoryOpt());
        code = 37 * code + Statics.anyHash(this.hostnameVerifierOpt());
        code = 37 * code + Statics.anyHash(this.method());
        code = 37 * code + Statics.anyHash(this.maxRedirectionsOpt());
        code = 37 * code + Statics.anyHash(this.proxy());
        code = 37 * code + Statics.anyHash(this.classLoaders());
        return 37 * code;
    }

    @Override
    public String productPrefix() {
        return "ConnectionBuilder";
    }

    @Override
    public int productArity() {
        return 12;
    }

    @Override
    public Object productElement(int n) {
        Object object;
        int n2 = n;
        switch (n2) {
            case 0: {
                object = this.url();
                break;
            }
            case 1: {
                object = this.authentication();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToLong(this.alreadyDownloaded());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean(this.followHttpToHttpsRedirections());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean(this.followHttpsToHttpRedirections());
                break;
            }
            case 5: {
                object = this.autoCredentials();
                break;
            }
            case 6: {
                object = this.sslSocketFactoryOpt();
                break;
            }
            case 7: {
                object = this.hostnameVerifierOpt();
                break;
            }
            case 8: {
                object = this.method();
                break;
            }
            case 9: {
                object = this.maxRedirectionsOpt();
                break;
            }
            case 10: {
                object = this.proxy();
                break;
            }
            case 11: {
                object = this.classLoaders();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(n2));
            }
        }
        return object;
    }

    public ConnectionBuilder(String url, Option<Authentication> authentication, long alreadyDownloaded, boolean followHttpToHttpsRedirections, boolean followHttpsToHttpRedirections, Seq<DirectCredentials> autoCredentials, Option<SSLSocketFactory> sslSocketFactoryOpt, Option<HostnameVerifier> hostnameVerifierOpt, String method, Option<Object> maxRedirectionsOpt, Option<Proxy> proxy, Seq<ClassLoader> classLoaders) {
        this.url = url;
        this.authentication = authentication;
        this.alreadyDownloaded = alreadyDownloaded;
        this.followHttpToHttpsRedirections = followHttpToHttpsRedirections;
        this.followHttpsToHttpRedirections = followHttpsToHttpRedirections;
        this.autoCredentials = autoCredentials;
        this.sslSocketFactoryOpt = sslSocketFactoryOpt;
        this.hostnameVerifierOpt = hostnameVerifierOpt;
        this.method = method;
        this.maxRedirectionsOpt = maxRedirectionsOpt;
        this.proxy = proxy;
        this.classLoaders = classLoaders;
        Product.$init$(this);
    }
}

