/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.commonscompress.archivers.zip;

import coursierapi.shaded.commonscompress.archivers.zip.AsiExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.ExtraFieldParsingBehavior;
import coursierapi.shaded.commonscompress.archivers.zip.JarMarker;
import coursierapi.shaded.commonscompress.archivers.zip.ResourceAlignmentExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.UnicodeCommentExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.UnicodePathExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.UnparseableExtraFieldBehavior;
import coursierapi.shaded.commonscompress.archivers.zip.UnparseableExtraFieldData;
import coursierapi.shaded.commonscompress.archivers.zip.UnrecognizedExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.X000A_NTFS;
import coursierapi.shaded.commonscompress.archivers.zip.X0014_X509Certificates;
import coursierapi.shaded.commonscompress.archivers.zip.X0015_CertificateIdForFile;
import coursierapi.shaded.commonscompress.archivers.zip.X0016_CertificateIdForCentralDirectory;
import coursierapi.shaded.commonscompress.archivers.zip.X0017_StrongEncryptionHeader;
import coursierapi.shaded.commonscompress.archivers.zip.X0019_EncryptionRecipientCertificateList;
import coursierapi.shaded.commonscompress.archivers.zip.X5455_ExtendedTimestamp;
import coursierapi.shaded.commonscompress.archivers.zip.X7875_NewUnix;
import coursierapi.shaded.commonscompress.archivers.zip.Zip64ExtendedInformationExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.ZipExtraField;
import coursierapi.shaded.commonscompress.archivers.zip.ZipShort;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipException;

public class ExtraFieldUtils {
    private static final Map<ZipShort, Class<?>> IMPLEMENTATIONS = new ConcurrentHashMap();
    static final ZipExtraField[] EMPTY_ZIP_EXTRA_FIELD_ARRAY;

    public static ZipExtraField createExtraField(ZipShort headerId) throws InstantiationException, IllegalAccessException {
        ZipExtraField field = ExtraFieldUtils.createExtraFieldNoDefault(headerId);
        if (field != null) {
            return field;
        }
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(headerId);
        return u;
    }

    public static ZipExtraField createExtraFieldNoDefault(ZipShort headerId) throws InstantiationException, IllegalAccessException {
        Class<?> c = IMPLEMENTATIONS.get(headerId);
        if (c != null) {
            return (ZipExtraField)c.newInstance();
        }
        return null;
    }

    public static ZipExtraField fillExtraField(ZipExtraField ze, byte[] data, int off, int len, boolean local) throws ZipException {
        try {
            if (local) {
                ze.parseFromLocalFileData(data, off, len);
            } else {
                ze.parseFromCentralDirectoryData(data, off, len);
            }
            return ze;
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            throw (ZipException)new ZipException("Failed to parse corrupt ZIP extra field of type " + Integer.toHexString(ze.getHeaderId().getValue())).initCause(aiobe);
        }
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] data) {
        byte[] central;
        int dataLength = data.length;
        boolean lastIsUnparseableHolder = dataLength > 0 && data[dataLength - 1] instanceof UnparseableExtraFieldData;
        int regularExtraFieldCount = lastIsUnparseableHolder ? dataLength - 1 : dataLength;
        int sum = 4 * regularExtraFieldCount;
        for (ZipExtraField element : data) {
            sum += element.getCentralDirectoryLength().getValue();
        }
        byte[] result = new byte[sum];
        int start = 0;
        for (int i = 0; i < regularExtraFieldCount; ++i) {
            System.arraycopy(data[i].getHeaderId().getBytes(), 0, result, start, 2);
            System.arraycopy(data[i].getCentralDirectoryLength().getBytes(), 0, result, start + 2, 2);
            start += 4;
            byte[] central2 = data[i].getCentralDirectoryData();
            if (central2 == null) continue;
            System.arraycopy(central2, 0, result, start, central2.length);
            start += central2.length;
        }
        if (lastIsUnparseableHolder && (central = data[dataLength - 1].getCentralDirectoryData()) != null) {
            System.arraycopy(central, 0, result, start, central.length);
        }
        return result;
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] data) {
        byte[] local;
        int dataLength = data.length;
        boolean lastIsUnparseableHolder = dataLength > 0 && data[dataLength - 1] instanceof UnparseableExtraFieldData;
        int regularExtraFieldCount = lastIsUnparseableHolder ? dataLength - 1 : dataLength;
        int sum = 4 * regularExtraFieldCount;
        for (ZipExtraField element : data) {
            sum += element.getLocalFileDataLength().getValue();
        }
        byte[] result = new byte[sum];
        int start = 0;
        for (int i = 0; i < regularExtraFieldCount; ++i) {
            System.arraycopy(data[i].getHeaderId().getBytes(), 0, result, start, 2);
            System.arraycopy(data[i].getLocalFileDataLength().getBytes(), 0, result, start + 2, 2);
            start += 4;
            byte[] local2 = data[i].getLocalFileDataData();
            if (local2 == null) continue;
            System.arraycopy(local2, 0, result, start, local2.length);
            start += local2.length;
        }
        if (lastIsUnparseableHolder && (local = data[dataLength - 1].getLocalFileDataData()) != null) {
            System.arraycopy(local, 0, result, start, local.length);
        }
        return result;
    }

    public static ZipExtraField[] parse(byte[] data, boolean local, ExtraFieldParsingBehavior parsingBehavior) throws ZipException {
        int length;
        ArrayList<ZipExtraField> v = new ArrayList<ZipExtraField>();
        int dataLength = data.length;
        for (int start = 0; start <= dataLength - 4; start += length + 4) {
            ZipShort headerId = new ZipShort(data, start);
            length = new ZipShort(data, start + 2).getValue();
            if (start + 4 + length > dataLength) {
                ZipExtraField field = parsingBehavior.onUnparseableExtraField(data, start, dataLength - start, local, length);
                if (field == null) break;
                v.add(field);
                break;
            }
            try {
                ZipExtraField ze = Objects.requireNonNull(parsingBehavior.createExtraField(headerId), "createExtraField must not return null");
                v.add(Objects.requireNonNull(parsingBehavior.fill(ze, data, start + 4, length, local), "fill must not return null"));
                continue;
            }
            catch (IllegalAccessException | InstantiationException ie) {
                throw (ZipException)new ZipException(ie.getMessage()).initCause(ie);
            }
        }
        return v.toArray(EMPTY_ZIP_EXTRA_FIELD_ARRAY);
    }

    public static void register(Class<?> c) {
        try {
            ZipExtraField ze = (ZipExtraField)c.newInstance();
            IMPLEMENTATIONS.put(ze.getHeaderId(), c);
        }
        catch (ClassCastException cc) {
            throw new IllegalArgumentException(c + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException(c + " is not a concrete class");
        }
        catch (IllegalAccessException ie) {
            throw new IllegalArgumentException(c + "'s no-arg constructor is not public");
        }
    }

    static {
        ExtraFieldUtils.register(AsiExtraField.class);
        ExtraFieldUtils.register(X5455_ExtendedTimestamp.class);
        ExtraFieldUtils.register(X7875_NewUnix.class);
        ExtraFieldUtils.register(JarMarker.class);
        ExtraFieldUtils.register(UnicodePathExtraField.class);
        ExtraFieldUtils.register(UnicodeCommentExtraField.class);
        ExtraFieldUtils.register(Zip64ExtendedInformationExtraField.class);
        ExtraFieldUtils.register(X000A_NTFS.class);
        ExtraFieldUtils.register(X0014_X509Certificates.class);
        ExtraFieldUtils.register(X0015_CertificateIdForFile.class);
        ExtraFieldUtils.register(X0016_CertificateIdForCentralDirectory.class);
        ExtraFieldUtils.register(X0017_StrongEncryptionHeader.class);
        ExtraFieldUtils.register(X0019_EncryptionRecipientCertificateList.class);
        ExtraFieldUtils.register(ResourceAlignmentExtraField.class);
        EMPTY_ZIP_EXTRA_FIELD_ARRAY = new ZipExtraField[0];
    }

    public static final class UnparseableExtraField
    implements UnparseableExtraFieldBehavior {
        public static final UnparseableExtraField THROW = new UnparseableExtraField(0);
        public static final UnparseableExtraField SKIP = new UnparseableExtraField(1);
        public static final UnparseableExtraField READ = new UnparseableExtraField(2);
        private final int key;

        private UnparseableExtraField(int k) {
            this.key = k;
        }

        @Override
        public ZipExtraField onUnparseableExtraField(byte[] data, int off, int len, boolean local, int claimedLength) throws ZipException {
            switch (this.key) {
                case 0: {
                    throw new ZipException("Bad extra field starting at " + off + ".  Block length of " + claimedLength + " bytes exceeds remaining data of " + (len - 4) + " bytes.");
                }
                case 2: {
                    UnparseableExtraFieldData field = new UnparseableExtraFieldData();
                    if (local) {
                        field.parseFromLocalFileData(data, off, len);
                    } else {
                        field.parseFromCentralDirectoryData(data, off, len);
                    }
                    return field;
                }
                case 1: {
                    return null;
                }
            }
            throw new ZipException("Unknown UnparseableExtraField key: " + this.key);
        }
    }
}

