/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.util;

import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceBundles {
    public static ResourceBundle getBundle(String bundleName) {
        return ResourceBundle.getBundle(bundleName.replace('$', '_'), Locale.getDefault(), Thread.currentThread().getContextClassLoader());
    }

    public static synchronized <T> T getValue(String bundleName, String key, String suffix, T defaultValue) {
        Object value;
        try {
            ResourceBundle bundle = ResourceBundles.getBundle(bundleName);
            value = bundle.getObject(ResourceBundles.getLookupKey(key, suffix));
        }
        catch (Exception e) {
            return defaultValue;
        }
        return (T)value;
    }

    private static String getLookupKey(String key, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return key;
        }
        return key + suffix;
    }

    public static String getCounterGroupName(String group, String defaultValue) {
        return ResourceBundles.getValue(group, "CounterGroupName", "", defaultValue);
    }

    public static String getCounterName(String group, String counter, String defaultValue) {
        return ResourceBundles.getValue(group, counter, ".name", defaultValue);
    }
}

