/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.pipelines;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.spark.connect.proto.DatasetType;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.PipelineCommand;
import org.apache.spark.connect.proto.PipelineCommandResult;
import org.apache.spark.connect.proto.PipelineEventResult;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.pipelines.DataflowGraphRegistry$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.pipelines.Language;
import org.apache.spark.sql.pipelines.QueryOriginType$;
import org.apache.spark.sql.pipelines.common.RunState;
import org.apache.spark.sql.pipelines.graph.FlowAnalysis$;
import org.apache.spark.sql.pipelines.graph.FlowFunction;
import org.apache.spark.sql.pipelines.graph.GraphIdentifierManager$;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext;
import org.apache.spark.sql.pipelines.graph.IdentifierHelper$;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContext;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContextImpl;
import org.apache.spark.sql.pipelines.graph.QueryContext;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.QueryOrigin$;
import org.apache.spark.sql.pipelines.graph.SqlGraphRegistrationContext;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.TemporaryView;
import org.apache.spark.sql.pipelines.graph.UnresolvedFlow;
import org.apache.spark.sql.pipelines.graph.View;
import org.apache.spark.sql.pipelines.logging.EventDetails;
import org.apache.spark.sql.pipelines.logging.PipelineEvent;
import org.apache.spark.sql.pipelines.logging.RunProgress;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import org.sparkproject.connect.protobuf.Timestamp;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;

public final class PipelinesHandler$
implements Logging {
    public static final PipelinesHandler$ MODULE$ = new PipelinesHandler$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public PipelineCommandResult handlePipelinesCommand(SessionHolder sessionHolder, PipelineCommand cmd, StreamObserver<ExecutePlanResponse> responseObserver, Function1<Relation, LogicalPlan> transformRelationFunc) {
        PipelineCommandResult defaultResponse = PipelineCommandResult.getDefaultInstance();
        PipelineCommand.CommandTypeCase commandTypeCase = cmd.getCommandTypeCase();
        if (PipelineCommand.CommandTypeCase.CREATE_DATAFLOW_GRAPH.equals(commandTypeCase)) {
            String createdGraphId = this.createDataflowGraph(cmd.getCreateDataflowGraph(), sessionHolder.session());
            return PipelineCommandResult.newBuilder().setCreateDataflowGraphResult(PipelineCommandResult.CreateDataflowGraphResult.newBuilder().setDataflowGraphId(createdGraphId).build()).build();
        }
        if (PipelineCommand.CommandTypeCase.DROP_DATAFLOW_GRAPH.equals(commandTypeCase)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Drop pipeline cmd received: " + cmd);
            DataflowGraphRegistry$.MODULE$.dropDataflowGraph(cmd.getDropDataflowGraph().getDataflowGraphId());
            return defaultResponse;
        }
        if (PipelineCommand.CommandTypeCase.DEFINE_DATASET.equals(commandTypeCase)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Define pipelines dataset cmd received: " + cmd);
            this.defineDataset(cmd.getDefineDataset(), sessionHolder.session());
            return defaultResponse;
        }
        if (PipelineCommand.CommandTypeCase.DEFINE_FLOW.equals(commandTypeCase)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Define pipelines flow cmd received: " + cmd);
            this.defineFlow(cmd.getDefineFlow(), transformRelationFunc, sessionHolder.session());
            return defaultResponse;
        }
        if (PipelineCommand.CommandTypeCase.START_RUN.equals(commandTypeCase)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Start pipeline cmd received: " + cmd);
            this.startRun(cmd.getStartRun(), responseObserver, sessionHolder);
            return defaultResponse;
        }
        if (PipelineCommand.CommandTypeCase.DEFINE_SQL_GRAPH_ELEMENTS.equals(commandTypeCase)) {
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Register sql datasets cmd received: " + cmd);
            this.defineSqlGraphElements(cmd.getDefineSqlGraphElements(), sessionHolder.session());
            return defaultResponse;
        }
        throw new UnsupportedOperationException(commandTypeCase + " not supported");
    }

    private String createDataflowGraph(PipelineCommand.CreateDataflowGraph cmd, org.apache.spark.sql.classic.SparkSession spark) {
        String defaultCatalog = (String)Option$.MODULE$.when(cmd.hasDefaultCatalog(), (Function0 & Serializable)() -> cmd.getDefaultCatalog()).getOrElse((Function0 & Serializable)() -> {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "No default catalog was supplied. Falling back to the current catalog.");
            return spark.catalog().currentCatalog();
        });
        String defaultDatabase = (String)Option$.MODULE$.when(cmd.hasDefaultDatabase(), (Function0 & Serializable)() -> cmd.getDefaultDatabase()).getOrElse((Function0 & Serializable)() -> {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "No default database was supplied. Falling back to the current database.");
            return spark.catalog().currentDatabase();
        });
        scala.collection.immutable.Map defaultSqlConf = CollectionConverters$.MODULE$.MapHasAsScala(cmd.getSqlConfMap()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return DataflowGraphRegistry$.MODULE$.createDataflowGraph(defaultCatalog, defaultDatabase, (scala.collection.immutable.Map<String, String>)defaultSqlConf);
    }

    private void defineSqlGraphElements(PipelineCommand.DefineSqlGraphElements cmd, org.apache.spark.sql.classic.SparkSession session) {
        String dataflowGraphId = cmd.getDataflowGraphId();
        GraphRegistrationContext graphElementRegistry = DataflowGraphRegistry$.MODULE$.getDataflowGraphOrThrow(dataflowGraphId);
        SqlGraphRegistrationContext sqlGraphElementRegistrationContext = new SqlGraphRegistrationContext(graphElementRegistry);
        sqlGraphElementRegistrationContext.processSqlFile(cmd.getSqlText(), cmd.getSqlFilePath(), (SparkSession)session);
    }

    private void defineDataset(PipelineCommand.DefineDataset dataset, org.apache.spark.sql.classic.SparkSession sparkSession) {
        String dataflowGraphId = dataset.getDataflowGraphId();
        GraphRegistrationContext graphElementRegistry = DataflowGraphRegistry$.MODULE$.getDataflowGraphOrThrow(dataflowGraphId);
        DatasetType datasetType = dataset.getDatasetType();
        if (DatasetType.MATERIALIZED_VIEW.equals(datasetType) ? true : DatasetType.TABLE.equals(datasetType)) {
            TableIdentifier tableIdentifier;
            TableIdentifier x$8 = tableIdentifier = GraphIdentifierManager$.MODULE$.parseTableIdentifier(dataset.getDatasetName(), sparkSession);
            Option x$9 = Option$.MODULE$.apply((Object)dataset.getComment());
            Option x$10 = Option$.MODULE$.when(dataset.hasSchema(), (Function0 & Serializable)() -> (StructType)DataTypeProtoConverter$.MODULE$.toCatalystType(dataset.getSchema()));
            Option x$11 = Option$.MODULE$.apply((Object)CollectionConverters$.MODULE$.ListHasAsScala((List)dataset.getPartitionColsList()).asScala().toSeq()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty()));
            scala.collection.immutable.Map x$12 = CollectionConverters$.MODULE$.MapHasAsScala(dataset.getTablePropertiesMap()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Option x$13 = Option$.MODULE$.apply((Object)QueryOriginType$.MODULE$.Table().toString());
            Option x$2 = Option$.MODULE$.apply((Object)tableIdentifier.unquotedString());
            Option x$3 = Option$.MODULE$.apply((Object)new Language.Python());
            Option x$4 = QueryOrigin$.MODULE$.apply$default$2();
            Option x$5 = QueryOrigin$.MODULE$.apply$default$3();
            Option x$6 = QueryOrigin$.MODULE$.apply$default$4();
            Option x$7 = QueryOrigin$.MODULE$.apply$default$5();
            QueryOrigin x$132 = new QueryOrigin(x$3, x$4, x$5, x$6, x$7, x$13, x$2);
            Option x$14 = Option$.MODULE$.when(dataset.hasFormat(), (Function0 & Serializable)() -> dataset.getFormat());
            None$ x$15 = None$.MODULE$;
            DatasetType datasetType2 = dataset.getDatasetType();
            DatasetType datasetType3 = DatasetType.TABLE;
            boolean x$16 = !(datasetType2 != null ? !datasetType2.equals(datasetType3) : datasetType3 != null);
            graphElementRegistry.registerTable(new Table(x$8, x$10, x$11, (Option)x$15, x$12, x$9, x$132, x$16, x$14));
            return;
        }
        if (DatasetType.TEMPORARY_VIEW.equals(datasetType)) {
            TableIdentifier viewIdentifier;
            TableIdentifier x$24 = viewIdentifier = GraphIdentifierManager$.MODULE$.parseTableIdentifier(dataset.getDatasetName(), sparkSession);
            Option x$25 = Option$.MODULE$.apply((Object)dataset.getComment());
            Option x$17 = Option$.MODULE$.apply((Object)QueryOriginType$.MODULE$.View().toString());
            Option x$18 = Option$.MODULE$.apply((Object)viewIdentifier.unquotedString());
            Option x$19 = Option$.MODULE$.apply((Object)new Language.Python());
            Option x$20 = QueryOrigin$.MODULE$.apply$default$2();
            Option x$21 = QueryOrigin$.MODULE$.apply$default$3();
            Option x$22 = QueryOrigin$.MODULE$.apply$default$4();
            Option x$23 = QueryOrigin$.MODULE$.apply$default$5();
            QueryOrigin x$26 = new QueryOrigin(x$19, x$20, x$21, x$22, x$23, x$17, x$18);
            scala.collection.immutable.Map x$27 = Predef$.MODULE$.Map().empty();
            graphElementRegistry.registerView((View)new TemporaryView(x$24, x$27, x$25, x$26));
            return;
        }
        throw new IllegalArgumentException("Unknown dataset type: " + dataset.getDatasetType());
    }

    private void defineFlow(PipelineCommand.DefineFlow flow, Function1<Relation, LogicalPlan> transformRelationFunc, org.apache.spark.sql.classic.SparkSession sparkSession) {
        String dataflowGraphId = flow.getDataflowGraphId();
        GraphRegistrationContext graphElementRegistry = DataflowGraphRegistry$.MODULE$.getDataflowGraphOrThrow(dataflowGraphId);
        String string = flow.getFlowName();
        String string2 = flow.getTargetDatasetName();
        boolean isImplicitFlow = !(string != null ? !string.equals(string2) : string2 != null);
        TableIdentifier flowIdentifier = GraphIdentifierManager$.MODULE$.parseTableIdentifier(flow.getFlowName(), sparkSession);
        if (!isImplicitFlow && !IdentifierHelper$.MODULE$.isSinglePartIdentifier(flowIdentifier)) {
            throw new AnalysisException("MULTIPART_FLOW_NAME_NOT_SUPPORTED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flowName"), (Object)flow.getFlowName())})));
        }
        TableIdentifier x$8 = flowIdentifier;
        TableIdentifier x$9 = GraphIdentifierManager$.MODULE$.parseTableIdentifier(flow.getTargetDatasetName(), sparkSession);
        FlowFunction x$10 = FlowAnalysis$.MODULE$.createFlowFunctionFromLogicalPlan((LogicalPlan)transformRelationFunc.apply((Object)flow.getPlan()));
        scala.collection.immutable.Map x$11 = CollectionConverters$.MODULE$.MapHasAsScala(flow.getSqlConfMap()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        boolean x$12 = flow.getOnce();
        QueryContext x$13 = new QueryContext(Option$.MODULE$.apply((Object)graphElementRegistry.defaultCatalog()), Option$.MODULE$.apply((Object)graphElementRegistry.defaultDatabase()));
        None$ x$14 = None$.MODULE$;
        Option x$1 = Option$.MODULE$.apply((Object)QueryOriginType$.MODULE$.Flow().toString());
        Option x$2 = Option$.MODULE$.apply((Object)flowIdentifier.unquotedString());
        Option x$3 = Option$.MODULE$.apply((Object)new Language.Python());
        Option x$4 = QueryOrigin$.MODULE$.apply$default$2();
        Option x$5 = QueryOrigin$.MODULE$.apply$default$3();
        Option x$6 = QueryOrigin$.MODULE$.apply$default$4();
        Option x$7 = QueryOrigin$.MODULE$.apply$default$5();
        QueryOrigin x$15 = new QueryOrigin(x$3, x$4, x$5, x$6, x$7, x$1, x$2);
        graphElementRegistry.registerFlow(new UnresolvedFlow(x$8, x$9, x$10, x$13, x$11, (Option)x$14, x$12, x$15));
    }

    private void startRun(PipelineCommand.StartRun cmd, StreamObserver<ExecutePlanResponse> responseObserver, SessionHolder sessionHolder) {
        String dataflowGraphId = cmd.getDataflowGraphId();
        GraphRegistrationContext graphElementRegistry = DataflowGraphRegistry$.MODULE$.getDataflowGraphOrThrow(dataflowGraphId);
        VolatileObjectRef runFailureEvent = VolatileObjectRef.create((Object)Option$.MODULE$.empty());
        Function1 & Serializable eventCallback = (Function1 & Serializable)event -> {
            PipelinesHandler$.$anonfun$startRun$1(runFailureEvent, responseObserver, sessionHolder, event);
            return BoxedUnit.UNIT;
        };
        PipelineUpdateContextImpl pipelineUpdateContext = new PipelineUpdateContextImpl(graphElementRegistry.toDataflowGraph(), (Function1)eventCallback);
        sessionHolder.cachePipelineExecution(dataflowGraphId, (PipelineUpdateContext)pipelineUpdateContext);
        pipelineUpdateContext.pipelineExecution().runPipeline();
        ((Option)runFailureEvent.elem).foreach((Function1 & Serializable)event -> {
            throw (Throwable)event.error().get();
        });
    }

    private static final Seq getExceptionMessages$1(Throwable throwable2) {
        String string = throwable2.getMessage();
        return (Seq)((SeqOps)Option$.MODULE$.apply((Object)throwable2.getCause()).map((Function1 & Serializable)throwable -> PipelinesHandler$.getExceptionMessages$1(throwable)).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$)).$plus$colon((Object)string);
    }

    public static final /* synthetic */ void $anonfun$startRun$1(VolatileObjectRef runFailureEvent$1, StreamObserver responseObserver$1, SessionHolder sessionHolder$1, PipelineEvent event) {
        String string;
        if (event.error().nonEmpty()) {
            Seq errorMessages = PipelinesHandler$.getExceptionMessages$1((Throwable)event.error().get());
            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(event.message() + "\n           |Error: " + errorMessages.mkString("\n")));
        } else {
            string = event.message();
        }
        String message = string;
        boolean bl = false;
        RunProgress runProgress = null;
        EventDetails eventDetails = event.details();
        if (eventDetails instanceof RunProgress) {
            RunState state;
            bl = true;
            runProgress = (RunProgress)eventDetails;
            RunState runState = state = runProgress.state();
            RunState.FAILED$ fAILED$ = RunState.FAILED$.MODULE$;
            if (!(runState != null ? !runState.equals(fAILED$) : fAILED$ != null)) {
                runFailureEvent$1.elem = new Some((Object)event);
                return;
            }
        }
        if (bl) {
            RunState state;
            RunState runState = state = runProgress.state();
            RunState.CANCELED$ cANCELED$ = RunState.CANCELED$.MODULE$;
            if (!(runState != null ? !runState.equals(cANCELED$) : cANCELED$ != null)) {
                throw new RuntimeException("Pipeline run was canceled.");
            }
        }
        responseObserver$1.onNext(ExecutePlanResponse.newBuilder().setSessionId(sessionHolder$1.sessionId()).setServerSideSessionId(sessionHolder$1.serverSessionId()).setPipelineEventResult(PipelineEventResult.newBuilder().setEvent(org.apache.spark.connect.proto.PipelineEvent.newBuilder().setTimestamp(Timestamp.newBuilder().setSeconds(event.timestamp().getTime() / 1000L).setNanos(event.timestamp().getNanos()).build()).setMessage(message).build()).build()).build());
    }

    private PipelinesHandler$() {
    }
}

