/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.ml;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.SparkException$;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.Fetch;
import org.apache.spark.connect.proto.MlCommand;
import org.apache.spark.connect.proto.MlCommandResult;
import org.apache.spark.connect.proto.MlOperator;
import org.apache.spark.connect.proto.MlParams;
import org.apache.spark.connect.proto.MlRelation;
import org.apache.spark.connect.proto.ObjectRef;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.EstimatorUtils$;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.clustering.LDA;
import org.apache.spark.ml.clustering.PowerIterationClustering;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.tree.TreeConfig$;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.Summary;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.connect.common.LiteralValueProtoConverter$;
import org.apache.spark.sql.connect.ml.AttributeHelper;
import org.apache.spark.sql.connect.ml.AttributeHelper$;
import org.apache.spark.sql.connect.ml.MLCache;
import org.apache.spark.sql.connect.ml.MLModelSummaryLostException;
import org.apache.spark.sql.connect.ml.MLUtils$;
import org.apache.spark.sql.connect.ml.MlUnsupportedException;
import org.apache.spark.sql.connect.ml.ModelAttributeHelper;
import org.apache.spark.sql.connect.ml.ModelAttributeHelper$;
import org.apache.spark.sql.connect.ml.Serializer$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.connect.protobuf.GeneratedMessage;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class MLHandler$
implements Logging {
    public static final MLHandler$ MODULE$ = new MLHandler$();
    private static final ThreadLocal<SessionHolder> currentSessionHolder;
    private static final ConcurrentHashMap<Object, Object> handlerExecutionStartTimeMap;
    private static final scala.collection.immutable.Map<String, Class<?>> allowlistedMLClasses;
    private static final Function1<String, Class<?>> safeMLClassLoader;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        currentSessionHolder = new ThreadLocal<SessionHolder>(){

            public SessionHolder initialValue() {
                return null;
            }
        };
        handlerExecutionStartTimeMap = new ConcurrentHashMap();
        scala.collection.immutable.Map<String, Class<?>> transformerClasses = MLUtils$.MODULE$.loadOperators(Transformer.class);
        scala.collection.immutable.Map<String, Class<?>> estimatorClasses = MLUtils$.MODULE$.loadOperators(Estimator.class);
        scala.collection.immutable.Map<String, Class<?>> evaluatorClasses = MLUtils$.MODULE$.loadOperators(Evaluator.class);
        allowlistedMLClasses = (scala.collection.immutable.Map)((MapOps)((MapOps)transformerClasses.$plus$plus(estimatorClasses)).$plus$plus(evaluatorClasses)).$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.ml.clustering.PowerIterationClustering"), PowerIterationClustering.class)})));
        safeMLClassLoader = (Function1 & Serializable)className -> {
            SessionHolder sessionHolder = MODULE$.currentSessionHolder().get();
            if (sessionHolder != null) {
                Class clazz;
                String name = MLUtils$.MODULE$.replaceOperator(sessionHolder, (String)className);
                try {
                    clazz = (Class)MODULE$.allowlistedMLClasses().apply((Object)name);
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new MlUnsupportedException("The class " + className + " to be loaded is not in the allowlist.");
                }
                return clazz;
            }
            return Utils$.MODULE$.classForName(className, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        };
        MODULE$.startHangingHandlerReaper();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ThreadLocal<SessionHolder> currentSessionHolder() {
        return currentSessionHolder;
    }

    public ConcurrentHashMap<Object, Object> handlerExecutionStartTimeMap() {
        return handlerExecutionStartTimeMap;
    }

    private scala.collection.immutable.Map<String, Class<?>> allowlistedMLClasses() {
        return allowlistedMLClasses;
    }

    public Function1<String, Class<?>> safeMLClassLoader() {
        return safeMLClassLoader;
    }

    public void startHangingHandlerReaper() {
        int handlerInterruptionTimeoutMinutes;
        int n;
        try {
            String envValue = System.getenv("SPARK_CONNECT_ML_HANDLER_INTERRUPTION_TIMEOUT_MINUTES");
            n = envValue != null ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(envValue)) : 0;
        }
        catch (Exception exception) {
            n = handlerInterruptionTimeoutMinutes = 0;
        }
        if (handlerInterruptionTimeoutMinutes > 0) {
            int handlerInterruptionTimeoutMillis = handlerInterruptionTimeoutMinutes * 60 * 1000;
            Thread thread = new Thread(() -> {
                while (true) {
                    MODULE$.handlerExecutionStartTimeMap().forEach((threadId, startTime) -> MLHandler$.$anonfun$startHangingHandlerReaper$2(handlerInterruptionTimeoutMillis, BoxesRunTime.unboxToLong((Object)threadId), BoxesRunTime.unboxToLong((Object)startTime)));
                    Thread.sleep(60000L);
                }
            });
            thread.setDaemon(true);
            thread.start();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MlCommandResult _handleMlCommand(SessionHolder sessionHolder, MlCommand mlCommand) {
        MlCommand.CommandCase commandCase;
        MLCache mlCache = sessionHolder.mlCache();
        boolean memoryControlEnabled = sessionHolder.mlCache().getMemoryControlEnabled();
        this.currentSessionHolder().set(sessionHolder);
        if (memoryControlEnabled) {
            long maxModelSize = sessionHolder.mlCache().getModelMaxSize();
            TreeConfig$.MODULE$.trainingEarlyStopModelSizeThresholdInBytes_$eq((long)((double)maxModelSize / 2.5));
        }
        if (MlCommand.CommandCase.FIT.equals(commandCase = mlCommand.getCommandCase())) {
            MlCommand.Fit fitCmd = mlCommand.getFit();
            MlOperator estimatorProto = fitCmd.getEstimator();
            MlOperator.OperatorType operatorType = estimatorProto.getType();
            MlOperator.OperatorType operatorType2 = MlOperator.OperatorType.OPERATOR_TYPE_ESTIMATOR;
            Predef$.MODULE$.assert(!(operatorType != null ? !operatorType.equals(operatorType2) : operatorType2 != null));
            Dataset<Row> dataset = MLUtils$.MODULE$.parseRelationProto(fitCmd.getDataset(), sessionHolder);
            Estimator<?> estimator = MLUtils$.MODULE$.getEstimator(sessionHolder, estimatorProto, (Option<MlParams>)new Some((Object)fitCmd.getParams()));
            if (memoryControlEnabled) {
                try {
                    long estimatedModelSize = estimator.estimateModelSize(dataset);
                    mlCache.checkModelSize(estimatedModelSize);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
                String string = estimator.getClass().getName();
                String string2 = "org.apache.spark.ml.fpm.FPGrowth";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    throw new MlUnsupportedException("FPGrowth algorithm is not supported if Spark Connect model cache offloading is enabled.");
                }
                String string3 = estimator.getClass().getName();
                String string4 = "org.apache.spark.ml.clustering.LDA";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    String string5 = ((LDA)estimator).getOptimizer().toLowerCase();
                    String string6 = "em";
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        throw new MlUnsupportedException("LDA algorithm with 'em' optimizer is not supported if Spark Connect model cache offloading is enabled.");
                    }
                }
            }
            EstimatorUtils$.MODULE$.warningMessagesBuffer().set(new ArrayBuffer());
            Model model = estimator.fit(dataset);
            String id = mlCache.register(model);
            String fitWarningMessage = ((ArrayBuffer)EstimatorUtils$.MODULE$.warningMessagesBuffer().get()).length() > 0 ? ((IterableOnceOps)EstimatorUtils$.MODULE$.warningMessagesBuffer().get()).mkString("\n") : null;
            EstimatorUtils$.MODULE$.warningMessagesBuffer().set(null);
            MlCommandResult.MlOperatorInfo.Builder opInfo = MlCommandResult.MlOperatorInfo.newBuilder().setObjRef(ObjectRef.newBuilder().setId(id));
            Object object = fitWarningMessage != null ? opInfo.setWarningMessage(fitWarningMessage) : BoxedUnit.UNIT;
            return MlCommandResult.newBuilder().setOperatorInfo(opInfo).build();
        }
        if (MlCommand.CommandCase.FETCH.equals(commandCase)) {
            Object object;
            AttributeHelper helper;
            Object attrResult;
            Object object2;
            String objRefId = mlCommand.getFetch().getObjRef().getId();
            Fetch.Method[] methods = (Fetch.Method[])CollectionConverters$.MODULE$.CollectionHasAsScala(mlCommand.getFetch().getMethodsList()).asScala().toArray(ClassTag$.MODULE$.apply(Fetch.Method.class));
            Object obj = sessionHolder.mlCache().get(objRefId);
            if (obj != null && obj instanceof HasTrainingSummary) {
                String string = methods[0].getMethod();
                String string7 = "summary";
                if (!(string != null ? !string.equals(string7) : string7 != null) && !((HasTrainingSummary)obj).hasSummary()) {
                    throw new MLModelSummaryLostException(objRefId);
                }
            }
            if ((object2 = (attrResult = (helper = AttributeHelper$.MODULE$.apply(sessionHolder, objRefId, methods)).getAttribute())) instanceof Summary) {
                Summary summary = (Summary)object2;
                String id = mlCache.register(summary);
                return MlCommandResult.newBuilder().setSummary(id).build();
            }
            if (object2 instanceof Model) {
                Model model = (Model)object2;
                String id = mlCache.register(model);
                return MlCommandResult.newBuilder().setOperatorInfo(MlCommandResult.MlOperatorInfo.newBuilder().setObjRef(ObjectRef.newBuilder().setId(id))).build();
            }
            if (ScalaRunTime$.MODULE$.isArray(object2, 1) && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.genericArrayOps(object = object2)) && ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.genericArrayOps(object), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MLHandler$.$anonfun$_handleMlCommand$1(x$2)))) {
                String[] ids = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps(object), (Function1 & Serializable)m4 -> mlCache.register((Model)m4), ClassTag$.MODULE$.apply(String.class));
                return MlCommandResult.newBuilder().setOperatorInfo(MlCommandResult.MlOperatorInfo.newBuilder().setObjRef(ObjectRef.newBuilder().setId(Predef$.MODULE$.wrapRefArray((Object[])ids).mkString(",")))).build();
            }
            Expression.Literal param = Serializer$.MODULE$.serializeParam(attrResult);
            return MlCommandResult.newBuilder().setParam(param).build();
        }
        if (MlCommand.CommandCase.DELETE.equals(commandCase)) {
            ArrayBuilder ids = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
            MlCommand.Delete deleteCmd = mlCommand.getDelete();
            boolean evictOnly = deleteCmd.hasEvictOnly() ? deleteCmd.getEvictOnly() : false;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])CollectionConverters$.MODULE$.CollectionHasAsScala(deleteCmd.getObjRefsList()).asScala().toArray(ClassTag$.MODULE$.apply(ObjectRef.class))), (Function1 & Serializable)objId -> {
                if (!objId.getId().contains(".")) {
                    if (mlCache.remove(objId.getId(), evictOnly)) {
                        return ids.$plus$eq((Object)objId.getId());
                    }
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            return MlCommandResult.newBuilder().setOperatorInfo(MlCommandResult.MlOperatorInfo.newBuilder().setObjRef(ObjectRef.newBuilder().setId(Predef$.MODULE$.wrapRefArray((Object[])ids.result()).mkString(",")))).build();
        }
        if (MlCommand.CommandCase.CLEAN_CACHE.equals(commandCase)) {
            int size = mlCache.clear();
            return MlCommandResult.newBuilder().setParam(LiteralValueProtoConverter$.MODULE$.toLiteralProto(BoxesRunTime.boxToInteger((int)size))).build();
        }
        if (MlCommand.CommandCase.GET_CACHE_INFO.equals(commandCase)) {
            return MlCommandResult.newBuilder().setParam(LiteralValueProtoConverter$.MODULE$.toLiteralProto(mlCache.getInfo())).build();
        }
        if (MlCommand.CommandCase.WRITE.equals(commandCase)) {
            MlCommand.Write.TypeCase typeCase = mlCommand.getWrite().getTypeCase();
            if (MlCommand.Write.TypeCase.OBJ_REF.equals(typeCase)) {
                String objId2 = mlCommand.getWrite().getObjRef().getId();
                Model model = (Model)mlCache.get(objId2);
                Model copiedModel = model.copy(ParamMap$.MODULE$.empty());
                MLUtils$.MODULE$.setInstanceParams((Params)copiedModel, mlCommand.getWrite().getParams());
                Model model2 = copiedModel;
                if (!(model2 instanceof MLWritable)) {
                    throw new MlUnsupportedException(model2 + " is not writable");
                }
                Model model3 = model2;
                MLUtils$.MODULE$.write((MLWritable)model3, mlCommand.getWrite());
                return MlCommandResult.newBuilder().build();
            } else {
                if (!MlCommand.Write.TypeCase.OPERATOR.equals(typeCase)) throw new MlUnsupportedException(typeCase + " write not supported");
                MlCommand.Write writer = mlCommand.getWrite();
                MlOperator.OperatorType operatorType = writer.getOperator().getType();
                String operatorName = writer.getOperator().getName();
                Some params = new Some((Object)writer.getParams());
                MlOperator.OperatorType operatorType3 = operatorType;
                if (MlOperator.OperatorType.OPERATOR_TYPE_ESTIMATOR.equals(operatorType3)) {
                    Estimator<?> estimator = MLUtils$.MODULE$.getEstimator(sessionHolder, writer.getOperator(), (Option<MlParams>)params);
                    Estimator<?> estimator2 = estimator;
                    if (!(estimator2 instanceof MLWritable)) {
                        throw new MlUnsupportedException("Estimator " + estimator2 + " is not writable");
                    }
                    Estimator<?> estimator3 = estimator2;
                    MLUtils$.MODULE$.write((MLWritable)estimator3, mlCommand.getWrite());
                    return MlCommandResult.newBuilder().build();
                } else if (MlOperator.OperatorType.OPERATOR_TYPE_EVALUATOR.equals(operatorType3)) {
                    Evaluator evaluator = MLUtils$.MODULE$.getEvaluator(sessionHolder, writer.getOperator(), (Option<MlParams>)params);
                    Evaluator evaluator2 = evaluator;
                    if (!(evaluator2 instanceof MLWritable)) {
                        throw new MlUnsupportedException("Evaluator " + evaluator2 + " is not writable");
                    }
                    Evaluator evaluator3 = evaluator2;
                    MLUtils$.MODULE$.write((MLWritable)evaluator3, mlCommand.getWrite());
                    return MlCommandResult.newBuilder().build();
                } else {
                    if (!MlOperator.OperatorType.OPERATOR_TYPE_TRANSFORMER.equals(operatorType3)) throw new MlUnsupportedException("Operator " + operatorName + " is not supported");
                    Transformer transformer = MLUtils$.MODULE$.getTransformer(sessionHolder, writer.getOperator(), (Option<MlParams>)params);
                    Transformer transformer2 = transformer;
                    if (!(transformer2 instanceof MLWritable)) {
                        throw new MlUnsupportedException("Transformer " + transformer2 + " is not writable");
                    }
                    Transformer transformer3 = transformer2;
                    MLUtils$.MODULE$.write((MLWritable)transformer3, mlCommand.getWrite());
                }
            }
            return MlCommandResult.newBuilder().build();
        }
        if (MlCommand.CommandCase.READ.equals(commandCase)) {
            Evaluator evaluator;
            MlOperator operator = mlCommand.getRead().getOperator();
            String name = operator.getName();
            String path = mlCommand.getRead().getPath();
            MlOperator.OperatorType operatorType = operator.getType();
            MlOperator.OperatorType operatorType4 = MlOperator.OperatorType.OPERATOR_TYPE_MODEL;
            if (!(operatorType != null ? !operatorType.equals(operatorType4) : operatorType4 != null)) {
                Transformer model = MLUtils$.MODULE$.loadTransformer(sessionHolder, name, path, MLUtils$.MODULE$.loadTransformer$default$4());
                String id = mlCache.register(model);
                return MlCommandResult.newBuilder().setOperatorInfo(MlCommandResult.MlOperatorInfo.newBuilder().setObjRef(ObjectRef.newBuilder().setId(id)).setUid(model.uid()).setParams(Serializer$.MODULE$.serializeParams((Params)model))).build();
            }
            MlOperator.OperatorType operatorType5 = operator.getType();
            MlOperator.OperatorType operatorType6 = MlOperator.OperatorType.OPERATOR_TYPE_ESTIMATOR;
            if (!(operatorType5 != null ? !operatorType5.equals(operatorType6) : operatorType6 != null)) {
                evaluator = MLUtils$.MODULE$.loadEstimator(sessionHolder, name, path);
            } else {
                MlOperator.OperatorType operatorType7 = operator.getType();
                MlOperator.OperatorType operatorType8 = MlOperator.OperatorType.OPERATOR_TYPE_EVALUATOR;
                if (!(operatorType7 != null ? !operatorType7.equals(operatorType8) : operatorType8 != null)) {
                    evaluator = MLUtils$.MODULE$.loadEvaluator(sessionHolder, name, path);
                } else {
                    MlOperator.OperatorType operatorType9 = operator.getType();
                    MlOperator.OperatorType operatorType10 = MlOperator.OperatorType.OPERATOR_TYPE_TRANSFORMER;
                    if (operatorType9 != null ? !operatorType9.equals(operatorType10) : operatorType10 != null) throw new MlUnsupportedException(operator.getType() + " read not supported");
                    evaluator = MLUtils$.MODULE$.loadTransformer(sessionHolder, name, path, MLUtils$.MODULE$.loadTransformer$default$4());
                }
            }
            Evaluator mlOperator = evaluator;
            return MlCommandResult.newBuilder().setOperatorInfo(MlCommandResult.MlOperatorInfo.newBuilder().setName(name).setUid(mlOperator.uid()).setParams(Serializer$.MODULE$.serializeParams((Params)mlOperator))).build();
        }
        if (MlCommand.CommandCase.EVALUATE.equals(commandCase)) {
            MlCommand.Evaluate evalCmd = mlCommand.getEvaluate();
            MlOperator evalProto = evalCmd.getEvaluator();
            MlOperator.OperatorType operatorType = evalProto.getType();
            MlOperator.OperatorType operatorType11 = MlOperator.OperatorType.OPERATOR_TYPE_EVALUATOR;
            Predef$.MODULE$.assert(!(operatorType != null ? !operatorType.equals(operatorType11) : operatorType11 != null));
            Dataset<Row> dataset = MLUtils$.MODULE$.parseRelationProto(evalCmd.getDataset(), sessionHolder);
            Evaluator evaluator = MLUtils$.MODULE$.getEvaluator(sessionHolder, evalProto, (Option<MlParams>)new Some((Object)evalCmd.getParams()));
            double metric = evaluator.evaluate(dataset);
            return MlCommandResult.newBuilder().setParam(LiteralValueProtoConverter$.MODULE$.toLiteralProto(BoxesRunTime.boxToDouble((double)metric))).build();
        }
        if (!MlCommand.CommandCase.CREATE_SUMMARY.equals(commandCase)) throw new MlUnsupportedException(commandCase + " not supported");
        MlCommand.CreateSummary createSummaryCmd = mlCommand.getCreateSummary();
        return this.createModelSummary(sessionHolder, createSummaryCmd);
    }

    public Object wrapHandler(Function0<Object> originHandler, GeneratedMessage reqProto) {
        Object object;
        long threadId = Thread.currentThread().getId();
        long startTime = System.currentTimeMillis();
        this.handlerExecutionStartTimeMap().put(BoxesRunTime.boxToLong((long)threadId), BoxesRunTime.boxToLong((long)startTime));
        try {
            try {
                object = originHandler.apply();
            }
            catch (InterruptedException e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String stackTrace = sw.toString();
                long execTime = (System.currentTimeMillis() - startTime) / 60000L;
                throw SparkException$.MODULE$.internalError("The Spark Connect ML handler thread is interrupted after executing for " + execTime + " minutes.\nThe request proto message is:\n" + reqProto.toString() + "\n, the current stack trace is:\n" + stackTrace + "\n");
            }
        }
        finally {
            this.handlerExecutionStartTimeMap().remove(BoxesRunTime.boxToLong((long)threadId));
        }
        return object;
    }

    public MlCommandResult handleMlCommand(SessionHolder sessionHolder, MlCommand mlCommand) {
        return (MlCommandResult)this.wrapHandler((Function0<Object>)(Function0 & Serializable)() -> MODULE$._handleMlCommand(sessionHolder, mlCommand), mlCommand);
    }

    private MlCommandResult createModelSummary(SessionHolder sessionHolder, MlCommand.CreateSummary createSummaryCmd) {
        MlCommandResult mlCommandResult;
        MLCache mLCache = sessionHolder.mlCache();
        synchronized (mLCache) {
            boolean bl;
            String refId = createSummaryCmd.getModelRef().getId();
            HasTrainingSummary model = (HasTrainingSummary)sessionHolder.mlCache().get(refId);
            if (!model.hasSummary()) {
                Dataset<Row> dataset = MLUtils$.MODULE$.parseRelationProto(createSummaryCmd.getDataset(), sessionHolder);
                Path modelPath = sessionHolder.mlCache().getModelOffloadingPath(refId);
                String summaryPath = ((Object)modelPath.resolve("summary")).toString();
                model.loadSummary(summaryPath, dataset);
                bl = true;
            } else {
                bl = false;
            }
            boolean isCreated = bl;
            mlCommandResult = MlCommandResult.newBuilder().setParam(LiteralValueProtoConverter$.MODULE$.toLiteralProto(BoxesRunTime.boxToBoolean((boolean)isCreated))).build();
        }
        return mlCommandResult;
    }

    public Dataset<Row> _transformMLRelation(MlRelation relation, SessionHolder sessionHolder) {
        MlRelation.MlTypeCase mlTypeCase = relation.getMlTypeCase();
        if (MlRelation.MlTypeCase.TRANSFORM.equals(mlTypeCase)) {
            MlRelation.Transform.OperatorCase operatorCase = relation.getTransform().getOperatorCase();
            if (MlRelation.Transform.OperatorCase.TRANSFORMER.equals(operatorCase)) {
                MlRelation.Transform transformProto = relation.getTransform();
                MlOperator.OperatorType operatorType = transformProto.getTransformer().getType();
                MlOperator.OperatorType operatorType2 = MlOperator.OperatorType.OPERATOR_TYPE_TRANSFORMER;
                Predef$.MODULE$.assert(!(operatorType != null ? !operatorType.equals(operatorType2) : operatorType2 != null));
                Dataset<Row> dataset = MLUtils$.MODULE$.parseRelationProto(transformProto.getInput(), sessionHolder);
                Transformer transformer = MLUtils$.MODULE$.getTransformer(sessionHolder, transformProto);
                return transformer.transform(dataset);
            }
            if (MlRelation.Transform.OperatorCase.OBJ_REF.equals(operatorCase)) {
                ModelAttributeHelper helper = ModelAttributeHelper$.MODULE$.apply(sessionHolder, relation.getTransform().getObjRef().getId(), (Fetch.Method[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Fetch.Method.class)));
                return helper.transform(relation.getTransform());
            }
            throw new IllegalArgumentException(operatorCase + " not supported");
        }
        if (MlRelation.MlTypeCase.FETCH.equals(mlTypeCase)) {
            String objRefId = relation.getFetch().getObjRef().getId();
            Fetch.Method[] methods = (Fetch.Method[])CollectionConverters$.MODULE$.CollectionHasAsScala(relation.getFetch().getMethodsList()).asScala().toArray(ClassTag$.MODULE$.apply(Fetch.Method.class));
            Object obj = sessionHolder.mlCache().get(objRefId);
            MLCache mLCache = sessionHolder.mlCache();
            synchronized (mLCache) {
                if (obj != null && obj instanceof HasTrainingSummary) {
                    String string = methods[0].getMethod();
                    String string2 = "summary";
                    if (!(string != null ? !string.equals(string2) : string2 != null) && !((HasTrainingSummary)obj).hasSummary()) {
                        if (relation.hasModelSummaryDataset()) {
                            Dataset<Row> dataset = MLUtils$.MODULE$.parseRelationProto(relation.getModelSummaryDataset(), sessionHolder);
                            Path modelPath = sessionHolder.mlCache().getModelOffloadingPath(objRefId);
                            String summaryPath = ((Object)modelPath.resolve("summary")).toString();
                            ((HasTrainingSummary)obj).loadSummary(summaryPath, dataset);
                        } else {
                            throw new MLModelSummaryLostException(objRefId);
                        }
                    }
                }
            }
            AttributeHelper helper = AttributeHelper$.MODULE$.apply(sessionHolder, objRefId, methods);
            return (Dataset)helper.getAttribute();
        }
        throw new MlUnsupportedException(mlTypeCase + " not supported");
    }

    public Dataset<Row> transformMLRelation(MlRelation relation, SessionHolder sessionHolder) {
        return (Dataset)this.wrapHandler((Function0<Object>)(Function0 & Serializable)() -> MODULE$._transformMLRelation(relation, sessionHolder), relation);
    }

    public static final /* synthetic */ void $anonfun$startHangingHandlerReaper$3(long threadId$1, Thread t2) {
        if (t2.getId() == threadId$1) {
            t2.interrupt();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$startHangingHandlerReaper$2(int handlerInterruptionTimeoutMillis$1, long threadId, long startTime) {
        long execTime = System.currentTimeMillis() - startTime;
        if (execTime > (long)handlerInterruptionTimeoutMillis$1) {
            CollectionConverters$.MODULE$.CollectionHasAsScala(Thread.getAllStackTraces().keySet()).asScala().foreach((Function1 & Serializable)t2 -> {
                MLHandler$.$anonfun$startHangingHandlerReaper$3(threadId, t2);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$_handleMlCommand$1(Object x$2) {
        return x$2 instanceof Model;
    }

    private MLHandler$() {
    }
}

