/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.StorageLevels;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function3;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.examples.streaming.StreamingExamples;
import org.apache.spark.streaming.Durations;
import org.apache.spark.streaming.StateSpec;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaMapWithStateDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import scala.Tuple2;

public class JavaStatefulNetworkWordCount {
    private static final Pattern SPACE = Pattern.compile(" ");

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: JavaStatefulNetworkWordCount <hostname> <port>");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        SparkConf sparkConf = new SparkConf().setAppName("JavaStatefulNetworkWordCount");
        JavaStreamingContext ssc = new JavaStreamingContext(sparkConf, Durations.seconds((long)1L));
        ssc.checkpoint(".");
        List<Tuple2> tuples = Arrays.asList(new Tuple2((Object)"hello", (Object)1), new Tuple2((Object)"world", (Object)1));
        JavaPairRDD initialRDD = ssc.sparkContext().parallelizePairs(tuples);
        JavaReceiverInputDStream lines = ssc.socketTextStream(args[0], Integer.parseInt(args[1]), StorageLevels.MEMORY_AND_DISK_SER_2);
        JavaDStream words = lines.flatMap((FlatMapFunction & Serializable)x -> Arrays.asList(SPACE.split((CharSequence)x)).iterator());
        JavaPairDStream wordsDstream = words.mapToPair((PairFunction & Serializable)s -> new Tuple2(s, (Object)1));
        Function3 & Serializable mappingFunc = (Function3 & Serializable)(word, one, state) -> {
            int sum = (Integer)one.orElse((Object)0) + (state.exists() ? (Integer)state.get() : 0);
            Tuple2 output = new Tuple2(word, (Object)sum);
            state.update((Object)sum);
            return output;
        };
        JavaMapWithStateDStream stateDstream = wordsDstream.mapWithState(StateSpec.function((Function3)mappingFunc).initialState(initialRDD));
        stateDstream.print();
        ssc.start();
        ssc.awaitTermination();
    }
}

