/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;

public final class LinearRegressionWithElasticNetExample$ {
    public static final LinearRegressionWithElasticNetExample$ MODULE$ = new LinearRegressionWithElasticNetExample$();

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("LinearRegressionWithElasticNetExample").getOrCreate();
        Dataset training = spark.read().format("libsvm").load("data/mllib/sample_linear_regression_data.txt");
        LinearRegression lr = new LinearRegression().setMaxIter(10).setRegParam(0.3).setElasticNetParam(0.8);
        LinearRegressionModel lrModel = (LinearRegressionModel)lr.fit(training);
        Predef$.MODULE$.println((Object)("Coefficients: " + lrModel.coefficients() + " Intercept: " + lrModel.intercept()));
        LinearRegressionTrainingSummary trainingSummary = lrModel.summary();
        Predef$.MODULE$.println((Object)("numIterations: " + trainingSummary.totalIterations()));
        Predef$.MODULE$.println((Object)("objectiveHistory: [" + Predef$.MODULE$.wrapDoubleArray(trainingSummary.objectiveHistory()).mkString(",") + "]"));
        trainingSummary.residuals().show();
        Predef$.MODULE$.println((Object)("RMSE: " + trainingSummary.rootMeanSquaredError()));
        Predef$.MODULE$.println((Object)("r2: " + trainingSummary.r2()));
        spark.stop();
    }

    private LinearRegressionWithElasticNetExample$() {
    }
}

