/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.feature.MinMaxScaler;
import org.apache.spark.ml.feature.MinMaxScalerModel;
import org.apache.spark.ml.regression.FMRegressionModel;
import org.apache.spark.ml.regression.FMRegressor;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public class JavaFMRegressorExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaFMRegressorExample").getOrCreate();
        Dataset data = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        MinMaxScalerModel featureScaler = new MinMaxScaler().setInputCol("features").setOutputCol("scaledFeatures").fit(data);
        Dataset[] splits = data.randomSplit(new double[]{0.7, 0.3});
        Dataset trainingData = splits[0];
        Dataset testData = splits[1];
        FMRegressor fm = ((FMRegressor)((FMRegressor)new FMRegressor().setLabelCol("label")).setFeaturesCol("scaledFeatures")).setStepSize(0.001);
        Pipeline pipeline = new Pipeline().setStages(new PipelineStage[]{featureScaler, fm});
        PipelineModel model = pipeline.fit(trainingData);
        Dataset predictions = model.transform(testData);
        predictions.select("prediction", new String[]{"label", "features"}).show(5);
        RegressionEvaluator evaluator = new RegressionEvaluator().setLabelCol("label").setPredictionCol("prediction").setMetricName("rmse");
        double rmse = evaluator.evaluate(predictions);
        System.out.println("Root Mean Squared Error (RMSE) on test data = " + rmse);
        FMRegressionModel fmModel = (FMRegressionModel)model.stages()[1];
        System.out.println("Factors: " + String.valueOf(fmModel.factors()));
        System.out.println("Linear: " + String.valueOf(fmModel.linear()));
        System.out.println("Intercept: " + fmModel.intercept());
        spark.stop();
    }
}

