/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import breeze.generic.UFunc;
import breeze.gymnastics.NotGiven$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.squaredDistance$;
import java.io.Serializable;
import java.util.Random;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class LocalKMeans$ {
    public static final LocalKMeans$ MODULE$ = new LocalKMeans$();
    private static final int N = 1000;
    private static final int R = 1000;
    private static final int D = 10;
    private static final int K = 10;
    private static final double convergeDist = 0.001;
    private static final Random rand = new Random(42L);

    public int N() {
        return N;
    }

    public int R() {
        return R;
    }

    public int D() {
        return D;
    }

    public int K() {
        return K;
    }

    public double convergeDist() {
        return convergeDist;
    }

    public Random rand() {
        return rand;
    }

    public DenseVector<Object>[] generateData() {
        return (DenseVector[])Array$.MODULE$.tabulate(this.N(), (Function1 & Serializable)i -> this.generatePoint$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(DenseVector.class));
    }

    public int closestPoint(Vector<Object> p, HashMap<Object, Vector<Object>> centers) {
        IntRef bestIndex = IntRef.create((int)0);
        DoubleRef closest = DoubleRef.create((double)Double.POSITIVE_INFINITY);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), centers.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Vector vCurr = (Vector)centers.apply((Object)BoxesRunTime.boxToInteger((int)i));
            double tempDist = BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply((Object)p, (Object)vCurr, squaredDistance$.MODULE$.squaredDistanceFromZippedValues((UFunc.UImpl2)HasOps$.MODULE$.zipValuesImpl_V_V_Double())));
            if (tempDist < closest$1.elem) {
                closest$1.elem = tempDist;
                bestIndex$1.elem = i;
                return;
            }
        });
        return bestIndex.elem;
    }

    public void showWarning() {
        System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of KMeans Clustering and is given as an example!\n        |Please use org.apache.spark.ml.clustering.KMeans\n        |for more conventional use.\n      ")));
    }

    public void main(String[] args) {
        this.showWarning();
        DenseVector<Object>[] data = this.generateData();
        HashSet points = new HashSet();
        HashMap kPoints = new HashMap();
        DoubleRef tempDist = DoubleRef.create((double)1.0);
        while (points.size() < this.K()) {
            points.add(data[this.rand().nextInt(this.N())]);
        }
        Iterator iter = points.iterator();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), points.size()).foreach((Function1 & Serializable)i -> kPoints.put((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), iter.next()));
        Predef$.MODULE$.println((Object)("Initial centers: " + kPoints));
        while (tempDist.elem > this.convergeDist()) {
            Tuple2[] closest = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])data), (Function1 & Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)MODULE$.closestPoint((Vector<Object>)p, (HashMap<Object, Vector<Object>>)kPoints)), (Object)new Tuple2(p, (Object)BoxesRunTime.boxToInteger((int)1))), ClassTag$.MODULE$.apply(Tuple2.class));
            Map mappings = ArrayOps$.MODULE$.groupBy$extension(Predef$.MODULE$.refArrayOps((Object[])closest), (Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)x._1$mcI$sp()));
            Map pointStats = (Map)mappings.map((Function1 & Serializable)pair -> (Tuple2)Predef$.MODULE$.wrapRefArray((Object[])pair._2()).reduceLeft((Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        int id1 = tuple22._1$mcI$sp();
                        Tuple2 tuple24 = (Tuple2)tuple22._2();
                        if (tuple24 != null) {
                            Tuple2 tuple25;
                            Vector p1 = (Vector)tuple24._1();
                            int c1 = tuple24._2$mcI$sp();
                            if (tuple23 != null && (tuple25 = (Tuple2)tuple23._2()) != null) {
                                DenseVector p2 = (DenseVector)tuple25._1();
                                int c2 = tuple25._2$mcI$sp();
                                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)id1), (Object)new Tuple2(p1.$plus((Object)p2, HasOps$.MODULE$.pureFromUpdate(HasOps$.MODULE$.castUpdateOps_V_V((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.neq(), (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_V_V_Idempotent_Double_OpAdd()), Vector$.MODULE$.canCopy())), (Object)BoxesRunTime.boxToInteger((int)(c1 + c2))));
                            }
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }));
            Map newPoints = (Map)pointStats.map((Function1 & Serializable)mapping -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)mapping._1$mcI$sp()), ((ImmutableNumericOps)((Tuple2)mapping._2())._1()).$times((Object)BoxesRunTime.boxToDouble((double)(1.0 / (double)((Tuple2)mapping._2())._2$mcI$sp())), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulMatrix())));
            tempDist.elem = 0.0;
            newPoints.foreach((Function1 & Serializable)mapping -> {
                LocalKMeans$.$anonfun$main$7(tempDist, kPoints, mapping);
                return BoxedUnit.UNIT;
            });
            newPoints.foreach((Function1 & Serializable)newP -> kPoints.put((Object)BoxesRunTime.boxToInteger((int)newP._1$mcI$sp()), newP._2()));
        }
        Predef$.MODULE$.println((Object)("Final centers: " + kPoints));
    }

    private final DenseVector generatePoint$1(int i) {
        return DenseVector$.MODULE$.fill$mDc$sp(this.D(), (Function0)(JFunction0.mcD.sp & Serializable)() -> MODULE$.rand().nextDouble() * (double)MODULE$.R(), (ClassTag)ClassTag$.MODULE$.Double());
    }

    public static final /* synthetic */ void $anonfun$main$7(DoubleRef tempDist$1, HashMap kPoints$1, Tuple2 mapping) {
        tempDist$1.elem += BoxesRunTime.unboxToDouble((Object)squaredDistance$.MODULE$.apply(kPoints$1.apply((Object)BoxesRunTime.boxToInteger((int)mapping._1$mcI$sp())), mapping._2(), squaredDistance$.MODULE$.squaredDistanceFromZippedValues((UFunc.UImpl2)HasOps$.MODULE$.zipValuesImpl_V_V_Double())));
    }

    private LocalKMeans$() {
    }
}

