/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantilescommon.FloatsSortedView;
import org.apache.datasketches.quantilescommon.FloatsSortedViewIterator;
import org.apache.datasketches.quantilescommon.IncludeMinMax;
import org.apache.datasketches.quantilescommon.InequalitySearch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesFloatsAPI;
import org.apache.datasketches.quantilescommon.QuantilesUtil;

public class FloatsSketchSortedView
implements FloatsSortedView {
    private final float[] quantiles;
    private final long[] cumWeights;
    private final long totalN;

    public FloatsSketchSortedView(float[] quantiles, long[] cumWeights, QuantilesFloatsAPI sk) {
        IncludeMinMax.FloatsPair fPair = IncludeMinMax.includeFloatsMinMax(quantiles, cumWeights, sk.getMaxItem(), sk.getMinItem());
        this.quantiles = fPair.quantiles;
        this.cumWeights = fPair.cumWeights;
        this.totalN = sk.getN();
    }

    FloatsSketchSortedView(float[] quantiles, long[] cumWeights, long totalN, float maxItem, float minItem) {
        IncludeMinMax.FloatsPair fPair = IncludeMinMax.includeFloatsMinMax(quantiles, cumWeights, maxItem, minItem);
        this.quantiles = fPair.quantiles;
        this.cumWeights = fPair.cumWeights;
        this.totalN = totalN;
    }

    @Override
    public long[] getCumulativeWeights() {
        return (long[])this.cumWeights.clone();
    }

    @Override
    public float getMaxItem() {
        int top = this.quantiles.length - 1;
        return this.quantiles[top];
    }

    @Override
    public float getMinItem() {
        return this.quantiles[0];
    }

    @Override
    public long getN() {
        return this.totalN;
    }

    @Override
    public int getNumRetained() {
        return this.quantiles.length;
    }

    @Override
    public float getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        QuantilesUtil.checkNormalizedRankBounds(rank);
        int len = this.cumWeights.length;
        double naturalRank = QuantilesUtil.getNaturalRank(rank, this.totalN, searchCrit);
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.GE : InequalitySearch.GT;
        int index = InequalitySearch.find(this.cumWeights, 0, len - 1, naturalRank, crit);
        if (index == -1) {
            return this.quantiles[len - 1];
        }
        return this.quantiles[index];
    }

    @Override
    public float[] getQuantiles() {
        return (float[])this.quantiles.clone();
    }

    @Override
    public double getRank(float quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        int len = this.quantiles.length;
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.LE : InequalitySearch.LT;
        int index = InequalitySearch.find(this.quantiles, 0, len - 1, quantile, crit);
        if (index == -1) {
            return 0.0;
        }
        return (double)this.cumWeights[index] / (double)this.totalN;
    }

    @Override
    public boolean isEmpty() {
        return this.totalN == 0L;
    }

    @Override
    public FloatsSortedViewIterator iterator() {
        return new FloatsSortedViewIterator(this.quantiles, this.cumWeights);
    }
}

