/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;

final class HeapDoublesSketchAccessor
extends DoublesSketchAccessor {
    HeapDoublesSketchAccessor(DoublesSketch ds, boolean forceSize, int level) {
        super(ds, forceSize, level);
        assert (!ds.hasMemory());
    }

    @Override
    DoublesSketchAccessor copyAndSetLevel(int level) {
        return new HeapDoublesSketchAccessor(this.ds_, this.forceSize_, level);
    }

    @Override
    double get(int index) {
        assert (index >= 0 && index < this.numItems_);
        assert (this.n_ == this.ds_.getN());
        return this.ds_.getCombinedBuffer()[this.offset_ + index];
    }

    @Override
    double set(int index, double quantile) {
        assert (index >= 0 && index < this.numItems_);
        assert (this.n_ == this.ds_.getN());
        int idxOffset = this.offset_ + index;
        double oldVal = this.ds_.getCombinedBuffer()[idxOffset];
        this.ds_.getCombinedBuffer()[idxOffset] = quantile;
        return oldVal;
    }

    @Override
    double[] getArray(int fromIdx, int numItems) {
        int stIdx = this.offset_ + fromIdx;
        return Arrays.copyOfRange(this.ds_.getCombinedBuffer(), stIdx, stIdx + numItems);
    }

    @Override
    void putArray(double[] srcArray, int srcIndex, int dstIndex, int numItems) {
        int tgtIdx = this.offset_ + dstIndex;
        System.arraycopy(srcArray, srcIndex, this.ds_.getCombinedBuffer(), tgtIdx, numItems);
    }

    @Override
    void sort() {
        assert (this.currLvl_ == -1);
        if (!this.ds_.isCompact()) {
            Arrays.sort(this.ds_.getCombinedBuffer(), this.offset_, this.offset_ + this.numItems_);
        }
    }
}

