/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.BBNonNativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.BBNonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.BBWritableMemoryImpl;
import org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.internal.NativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.Util;

final class BBWritableBufferImpl
extends NativeWritableBufferImpl {
    private final ByteBuffer byteBuf;
    private final Object unsafeObj;
    private final long nativeBaseOffset;

    BBWritableBufferImpl(Object unsafeObj, long nativeBaseOffset, long offsetBytes, long capacityBytes, int typeId, long cumOffsetBytes, MemoryRequestServer memReqSvr, ByteBuffer byteBuf) {
        super(capacityBytes);
        this.unsafeObj = unsafeObj;
        this.nativeBaseOffset = nativeBaseOffset;
        this.offsetBytes = offsetBytes;
        this.capacityBytes = capacityBytes;
        this.typeId = BBWritableBufferImpl.removeNnBuf(typeId) | 0x80 | 0x40 | 0;
        this.cumOffsetBytes = cumOffsetBytes;
        this.memReqSvr = memReqSvr;
        this.byteBuf = byteBuf;
        if (this.owner != null && this.owner != Thread.currentThread()) {
            throw new IllegalStateException("Attempted access outside owning thread");
        }
        this.owner = Thread.currentThread();
    }

    @Override
    BaseWritableBufferImpl toWritableRegion(long regionOffsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        long newOffsetBytes = this.offsetBytes + regionOffsetBytes;
        long newCumOffsetBytes = this.cumOffsetBytes + regionOffsetBytes;
        int typeIdOut = BBWritableBufferImpl.removeNnBuf(this.typeId) | 0x40 | 2 | (readOnly ? 1 : 0);
        if (Util.isNativeByteOrder(byteOrder)) {
            return new BBWritableBufferImpl(this.unsafeObj, this.nativeBaseOffset, newOffsetBytes, capacityBytes, typeIdOut |= 0, newCumOffsetBytes, this.memReqSvr, this.byteBuf);
        }
        return new BBNonNativeWritableBufferImpl(this.unsafeObj, this.nativeBaseOffset, newOffsetBytes, capacityBytes, typeIdOut |= 0x20, newCumOffsetBytes, this.memReqSvr, this.byteBuf);
    }

    @Override
    BaseWritableMemoryImpl toWritableMemory(boolean readOnly, ByteOrder byteOrder) {
        int typeIdOut = BBWritableBufferImpl.removeNnBuf(this.typeId) | 0 | (readOnly ? 1 : 0);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return new BBWritableMemoryImpl(this.unsafeObj, this.nativeBaseOffset, this.offsetBytes, this.capacityBytes, typeIdOut |= 0, this.cumOffsetBytes, this.memReqSvr, this.byteBuf);
        }
        return new BBNonNativeWritableMemoryImpl(this.unsafeObj, this.nativeBaseOffset, this.offsetBytes, this.capacityBytes, typeIdOut |= 0x20, this.cumOffsetBytes, this.memReqSvr, this.byteBuf);
    }

    @Override
    BaseWritableBufferImpl toDuplicate(boolean readOnly, ByteOrder byteOrder) {
        int typeIdOut = BBWritableBufferImpl.removeNnBuf(this.typeId) | 0x40 | 4 | (readOnly ? 1 : 0);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return new BBWritableBufferImpl(this.unsafeObj, this.nativeBaseOffset, this.offsetBytes, this.capacityBytes, typeIdOut |= 0, this.cumOffsetBytes, this.memReqSvr, this.byteBuf);
        }
        return new BBNonNativeWritableBufferImpl(this.unsafeObj, this.nativeBaseOffset, this.offsetBytes, this.capacityBytes, typeIdOut |= 0x20, this.cumOffsetBytes, this.memReqSvr, this.byteBuf);
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuf;
    }

    @Override
    Object getUnsafeObject() {
        return this.unsafeObj;
    }
}

