/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.analysis.AnalysisContext$;
import org.apache.spark.sql.catalyst.analysis.FieldName;
import org.apache.spark.sql.catalyst.analysis.FieldPosition;
import org.apache.spark.sql.catalyst.analysis.ResolvedPersistentView;
import org.apache.spark.sql.catalyst.analysis.ResolvedTable;
import org.apache.spark.sql.catalyst.analysis.ResolvedTempView;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.logical.AddColumns;
import org.apache.spark.sql.catalyst.plans.logical.AlterColumnSpec;
import org.apache.spark.sql.catalyst.plans.logical.AlterColumns;
import org.apache.spark.sql.catalyst.plans.logical.AlterViewAs;
import org.apache.spark.sql.catalyst.plans.logical.ColumnDefinition;
import org.apache.spark.sql.catalyst.plans.logical.CreateTable;
import org.apache.spark.sql.catalyst.plans.logical.CreateTempView;
import org.apache.spark.sql.catalyst.plans.logical.CreateView;
import org.apache.spark.sql.catalyst.plans.logical.DefaultValueExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.QualifiedColType;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceColumns;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTable;
import org.apache.spark.sql.catalyst.plans.logical.V2CreateTablePlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.CurrentOrigin$;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.IdentityColumnSpec;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.VarcharType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class ApplyDefaultCollationToStringType$
extends Rule<LogicalPlan> {
    public static final ApplyDefaultCollationToStringType$ MODULE$ = new ApplyDefaultCollationToStringType$();

    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        LogicalPlan preprocessedPlan = this.pruneRedundantAlterColumnTypes(plan2);
        Option<String> option = this.fetchDefaultCollation(plan2);
        if (option instanceof Some) {
            Some some = (Some)option;
            String collation = (String)some.value();
            return this.transform(preprocessedPlan, StringType$.MODULE$.apply(collation));
        }
        if (None$.MODULE$.equals(option)) {
            return preprocessedPlan;
        }
        throw new MatchError(option);
    }

    private Option<String> fetchDefaultCollation(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof CreateTable) {
            CreateTable createTable = (CreateTable)logicalPlan;
            return createTable.tableSpec().collation();
        }
        if (logicalPlan instanceof CreateView) {
            CreateView createView = (CreateView)logicalPlan;
            return createView.collation();
        }
        if (logicalPlan instanceof CreateTempView) {
            LogicalPlan logicalPlan2 = logicalPlan;
            return ((CreateTempView)((Object)logicalPlan2)).collation();
        }
        if (logicalPlan instanceof ReplaceTable) {
            ReplaceTable replaceTable = (ReplaceTable)logicalPlan;
            return replaceTable.tableSpec().collation();
        }
        if (logicalPlan instanceof AddColumns) {
            AddColumns addColumns = (AddColumns)logicalPlan;
            return this.getCollationFromTableProps(addColumns.table());
        }
        if (logicalPlan instanceof ReplaceColumns) {
            ReplaceColumns replaceColumns = (ReplaceColumns)logicalPlan;
            return this.getCollationFromTableProps(replaceColumns.table());
        }
        if (logicalPlan instanceof AlterColumns) {
            AlterColumns alterColumns = (AlterColumns)logicalPlan;
            return this.getCollationFromTableProps(alterColumns.table());
        }
        if (logicalPlan instanceof AlterViewAs) {
            AlterViewAs alterViewAs = (AlterViewAs)logicalPlan;
            LogicalPlan logicalPlan3 = alterViewAs.child();
            if (logicalPlan3 instanceof ResolvedPersistentView) {
                ResolvedPersistentView resolvedPersistentView = (ResolvedPersistentView)logicalPlan3;
                return resolvedPersistentView.metadata().collation();
            }
            if (logicalPlan3 instanceof ResolvedTempView) {
                ResolvedTempView resolvedTempView = (ResolvedTempView)logicalPlan3;
                return resolvedTempView.metadata().collation();
            }
            return None$.MODULE$;
        }
        if (AnalysisContext$.MODULE$.get().collation().isDefined()) {
            return AnalysisContext$.MODULE$.get().collation();
        }
        return None$.MODULE$;
    }

    private Option<String> getCollationFromTableProps(LogicalPlan t) {
        ResolvedTable resolvedTable;
        LogicalPlan logicalPlan = t;
        if (logicalPlan instanceof ResolvedTable && (resolvedTable = (ResolvedTable)logicalPlan).table().properties().containsKey("collation")) {
            return new Some((Object)resolvedTable.table().properties().get("collation"));
        }
        return None$.MODULE$;
    }

    public boolean org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$isCreateOrAlterPlan(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        return logicalPlan instanceof V2CreateTablePlan ? true : (logicalPlan instanceof ReplaceTable ? true : (logicalPlan instanceof CreateView ? true : (logicalPlan instanceof AlterViewAs ? true : logicalPlan instanceof CreateTempView)));
    }

    private LogicalPlan transform(LogicalPlan plan2, StringType newType) {
        return plan2.resolveOperators((PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(newType){
            private static final long serialVersionUID = 0L;
            private final StringType newType$1;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ReplaceColumns replaceColumns;
                AddColumns addColumns;
                A1 A1 = x1;
                if (ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$isCreateOrAlterPlan(A1) || AnalysisContext$.MODULE$.get().collation().isDefined()) {
                    return (B1)ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$transformPlan(A1, this.newType$1);
                }
                if (A1 instanceof AddColumns && (addColumns = (AddColumns)A1).table() instanceof ResolvedTable) {
                    Seq<QualifiedColType> x$1 = ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$replaceColumnTypes(addColumns.columnsToAdd(), this.newType$1);
                    LogicalPlan x$2 = addColumns.copy$default$1();
                    return (B1)addColumns.copy(x$2, x$1);
                }
                if (A1 instanceof ReplaceColumns && (replaceColumns = (ReplaceColumns)A1).table() instanceof ResolvedTable) {
                    Seq<QualifiedColType> x$3 = ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$replaceColumnTypes(replaceColumns.columnsToAdd(), this.newType$1);
                    LogicalPlan x$4 = replaceColumns.copy$default$1();
                    return (B1)replaceColumns.copy(x$4, x$3);
                }
                if (A1 instanceof AlterColumns) {
                    ResolvedTable resolvedTable;
                    Table table;
                    AlterColumns alterColumns = (AlterColumns)A1;
                    LogicalPlan logicalPlan = alterColumns.table();
                    Seq<AlterColumnSpec> specs = alterColumns.specs();
                    if (logicalPlan instanceof ResolvedTable && (table = (resolvedTable = (ResolvedTable)logicalPlan).table()) != null) {
                        Table table2 = table;
                        if (specs != null) {
                            Seq newSpecs;
                            Seq<AlterColumnSpec> seq = specs;
                            Seq x$11 = newSpecs = (Seq)seq.map((Function1 & Serializable)x0$1 -> {
                                AlterColumnSpec alterColumnSpec = x0$1;
                                if (ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$shouldApplyDefaultCollationToAlterColumn(alterColumnSpec, table2)) {
                                    Some x$5 = new Some((Object)ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$replaceDefaultStringType((DataType)alterColumnSpec.newDataType().get(), $this.newType$1));
                                    FieldName x$6 = alterColumnSpec.copy$default$1();
                                    Option<Object> x$7 = alterColumnSpec.copy$default$3();
                                    Option<String> x$8 = alterColumnSpec.copy$default$4();
                                    Option<FieldPosition> x$9 = alterColumnSpec.copy$default$5();
                                    Option<String> x$10 = alterColumnSpec.copy$default$6();
                                    return alterColumnSpec.copy(x$6, (Option<DataType>)x$5, x$7, x$8, x$9, x$10);
                                }
                                return alterColumnSpec;
                            });
                            LogicalPlan x$12 = alterColumns.copy$default$1();
                            return (B1)alterColumns.copy(x$12, (Seq<AlterColumnSpec>)x$11);
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                ReplaceColumns replaceColumns;
                AddColumns addColumns;
                LogicalPlan logicalPlan = x1;
                if (ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$isCreateOrAlterPlan(logicalPlan) || AnalysisContext$.MODULE$.get().collation().isDefined()) {
                    return true;
                }
                if (logicalPlan instanceof AddColumns && (addColumns = (AddColumns)logicalPlan).table() instanceof ResolvedTable) {
                    return true;
                }
                if (logicalPlan instanceof ReplaceColumns && (replaceColumns = (ReplaceColumns)logicalPlan).table() instanceof ResolvedTable) {
                    return true;
                }
                if (logicalPlan instanceof AlterColumns) {
                    ResolvedTable resolvedTable;
                    Table table;
                    AlterColumns alterColumns = (AlterColumns)logicalPlan;
                    LogicalPlan logicalPlan2 = alterColumns.table();
                    Seq<AlterColumnSpec> specs = alterColumns.specs();
                    if (logicalPlan2 instanceof ResolvedTable && (table = (resolvedTable = (ResolvedTable)logicalPlan2).table()) != null && specs != null) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.newType$1 = newType$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.analysis.ApplyDefaultCollationToStringType$$anonfun$transform$1 org.apache.spark.sql.connector.catalog.Table org.apache.spark.sql.catalyst.plans.logical.AlterColumnSpec )}, serializedLambda);
            }
        });
    }

    private LogicalPlan pruneRedundantAlterColumnTypes(LogicalPlan plan2) {
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof AlterColumns) {
            ResolvedTable resolvedTable;
            Table table;
            AlterColumns alterColumns = (AlterColumns)logicalPlan;
            LogicalPlan logicalPlan2 = alterColumns.table();
            Seq<AlterColumnSpec> specs = alterColumns.specs();
            if (logicalPlan2 instanceof ResolvedTable && (table = (resolvedTable = (ResolvedTable)logicalPlan2).table()) != null) {
                Table table2 = table;
                if (specs != null) {
                    Seq<AlterColumnSpec> seq = specs;
                    Seq resolvedSpecs = (Seq)seq.map((Function1 & Serializable)spec -> {
                        if (spec.newDataType().isDefined() && MODULE$.isStringTypeColumn(spec.column(), table2) && MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$isDefaultStringType((DataType)spec.newDataType().get())) {
                            None$ x$1 = None$.MODULE$;
                            FieldName x$2 = spec.copy$default$1();
                            Option<Object> x$3 = spec.copy$default$3();
                            Option<String> x$4 = spec.copy$default$4();
                            Option<FieldPosition> x$5 = spec.copy$default$5();
                            Option<String> x$6 = spec.copy$default$6();
                            return spec.copy(x$2, (Option<DataType>)x$1, x$3, x$4, x$5, x$6);
                        }
                        return spec;
                    });
                    AlterColumns newAlterColumns = (AlterColumns)CurrentOrigin$.MODULE$.withOrigin(alterColumns.origin(), (Function0 & Serializable)() -> {
                        Seq x$7 = resolvedSpecs;
                        LogicalPlan x$8 = alterColumns.copy$default$1();
                        return alterColumns.copy(x$8, (Seq<AlterColumnSpec>)x$7);
                    });
                    newAlterColumns.copyTagsFrom(alterColumns);
                    return newAlterColumns;
                }
            }
        }
        return plan2;
    }

    public boolean org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$shouldApplyDefaultCollationToAlterColumn(AlterColumnSpec alterColumnSpec, Table table) {
        return alterColumnSpec.newDataType().isDefined() && !this.isStringTypeColumn(alterColumnSpec.column(), table) && this.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$hasDefaultStringType((DataType)alterColumnSpec.newDataType().get());
    }

    private boolean isStringTypeColumn(FieldName fieldName, Table table) {
        StructType qual$1 = CatalogV2Util$.MODULE$.v2ColumnsToStructType(table.columns());
        Seq<String> x$1 = fieldName.name();
        boolean x$2 = true;
        Function2<String, String, Object> x$3 = this.conf().resolver();
        Origin x$4 = qual$1.findNestedField$default$4();
        return BoxesRunTime.unboxToBoolean((Object)qual$1.findNestedField(x$1, true, x$3, x$4).map((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ApplyDefaultCollationToStringType$.$anonfun$isStringTypeColumn$1(x0$1))).getOrElse((Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.unresolvedColumnError(DataTypeErrors$.MODULE$.toSQLId(fieldName.name()), (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.columns()), (Function1 & Serializable)x$1 -> x$1.name(), ClassTag$.MODULE$.apply(String.class)));
        }));
    }

    public LogicalPlan org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$transformPlan(LogicalPlan plan2, StringType newType) {
        LogicalPlan transformedPlan = plan2.resolveExpressionsUp((PartialFunction<Expression, Expression>)new Serializable(newType){
            private static final long serialVersionUID = 0L;
            private final StringType newType$2;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 expression, Function1<A1, B1> function1) {
                A1 A1 = expression;
                return (B1)ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$transformExpression().andThen((Function1 & Serializable)x$2 -> (Expression)x$2.apply((Object)$this.newType$2)).applyOrElse(expression, (Function1 & Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
            }

            public final boolean isDefinedAt(Expression expression) {
                Expression expression2 = expression;
                return true;
            }
            {
                this.newType$2 = newType$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.analysis.ApplyDefaultCollationToStringType$$anonfun$1 scala.Function1 ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        });
        return this.castDefaultStringExpressions(transformedPlan, newType);
    }

    public PartialFunction<Expression, Function1<StringType, Expression>> org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$transformExpression() {
        return new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Cast cast;
                ColumnDefinition columnDefinition;
                A1 A1 = x1;
                if (A1 instanceof ColumnDefinition && ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$hasDefaultStringType((columnDefinition = (ColumnDefinition)A1).dataType())) {
                    return (B1)(Function1 & Serializable)newType -> {
                        DataType x$1 = ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$replaceDefaultStringType(columnDefinition.dataType(), (StringType)newType);
                        String x$2 = columnDefinition.copy$default$1();
                        boolean x$3 = columnDefinition.copy$default$3();
                        Option<String> x$4 = columnDefinition.copy$default$4();
                        Option<DefaultValueExpression> x$5 = columnDefinition.copy$default$5();
                        Option<String> x$6 = columnDefinition.copy$default$6();
                        Option<IdentityColumnSpec> x$7 = columnDefinition.copy$default$7();
                        Metadata x$8 = columnDefinition.copy$default$8();
                        return columnDefinition.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8);
                    };
                }
                if (A1 instanceof Cast && ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$hasDefaultStringType((cast = (Cast)A1).dataType()) && cast.getTagValue(Cast$.MODULE$.USER_SPECIFIED_CAST()).isDefined()) {
                    return (B1)(Function1 & Serializable)newType -> {
                        DataType x$9 = ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$replaceDefaultStringType(cast.dataType(), (StringType)newType);
                        Expression x$10 = cast.copy$default$1();
                        Option<String> x$11 = cast.copy$default$3();
                        Enumeration.Value x$12 = cast.copy$default$4();
                        return cast.copy(x$10, x$9, x$11, x$12);
                    };
                }
                if (A1 instanceof Literal) {
                    Literal literal = (Literal)A1;
                    Object value = literal.value();
                    DataType dt = literal.dataType();
                    if (ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$hasDefaultStringType(dt)) {
                        return (B1)(Function1 & Serializable)newType -> new Literal(value, ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$replaceDefaultStringType(dt, (StringType)newType));
                    }
                }
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    LogicalPlan plan2 = (LogicalPlan)subqueryExpression.plan();
                    return (B1)(Function1 & Serializable)newType -> {
                        LogicalPlan newPlan = plan2.resolveExpressionsUp((PartialFunction<Expression, Expression>)new Serializable(null, (StringType)newType){
                            private static final long serialVersionUID = 0L;
                            private final StringType newType$3;

                            public final <A1 extends Expression, B1> B1 applyOrElse(A1 expression, Function1<A1, B1> function1) {
                                A1 A1 = expression;
                                return (B1)ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$transformExpression().andThen((Function1 & Serializable)x$3 -> (Expression)x$3.apply((Object)$this.newType$3)).applyOrElse(expression, (Function1 & Serializable)x -> (Expression)Predef$.MODULE$.identity(x));
                            }

                            public final boolean isDefinedAt(Expression expression) {
                                Expression expression2 = expression;
                                return true;
                            }
                            {
                                this.newType$3 = newType$3;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$8(org.apache.spark.sql.catalyst.analysis.ApplyDefaultCollationToStringType$$anonfun$org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$transformExpression$1$$anonfun$2 scala.Function1 ), $anonfun$applyOrElse$9(org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
                            }
                        });
                        return subqueryExpression.withNewPlan(newPlan);
                    };
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Literal literal;
                DataType dt;
                Cast cast;
                ColumnDefinition columnDefinition;
                Expression expression = x1;
                if (expression instanceof ColumnDefinition && ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$hasDefaultStringType((columnDefinition = (ColumnDefinition)expression).dataType())) {
                    return true;
                }
                if (expression instanceof Cast && ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$hasDefaultStringType((cast = (Cast)expression).dataType()) && cast.getTagValue(Cast$.MODULE$.USER_SPECIFIED_CAST()).isDefined()) {
                    return true;
                }
                if (expression instanceof Literal && ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$hasDefaultStringType(dt = (literal = (Literal)expression).dataType())) {
                    return true;
                }
                return expression instanceof SubqueryExpression;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$4(org.apache.spark.sql.catalyst.plans.logical.ColumnDefinition org.apache.spark.sql.types.StringType ), $anonfun$applyOrElse$5(org.apache.spark.sql.catalyst.expressions.Cast org.apache.spark.sql.types.StringType ), $anonfun$applyOrElse$6(java.lang.Object org.apache.spark.sql.types.DataType org.apache.spark.sql.types.StringType ), $anonfun$applyOrElse$7(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.catalyst.expressions.SubqueryExpression org.apache.spark.sql.types.StringType )}, serializedLambda);
            }
        };
    }

    private LogicalPlan castDefaultStringExpressions(LogicalPlan plan2, StringType newType) {
        StringType stringType = newType;
        StringType$ stringType$ = StringType$.MODULE$;
        if (!(stringType != null ? !stringType.equals(stringType$) : stringType$ != null)) {
            return plan2;
        }
        return plan2.resolveOperators((PartialFunction<LogicalPlan, LogicalPlan>)new Serializable(newType){
            private static final long serialVersionUID = 0L;
            private final StringType newType$4;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 operator, Function1<A1, B1> function1) {
                A1 A1 = operator;
                return (B1)operator.mapExpressions((Function1<Expression, Expression>)(Function1 & Serializable)ex -> ApplyDefaultCollationToStringType$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$inner$1(ex, $this.newType$4));
            }

            public final boolean isDefinedAt(LogicalPlan operator) {
                LogicalPlan logicalPlan = operator;
                return true;
            }
            {
                this.newType$4 = newType$4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$10(org.apache.spark.sql.catalyst.analysis.ApplyDefaultCollationToStringType$$anonfun$castDefaultStringExpressions$4 org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        });
    }

    public boolean org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$hasDefaultStringType(DataType dataType2) {
        return dataType2.existsRecursively((Function1 & Serializable)dataType -> BoxesRunTime.boxToBoolean((boolean)ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$isDefaultStringType(dataType)));
    }

    public boolean org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$isDefaultStringType(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof StringType) {
            StringType stringType = (StringType)dataType2;
            return stringType == StringType$.MODULE$;
        }
        return false;
    }

    public DataType org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$replaceDefaultStringType(DataType dataType, StringType newType) {
        return dataType.transformRecursively((PartialFunction)new Serializable(newType){
            private static final long serialVersionUID = 0L;
            private final StringType newType$5;

            public final <A1 extends DataType, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                StringType stringType;
                A1 A1 = x1;
                if (A1 instanceof StringType && ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$isDefaultStringType((DataType)(stringType = (StringType)A1))) {
                    return (B1)this.newType$5;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(DataType x1) {
                StringType stringType;
                DataType dataType = x1;
                return dataType instanceof StringType && ApplyDefaultCollationToStringType$.MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$isDefaultStringType((DataType)(stringType = (StringType)dataType));
            }
            {
                this.newType$5 = newType$5;
            }
        });
    }

    public Seq<QualifiedColType> org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$replaceColumnTypes(Seq<QualifiedColType> colTypes, StringType newType) {
        return (Seq)colTypes.map((Function1 & Serializable)x0$1 -> {
            QualifiedColType qualifiedColType = x0$1;
            if (MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$hasDefaultStringType(qualifiedColType.dataType())) {
                DataType replaced;
                DataType x$1 = replaced = MODULE$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$replaceDefaultStringType(qualifiedColType.dataType(), newType);
                Option<FieldName> x$2 = qualifiedColType.copy$default$1();
                String x$3 = qualifiedColType.copy$default$2();
                boolean x$4 = qualifiedColType.copy$default$4();
                Option<String> x$5 = qualifiedColType.copy$default$5();
                Option<FieldPosition> x$6 = qualifiedColType.copy$default$6();
                Option<String> x$7 = qualifiedColType.copy$default$7();
                return qualifiedColType.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7);
            }
            return qualifiedColType;
        });
    }

    public static final /* synthetic */ boolean $anonfun$isStringTypeColumn$1(Tuple2 x0$1) {
        StructField structField;
        StructField structField2;
        StructField structField3;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null && (structField3 = (StructField)tuple2._2()) != null && structField3.dataType() instanceof CharType) {
            return false;
        }
        if (tuple2 != null && (structField2 = (StructField)tuple2._2()) != null && structField2.dataType() instanceof VarcharType) {
            return false;
        }
        if (tuple2 != null && (structField = (StructField)tuple2._2()) != null) {
            Metadata metadata = structField.metadata();
            if (structField.dataType() instanceof StringType && !metadata.contains(CharVarcharUtils$.MODULE$.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY())) {
                return true;
            }
        }
        if (tuple2 != null) {
            return false;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final Expression org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$inner$1(Expression ex2, StringType newType$4) {
        Expression expression = ex2;
        if (expression instanceof Cast) {
            Cast cast = (Cast)expression;
            Expression e = cast.child();
            DataType dt = cast.dataType();
            if (e instanceof DefaultStringProducingExpression) {
                DefaultStringProducingExpression defaultStringProducingExpression = (DefaultStringProducingExpression)((Object)e);
                StringType stringType = newType$4;
                DataType dataType = dt;
                if (!(stringType != null ? !stringType.equals(dataType) : dataType != null)) {
                    return cast.copy((Expression)((TreeNode)((Object)defaultStringProducingExpression)).withNewChildren((Seq)((TreeNode)((Object)defaultStringProducingExpression)).children().map((Function1 & Serializable)ex -> ApplyDefaultCollationToStringType$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$inner$1(ex, newType$4))), cast.copy$default$2(), cast.copy$default$3(), cast.copy$default$4());
                }
            }
        }
        if (expression instanceof DefaultStringProducingExpression) {
            DefaultStringProducingExpression defaultStringProducingExpression = (DefaultStringProducingExpression)((Object)expression);
            return new Cast((Expression)((TreeNode)((Object)defaultStringProducingExpression)).withNewChildren((Seq)((TreeNode)((Object)defaultStringProducingExpression)).children().map((Function1 & Serializable)ex -> ApplyDefaultCollationToStringType$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$inner$1(ex, newType$4))), (DataType)newType$4, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
        }
        return (Expression)expression.withNewChildren((Seq)expression.children().map((Function1 & Serializable)ex -> ApplyDefaultCollationToStringType$.org$apache$spark$sql$catalyst$analysis$ApplyDefaultCollationToStringType$$inner$1(ex, newType$4)));
    }

    private ApplyDefaultCollationToStringType$() {
    }
}

