/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Base64;
import org.apache.spark.SparkIllegalArgumentException;
import org.apache.spark.annotation.Stable;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.catalyst.util.UDTUtils$;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.internal.SqlApiConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.util.ArrayImplicits$;
import org.json4s.JArray;
import org.json4s.JBool$;
import org.json4s.JDecimal;
import org.json4s.JDouble;
import org.json4s.JLong;
import org.json4s.JNull$;
import org.json4s.JObject;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

@Stable
@ScalaSignature(bytes="\u0006\u0005\r}r!\u0002\u001c8\u0011\u0003\u0001e!\u0002\"8\u0011\u0003\u0019\u0005\"\u0002*\u0002\t\u0003\u0019\u0006\"\u0002+\u0002\t\u0003)\u0006bBA\u0002\u0003\u0011\u0005!q\u001d\u0005\b\u0005g\fA\u0011\u0001B{\u0011\u001d\u0011I0\u0001C\u0001\u0005wDqaa\u0002\u0002\t\u0003\u0019I\u0001C\u0005\u0004&\u0005\u0011\r\u0011\"\u0001\u0004(!91\u0011F\u0001!\u0002\u0013Q\u0007\"CB\u0016\u0003\u0005\u0005I\u0011BB\u0017\r\u001d\u0011u\u0007%A\u0002\u0002-DQA\\\u0006\u0005\u0002=DQa]\u0006\u0005\u0002QDQ\u0001_\u0006\u0007\u0002QDQ!_\u0006\u0005\u0002iDq!a\u0001\f\t\u0003\t)\u0001C\u0004\u0002\f-1\t!!\u0004\t\u000f\u0005E1\u0002\"\u0001\u0002\u0014!9\u0011QD\u0006\u0005\u0002\u0005}\u0001bBA\u0012\u0017\u0011\u0005\u0011Q\u0005\u0005\b\u0003_YA\u0011AA\u0019\u0011\u001d\tYd\u0003C\u0001\u0003{Aq!!\u0011\f\t\u0003\t\u0019\u0005C\u0004\u0002N-!\t!a\u0014\t\u000f\u0005e3\u0002\"\u0001\u0002\\!9\u0011QM\u0006\u0005\u0002\u0005\u001d\u0004bBA>\u0017\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u001b[A\u0011AAH\u0011\u001d\tij\u0003C\u0001\u0003?Cq!a,\f\t\u0003\t\t\fC\u0004\u0002<.!\t!!0\t\u000f\u0005\u001d7\u0002\"\u0001\u0002J\"9\u0011\u0011]\u0006\u0005\u0002\u0005\r\bbBA}\u0017\u0011\u0005\u00111 \u0005\b\u00053YA\u0011\u0001B\u000e\u0011\u001d\u0011ic\u0003C\u0001\u0005_AqAa\r\f\t\u0003\u0011)\u0004C\u0004\u00034-!\tAa\u0010\t\u000f\t-3\u0002\"\u0001\u0003N!9!1K\u0006\u0005\u0002\tU\u0003b\u0002B4\u0017\u0011\u0005#\u0011\u000e\u0005\b\u0005WZa\u0011\u0001B7\u0011\u001d\u0011yg\u0003C\u0001\u0005cBqAa\u001d\f\t\u0003\u0012)\bC\u0004\u0003|-!\tE! \t\u000f\t}4\u0002\"\u0001\u0003\u0002\"9!1Q\u0006\u0005\u0002\t\u0015\u0005b\u0002BB\u0017\u0011\u0005!q\u0011\u0005\b\u0005\u0007[A\u0011\u0001BG\u0011\u001d\u0011Ij\u0003C\u0005\u00057CqA!,\f\t\u0003\u0011)\tC\u0004\u0003>.!\tA!\"\t\u0011\t\u00057\u0002\"\u00018\u0005\u0007\f1AU8x\u0015\tA\u0014(A\u0002tc2T!AO\u001e\u0002\u000bM\u0004\u0018M]6\u000b\u0005qj\u0014AB1qC\u000eDWMC\u0001?\u0003\ry'oZ\u0002\u0001!\t\t\u0015!D\u00018\u0005\r\u0011vn^\n\u0004\u0003\u0011S\u0005CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%AB!osJ+g\r\u0005\u0002L!6\tAJ\u0003\u0002N\u001d\u0006\u0011\u0011n\u001c\u0006\u0002\u001f\u0006!!.\u0019<b\u0013\t\tFJ\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0001\u0006QQO\\1qa2L8+Z9\u0015\u0005YC\u0007cA#X3&\u0011\u0001L\u0012\u0002\u0005'>lW\rE\u0002[E\u0016t!a\u00171\u000f\u0005q{V\"A/\u000b\u0005y{\u0014A\u0002\u001fs_>$h(C\u0001H\u0013\t\tg)A\u0004qC\u000e\\\u0017mZ3\n\u0005\r$'aA*fc*\u0011\u0011M\u0012\t\u0003\u000b\u001aL!a\u001a$\u0003\u0007\u0005s\u0017\u0010C\u0003j\u0007\u0001\u0007!.A\u0002s_^\u0004\"!Q\u0006\u0014\u0007-!E\u000e\u0005\u0002[[&\u0011\u0011\u000bZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003A\u0004\"!R9\n\u0005I4%\u0001B+oSR\fAa]5{KV\tQ\u000f\u0005\u0002Fm&\u0011qO\u0012\u0002\u0004\u0013:$\u0018A\u00027f]\u001e$\b.\u0001\u0004tG\",W.Y\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011apN\u0001\u0006if\u0004Xm]\u0005\u0004\u0003\u0003i(AC*ueV\u001cG\u000fV=qK\u0006)\u0011\r\u001d9msR\u0019Q-a\u0002\t\r\u0005%\u0001\u00031\u0001v\u0003\u0005I\u0017aA4fiR\u0019Q-a\u0004\t\r\u0005%\u0011\u00031\u0001v\u0003!I7OT;mY\u0006#H\u0003BA\u000b\u00037\u00012!RA\f\u0013\r\tIB\u0012\u0002\b\u0005>|G.Z1o\u0011\u0019\tIA\u0005a\u0001k\u0006Qq-\u001a;C_>dW-\u00198\u0015\t\u0005U\u0011\u0011\u0005\u0005\u0007\u0003\u0013\u0019\u0002\u0019A;\u0002\u000f\u001d,GOQ=uKR!\u0011qEA\u0017!\r)\u0015\u0011F\u0005\u0004\u0003W1%\u0001\u0002\"zi\u0016Da!!\u0003\u0015\u0001\u0004)\u0018\u0001C4fiNCwN\u001d;\u0015\t\u0005M\u0012\u0011\b\t\u0004\u000b\u0006U\u0012bAA\u001c\r\n)1\u000b[8si\"1\u0011\u0011B\u000bA\u0002U\faaZ3u\u0013:$HcA;\u0002@!1\u0011\u0011\u0002\fA\u0002U\fqaZ3u\u0019>tw\r\u0006\u0003\u0002F\u0005-\u0003cA#\u0002H%\u0019\u0011\u0011\n$\u0003\t1{gn\u001a\u0005\u0007\u0003\u00139\u0002\u0019A;\u0002\u0011\u001d,GO\u00127pCR$B!!\u0015\u0002XA\u0019Q)a\u0015\n\u0007\u0005UcIA\u0003GY>\fG\u000f\u0003\u0004\u0002\na\u0001\r!^\u0001\nO\u0016$Hi\\;cY\u0016$B!!\u0018\u0002dA\u0019Q)a\u0018\n\u0007\u0005\u0005dI\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u0003\u0013I\u0002\u0019A;\u0002\u0013\u001d,Go\u0015;sS:<G\u0003BA5\u0003s\u0002B!a\u001b\u0002t9!\u0011QNA8!\taf)C\u0002\u0002r\u0019\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA;\u0003o\u0012aa\u0015;sS:<'bAA9\r\"1\u0011\u0011\u0002\u000eA\u0002U\f!bZ3u\t\u0016\u001c\u0017.\\1m)\u0011\ty(a#\u0011\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007S1!!\"O\u0003\u0011i\u0017\r\u001e5\n\t\u0005%\u00151\u0011\u0002\u000b\u0005&<G)Z2j[\u0006d\u0007BBA\u00057\u0001\u0007Q/A\u0004hKR$\u0015\r^3\u0015\t\u0005E\u00151\u0014\t\u0005\u0003'\u000b9*\u0004\u0002\u0002\u0016*\u0011\u0001HT\u0005\u0005\u00033\u000b)J\u0001\u0003ECR,\u0007BBA\u00059\u0001\u0007Q/\u0001\u0007hKRdunY1m\t\u0006$X\r\u0006\u0003\u0002\"\u00065\u0006\u0003BAR\u0003Sk!!!*\u000b\u0007\u0005\u001df*\u0001\u0003uS6,\u0017\u0002BAV\u0003K\u0013\u0011\u0002T8dC2$\u0015\r^3\t\r\u0005%Q\u00041\u0001v\u000319W\r\u001e+j[\u0016\u001cH/Y7q)\u0011\t\u0019,!/\u0011\t\u0005M\u0015QW\u0005\u0005\u0003o\u000b)JA\u0005US6,7\u000f^1na\"1\u0011\u0011\u0002\u0010A\u0002U\f!bZ3u\u0013:\u001cH/\u00198u)\u0011\ty,!2\u0011\t\u0005\r\u0016\u0011Y\u0005\u0005\u0003\u0007\f)KA\u0004J]N$\u0018M\u001c;\t\r\u0005%q\u00041\u0001v\u0003\u00199W\r^*fcV!\u00111ZAj)\u0011\ti-a8\u0011\ti\u0013\u0017q\u001a\t\u0005\u0003#\f\u0019\u000e\u0004\u0001\u0005\u000f\u0005U\u0007E1\u0001\u0002X\n\tA+E\u0002\u0002Z\u0016\u00042!RAn\u0013\r\tiN\u0012\u0002\b\u001d>$\b.\u001b8h\u0011\u0019\tI\u0001\ta\u0001k\u00069q-\u001a;MSN$X\u0003BAs\u0003k$B!a:\u0002xB1\u0011\u0011^Ax\u0003gl!!a;\u000b\u0007\u00055h*\u0001\u0003vi&d\u0017\u0002BAy\u0003W\u0014A\u0001T5tiB!\u0011\u0011[A{\t\u001d\t).\tb\u0001\u0003/Da!!\u0003\"\u0001\u0004)\u0018AB4fi6\u000b\u0007/\u0006\u0004\u0002~\n5!1\u0003\u000b\u0005\u0003\u007f\u00149\u0002\u0005\u0005\u0003\u0002\t\u001d!1\u0002B\t\u001b\t\u0011\u0019AC\u0002\u0003\u0006\u0019\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011IAa\u0001\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002R\n5Aa\u0002B\bE\t\u0007\u0011q\u001b\u0002\u0002\u0017B!\u0011\u0011\u001bB\n\t\u001d\u0011)B\tb\u0001\u0003/\u0014\u0011A\u0016\u0005\u0007\u0003\u0013\u0011\u0003\u0019A;\u0002\u0015\u001d,GOS1wC6\u000b\u0007/\u0006\u0004\u0003\u001e\t\u0015\"\u0011\u0006\u000b\u0005\u0005?\u0011Y\u0003\u0005\u0005\u0002j\n\u0005\"1\u0005B\u0014\u0013\u0011\u0011I!a;\u0011\t\u0005E'Q\u0005\u0003\b\u0005\u001f\u0019#\u0019AAl!\u0011\t\tN!\u000b\u0005\u000f\tU1E1\u0001\u0002X\"1\u0011\u0011B\u0012A\u0002U\f\u0011bZ3u'R\u0014Xo\u0019;\u0015\u0007)\u0014\t\u0004\u0003\u0004\u0002\n\u0011\u0002\r!^\u0001\u0006O\u0016$\u0018i]\u000b\u0005\u0005o\u0011Y\u0004\u0006\u0003\u0003:\tu\u0002\u0003BAi\u0005w!q!!6&\u0005\u0004\t9\u000e\u0003\u0004\u0002\n\u0015\u0002\r!^\u000b\u0005\u0005\u0003\u0012)\u0005\u0006\u0003\u0003D\t\u001d\u0003\u0003BAi\u0005\u000b\"q!!6'\u0005\u0004\t9\u000eC\u0004\u0003J\u0019\u0002\r!!\u001b\u0002\u0013\u0019LW\r\u001c3OC6,\u0017A\u00034jK2$\u0017J\u001c3fqR\u0019QOa\u0014\t\u000f\tEs\u00051\u0001\u0002j\u0005!a.Y7f\u000319W\r\u001e,bYV,7/T1q+\u0011\u00119Fa\u0018\u0015\t\te#\u0011\r\t\t\u0003W\u0012Y&!\u001b\u0003^%!!\u0011BA<!\u0011\t\tNa\u0018\u0005\u000f\u0005U\u0007F1\u0001\u0002X\"9!1\r\u0015A\u0002\t\u0015\u0014A\u00034jK2$g*Y7fgB!!LYA5\u0003!!xn\u0015;sS:<GCAA5\u0003\u0011\u0019w\u000e]=\u0015\u0003)\fq!\u00198z\u001dVdG.\u0006\u0002\u0002\u0016\u00051Q-];bYN$B!!\u0006\u0003x!1!\u0011\u0010\u0017A\u0002\u0015\f\u0011a\\\u0001\tQ\u0006\u001c\bnQ8eKR\tQ/A\u0003u_N+\u0017/F\u0001Z\u0003!i7n\u0015;sS:<WCAA5)\u0011\tIG!#\t\u000f\t-\u0005\u00071\u0001\u0002j\u0005\u00191/\u001a9\u0015\u0011\u0005%$q\u0012BJ\u0005+CqA!%2\u0001\u0004\tI'A\u0003ti\u0006\u0014H\u000fC\u0004\u0003\fF\u0002\r!!\u001b\t\u000f\t]\u0015\u00071\u0001\u0002j\u0005\u0019QM\u001c3\u0002\u0017\u001d,G/\u00118z-\u0006d\u0017i]\u000b\u0005\u0005;\u0013\t\u000b\u0006\u0003\u0003 \n-\u0006\u0003BAi\u0005C#q!!63\u0005\u0004\u0011\u0019+\u0005\u0003\u0002Z\n\u0015\u0006cA#\u0003(&\u0019!\u0011\u0016$\u0003\r\u0005s\u0017PV1m\u0011\u0019\tIA\ra\u0001k\u0006!!n]8oQ\r\u0019$\u0011\u0017\t\u0005\u0005g\u0013I,\u0004\u0002\u00036*\u0019!qW\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003<\nU&\u0001C+ogR\f'\r\\3\u0002\u0015A\u0014X\r\u001e;z\u0015N|g\u000eK\u00025\u0005c\u000b\u0011B[:p]Z\u000bG.^3\u0016\u0005\t\u0015\u0007\u0003\u0002Bd\u00053tAA!3\u0003T:!!1\u001aBh\u001d\ra&QZ\u0005\u0002}%\u0019!\u0011[\u001f\u0002\r)\u001cxN\u001c\u001bt\u0013\u0011\u0011)Na6\u0002\u000f)\u001bxN\\!T)*\u0019!\u0011[\u001f\n\t\tm'Q\u001c\u0002\u0007\u0015Z\u000bG.^3\u000b\t\tU'q\u001b\u0015\u0004\u0017\t\u0005\b\u0003\u0002BZ\u0005GLAA!:\u00036\n11\u000b^1cY\u0016$2A\u001bBu\u0011\u001d\u0011Y\u000f\u0002a\u0001\u0005[\faA^1mk\u0016\u001c\b\u0003B#\u0003p\u0016L1A!=G\u0005)a$/\u001a9fCR,GMP\u0001\bMJ|WnU3r)\rQ'q\u001f\u0005\u0007\u0005W,\u0001\u0019A-\u0002\u0013\u0019\u0014x.\u001c+va2,Gc\u00016\u0003~\"9!q \u0004A\u0002\r\u0005\u0011!\u0002;va2,\u0007cA#\u0004\u0004%\u00191Q\u0001$\u0003\u000fA\u0013x\u000eZ;di\u0006)Q.\u001a:hKR\u0019!na\u0003\t\u000f\r5q\u00011\u0001\u0004\u0010\u0005!!o\\<t!\u0011)%q\u001e6)\u0017\u001d\u0019\u0019b!\u0007\u0004\u001c\r}1\u0011\u0005\t\u0004\u000b\u000eU\u0011bAB\f\r\nQA-\u001a9sK\u000e\fG/\u001a3\u0002\u000f5,7o]1hK\u0006\u00121QD\u0001B)\"L7\u000fI7fi\"|G\rI5tA\u0011,\u0007O]3dCR,G\rI1oI\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/Z7pm\u0016$\u0007%\u001b8!MV$XO]3!m\u0016\u00148/[8og:\nQa]5oG\u0016\f#aa\t\u0002\u000bMr\u0003G\f\u0019\u0002\u000b\u0015l\u0007\u000f^=\u0016\u0003)\fa!Z7qif\u0004\u0013\u0001D<sSR,'+\u001a9mC\u000e,GCAB\u0018!\u0011\u0019\tda\u000e\u000e\u0005\rM\"bAB\u001b\u001d\u0006!A.\u00198h\u0013\u0011\u0019Ida\r\u0003\r=\u0013'.Z2uQ\r\t!\u0011\u001d\u0015\u0004\u0001\t\u0005\b")
public interface Row
extends Serializable {
    public static Row empty() {
        return Row$.MODULE$.empty();
    }

    public static Row merge(scala.collection.immutable.Seq<Row> rows) {
        return Row$.MODULE$.merge(rows);
    }

    public static Row fromTuple(Product tuple) {
        return Row$.MODULE$.fromTuple(tuple);
    }

    public static Row fromSeq(scala.collection.immutable.Seq<Object> values) {
        return Row$.MODULE$.fromSeq(values);
    }

    public static Some<scala.collection.immutable.Seq<Object>> unapplySeq(Row row) {
        return Row$.MODULE$.unapplySeq(row);
    }

    public static /* synthetic */ int size$(Row $this) {
        return $this.size();
    }

    default public int size() {
        return this.length();
    }

    public int length();

    public static /* synthetic */ StructType schema$(Row $this) {
        return $this.schema();
    }

    default public StructType schema() {
        return null;
    }

    public static /* synthetic */ Object apply$(Row $this, int i) {
        return $this.apply(i);
    }

    default public Object apply(int i) {
        return this.get(i);
    }

    public Object get(int var1);

    public static /* synthetic */ boolean isNullAt$(Row $this, int i) {
        return $this.isNullAt(i);
    }

    default public boolean isNullAt(int i) {
        return this.get(i) == null;
    }

    public static /* synthetic */ boolean getBoolean$(Row $this, int i) {
        return $this.getBoolean(i);
    }

    default public boolean getBoolean(int i) {
        return BoxesRunTime.unboxToBoolean(this.getAnyValAs(i));
    }

    public static /* synthetic */ byte getByte$(Row $this, int i) {
        return $this.getByte(i);
    }

    default public byte getByte(int i) {
        return BoxesRunTime.unboxToByte(this.getAnyValAs(i));
    }

    public static /* synthetic */ short getShort$(Row $this, int i) {
        return $this.getShort(i);
    }

    default public short getShort(int i) {
        return BoxesRunTime.unboxToShort(this.getAnyValAs(i));
    }

    public static /* synthetic */ int getInt$(Row $this, int i) {
        return $this.getInt(i);
    }

    default public int getInt(int i) {
        return BoxesRunTime.unboxToInt(this.getAnyValAs(i));
    }

    public static /* synthetic */ long getLong$(Row $this, int i) {
        return $this.getLong(i);
    }

    default public long getLong(int i) {
        return BoxesRunTime.unboxToLong(this.getAnyValAs(i));
    }

    public static /* synthetic */ float getFloat$(Row $this, int i) {
        return $this.getFloat(i);
    }

    default public float getFloat(int i) {
        return BoxesRunTime.unboxToFloat(this.getAnyValAs(i));
    }

    public static /* synthetic */ double getDouble$(Row $this, int i) {
        return $this.getDouble(i);
    }

    default public double getDouble(int i) {
        return BoxesRunTime.unboxToDouble(this.getAnyValAs(i));
    }

    public static /* synthetic */ String getString$(Row $this, int i) {
        return $this.getString(i);
    }

    default public String getString(int i) {
        return (String)this.getAs(i);
    }

    public static /* synthetic */ java.math.BigDecimal getDecimal$(Row $this, int i) {
        return $this.getDecimal(i);
    }

    default public java.math.BigDecimal getDecimal(int i) {
        return (java.math.BigDecimal)this.getAs(i);
    }

    public static /* synthetic */ Date getDate$(Row $this, int i) {
        return $this.getDate(i);
    }

    default public Date getDate(int i) {
        return (Date)this.getAs(i);
    }

    public static /* synthetic */ LocalDate getLocalDate$(Row $this, int i) {
        return $this.getLocalDate(i);
    }

    default public LocalDate getLocalDate(int i) {
        return (LocalDate)this.getAs(i);
    }

    public static /* synthetic */ Timestamp getTimestamp$(Row $this, int i) {
        return $this.getTimestamp(i);
    }

    default public Timestamp getTimestamp(int i) {
        return (Timestamp)this.getAs(i);
    }

    public static /* synthetic */ Instant getInstant$(Row $this, int i) {
        return $this.getInstant(i);
    }

    default public Instant getInstant(int i) {
        return (Instant)this.getAs(i);
    }

    public static /* synthetic */ scala.collection.immutable.Seq getSeq$(Row $this, int i) {
        return $this.getSeq(i);
    }

    default public <T> scala.collection.immutable.Seq<T> getSeq(int i) {
        Seq seq = (Seq)this.getAs(i);
        if (seq instanceof ArraySeq) {
            ArraySeq arraySeq = (ArraySeq)seq;
            return ArrayImplicits$.MODULE$.SparkArrayOps(arraySeq.array()).toImmutableArraySeq();
        }
        if (seq != null) {
            return seq.toSeq();
        }
        return null;
    }

    public static /* synthetic */ java.util.List getList$(Row $this, int i) {
        return $this.getList(i);
    }

    default public <T> java.util.List<T> getList(int i) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.getSeq(i)).asJava();
    }

    public static /* synthetic */ Map getMap$(Row $this, int i) {
        return $this.getMap(i);
    }

    default public <K, V> Map<K, V> getMap(int i) {
        return (Map)this.getAs(i);
    }

    public static /* synthetic */ java.util.Map getJavaMap$(Row $this, int i) {
        return $this.getJavaMap(i);
    }

    default public <K, V> java.util.Map<K, V> getJavaMap(int i) {
        return CollectionConverters$.MODULE$.MapHasAsJava(this.getMap(i)).asJava();
    }

    public static /* synthetic */ Row getStruct$(Row $this, int i) {
        return $this.getStruct(i);
    }

    default public Row getStruct(int i) {
        return (Row)this.getAs(i);
    }

    public static /* synthetic */ Object getAs$(Row $this, int i) {
        return $this.getAs(i);
    }

    default public <T> T getAs(int i) {
        return (T)this.get(i);
    }

    public static /* synthetic */ Object getAs$(Row $this, String fieldName) {
        return $this.getAs(fieldName);
    }

    default public <T> T getAs(String fieldName) {
        return this.getAs(this.fieldIndex(fieldName));
    }

    public static /* synthetic */ int fieldIndex$(Row $this, String name) {
        return $this.fieldIndex(name);
    }

    default public int fieldIndex(String name) {
        throw DataTypeErrors$.MODULE$.fieldIndexOnRowWithoutSchemaError(name);
    }

    public static /* synthetic */ scala.collection.immutable.Map getValuesMap$(Row $this, scala.collection.immutable.Seq fieldNames) {
        return $this.getValuesMap((scala.collection.immutable.Seq<String>)fieldNames);
    }

    default public <T> scala.collection.immutable.Map<String, T> getValuesMap(scala.collection.immutable.Seq<String> fieldNames) {
        return ((IterableOnceOps)fieldNames.map((Function1 & Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), this.getAs((String)name)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static /* synthetic */ String toString$(Row $this) {
        return $this.toString();
    }

    default public String toString() {
        return this.mkString("[", ",", "]");
    }

    public Row copy();

    public static /* synthetic */ boolean anyNull$(Row $this) {
        return $this.anyNull();
    }

    default public boolean anyNull() {
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            if (!this.isNullAt(i)) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean equals$(Row $this, Object o) {
        return $this.equals(o);
    }

    default public boolean equals(Object o) {
        if (!(o instanceof Row)) {
            return false;
        }
        Row other = (Row)o;
        if (other == null) {
            return false;
        }
        if (this.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            double d;
            float f;
            if (this.isNullAt(i) != other.isNullAt(i)) {
                return false;
            }
            if (this.isNullAt(i)) continue;
            Object o1 = this.get(i);
            Object o2 = other.get(i);
            Object object = o1;
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                if (o2 instanceof byte[] && Arrays.equals(byArray, (byte[])o2)) continue;
                return false;
            }
            if (object instanceof Float && Float.isNaN(f = BoxesRunTime.unboxToFloat((Object)object))) {
                if (o2 instanceof Float && Float.isNaN(BoxesRunTime.unboxToFloat((Object)o2))) continue;
                return false;
            }
            if (object instanceof Double && Double.isNaN(d = BoxesRunTime.unboxToDouble((Object)object))) {
                if (o2 instanceof Double && Double.isNaN(BoxesRunTime.unboxToDouble((Object)o2))) continue;
                return false;
            }
            if (object instanceof java.math.BigDecimal) {
                java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
                if (o2 instanceof java.math.BigDecimal) {
                    if (bigDecimal.compareTo((java.math.BigDecimal)o2) == 0) continue;
                    return false;
                }
            }
            if (BoxesRunTime.equals((Object)o1, (Object)o2)) continue;
            return false;
        }
        return true;
    }

    public static /* synthetic */ int hashCode$(Row $this) {
        return $this.hashCode();
    }

    default public int hashCode() {
        int n;
        int h = MurmurHash3$.MODULE$.seqSeed();
        int len = this.length();
        for (n = 0; n < len; ++n) {
            h = MurmurHash3$.MODULE$.mix(h, Statics.anyHash((Object)this.apply(n)));
        }
        return MurmurHash3$.MODULE$.finalizeHash(h, n);
    }

    public static /* synthetic */ scala.collection.immutable.Seq toSeq$(Row $this) {
        return $this.toSeq();
    }

    default public scala.collection.immutable.Seq<Object> toSeq() {
        int n = this.length();
        Object[] values = new Object[n];
        for (int i = 0; i < n; ++i) {
            values[i] = this.get(i);
        }
        return ArrayImplicits$.MODULE$.SparkArrayOps((Object)values).toImmutableArraySeq();
    }

    public static /* synthetic */ String mkString$(Row $this) {
        return $this.mkString();
    }

    default public String mkString() {
        return this.mkString("");
    }

    public static /* synthetic */ String mkString$(Row $this, String sep) {
        return $this.mkString(sep);
    }

    default public String mkString(String sep) {
        return this.mkString("", sep, "");
    }

    public static /* synthetic */ String mkString$(Row $this, String start, String sep, String end) {
        return $this.mkString(start, sep, end);
    }

    default public String mkString(String start, String sep, String end) {
        int n = this.length();
        StringBuilder builder = new StringBuilder();
        builder.append(start);
        if (n > 0) {
            builder.append(this.get(0));
            for (int i = 1; i < n; ++i) {
                builder.append(sep);
                builder.append(this.get(i));
            }
        }
        builder.append(end);
        return builder.toString();
    }

    private <T> T getAnyValAs(int i) {
        if (this.isNullAt(i)) {
            throw DataTypeErrors$.MODULE$.valueIsNullError(i);
        }
        return this.getAs(i);
    }

    public static /* synthetic */ String json$(Row $this) {
        return $this.json();
    }

    @Unstable
    default public String json() {
        return JsonMethods$.MODULE$.compact(this.jsonValue());
    }

    public static /* synthetic */ String prettyJson$(Row $this) {
        return $this.prettyJson();
    }

    @Unstable
    default public String prettyJson() {
        return JsonMethods$.MODULE$.pretty(JsonMethods$.MODULE$.render(this.jsonValue(), JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3()));
    }

    public static /* synthetic */ JValue jsonValue$(Row $this) {
        return $this.jsonValue();
    }

    default public JValue jsonValue() {
        LazyRef zoneId$lzy = new LazyRef();
        LazyRef dateFormatter$lzy = new LazyRef();
        LazyRef timestampFormatter$lzy = new LazyRef();
        Predef$.MODULE$.require(this.schema() != null, (Function0 & Serializable)() -> "JSON serialization requires a non-null schema.");
        return this.toJson$1(this, this.schema(), dateFormatter$lzy, timestampFormatter$lzy, zoneId$lzy);
    }

    private static /* synthetic */ ZoneId zoneId$lzycompute$1(LazyRef zoneId$lzy$1) {
        ZoneId zoneId;
        LazyRef lazyRef = zoneId$lzy$1;
        synchronized (lazyRef) {
            zoneId = zoneId$lzy$1.initialized() ? (ZoneId)zoneId$lzy$1.value() : (ZoneId)zoneId$lzy$1.initialize((Object)SparkDateTimeUtils$.MODULE$.getZoneId(SqlApiConf$.MODULE$.get().sessionLocalTimeZone()));
        }
        return zoneId;
    }

    private static ZoneId zoneId$1(LazyRef zoneId$lzy$1) {
        if (zoneId$lzy$1.initialized()) {
            return (ZoneId)zoneId$lzy$1.value();
        }
        return Row.zoneId$lzycompute$1(zoneId$lzy$1);
    }

    private static /* synthetic */ DateFormatter dateFormatter$lzycompute$1(LazyRef dateFormatter$lzy$1) {
        DateFormatter dateFormatter;
        LazyRef lazyRef = dateFormatter$lzy$1;
        synchronized (lazyRef) {
            dateFormatter = dateFormatter$lzy$1.initialized() ? (DateFormatter)dateFormatter$lzy$1.value() : (DateFormatter)dateFormatter$lzy$1.initialize((Object)DateFormatter$.MODULE$.apply());
        }
        return dateFormatter;
    }

    private static DateFormatter dateFormatter$1(LazyRef dateFormatter$lzy$1) {
        if (dateFormatter$lzy$1.initialized()) {
            return (DateFormatter)dateFormatter$lzy$1.value();
        }
        return Row.dateFormatter$lzycompute$1(dateFormatter$lzy$1);
    }

    private static /* synthetic */ TimestampFormatter timestampFormatter$lzycompute$1(LazyRef timestampFormatter$lzy$1, LazyRef zoneId$lzy$1) {
        TimestampFormatter timestampFormatter;
        LazyRef lazyRef = timestampFormatter$lzy$1;
        synchronized (lazyRef) {
            timestampFormatter = timestampFormatter$lzy$1.initialized() ? (TimestampFormatter)timestampFormatter$lzy$1.value() : (TimestampFormatter)timestampFormatter$lzy$1.initialize((Object)TimestampFormatter$.MODULE$.apply(Row.zoneId$1(zoneId$lzy$1)));
        }
        return timestampFormatter;
    }

    private static TimestampFormatter timestampFormatter$1(LazyRef timestampFormatter$lzy$1, LazyRef zoneId$lzy$1) {
        if (timestampFormatter$lzy$1.initialized()) {
            return (TimestampFormatter)timestampFormatter$lzy$1.value();
        }
        return Row.timestampFormatter$lzycompute$1(timestampFormatter$lzy$1, zoneId$lzy$1);
    }

    private JArray iteratorToJsonArray$1(Iterator iterator, DataType elementType, LazyRef dateFormatter$lzy$1, LazyRef timestampFormatter$lzy$1, LazyRef zoneId$lzy$1) {
        return new JArray(iterator.map((Function1 & Serializable)x$2 -> this.toJson$1(x$2, elementType, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1)).toList());
    }

    private JValue toJson$1(Object value, DataType dataType, LazyRef dateFormatter$lzy$1, LazyRef timestampFormatter$lzy$1, LazyRef zoneId$lzy$1) {
        while (true) {
            Object i;
            Object d;
            Object t;
            Object i2;
            Object d2;
            Object d3;
            Object s;
            Object d4;
            Object d5;
            Object d6;
            Object d7;
            Object f;
            Object l;
            Object i3;
            Object s2;
            Object b;
            Object b2;
            Object object;
            Tuple2 tuple2;
            if ((tuple2 = new Tuple2(value, (Object)dataType)) != null && (object = tuple2._1()) == null) {
                return JNull$.MODULE$;
            }
            if (tuple2 != null && (b2 = tuple2._1()) instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)b2);
                return JBool$.MODULE$.apply(bl);
            }
            if (tuple2 != null && (b = tuple2._1()) instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)b);
                return new JLong((long)by);
            }
            if (tuple2 != null && (s2 = tuple2._1()) instanceof Short) {
                short s3 = BoxesRunTime.unboxToShort((Object)s2);
                return new JLong((long)s3);
            }
            if (tuple2 != null && (i3 = tuple2._1()) instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)i3);
                return new JLong((long)n);
            }
            if (tuple2 != null && (l = tuple2._1()) instanceof Long) {
                long l2 = BoxesRunTime.unboxToLong((Object)l);
                return new JLong(l2);
            }
            if (tuple2 != null && (f = tuple2._1()) instanceof Float) {
                float f2 = BoxesRunTime.unboxToFloat((Object)f);
                return new JDouble((double)f2);
            }
            if (tuple2 != null && (d7 = tuple2._1()) instanceof Double) {
                double d8 = BoxesRunTime.unboxToDouble((Object)d7);
                return new JDouble(d8);
            }
            if (tuple2 != null && (d6 = tuple2._1()) instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)d6;
                return new JDecimal(bigDecimal);
            }
            if (tuple2 != null && (d5 = tuple2._1()) instanceof java.math.BigDecimal) {
                java.math.BigDecimal bigDecimal = (java.math.BigDecimal)d5;
                return new JDecimal(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(bigDecimal));
            }
            if (tuple2 != null && (d4 = tuple2._1()) instanceof Decimal) {
                Decimal decimal = (Decimal)d4;
                return new JDecimal(decimal.toBigDecimal());
            }
            if (tuple2 != null && (s = tuple2._1()) instanceof String) {
                String string = (String)s;
                return new JString(string);
            }
            if (tuple2 != null) {
                Object b3 = tuple2._1();
                DataType dataType2 = (DataType)tuple2._2();
                if (b3 instanceof byte[]) {
                    byte[] byArray = (byte[])b3;
                    if (BinaryType$.MODULE$.equals(dataType2)) {
                        return new JString(Base64.getEncoder().encodeToString(byArray));
                    }
                }
            }
            if (tuple2 != null && (d3 = tuple2._1()) instanceof LocalDate) {
                LocalDate localDate = (LocalDate)d3;
                return new JString(Row.dateFormatter$1(dateFormatter$lzy$1).format(localDate));
            }
            if (tuple2 != null && (d2 = tuple2._1()) instanceof Date) {
                Date date = (Date)d2;
                return new JString(Row.dateFormatter$1(dateFormatter$lzy$1).format(date));
            }
            if (tuple2 != null && (i2 = tuple2._1()) instanceof Instant) {
                Instant instant = (Instant)i2;
                return new JString(Row.timestampFormatter$1(timestampFormatter$lzy$1, zoneId$lzy$1).format(instant));
            }
            if (tuple2 != null && (t = tuple2._1()) instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)t;
                return new JString(Row.timestampFormatter$1(timestampFormatter$lzy$1, zoneId$lzy$1).format(timestamp));
            }
            if (tuple2 != null && (d = tuple2._1()) instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)d;
                return new JString(Row.timestampFormatter$1(timestampFormatter$lzy$1, zoneId$lzy$1).format(localDateTime));
            }
            if (tuple2 != null && (i = tuple2._1()) instanceof CalendarInterval) {
                CalendarInterval calendarInterval = (CalendarInterval)i;
                return new JString(calendarInterval.toString());
            }
            if (tuple2 != null) {
                Object a = tuple2._1();
                DataType dataType3 = (DataType)tuple2._2();
                if (ScalaRunTime$.MODULE$.isArray(a, 1)) {
                    Object object2 = a;
                    if (dataType3 instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType3;
                        DataType elementType = arrayType.elementType();
                        return this.iteratorToJsonArray$1(ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.genericArrayOps(object2)), elementType, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1);
                    }
                }
            }
            if (tuple2 != null) {
                Object a = tuple2._1();
                DataType dataType4 = (DataType)tuple2._2();
                if (a instanceof ArraySeq) {
                    ArraySeq arraySeq = (ArraySeq)a;
                    if (dataType4 instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType4;
                        DataType elementType = arrayType.elementType();
                        return this.iteratorToJsonArray$1(arraySeq.iterator(), elementType, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1);
                    }
                }
            }
            if (tuple2 != null) {
                Object s4 = tuple2._1();
                DataType dataType5 = (DataType)tuple2._2();
                if (s4 instanceof scala.collection.immutable.Seq) {
                    scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)s4;
                    if (dataType5 instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType5;
                        DataType elementType = arrayType.elementType();
                        return this.iteratorToJsonArray$1(seq.iterator(), elementType, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1);
                    }
                }
            }
            if (tuple2 != null) {
                Object m = tuple2._1();
                DataType dataType6 = (DataType)tuple2._2();
                if (m instanceof scala.collection.immutable.Map) {
                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)m;
                    if (dataType6 instanceof MapType) {
                        MapType mapType = (MapType)dataType6;
                        DataType dataType7 = mapType.keyType();
                        DataType valueType = mapType.valueType();
                        if (((Object)StringType$.MODULE$).equals(dataType7)) {
                            return new JObject(((List)map.toList().sortBy((Function1 & Serializable)x$3 -> (String)x$3._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
                                Tuple2 tuple2 = x0$1;
                                if (tuple2 != null) {
                                    String k = (String)tuple2._1();
                                    Object v = tuple2._2();
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)this.toJson$1(v, valueType, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1));
                                }
                                throw new MatchError((Object)tuple2);
                            }));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Object m = tuple2._1();
                DataType dataType8 = (DataType)tuple2._2();
                if (m instanceof scala.collection.immutable.Map) {
                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)m;
                    if (dataType8 instanceof MapType) {
                        MapType mapType = (MapType)dataType8;
                        DataType keyType = mapType.keyType();
                        DataType valueType = mapType.valueType();
                        return new JArray(map.iterator().map((Function1 & Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 != null) {
                                Object k = tuple2._1();
                                Object v = tuple2._2();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)this.toJson$1(k, keyType, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1));
                                Tuple2 tuple23 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)this.toJson$1(v, valueType, dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1));
                                return new JObject(Nil$.MODULE$.$colon$colon((Object)tuple23).$colon$colon((Object)tuple22));
                            }
                            throw new MatchError((Object)tuple2);
                        }).toList());
                    }
                }
            }
            if (tuple2 != null) {
                Object row = tuple2._1();
                DataType schema = (DataType)tuple2._2();
                if (row instanceof Row) {
                    Row row2 = (Row)row;
                    if (schema instanceof StructType) {
                        StructType structType = (StructType)schema;
                        ListBuffer elements = new ListBuffer();
                        int len = row2.length();
                        for (int n = 0; n < len; ++n) {
                            StructField field = structType.apply(n);
                            elements.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)this.toJson$1(row2.apply(n), field.dataType(), dateFormatter$lzy$1, timestampFormatter$lzy$1, zoneId$lzy$1)));
                        }
                        return new JObject(elements.toList());
                    }
                }
            }
            if (tuple2 == null) break;
            Object v = tuple2._1();
            DataType udt = (DataType)tuple2._2();
            if (!(v instanceof Object)) break;
            Object object3 = v;
            if (!(udt instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)udt;
            dataType = userDefinedType.sqlType();
            value = UDTUtils$.MODULE$.toRow(object3, userDefinedType);
        }
        throw new SparkIllegalArgumentException("FAILED_ROW_TO_JSON", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)DataTypeErrors$.MODULE$.toSQLValue(value.toString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)value.getClass().toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlType"), (Object)DataTypeErrors$.MODULE$.toSQLType(dataType.toString()))})));
    }

    public static void $init$(Row $this) {
    }
}

