/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FrameLessOffsetWindowFunction;
import org.apache.spark.sql.catalyst.expressions.Lead$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExpressionDescription(usage="\n    _FUNC_(input[, offset[, default]]) - Returns the value of `input` at the `offset`th row\n      after the current row in the window. The default value of `offset` is 1 and the default\n      value of `default` is null. If the value of `input` at the `offset`th row is null,\n      null is returned. If there is no such an offset row (e.g., when the offset is 1, the last\n      row of the window does not have any subsequent row), `default` is returned.\n  ", arguments="\n    Arguments:\n      * input - a string expression to evaluate `offset` rows after the current row.\n      * offset - an int expression which is rows to jump ahead in the partition.\n      * default - a string expression which is to use when the offset is larger than the window.\n          The default value is null.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(b) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t2\n       A1\t2\tNULL\n       A2\t3\tNULL\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001\u0002\u0013&\u0001JB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005{!AA\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005N\u0001\tE\t\u0015!\u0003>\u0011!q\u0005A!f\u0001\n\u0003Q\u0005\u0002C(\u0001\u0005#\u0005\u000b\u0011B\u001f\t\u0011A\u0003!Q3A\u0005\u0002EC\u0001\"\u0016\u0001\u0003\u0012\u0003\u0006IA\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\u0006-\u0002!\t!\u0018\u0005\u0006-\u0002!\t!\u0019\u0005\u0006-\u0002!\t\u0001\u001a\u0005\u0006-\u0002!\tA\u001a\u0005\u0006O\u0002!\tE\u0013\u0005\u0006Q\u0002!\tE\u0013\u0005\u0006S\u0002!\tE\u0013\u0005\u0006U\u0002!\tf\u001b\u0005\be\u0002\t\t\u0011\"\u0001t\u0011\u001dA\b!%A\u0005\u0002eD\u0001\"!\u0003\u0001#\u0003%\t!\u001f\u0005\t\u0003\u0017\u0001\u0011\u0013!C\u0001s\"I\u0011Q\u0002\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003'\u0001\u0011\u0011!C!\u0003+A\u0011\"a\n\u0001\u0003\u0003%\t!!\u000b\t\u0013\u0005E\u0002!!A\u0005\u0002\u0005M\u0002\"CA \u0001\u0005\u0005I\u0011IA!\u0011%\ty\u0005AA\u0001\n\u0003\t\t\u0006C\u0005\u0002V\u0001\t\t\u0011\"\u0011\u0002X\u001dI\u0011\u0011Q\u0013\u0002\u0002#\u0005\u00111\u0011\u0004\tI\u0015\n\t\u0011#\u0001\u0002\u0006\"1aK\bC\u0001\u0003'C\u0011\"!&\u001f\u0003\u0003%)%a&\t\u0013\u0005ee$!A\u0005\u0002\u0006m\u0005\"CAS=\u0005\u0005I\u0011QAT\u0011%\tILHA\u0001\n\u0013\tYL\u0001\u0003MK\u0006$'B\u0001\u0014(\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005!J\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005)Z\u0013aA:rY*\u0011A&L\u0001\u0006gB\f'o\u001b\u0006\u0003]=\na!\u00199bG\",'\"\u0001\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0019t\u0007\u0011$\u0011\u0005Q*T\"A\u0013\n\u0005Y*#!\b$sC6,G*Z:t\u001f\u001a47/\u001a;XS:$wn\u001e$v]\u000e$\u0018n\u001c8\u0011\u0007aZT(D\u0001:\u0015\tQt%A\u0003ue\u0016,7/\u0003\u0002=s\tYA+\u001a:oCJLH*[6f!\t!d(\u0003\u0002@K\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011iR\u0005\u0003\u0011\n\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fQ!\u001b8qkR,\u0012!P\u0001\u0007S:\u0004X\u000f\u001e\u0011\u0002\r=4gm]3u\u0003\u001dygMZ:fi\u0002\nq\u0001Z3gCVdG/\u0001\u0005eK\u001a\fW\u000f\u001c;!\u0003-IwM\\8sK:+H\u000e\\:\u0016\u0003I\u0003\"!Q*\n\u0005Q\u0013%a\u0002\"p_2,\u0017M\\\u0001\rS\u001etwN]3Ok2d7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000baK&l\u0017/\u0011\u0005Q\u0002\u0001\"B%\n\u0001\u0004i\u0004\"\u0002'\n\u0001\u0004i\u0004\"\u0002(\n\u0001\u0004i\u0004\"\u0002)\n\u0001\u0004\u0011F\u0003\u0002-_?\u0002DQ!\u0013\u0006A\u0002uBQ\u0001\u0014\u0006A\u0002uBQA\u0014\u0006A\u0002u\"2\u0001\u00172d\u0011\u0015I5\u00021\u0001>\u0011\u0015a5\u00021\u0001>)\tAV\rC\u0003J\u0019\u0001\u0007Q\bF\u0001Y\u0003\u00151\u0017N]:u\u0003\u0019\u0019XmY8oI\u0006)A\u000f[5sI\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u000512t\u0007\u000fC\u0003n#\u0001\u0007Q(\u0001\u0005oK^4\u0015N]:u\u0011\u0015y\u0017\u00031\u0001>\u0003%qWm^*fG>tG\rC\u0003r#\u0001\u0007Q(\u0001\u0005oK^$\u0006.\u001b:e\u0003\u0011\u0019w\u000e]=\u0015\u000ba#XO^<\t\u000f%\u0013\u0002\u0013!a\u0001{!9AJ\u0005I\u0001\u0002\u0004i\u0004b\u0002(\u0013!\u0003\u0005\r!\u0010\u0005\b!J\u0001\n\u00111\u0001S\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A\u001f\u0016\u0003{m\\\u0013\u0001 \t\u0004{\u0006\u0015Q\"\u0001@\u000b\u0007}\f\t!A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0001\"\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\by\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005E!F\u0001*|\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0012\u0001\u00026bm\u0006LA!!\n\u0002\u001c\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u000b\u0011\u0007\u0005\u000bi#C\u0002\u00020\t\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u000e\u0002<A\u0019\u0011)a\u000e\n\u0007\u0005e\"IA\u0002B]fD\u0011\"!\u0010\u001a\u0003\u0003\u0005\r!a\u000b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0005\u0005\u0004\u0002F\u0005-\u0013QG\u0007\u0003\u0003\u000fR1!!\u0013C\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\n9E\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001*\u0002T!I\u0011QH\u000e\u0002\u0002\u0003\u0007\u0011QG\u0001\u0007KF,\u0018\r\\:\u0015\u0007I\u000bI\u0006C\u0005\u0002>q\t\t\u00111\u0001\u00026!:\u0002!!\u0018\u0002d\u0005\u0015\u0014\u0011NA6\u0003_\n\t(!\u001e\u0002x\u0005m\u0014Q\u0010\t\u0004i\u0005}\u0013bAA1K\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA4\u0003\rE%\u0002\t\u0011!A}3UKT\"`Q%t\u0007/\u001e;\\Y\u0001zgMZ:finc\u0003\u0005Z3gCVdG/X/*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAY\fG.^3!_\u001a\u0004\u0003-\u001b8qkR\u0004\u0007%\u0019;!i\",\u0007\u0005Y8gMN,G\u000f\u0019;iAI|wO\u0003\u0011!A\u0001\u0002\u0003%\u00194uKJ\u0004C\u000f[3!GV\u0014(/\u001a8uAI|w\u000fI5oAQDW\rI<j]\u0012|wO\f\u0011UQ\u0016\u0004C-\u001a4bk2$\bE^1mk\u0016\u0004sN\u001a\u0011a_\u001a47/\u001a;aA%\u001c\b%\r\u0011b]\u0012\u0004C\u000f[3!I\u00164\u0017-\u001e7u\u0015\u0001\u0002\u0003\u0005\t\u0011!m\u0006dW/\u001a\u0011pM\u0002\u0002G-\u001a4bk2$\b\rI5tA9,H\u000e\u001c\u0018!\u0013\u001a\u0004C\u000f[3!m\u0006dW/\u001a\u0011pM\u0002\u0002\u0017N\u001c9vi\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004\u0003m\u001c4gg\u0016$\b\r\u001e5!e><\b%[:!]VdG\u000e\f\u0006!A\u0001\u0002\u0003\u0005\t8vY2\u0004\u0013n\u001d\u0011sKR,(O\\3e]\u0001Je\r\t;iKJ,\u0007%[:!]>\u00043/^2iA\u0005t\u0007e\u001c4gg\u0016$\bE]8xA!*gf\u001a\u0018-A]DWM\u001c\u0011uQ\u0016\u0004sN\u001a4tKR\u0004\u0013n\u001d\u00112Y\u0001\"\b.\u001a\u0011mCN$(\u0002\t\u0011!A\u0001\u0002#o\\<!_\u001a\u0004C\u000f[3!o&tGm\\<!I>,7\u000f\t8pi\u0002B\u0017M^3!C:L\be];cg\u0016\fX/\u001a8uAI|w/\u000b\u0017!A\u0012,g-Y;mi\u0002\u0004\u0013n\u001d\u0011sKR,(O\\3e])\u0001\u0003%A\u0005be\u001e,X.\u001a8ug\u0006\u0012\u0011QN\u0001\u0003~)\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001b8qkR\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>t\u0007\u0005^8!KZ\fG.^1uK\u0002\u0002wN\u001a4tKR\u0004\u0007E]8xg\u0002\ng\r^3sAQDW\rI2veJ,g\u000e\u001e\u0011s_^t#\u0002\t\u0011!A\u0001\u0002#\u0006I8gMN,G\u000fI\u0017!C:\u0004\u0013N\u001c;!Kb\u0004(/Z:tS>t\u0007e\u001e5jG\"\u0004\u0013n\u001d\u0011s_^\u001c\b\u0005^8!UVl\u0007\u000fI1iK\u0006$\u0007%\u001b8!i\",\u0007\u0005]1si&$\u0018n\u001c8/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"WMZ1vYR\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>t\u0007e\u001e5jG\"\u0004\u0013n\u001d\u0011u_\u0002*8/\u001a\u0011xQ\u0016t\u0007\u0005\u001e5fA=4gm]3uA%\u001c\b\u0005\\1sO\u0016\u0014\b\u0005\u001e5b]\u0002\"\b.\u001a\u0011xS:$wn\u001e\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C\u000b[3!I\u00164\u0017-\u001e7uAY\fG.^3!SN\u0004c.\u001e7m])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019(AAR\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\nG\u0006\t2-A}3UKT\"`Q\tL\u0003e\u0014,F%\u0002B\u0003+\u0011*U\u0013RKuJ\u0014\u0011C3\u0002\n\u0007e\u0014*E\u000bJ\u0003#)\u0017\u0011cS\u00012%kT'!-\u0006cU+R*!Q\u001d\n\u0015g\n\u0017!e%b\u0003\u0005K\u0014Bc\u001db\u0003%M\u0015-A!:\u0013IM\u0014-AMJC\u0006\t\u0015(\u0003F:C\u0006I\u0019*AQ\f'\rK1-A\tL3H\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013EJ\u0011G\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013EJ!G\u0003\u0011!A\u0001\u0002\u0003\u0005I!2\u0013IJa*\u0016'M\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u0013\u0014bM\u0005O+2c%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005e\u0014!\u0002\u001a/a9\u0002\u0014!B4s_V\u0004\u0018EAA@\u000319\u0018N\u001c3po~3WO\\2t\u0003\u0011aU-\u00193\u0011\u0005Qr2\u0003\u0002\u0010\u0002\b\u001a\u0003\u0012\"!#\u0002\u0010vjTH\u0015-\u000e\u0005\u0005-%bAAG\u0005\u00069!/\u001e8uS6,\u0017\u0002BAI\u0003\u0017\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c85)\t\t\u0019)\u0001\u0005u_N#(/\u001b8h)\t\t9\"A\u0003baBd\u0017\u0010F\u0005Y\u0003;\u000by*!)\u0002$\")\u0011*\ta\u0001{!)A*\ta\u0001{!)a*\ta\u0001{!)\u0001+\ta\u0001%\u00069QO\\1qa2LH\u0003BAU\u0003k\u0003R!QAV\u0003_K1!!,C\u0005\u0019y\u0005\u000f^5p]B9\u0011)!->{u\u0012\u0016bAAZ\u0005\n1A+\u001e9mKRB\u0001\"a.#\u0003\u0003\u0005\r\u0001W\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!0\u0011\t\u0005e\u0011qX\u0005\u0005\u0003\u0003\fYB\u0001\u0004PE*,7\r\u001e")
public class Lead
extends FrameLessOffsetWindowFunction
implements TernaryLike<Expression>,
Serializable {
    private final Expression input;
    private final Expression offset;
    private final Expression default;
    private final boolean ignoreNulls;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Object>> unapply(Lead lead) {
        return Lead$.MODULE$.unapply(lead);
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Object>, Lead> tupled() {
        return Lead$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Lead>>>> curried() {
        return Lead$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        Lead lead = this;
        synchronized (lead) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression input() {
        return this.input;
    }

    @Override
    public Expression offset() {
        return this.offset;
    }

    @Override
    public Expression default() {
        return this.default;
    }

    @Override
    public boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    public Expression first() {
        return this.input();
    }

    @Override
    public Expression second() {
        return this.offset();
    }

    @Override
    public Expression third() {
        return this.default();
    }

    @Override
    public Lead withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird, this.copy$default$4());
    }

    public Lead copy(Expression input, Expression offset, Expression expression, boolean ignoreNulls) {
        return new Lead(input, offset, expression, ignoreNulls);
    }

    public Expression copy$default$1() {
        return this.input();
    }

    public Expression copy$default$2() {
        return this.offset();
    }

    public Expression copy$default$3() {
        return this.default();
    }

    public boolean copy$default$4() {
        return this.ignoreNulls();
    }

    @Override
    public String productPrefix() {
        return "Lead";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.input();
            }
            case 1: {
                return this.offset();
            }
            case 2: {
                return this.default();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.ignoreNulls());
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Lead;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Lead)) return false;
        boolean bl = true;
        if (!bl) return false;
        Lead lead = (Lead)x$1;
        Expression expression = this.input();
        Expression expression2 = lead.input();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.offset();
        Expression expression4 = lead.offset();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.default();
        Expression expression6 = lead.default();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.ignoreNulls() != lead.ignoreNulls()) return false;
        if (!lead.canEqual(this)) return false;
        return true;
    }

    public Lead(Expression input, Expression offset, Expression expression, boolean ignoreNulls) {
        this.input = input;
        this.offset = offset;
        this.default = expression;
        this.ignoreNulls = ignoreNulls;
        TernaryLike.$init$(this);
    }

    public Lead(Expression input, Expression offset, Expression expression) {
        this(input, offset, expression, false);
    }

    public Lead(Expression input, Expression offset) {
        this(input, offset, Literal$.MODULE$.apply(null));
    }

    public Lead(Expression input) {
        this(input, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }

    public Lead() {
        this(Literal$.MODULE$.apply(null));
    }
}

