/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.EuclideanDistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i4QAD\b\u0001'eAQA\b\u0001\u0005\u0002\u0001BQA\t\u0001\u0005B\rBQ\u0001\f\u0001\u0005B5BQ\u0001\f\u0001\u0005B\u0005CQ\u0001\u0012\u0001\u0005B\u0015CQa\u000b\u0001\u0005B=CQ\u0001\u0016\u0001\u0005BUCQA\u0018\u0001\u0005B};aAY\b\t\u0002M\u0019gA\u0002\b\u0010\u0011\u0003\u0019B\rC\u0003\u001f\u0015\u0011\u00051\u000e\u0003\u0004m\u0015\u0011\u0005q\"\u001c\u0005\ba*\t\t\u0011\"\u0003r\u0005a)Uo\u00197jI\u0016\fg\u000eR5ti\u0006t7-Z'fCN,(/\u001a\u0006\u0003!E\t!b\u00197vgR,'/\u001b8h\u0015\t\u00112#A\u0003nY2L'M\u0003\u0002\u0015+\u0005)1\u000f]1sW*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h'\t\u0001!\u0004\u0005\u0002\u001c95\tq\"\u0003\u0002\u001e\u001f\tyA)[:uC:\u001cW-T3bgV\u0014X-\u0001\u0004=S:LGOP\u0002\u0001)\u0005\t\u0003CA\u000e\u0001\u0003E\u0019w.\u001c9vi\u0016\u001cF/\u0019;jgRL7m\u001d\u000b\u0003I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a\u0001R8vE2,\u0007\"B\u0016\u0003\u0001\u0004!\u0013\u0001\u00033jgR\fgnY3\u0002\u0017\u0019Lg\u000eZ\"m_N,7\u000f\u001e\u000b\u0005]Qbt\b\u0005\u0003&_E\"\u0013B\u0001\u0019'\u0005\u0019!V\u000f\u001d7feA\u0011QEM\u0005\u0003g\u0019\u00121!\u00138u\u0011\u0015)4\u00011\u00017\u0003\u001d\u0019WM\u001c;feN\u00042!J\u001c:\u0013\tAdEA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001cu%\u00111h\u0004\u0002\u000f-\u0016\u001cGo\u001c:XSRDgj\u001c:n\u0011\u0015i4\u00011\u0001?\u0003)\u0019H/\u0019;jgRL7m\u001d\t\u0004K]\"\u0003\"\u0002!\u0004\u0001\u0004I\u0014!\u00029pS:$Hc\u0001\u0018C\u0007\")Q\u0007\u0002a\u0001m!)\u0001\t\u0002a\u0001s\u0005\t\u0012n]\"f]R,'oQ8om\u0016\u0014x-\u001a3\u0015\t\u0019K5*\u0014\t\u0003K\u001dK!\u0001\u0013\u0014\u0003\u000f\t{w\u000e\\3b]\")!*\u0002a\u0001s\u0005Iq\u000e\u001c3DK:$XM\u001d\u0005\u0006\u0019\u0016\u0001\r!O\u0001\n]\u0016<8)\u001a8uKJDQAT\u0003A\u0002\u0011\nq!\u001a9tS2|g\u000eF\u0002%!JCQ!\u0015\u0004A\u0002e\n!A^\u0019\t\u000bM3\u0001\u0019A\u001d\u0002\u0005Y\u0014\u0014aC2mkN$XM]\"pgR$R\u0001\n,Y5rCQaV\u0004A\u0002e\n\u0001bY3oiJ|\u0017\u000e\u001a\u0005\u00063\u001e\u0001\r!O\u0001\na>Lg\u000e^:Tk6DQaW\u0004A\u0002\u0011\n\u0011b^3jO\"$8+^7\t\u000bu;\u0001\u0019\u0001\u0013\u0002#A|\u0017N\u001c;t'F,\u0018M]3e\u001d>\u0014X.\u0001\u0003d_N$Hc\u0001\u0013aC\")\u0001\t\u0003a\u0001s!)q\u000b\u0003a\u0001s\u0005AR)^2mS\u0012,\u0017M\u001c#jgR\fgnY3NK\u0006\u001cXO]3\u0011\u0005mQ1c\u0001\u0006fQB\u0011QEZ\u0005\u0003O\u001a\u0012a!\u00118z%\u00164\u0007CA\u0013j\u0013\tQgE\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001d\u0003M1\u0017m\u001d;TcV\f'/\u001a3ESN$\u0018M\\2f)\r!cn\u001c\u0005\u0006#2\u0001\r!\u000f\u0005\u0006'2\u0001\r!O\u0001\fe\u0016\fGMU3t_24X\rF\u0001s!\t\u0019\b0D\u0001u\u0015\t)h/\u0001\u0003mC:<'\"A<\u0002\t)\fg/Y\u0005\u0003sR\u0014aa\u00142kK\u000e$\b")
public class EuclideanDistanceMeasure
extends DistanceMeasure {
    @Override
    public double computeStatistics(double distance) {
        return 0.25 * distance * distance;
    }

    @Override
    public Tuple2<Object, Object> findClosest(VectorWithNorm[] centers, double[] statistics, VectorWithNorm point) {
        double bestDistance = EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(centers[0], point);
        if (bestDistance < statistics[0]) {
            return new Tuple2.mcID.sp(0, bestDistance);
        }
        int k = centers.length;
        int bestIndex = 0;
        for (int i = 1; i < k; ++i) {
            int index2;
            int index1;
            VectorWithNorm center = centers[i];
            double normDiff = center.norm() - point.norm();
            double lowerBound = normDiff * normDiff;
            if (!(lowerBound < bestDistance) || !(statistics[index1 = Utils$.MODULE$.indexUpperTriangular(k, i, bestIndex)] < bestDistance)) continue;
            double d = EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(center, point);
            if (d < statistics[index2 = Utils$.MODULE$.indexUpperTriangular(k, i, i)]) {
                return new Tuple2.mcID.sp(i, d);
            }
            if (!(d < bestDistance)) continue;
            bestDistance = d;
            bestIndex = i;
        }
        return new Tuple2.mcID.sp(bestIndex, bestDistance);
    }

    @Override
    public Tuple2<Object, Object> findClosest(VectorWithNorm[] centers, VectorWithNorm point) {
        double bestDistance = Double.POSITIVE_INFINITY;
        int bestIndex = 0;
        for (int i = 0; i < centers.length; ++i) {
            double distance;
            VectorWithNorm center = centers[i];
            double lowerBoundOfSqDist = center.norm() - point.norm();
            if (!((lowerBoundOfSqDist *= lowerBoundOfSqDist) < bestDistance) || !((distance = EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(center, point)) < bestDistance)) continue;
            bestDistance = distance;
            bestIndex = i;
        }
        return new Tuple2.mcID.sp(bestIndex, bestDistance);
    }

    @Override
    public boolean isCenterConverged(VectorWithNorm oldCenter, VectorWithNorm newCenter, double epsilon) {
        return EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(newCenter, oldCenter) <= epsilon * epsilon;
    }

    @Override
    public double distance(VectorWithNorm v1, VectorWithNorm v2) {
        return Math.sqrt(EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(v1, v2));
    }

    @Override
    public double clusterCost(VectorWithNorm centroid, VectorWithNorm pointsSum, double weightSum, double pointsSquaredNorm) {
        return package$.MODULE$.max(pointsSquaredNorm - weightSum * centroid.norm() * centroid.norm(), 0.0);
    }

    @Override
    public double cost(VectorWithNorm point, VectorWithNorm centroid) {
        return EuclideanDistanceMeasure$.MODULE$.fastSquaredDistance(point, centroid);
    }
}

