/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.streaming.StreamingQuery;

public final class JavaStructuredSessionization {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: JavaStructuredSessionization <hostname> <port>");
            System.exit(1);
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        SparkSession spark = SparkSession.builder().appName("JavaStructuredSessionization").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", host).option("port", (long)port).option("includeTimestamp", true).load();
        Dataset events = lines.selectExpr(new String[]{"explode(split(value, ' ')) AS sessionId", "timestamp AS eventTime"});
        Dataset sessionUpdates = events.groupBy(new Column[]{functions.session_window((Column)functions.col((String)"eventTime"), (String)"10 seconds").as("session"), functions.col((String)"sessionId")}).agg(functions.count((String)"*").as("numEvents"), new Column[0]).selectExpr(new String[]{"sessionId", "CAST(session.start AS LONG)", "CAST(session.end AS LONG)", "CAST(session.end AS LONG) - CAST(session.start AS LONG) AS durationMs", "numEvents"});
        StreamingQuery query = sessionUpdates.writeStream().outputMode("update").format("console").start();
        query.awaitTermination();
    }
}

