/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.pythonconverters;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;
import org.apache.spark.SparkException;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class AvroConversionUtil$
implements scala.Serializable {
    public static AvroConversionUtil$ MODULE$;

    static {
        new AvroConversionUtil$();
    }

    public Object fromAvro(Object obj, Schema schema) {
        if (obj == null) {
            return null;
        }
        Schema.Type type = schema.getType();
        if (Schema.Type.UNION.equals(type)) {
            return this.unpackUnion(obj, schema);
        }
        if (Schema.Type.ARRAY.equals(type)) {
            return this.unpackArray(obj, schema);
        }
        if (Schema.Type.FIXED.equals(type)) {
            return this.unpackFixed(obj, schema);
        }
        if (Schema.Type.MAP.equals(type)) {
            return this.unpackMap(obj, schema);
        }
        if (Schema.Type.BYTES.equals(type)) {
            return this.unpackBytes(obj);
        }
        if (Schema.Type.RECORD.equals(type)) {
            return this.unpackRecord(obj);
        }
        if (Schema.Type.STRING.equals(type)) {
            return obj.toString();
        }
        if (Schema.Type.ENUM.equals(type)) {
            return obj.toString();
        }
        if (Schema.Type.NULL.equals(type)) {
            return obj;
        }
        if (Schema.Type.BOOLEAN.equals(type)) {
            return obj;
        }
        if (Schema.Type.DOUBLE.equals(type)) {
            return obj;
        }
        if (Schema.Type.FLOAT.equals(type)) {
            return obj;
        }
        if (Schema.Type.INT.equals(type)) {
            return obj;
        }
        if (Schema.Type.LONG.equals(type)) {
            return obj;
        }
        throw new SparkException(new StringBuilder(25).append("Unknown Avro schema type ").append(type.getName()).toString());
    }

    public java.util.Map<String, Object> unpackRecord(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object object = obj;
        if (!(object instanceof IndexedRecord)) {
            throw new SparkException(new StringBuilder(24).append("Unsupported RECORD type ").append(object.getClass().getName()).toString());
        }
        IndexedRecord indexedRecord = (IndexedRecord)object;
        ((IterableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(indexedRecord.getSchema().getFields()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Schema.Field f = (Schema.Field)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return map.put(f.name(), MODULE$.fromAvro(indexedRecord.get(i), f.schema()));
            }
            throw new MatchError((Object)tuple2);
        });
        return map;
    }

    public java.util.Map<String, Object> unpackMap(Object obj, Schema schema) {
        return (java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)obj).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object key = tuple2._1();
                Object value = tuple2._2();
                return new Tuple2((Object)key.toString(), MODULE$.fromAvro(value, schema.getValueType()));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public byte[] unpackFixed(Object obj, Schema schema) {
        return this.unpackBytes(((GenericFixed)obj).bytes());
    }

    public byte[] unpackBytes(Object obj) {
        byte[] byArray;
        Object object = obj;
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] arr = new byte[byteBuffer.remaining()];
            byteBuffer.get(arr);
            byArray = arr;
        } else if (object instanceof byte[]) {
            byte[] byArray2;
            byArray = byArray2 = (byte[])object;
        } else {
            throw new SparkException(new StringBuilder(19).append("Unknown BYTES type ").append(object.getClass().getName()).toString());
        }
        byte[] bytes = byArray;
        byte[] bytearray = new byte[bytes.length];
        System.arraycopy(bytes, 0, bytearray, 0, bytes.length);
        return bytearray;
    }

    public Collection<Object> unpackArray(Object obj, Schema schema) {
        Object object;
        Object object2 = obj;
        if (object2 instanceof Collection) {
            Collection collection = (Collection)object2;
            return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(collection).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.fromAvro(x$1, schema.getElementType()), Iterable$.MODULE$.canBuildFrom())).toSeq()).asJava();
        }
        if (ScalaRunTime$.MODULE$.isArray(object2, 1) && (object = object2).getClass().getComponentType().isPrimitive()) {
            return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(Predef$.MODULE$.genericArrayOps(object).toSeq()).asJava();
        }
        if (ScalaRunTime$.MODULE$.isArray(object2, 1)) {
            Object object3 = object2;
            return (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(object3).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.fromAvro(x$2, schema.getElementType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSeq()).asJava();
        }
        throw new SparkException(new StringBuilder(19).append("Unknown ARRAY type ").append(object2.getClass().getName()).toString());
    }

    public Object unpackUnion(Object obj, Schema schema) {
        Some some;
        List list = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getTypes()).asScala()).toList();
        Some some2 = List$.MODULE$.unapplySeq((Seq)list);
        if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0) {
            Schema s = (Schema)((LinearSeqOptimized)some2.get()).apply(0);
            return this.fromAvro(obj, s);
        }
        Some some3 = List$.MODULE$.unapplySeq((Seq)list);
        if (!some3.isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(2) == 0) {
            Schema n = (Schema)((LinearSeqOptimized)some3.get()).apply(0);
            Schema s = (Schema)((LinearSeqOptimized)some3.get()).apply(1);
            Schema.Type type = n.getType();
            Schema.Type type2 = Schema.Type.NULL;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                return this.fromAvro(obj, s);
            }
        }
        if (!(some = List$.MODULE$.unapplySeq((Seq)list)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
            Schema s = (Schema)((LinearSeqOptimized)some.get()).apply(0);
            Schema n = (Schema)((LinearSeqOptimized)some.get()).apply(1);
            Schema.Type type = n.getType();
            Schema.Type type3 = Schema.Type.NULL;
            if (!(type != null ? !type.equals(type3) : type3 != null)) {
                return this.fromAvro(obj, s);
            }
        }
        throw new SparkException("Unions may only consist of a concrete type and null");
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AvroConversionUtil$() {
        MODULE$ = this;
    }
}

