/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;

public final class JavaTC {
    private static final int numEdges = 200;
    private static final int numVertices = 100;
    private static final Random rand = new Random(42L);

    static List<Tuple2<Integer, Integer>> generateGraph() {
        HashSet<Tuple2> edges = new HashSet<Tuple2>(200);
        while (edges.size() < 200) {
            int from = rand.nextInt(100);
            int to = rand.nextInt(100);
            Tuple2 e = new Tuple2((Object)from, (Object)to);
            if (from == to) continue;
            edges.add(e);
        }
        return new ArrayList<Tuple2<Integer, Integer>>(edges);
    }

    public static void main(String[] args) {
        long oldCount;
        SparkSession spark = SparkSession.builder().appName("JavaTC").getOrCreate();
        JavaSparkContext jsc = new JavaSparkContext(spark.sparkContext());
        int slices = args.length > 0 ? Integer.parseInt(args[0]) : 2;
        JavaPairRDD tc = jsc.parallelizePairs(JavaTC.generateGraph(), slices).cache();
        JavaPairRDD edges = tc.mapToPair((PairFunction & Serializable)e -> new Tuple2(e._2(), e._1()));
        long nextCount = tc.count();
        do {
            oldCount = nextCount;
        } while ((nextCount = (tc = tc.union(tc.join(edges).mapToPair((PairFunction)ProjectFn.INSTANCE)).distinct().cache()).count()) != oldCount);
        System.out.println("TC has " + tc.count() + " edges.");
        spark.stop();
    }

    static class ProjectFn
    implements PairFunction<Tuple2<Integer, Tuple2<Integer, Integer>>, Integer, Integer> {
        static final ProjectFn INSTANCE = new ProjectFn();

        ProjectFn() {
        }

        public Tuple2<Integer, Integer> call(Tuple2<Integer, Tuple2<Integer, Integer>> triple) {
            return new Tuple2(((Tuple2)triple._2())._2(), ((Tuple2)triple._2())._1());
        }
    }
}

