/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NTile$;
import org.apache.spark.sql.catalyst.expressions.RowNumberLike;
import org.apache.spark.sql.catalyst.expressions.SizeBasedWindowFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.NoOp$;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(n) - Divides the rows for each window partition into `n` buckets ranging\n      from 1 to at most `n`.\n  ", arguments="\n    Arguments:\n      * buckets - an int expression which is number of buckets to divide the rows in.\n          Default value is 1.\n  ", examples="\n    Examples:\n      > SELECT a, b, _FUNC_(2) OVER (PARTITION BY a ORDER BY b) FROM VALUES ('A1', 2), ('A1', 1), ('A2', 3), ('A1', 1) tab(a, b);\n       A1\t1\t1\n       A1\t1\t1\n       A1\t2\t2\n       A2\t3\t1\n  ", since="2.0.0", group="window_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001\u0002\u0015*\u0001ZB\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005\t\")\u0011\f\u0001C\u00015\")\u0011\f\u0001C\u0001;\")a\f\u0001C!/\")q\f\u0001C!A\"9q\r\u0001b\u0001\n\u0013A\u0007B\u00027\u0001A\u0003%\u0011\u000eC\u0004n\u0001\t\u0007I\u0011\u00025\t\r9\u0004\u0001\u0015!\u0003j\u0011\u001dy\u0007A1A\u0005\n!Da\u0001\u001d\u0001!\u0002\u0013I\u0007bB9\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007e\u0002\u0001\u000b\u0011B5\t\u000bM\u0004A\u0011\u0002;\t\u000fi\u0004!\u0019!C!w\"9\u0011Q\u0001\u0001!\u0002\u0013a\b\"CA\u0004\u0001\t\u0007I\u0011IA\u0005\u0011!\ti\u0001\u0001Q\u0001\n\u0005-\u0001\"CA\b\u0001\t\u0007I\u0011IA\u0005\u0011!\t\t\u0002\u0001Q\u0001\n\u0005-\u0001\u0002CA\n\u0001\t\u0007I\u0011\t5\t\u000f\u0005U\u0001\u0001)A\u0005S\"9\u0011q\u0003\u0001\u0005R\u0005e\u0001\"CA\u0010\u0001\u0005\u0005I\u0011AA\u0011\u0011%\t)\u0003AI\u0001\n\u0003\t9\u0003C\u0005\u0002>\u0001\t\t\u0011\"\u0011\u0002@!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u00037\u0002\u0011\u0011!C\u0001\u0003;B\u0011\"!\u001b\u0001\u0003\u0003%\t%a\u001b\t\u0013\u0005M\u0004!!A\u0005\u0002\u0005U\u0004\"CA@\u0001\u0005\u0005I\u0011IAA\u000f%\tY+KA\u0001\u0012\u0003\tiK\u0002\u0005)S\u0005\u0005\t\u0012AAX\u0011\u0019I&\u0005\"\u0001\u0002>\"I\u0011q\u0018\u0012\u0002\u0002\u0013\u0015\u0013\u0011\u0019\u0005\n\u0003\u0007\u0014\u0013\u0011!CA\u0003\u000bD\u0011\"!3#\u0003\u0003%\t)a3\t\u0013\u0005]'%!A\u0005\n\u0005e'!\u0002(US2,'B\u0001\u0016,\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u00051j\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u00059z\u0013aA:rY*\u0011\u0001'M\u0001\u0006gB\f'o\u001b\u0006\u0003eM\na!\u00199bG\",'\"\u0001\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u000194HP$N'B\u0011\u0001(O\u0007\u0002S%\u0011!(\u000b\u0002\u000e%><h*^7cKJd\u0015n[3\u0011\u0005ab\u0014BA\u001f*\u0005]\u0019\u0016N_3CCN,GmV5oI><h)\u001e8di&|g\u000eE\u0002@\u0005\u0012k\u0011\u0001\u0011\u0006\u0003\u0003.\nQ\u0001\u001e:fKNL!a\u0011!\u0003\u0013Us\u0017M]=MS.,\u0007C\u0001\u001dF\u0013\t1\u0015F\u0001\u0006FqB\u0014Xm]:j_:\u0004\"\u0001S&\u000e\u0003%S!AS\u0017\u0002\r\u0015\u0014(o\u001c:t\u0013\ta\u0015JA\bRk\u0016\u0014\u00180\u0012:s_J\u001c()Y:f!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0014+\n\u0005U{%\u0001D*fe&\fG.\u001b>bE2,\u0017a\u00022vG.,Go]\u000b\u0002\t\u0006A!-^2lKR\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u00037r\u0003\"\u0001\u000f\u0001\t\u000bY\u001b\u0001\u0019\u0001#\u0015\u0003m\u000bQa\u00195jY\u0012\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003I.\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0003M\u000e\u0014q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u0007EV\u001c7.\u001a;\u0016\u0003%\u0004\"\u0001\u000f6\n\u0005-L#AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016\fqAY;dW\u0016$\b%A\bck\u000e\\W\r\u001e+ie\u0016\u001c\bn\u001c7e\u0003A\u0011WoY6fiRC'/Z:i_2$\u0007%\u0001\u0006ck\u000e\\W\r^*ju\u0016\f1BY;dW\u0016$8+\u001b>fA\u0005\u0011\"-^2lKR\u001cx+\u001b;i!\u0006$G-\u001b8h\u0003M\u0011WoY6fiN<\u0016\u000e\u001e5QC\u0012$\u0017N\\4!\u00039\u0011WoY6fi>3XM\u001d4m_^$\"!\u001e=\u0011\u0005a2\u0018BA<*\u0005\tIe\rC\u0003z\u001f\u0001\u0007A)A\u0001f\u0003M\twm\u001a\"vM\u001a,'/\u0011;ue&\u0014W\u000f^3t+\u0005a\b\u0003B?\u0002\u0002%l\u0011A \u0006\u0003\u007f>\u000b!bY8mY\u0016\u001cG/[8o\u0013\r\t\u0019A \u0002\u0004'\u0016\f\u0018\u0001F1hO\n+hMZ3s\u0003R$(/\u001b2vi\u0016\u001c\b%A\u0007j]&$\u0018.\u00197WC2,Xm]\u000b\u0003\u0003\u0017\u0001B!`A\u0001\t\u0006q\u0011N\\5uS\u0006dg+\u00197vKN\u0004\u0013!E;qI\u0006$X-\u0012=qe\u0016\u001c8/[8og\u0006\u0011R\u000f\u001d3bi\u0016,\u0005\u0010\u001d:fgNLwN\\:!\u0003I)g/\u00197vCR,W\t\u001f9sKN\u001c\u0018n\u001c8\u0002'\u00154\u0018\r\\;bi\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0011\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\rY\u00161\u0004\u0005\u0007\u0003;A\u0002\u0019\u0001#\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR\u00191,a\t\t\u000fYK\u0002\u0013!a\u0001\t\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0015U\r!\u00151F\u0016\u0003\u0003[\u0001B!a\f\u0002:5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$A\u0005v]\u000eDWmY6fI*\u0019\u0011qG(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002<\u0005E\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0011\u0011\t\u0005\r\u0013QJ\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005!A.\u00198h\u0015\t\tY%\u0001\u0003kCZ\f\u0017\u0002BA(\u0003\u000b\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA+!\rq\u0015qK\u0005\u0004\u00033z%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA0\u0003K\u00022ATA1\u0013\r\t\u0019g\u0014\u0002\u0004\u0003:L\b\"CA4;\u0005\u0005\t\u0019AA+\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u000e\t\u0006{\u0006=\u0014qL\u0005\u0004\u0003cr(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u001e\u0002~A\u0019a*!\u001f\n\u0007\u0005mtJA\u0004C_>dW-\u00198\t\u0013\u0005\u001dt$!AA\u0002\u0005}\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002x\u0005\r\u0005\"CA4A\u0005\u0005\t\u0019AA0Q]\u0001\u0011qQAG\u0003\u001f\u000b\u0019*!&\u0002\u001a\u0006m\u0015qTAQ\u0003K\u000b9\u000bE\u00029\u0003\u0013K1!a#*\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!%\u0002i*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015oS\u0001j\u0003\u0005R5wS\u0012,7\u000f\t;iK\u0002\u0012xn^:!M>\u0014\b%Z1dQ\u0002:\u0018N\u001c3po\u0002\u0002\u0018M\u001d;ji&|g\u000eI5oi>\u0004\u0003M\u001c1!EV\u001c7.\u001a;tAI\fgnZ5oO*\u0001\u0003\u0005\t\u0011!A\u0019\u0014x.\u001c\u00112AQ|\u0007%\u0019;![>\u001cH\u000f\t1oA:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!a&\u0002\u0003\u001bQ\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006\t2vG.,Go\u001d\u0011.A\u0005t\u0007%\u001b8uA\u0015D\bO]3tg&|g\u000eI<iS\u000eD\u0007%[:!]Vl'-\u001a:!_\u001a\u0004#-^2lKR\u001c\b\u0005^8!I&4\u0018\u000eZ3!i\",\u0007E]8xg\u0002JgN\f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"UMZ1vYR\u0004c/\u00197vK\u0002J7\u000fI\u0019/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005u\u0015!a&\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\u0005d\u0003E\u0019\u0017!?\u001a+fjQ0)e%\u0002sJV#SA!\u0002\u0016I\u0015+J)&{e\n\t\"ZA\u0005\u0004sJ\u0015#F%\u0002\u0012\u0015\f\t2*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)O\u0005\u000bt\u0005\f\u00113S1\u0002\u0003fJ!2O1\u0002\u0013'\u000b\u0017!Q\u001d\n%g\n\u0017!g%b\u0003\u0005K\u0014Bc\u001db\u0003%M\u0015!i\u0006\u0014\u0007&\u0019\u0017!E&Z$\u0002\t\u0011!A\u0001\u0002\u0003%Q\u0019\nc%\t$\u0002\t\u0011!A\u0001\u0002\u0003%Q\u0019\nc%\t$\u0002\t\u0011!A\u0001\u0002\u0003%Q\u0019\ne%\u0011$\u0002\t\u0011!A\u0001\u0002\u0003%\u0011\u001a\ng%\t$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\r\u0016!\u0002\u001a/a9\u0002\u0014!B4s_V\u0004\u0018EAAU\u000319\u0018N\u001c3po~3WO\\2t\u0003\u0015qE+\u001b7f!\tA$e\u0005\u0003#\u0003c\u001b\u0006CBAZ\u0003s#5,\u0004\u0002\u00026*\u0019\u0011qW(\u0002\u000fI,h\u000e^5nK&!\u00111XA[\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003[\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0003\nQ!\u00199qYf$2aWAd\u0011\u00151V\u00051\u0001E\u0003\u001d)h.\u00199qYf$B!!4\u0002TB!a*a4E\u0013\r\t\tn\u0014\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005Ug%!AA\u0002m\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0007\u0003BA\"\u0003;LA!a8\u0002F\t1qJ\u00196fGR\u0004")
public class NTile
extends RowNumberLike
implements SizeBasedWindowFunction,
UnaryLike<Expression>,
QueryErrorsBase {
    private final Expression buckets;
    private final AttributeReference bucket;
    private final AttributeReference bucketThreshold;
    private final AttributeReference bucketSize;
    private final AttributeReference bucketsWithPadding;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<Expression> initialValues;
    private final Seq<Expression> updateExpressions;
    private final AttributeReference evaluateExpression;
    private transient Seq<Expression> children;
    private final AttributeReference n;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(NTile nTile) {
        return NTile$.MODULE$.unapply(nTile);
    }

    public static <A> Function1<Expression, A> andThen(Function1<NTile, A> function1) {
        return NTile$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, NTile> compose(Function1<A, Expression> function1) {
        return NTile$.MODULE$.compose(function1);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        NTile nTile = this;
        synchronized (nTile) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public AttributeReference n() {
        return this.n;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$SizeBasedWindowFunction$_setter_$n_$eq(AttributeReference x$1) {
        this.n = x$1;
    }

    public Expression buckets() {
        return this.buckets;
    }

    @Override
    public Expression child() {
        return this.buckets();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.buckets().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)"buckets"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.buckets().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)this.toSQLExpr(this.buckets()))}))));
        }
        DataType dataType = this.buckets().dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)this.toSQLType((AbstractDataType)IntegerType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)this.toSQLExpr(this.buckets())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)this.toSQLType((AbstractDataType)this.buckets().dataType()))}))));
        }
        int i = BoxesRunTime.unboxToInt((Object)this.buckets().eval(this.buckets().eval$default$1()));
        if (i > 0) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"buckets"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)new StringBuilder(5).append("(0, ").append(Integer.MAX_VALUE).append("]").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)this.toSQLValue(BoxesRunTime.boxToInteger((int)i), (DataType)IntegerType$.MODULE$))}))));
    }

    private AttributeReference bucket() {
        return this.bucket;
    }

    private AttributeReference bucketThreshold() {
        return this.bucketThreshold;
    }

    private AttributeReference bucketSize() {
        return this.bucketSize;
    }

    private AttributeReference bucketsWithPadding() {
        return this.bucketsWithPadding;
    }

    private If bucketOverflow(Expression e) {
        return new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.rowNumber()).$greater$eq(this.bucketThreshold())), e, this.zero());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<Expression> initialValues() {
        return this.initialValues;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return this.updateExpressions;
    }

    @Override
    public AttributeReference evaluateExpression() {
        return this.evaluateExpression;
    }

    @Override
    public NTile withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public NTile copy(Expression buckets) {
        return new NTile(buckets);
    }

    public Expression copy$default$1() {
        return this.buckets();
    }

    @Override
    public String productPrefix() {
        return "NTile";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.buckets();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NTile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        NTile nTile = (NTile)x$1;
        Expression expression = this.buckets();
        Expression expression2 = nTile.buckets();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!nTile.canEqual(this)) return false;
        return true;
    }

    public NTile(Expression buckets) {
        this.buckets = buckets;
        SizeBasedWindowFunction.$init$(this);
        UnaryLike.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        String x$1 = "bucket";
        IntegerType$ x$2 = IntegerType$.MODULE$;
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        this.bucket = new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
        String x$7 = "bucketThreshold";
        IntegerType$ x$8 = IntegerType$.MODULE$;
        boolean x$9 = false;
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, (DataType)x$8, x$9, x$10);
        Seq<String> x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, (DataType)x$8, x$9, x$10);
        this.bucketThreshold = new AttributeReference(x$7, (DataType)x$8, x$9, x$10, x$11, x$12);
        String x$13 = "bucketSize";
        IntegerType$ x$14 = IntegerType$.MODULE$;
        boolean x$15 = false;
        Metadata x$16 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, (DataType)x$14, x$15, x$16);
        Seq<String> x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, (DataType)x$14, x$15, x$16);
        this.bucketSize = new AttributeReference(x$13, (DataType)x$14, x$15, x$16, x$17, x$18);
        String x$19 = "bucketsWithPadding";
        IntegerType$ x$20 = IntegerType$.MODULE$;
        boolean x$21 = false;
        Metadata x$22 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$23 = AttributeReference$.MODULE$.apply$default$5(x$19, (DataType)x$20, x$21, x$22);
        Seq<String> x$24 = AttributeReference$.MODULE$.apply$default$6(x$19, (DataType)x$20, x$21, x$22);
        this.bucketsWithPadding = new AttributeReference(x$19, (DataType)x$20, x$21, x$22, x$23, x$24);
        this.aggBufferAttributes = (Seq)new .colon.colon((Object)this.rowNumber(), (List)new .colon.colon((Object)this.bucket(), (List)new .colon.colon((Object)this.bucketThreshold(), (List)new .colon.colon((Object)this.bucketSize(), (List)new .colon.colon((Object)this.bucketsWithPadding(), (List)Nil$.MODULE$)))));
        this.initialValues = (Seq)new .colon.colon((Object)this.zero(), (List)new .colon.colon((Object)this.zero(), (List)new .colon.colon((Object)this.zero(), (List)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).div(buckets)).cast((DataType)IntegerType$.MODULE$), (List)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.DslExpression(this.n()).$percent(buckets)).cast((DataType)IntegerType$.MODULE$), (List)Nil$.MODULE$)))));
        this.updateExpressions = (Seq)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(this.rowNumber()).$plus(this.one()), (List)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(this.bucket()).$plus(this.bucketOverflow(this.one())), (List)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(this.bucketThreshold()).$plus(this.bucketOverflow(package$expressions$.MODULE$.DslExpression(this.bucketSize()).$plus(new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.bucket()).$less(this.bucketsWithPadding())), this.one(), this.zero())))), (List)new .colon.colon((Object)NoOp$.MODULE$, (List)new .colon.colon((Object)NoOp$.MODULE$, (List)Nil$.MODULE$)))));
        this.evaluateExpression = this.bucket();
    }

    public NTile() {
        this(Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

