/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.sources;

import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;

public final class RateStreamProvider$ {
    public static final RateStreamProvider$ MODULE$ = new RateStreamProvider$();
    private static final StructType SCHEMA = new StructType((StructField[])((Object[])new StructField[]{new StructField("timestamp", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("value", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
    private static final int VERSION = 1;
    private static final String NUM_PARTITIONS = "numPartitions";
    private static final String ROWS_PER_SECOND = "rowsPerSecond";
    private static final String RAMP_UP_TIME = "rampUpTime";

    public StructType SCHEMA() {
        return SCHEMA;
    }

    public int VERSION() {
        return VERSION;
    }

    public String NUM_PARTITIONS() {
        return NUM_PARTITIONS;
    }

    public String ROWS_PER_SECOND() {
        return ROWS_PER_SECOND;
    }

    public String RAMP_UP_TIME() {
        return RAMP_UP_TIME;
    }

    public long valueAtSecond(long seconds, long rowsPerSecond, long rampUpTimeSeconds) {
        long l;
        long speedDeltaPerSecond = rowsPerSecond / (rampUpTimeSeconds + 1L);
        if (seconds <= rampUpTimeSeconds) {
            l = seconds % 2L == 1L ? (seconds + 1L) / 2L * speedDeltaPerSecond * seconds : seconds / 2L * speedDeltaPerSecond * (seconds + 1L);
        } else {
            long rampUpPart = this.valueAtSecond(rampUpTimeSeconds, rowsPerSecond, rampUpTimeSeconds);
            l = rampUpPart + (seconds - rampUpTimeSeconds) * rowsPerSecond;
        }
        return l;
    }

    private RateStreamProvider$() {
    }
}

