/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.ErrorMessageFormat$;
import org.apache.spark.JobArtifactSet$;
import org.apache.spark.JobArtifactState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkThrowable;
import org.apache.spark.SparkThrowableHelper$;
import org.apache.spark.internal.config.Tests$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.execution.ExplainMode$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlanInfo$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SQLExecution$ {
    public static final SQLExecution$ MODULE$ = new SQLExecution$();
    private static final String EXECUTION_ID_KEY = "spark.sql.execution.id";
    private static final String EXECUTION_ROOT_ID_KEY = "spark.sql.execution.root.id";
    private static final AtomicLong _nextExecutionId = new AtomicLong(0L);
    private static final ConcurrentHashMap<Object, QueryExecution> executionIdToQueryExecution = new ConcurrentHashMap();
    private static final boolean testing = scala.sys.package$.MODULE$.props().contains(Tests$.MODULE$.IS_TESTING().key());

    public String EXECUTION_ID_KEY() {
        return EXECUTION_ID_KEY;
    }

    public String EXECUTION_ROOT_ID_KEY() {
        return EXECUTION_ROOT_ID_KEY;
    }

    private AtomicLong _nextExecutionId() {
        return _nextExecutionId;
    }

    private long nextExecutionId() {
        return this._nextExecutionId().getAndIncrement();
    }

    private ConcurrentHashMap<Object, QueryExecution> executionIdToQueryExecution() {
        return executionIdToQueryExecution;
    }

    public QueryExecution getQueryExecution(long executionId) {
        return this.executionIdToQueryExecution().get(BoxesRunTime.boxToLong((long)executionId));
    }

    private boolean testing() {
        return testing;
    }

    public void checkSQLExecutionId(SparkSession sparkSession) {
        SparkContext sc = sparkSession.sparkContext();
        if (this.testing() && sc.getLocalProperty(this.EXECUTION_ID_KEY()) == null) {
            throw new IllegalStateException("Execution ID should be set");
        }
    }

    public <T> T withNewExecutionId(QueryExecution queryExecution, Option<String> name, Function0<T> body) {
        return queryExecution.sparkSession().withActive((Function0 & Serializable)() -> {
            Object t;
            SparkSession sparkSession = queryExecution.sparkSession();
            SparkContext sc = sparkSession.sparkContext();
            String oldExecutionId = sc.getLocalProperty(MODULE$.EXECUTION_ID_KEY());
            long executionId = MODULE$.nextExecutionId();
            sc.setLocalProperty(MODULE$.EXECUTION_ID_KEY(), Long.toString(executionId));
            if (sc.getLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY()) == null) {
                sc.setLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY(), Long.toString(executionId));
            }
            long rootExecutionId = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(sc.getLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY())));
            MODULE$.executionIdToQueryExecution().put(BoxesRunTime.boxToLong((long)executionId), queryExecution);
            try {
                CallSite callSite = sc.getCallSite();
                int truncateLength = BoxesRunTime.unboxToInt((Object)sc.conf().get(StaticSQLConf$.MODULE$.SQL_EVENT_TRUNCATE_LENGTH()));
                String desc = (String)Option$.MODULE$.apply((Object)sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION())).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SQLExecution$.$anonfun$withNewExecutionId$2(truncateLength, x$1))).map((Function1 & Serializable)sqlStr -> {
                    String redactedStr = Utils$.MODULE$.redact(sparkSession.sessionState().conf().stringRedactionPattern(), sqlStr);
                    return redactedStr.substring(0, Math.min(truncateLength, redactedStr.length()));
                }).getOrElse((Function0 & Serializable)() -> callSite.shortForm());
                ExplainMode planDescriptionMode = ExplainMode$.MODULE$.fromString(sparkSession.sessionState().conf().uiExplainMode());
                Map globalConfigs = Predef$.MODULE$.wrapRefArray((Object[])sparkSession.sharedState().conf().getAll()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Map modifiedConfigs = (Map)sparkSession.sessionState().conf().getAllConfs().filterNot((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SQLExecution$.$anonfun$withNewExecutionId$5(globalConfigs, x0$1)));
                Map redactedConfigs = sparkSession.sessionState().conf().redactOptions(modifiedConfigs);
                t = MODULE$.withSQLConfPropagated(sparkSession, (Function0 & Serializable)() -> {
                    Object object;
                    None$ ex = None$.MODULE$;
                    long startTime = System.nanoTime();
                    try {
                        try {
                            sc.listenerBus().post((SparkListenerEvent)new SparkListenerSQLExecutionStart(executionId, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)rootExecutionId)), desc, callSite.longForm(), queryExecution.explainString(planDescriptionMode), SparkPlanInfo$.MODULE$.fromSparkPlan(queryExecution.executedPlan()), System.currentTimeMillis(), (Map<String, String>)redactedConfigs, (Set<String>)sc.getJobTags()));
                            object = body.apply();
                        }
                        catch (Throwable e) {
                            ex = new Some((Object)e);
                            throw e;
                        }
                    }
                    finally {
                        long endTime = System.nanoTime();
                        Option errorMessage = ex.map((Function1 & Serializable)x0$2 -> {
                            String string;
                            Throwable throwable = x0$2;
                            if (throwable instanceof SparkThrowable) {
                                Throwable throwable2 = throwable;
                                string = SparkThrowableHelper$.MODULE$.getMessage(throwable2, ErrorMessageFormat$.MODULE$.PRETTY());
                            } else {
                                string = Utils$.MODULE$.exceptionString(throwable);
                            }
                            return string;
                        });
                        SparkListenerSQLExecutionEnd event = new SparkListenerSQLExecutionEnd(executionId, System.currentTimeMillis(), (Option<String>)errorMessage.orElse((Function0 & Serializable)() -> new Some((Object)"")));
                        event.executionName_$eq(name);
                        event.duration_$eq(endTime - startTime);
                        event.qe_$eq(queryExecution);
                        event.executionFailure_$eq((Option<Throwable>)ex);
                        sc.listenerBus().post((SparkListenerEvent)event);
                    }
                    return object;
                });
            }
            finally {
                MODULE$.executionIdToQueryExecution().remove(BoxesRunTime.boxToLong((long)executionId));
                sc.setLocalProperty(MODULE$.EXECUTION_ID_KEY(), oldExecutionId);
                String string = sc.getLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY());
                String string2 = Long.toString(executionId);
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    sc.setLocalProperty(MODULE$.EXECUTION_ROOT_ID_KEY(), null);
                }
            }
            return t;
        });
    }

    public <T> Option<String> withNewExecutionId$default$2() {
        return None$.MODULE$;
    }

    public <T> T withExecutionId(SparkSession sparkSession, String executionId, Function0<T> body) {
        SparkContext sc = sparkSession.sparkContext();
        String oldExecutionId = sc.getLocalProperty(this.EXECUTION_ID_KEY());
        return this.withSQLConfPropagated(sparkSession, (Function0 & Serializable)() -> {
            Object object;
            try {
                sc.setLocalProperty(MODULE$.EXECUTION_ID_KEY(), executionId);
                object = body.apply();
            }
            finally {
                sc.setLocalProperty(MODULE$.EXECUTION_ID_KEY(), oldExecutionId);
            }
            return object;
        });
    }

    public <T> T withSQLConfPropagated(SparkSession sparkSession, Function0<T> body) {
        Object object;
        SparkContext sc = sparkSession.sparkContext();
        Map allConfigs = sparkSession.sessionState().conf().getAllConfs();
        Map originalLocalProps = (Map)allConfigs.collect((PartialFunction)new Serializable(sc){
            private static final long serialVersionUID = 0L;
            private final SparkContext sc$3;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String key = (String)A1._1();
                    String value = (String)A1._2();
                    if (key.startsWith("spark")) {
                        String originalValue = this.sc$3.getLocalProperty(key);
                        this.sc$3.setLocalProperty(key, value);
                        object = new Tuple2((Object)key, (Object)originalValue);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, String> x1) {
                String key;
                Tuple2<String, String> tuple2 = x1;
                boolean bl = tuple2 != null && (key = (String)tuple2._1()).startsWith("spark");
                return bl;
            }
            {
                this.sc$3 = sc$3;
            }
        });
        try {
            object = body.apply();
        }
        finally {
            originalLocalProps.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SQLExecution$.$anonfun$withSQLConfPropagated$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
                SQLExecution$.$anonfun$withSQLConfPropagated$2(sc, x$2);
                return BoxedUnit.UNIT;
            });
        }
        return (T)object;
    }

    public <T> Future<T> withThreadLocalCaptured(SparkSession sparkSession, ExecutorService exec, Function0<T> body) {
        SparkSession activeSession = sparkSession;
        SparkContext sc = sparkSession.sparkContext();
        Properties localProps = Utils$.MODULE$.cloneProperties(sc.getLocalProperties());
        JobArtifactState artifactState = (JobArtifactState)JobArtifactSet$.MODULE$.getCurrentJobArtifactState().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return exec.submit(() -> JobArtifactSet$.MODULE$.withActiveJobArtifactState(artifactState, (Function0 & Serializable)() -> {
            Option<SparkSession> originalSession = SparkSession$.MODULE$.getActiveSession();
            Properties originalLocalProps = sc.getLocalProperties();
            SparkSession$.MODULE$.setActiveSession(activeSession);
            sc.setLocalProperties(localProps);
            Object res = body.apply();
            sc.setLocalProperties(originalLocalProps);
            if (originalSession.nonEmpty()) {
                SparkSession$.MODULE$.setActiveSession((SparkSession)originalSession.get());
            } else {
                SparkSession$.MODULE$.clearActiveSession();
            }
            return res;
        }));
    }

    public static final /* synthetic */ boolean $anonfun$withNewExecutionId$2(int truncateLength$1, String x$1) {
        return truncateLength$1 > 0;
    }

    public static final /* synthetic */ boolean $anonfun$withNewExecutionId$5(Map globalConfigs$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        boolean bl = key.startsWith(package$.MODULE$.SPARK_DRIVER_PREFIX()) || key.startsWith(package$.MODULE$.SPARK_EXECUTOR_PREFIX()) || globalConfigs$1.get((Object)key).contains((Object)value);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$withSQLConfPropagated$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$withSQLConfPropagated$2(SparkContext sc$3, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        sc$3.setLocalProperty(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SQLExecution$() {
    }
}

