/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.ptf.MultiValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.SingleValueBoundaryScanner;

public abstract class ValueBoundaryScanner {
    BoundaryDef start;
    BoundaryDef end;

    public ValueBoundaryScanner(BoundaryDef start, BoundaryDef end) {
        this.start = start;
        this.end = end;
    }

    public abstract int computeStart(int var1, PTFPartition var2) throws HiveException;

    public abstract int computeEnd(int var1, PTFPartition var2) throws HiveException;

    public static ValueBoundaryScanner getScanner(WindowFrameDef winFrameDef) throws HiveException {
        OrderDef orderDef = winFrameDef.getOrderDef();
        int numOrders = orderDef.getExpressions().size();
        if (numOrders != 1) {
            return new MultiValueBoundaryScanner(winFrameDef.getStart(), winFrameDef.getEnd(), orderDef);
        }
        return SingleValueBoundaryScanner.getScanner(winFrameDef.getStart(), winFrameDef.getEnd(), orderDef);
    }
}

