/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.ArrayTransform;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflowInTableInsert;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.MapFromArrays;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable$;
import org.apache.spark.sql.catalyst.expressions.objects.AssertNotNull;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$StoreAssignmentPolicy$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public final class TableOutputResolver$ {
    public static final TableOutputResolver$ MODULE$ = new TableOutputResolver$();

    public LogicalPlan resolveOutputColumns(String tableName, Seq<Attribute> expected, LogicalPlan query, boolean byName, SQLConf conf, boolean supportColDefaultValue) {
        Seq<NamedExpression> seq;
        Seq actualExpectedCols = (Seq)expected.map((Function1 & Serializable)attr -> attr.withDataType((DataType)CharVarcharUtils$.MODULE$.getRawType(attr.metadata()).getOrElse((Function0 & Serializable)() -> attr.dataType())));
        if (actualExpectedCols.size() < query.output().size()) {
            throw QueryCompilationErrors$.MODULE$.cannotWriteTooManyColumnsToTableError(tableName, (Seq<String>)((Seq)actualExpectedCols.map((Function1 & Serializable)x$1 -> x$1.name())), query.output());
        }
        ArrayBuffer errors = new ArrayBuffer();
        if (byName) {
            String x$12 = tableName;
            Seq<Attribute> x$22 = query.output();
            Seq x$32 = actualExpectedCols;
            SQLConf x$42 = conf;
            Function1 & Serializable x$52 = (Function1 & Serializable)x$2 -> {
                errors.$plus$eq((Object)x$2);
                return BoxedUnit.UNIT;
            };
            boolean x$6 = supportColDefaultValue;
            Seq<String> x$7 = this.reorderColumnsByName$default$6();
            seq = this.reorderColumnsByName(x$12, x$22, (Seq<Attribute>)x$32, x$42, (Function1<String, BoxedUnit>)x$52, x$7, x$6);
        } else {
            if (actualExpectedCols.size() > query.output().size()) {
                throw QueryCompilationErrors$.MODULE$.cannotWriteNotEnoughColumnsToTableError(tableName, (Seq<String>)((Seq)actualExpectedCols.map((Function1 & Serializable)x$3 -> x$3.name())), query.output());
            }
            seq = this.resolveColumnsByPosition(tableName, query.output(), (Seq<Attribute>)actualExpectedCols, conf, (Function1<String, BoxedUnit>)(Function1 & Serializable)x$4 -> {
                errors.$plus$eq((Object)x$4);
                return BoxedUnit.UNIT;
            }, this.resolveColumnsByPosition$default$6());
        }
        Seq<NamedExpression> resolved2 = seq;
        Seq<NamedExpression> seq2 = errors.nonEmpty() ? this.resolveColumnsByPosition(tableName, query.output(), (Seq<Attribute>)actualExpectedCols, conf, (Function1<String, BoxedUnit>)(Function1 & Serializable)x$5 -> {
            errors.$plus$eq((Object)x$5);
            return BoxedUnit.UNIT;
        }, this.resolveColumnsByPosition$default$6()) : BoxedUnit.UNIT;
        Seq<NamedExpression> seq3 = resolved2;
        Seq<Attribute> seq4 = query.output();
        return !(seq3 != null ? !seq3.equals(seq4) : seq4 != null) ? query : new Project(resolved2, query);
    }

    public boolean resolveOutputColumns$default$6() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression resolveUpdate(String tableName, Expression value, Attribute col, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        DataType colType;
        DataType valueType;
        Tuple2 tuple2 = new Tuple2((Object)value.dataType(), (Object)col.dataType());
        if (tuple2 != null && DataType$.MODULE$.equalsIgnoreCompatibleNullability(valueType = (DataType)tuple2._1(), colType = (DataType)tuple2._2())) {
            boolean canWriteExpr = this.canWrite(tableName, valueType, colType, true, conf, addError, colPath);
            return canWriteExpr ? this.checkNullability(value, col, conf, colPath) : value;
        }
        if (tuple2 != null) {
            DataType valueType2 = (DataType)tuple2._1();
            DataType colType2 = (DataType)tuple2._2();
            if (valueType2 instanceof StructType) {
                StructType structType = (StructType)valueType2;
                if (colType2 instanceof StructType) {
                    StructType structType2 = (StructType)colType2;
                    Option<NamedExpression> resolvedValue = this.resolveStructType(tableName, value, structType, col, structType2, true, conf, addError, colPath);
                    return (Expression)resolvedValue.getOrElse((Function0 & Serializable)() -> value);
                }
            }
        }
        if (tuple2 != null) {
            DataType valueType3 = (DataType)tuple2._1();
            DataType colType3 = (DataType)tuple2._2();
            if (valueType3 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)valueType3;
                if (colType3 instanceof ArrayType) {
                    ArrayType arrayType2 = (ArrayType)colType3;
                    Option<NamedExpression> resolvedValue = this.resolveArrayType(tableName, value, arrayType, col, arrayType2, true, conf, addError, colPath);
                    return (Expression)resolvedValue.getOrElse((Function0 & Serializable)() -> value);
                }
            }
        }
        if (tuple2 == null) return this.checkUpdate(tableName, value, col, conf, addError, colPath);
        DataType valueType4 = (DataType)tuple2._1();
        DataType colType4 = (DataType)tuple2._2();
        if (!(valueType4 instanceof MapType)) return this.checkUpdate(tableName, value, col, conf, addError, colPath);
        MapType mapType = (MapType)valueType4;
        if (!(colType4 instanceof MapType)) return this.checkUpdate(tableName, value, col, conf, addError, colPath);
        MapType mapType2 = (MapType)colType4;
        Option<NamedExpression> resolvedValue = this.resolveMapType(tableName, value, mapType, col, mapType2, true, conf, addError, colPath);
        return (Expression)resolvedValue.getOrElse((Function0 & Serializable)() -> value);
    }

    private Expression checkUpdate(String tableName, Expression value, Attribute attr, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        Expression expression;
        boolean attrTypeHasCharVarchar = CharVarcharUtils$.MODULE$.hasCharVarchar(attr.dataType());
        DataType attrTypeWithoutCharVarchar = attrTypeHasCharVarchar ? CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(attr.dataType()) : attr.dataType();
        boolean canWriteValue = this.canWrite(tableName, value.dataType(), attrTypeWithoutCharVarchar, true, conf, addError, colPath);
        if (canWriteValue) {
            Expression exprWithStrLenCheck;
            Expression nullCheckedValue = this.checkNullability(value, attr, conf, colPath);
            Expression casted = this.cast(nullCheckedValue, attrTypeWithoutCharVarchar, conf, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted());
            Expression x$1 = exprWithStrLenCheck = conf.charVarcharAsString() || !attrTypeHasCharVarchar ? casted : CharVarcharUtils$.MODULE$.stringLengthCheck(casted, attr.dataType());
            String x$2 = attr.name();
            Some x$3 = new Some((Object)attr.metadata());
            ExprId x$4 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq<String> x$5 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            expression = new Alias(x$1, x$2, x$4, x$5, (Option<Metadata>)x$3, x$6);
        } else {
            expression = value;
        }
        return expression;
    }

    private boolean canWrite(String tableName, DataType valueType, DataType expectedType, boolean byName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        boolean bl;
        Enumeration.Value value = conf.storeAssignmentPolicy();
        Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.STRICT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
            Enumeration.Value value5 = value;
            bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        boolean bl2 = bl ? DataTypeUtils$.MODULE$.canWrite(tableName, valueType, expectedType, byName, conf.resolver(), CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted(), conf.storeAssignmentPolicy(), addError) : true;
        return bl2;
    }

    private Seq<NamedExpression> reorderColumnsByName(String tableName, Seq<NamedExpression> inputCols, Seq<Attribute> expectedCols, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath, boolean fillDefaultValue) {
        Nil$ nil$;
        HashSet matchedCols = HashSet$.MODULE$.empty();
        Seq reordered = (Seq)expectedCols.flatMap(arg_0 -> TableOutputResolver$.$anonfun$reorderColumnsByName$1(inputCols, conf, colPath, fillDefaultValue, tableName, matchedCols, addError, arg_0));
        if (reordered.length() == expectedCols.length()) {
            if (matchedCols.size() < inputCols.length()) {
                String extraCols = ((IterableOnceOps)((IterableOps)inputCols.filterNot((Function1 & Serializable)col -> BoxesRunTime.boxToBoolean((boolean)matchedCols.contains((Object)col.name())))).map((Function1 & Serializable)col -> String.valueOf(TypeUtils$.MODULE$.toSQLId(col.name())))).mkString(", ");
                if (colPath.isEmpty()) {
                    throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableExtraColumnsError(tableName, extraCols);
                }
                throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableExtraStructFieldsError(tableName, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted(), extraCols);
            }
            nil$ = reordered;
        } else {
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    private Seq<String> reorderColumnsByName$default$6() {
        return package$.MODULE$.Nil();
    }

    private boolean reorderColumnsByName$default$7() {
        return false;
    }

    private Seq<NamedExpression> resolveColumnsByPosition(String tableName, Seq<NamedExpression> inputCols, Seq<Attribute> expectedCols, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        if (inputCols.size() > expectedCols.size()) {
            String extraColsStr = ((IterableOnceOps)((IterableOps)inputCols.takeRight(inputCols.size() - expectedCols.size())).map((Function1 & Serializable)col -> TypeUtils$.MODULE$.toSQLId(col.name()))).mkString(", ");
            if (colPath.isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.cannotWriteTooManyColumnsToTableError(tableName, (Seq<String>)((Seq)expectedCols.map((Function1 & Serializable)x$6 -> x$6.name())), (Seq<Attribute>)((Seq)inputCols.map((Function1 & Serializable)x$7 -> x$7.toAttribute())));
            }
            throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableExtraStructFieldsError(tableName, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted(), extraColsStr);
        }
        if (inputCols.size() < expectedCols.size()) {
            String missingColsStr = ((IterableOnceOps)((IterableOps)expectedCols.takeRight(expectedCols.size() - inputCols.size())).map((Function1 & Serializable)col -> TypeUtils$.MODULE$.toSQLId(col.name()))).mkString(", ");
            if (colPath.isEmpty()) {
                throw QueryCompilationErrors$.MODULE$.cannotWriteNotEnoughColumnsToTableError(tableName, (Seq<String>)((Seq)expectedCols.map((Function1 & Serializable)x$8 -> x$8.name())), (Seq<Attribute>)((Seq)inputCols.map((Function1 & Serializable)x$9 -> x$9.toAttribute())));
            }
            throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableStructMissingFieldsError(tableName, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(colPath).quoted(), missingColsStr);
        }
        return (Seq)((IterableOps)inputCols.zip(expectedCols)).flatMap(arg_0 -> TableOutputResolver$.$anonfun$resolveColumnsByPosition$7(colPath, tableName, conf, addError, arg_0));
    }

    private Seq<String> resolveColumnsByPosition$default$6() {
        return package$.MODULE$.Nil();
    }

    public Expression checkNullability(Expression input, Attribute expected, SQLConf conf, Seq<String> colPath) {
        return this.requiresNullChecks(input, expected, conf) ? new AssertNotNull(input, colPath) : input;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean requiresNullChecks(Expression input, Attribute attr, SQLConf conf) {
        if (!input.nullable()) return false;
        if (attr.nullable()) return false;
        Enumeration.Value value = conf.storeAssignmentPolicy();
        Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.LEGACY();
        if (value == null) {
            if (value2 == null) return false;
            return true;
        } else if (value.equals(value2)) return false;
        return true;
    }

    private Option<NamedExpression> resolveStructType(String tableName, Expression input, StructType inputType, Attribute expected, StructType expectedType, boolean byName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        None$ none$;
        Seq<NamedExpression> resolved2;
        Expression nullCheckedInput = this.checkNullability(input, expected, conf, colPath);
        Seq fields = (Seq)((IterableOps)inputType.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField f = (StructField)tuple2._1();
            int i = tuple2._2$mcI$sp();
            GetStructField x$1 = new GetStructField(nullCheckedInput, i, (Option<String>)new Some((Object)f.name()));
            String x$2 = f.name();
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            Alias alias = new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
            return alias;
        });
        Seq<NamedExpression> seq = resolved2 = byName ? this.reorderColumnsByName(tableName, (Seq<NamedExpression>)fields, DataTypeUtils$.MODULE$.toAttributes(expectedType), conf, addError, colPath, this.reorderColumnsByName$default$7()) : this.resolveColumnsByPosition(tableName, (Seq<NamedExpression>)fields, DataTypeUtils$.MODULE$.toAttributes(expectedType), conf, addError, colPath);
        if (resolved2.length() == expectedType.length()) {
            Expression res;
            CreateNamedStruct struct = CreateStruct$.MODULE$.apply(resolved2);
            Expression x$7 = res = nullCheckedInput.nullable() ? new If(new IsNull(nullCheckedInput), new Literal(null, (DataType)struct.dataType()), struct) : struct;
            String x$8 = expected.name();
            ExprId x$9 = Alias$.MODULE$.apply$default$3(x$7, x$8);
            Seq<String> x$10 = Alias$.MODULE$.apply$default$4(x$7, x$8);
            Option<Metadata> x$11 = Alias$.MODULE$.apply$default$5(x$7, x$8);
            Seq<String> x$12 = Alias$.MODULE$.apply$default$6(x$7, x$8);
            Some some = new Some((Object)new Alias(x$7, x$8, x$9, x$10, x$11, x$12));
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<NamedExpression> resolveArrayType(String tableName, Expression input, ArrayType inputType, Attribute expected, ArrayType expectedType, boolean byName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        None$ none$;
        Seq<NamedExpression> res;
        Expression nullCheckedInput = this.checkNullability(input, expected, conf, colPath);
        NamedLambdaVariable param = new NamedLambdaVariable("element", inputType.elementType(), inputType.containsNull(), NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        String x$1 = "element";
        DataType x$2 = expectedType.elementType();
        boolean x$3 = expectedType.containsNull();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("element", x$2, x$3, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("element", x$2, x$3, x$4);
        AttributeReference fakeAttr = new AttributeReference("element", x$2, x$3, x$4, x$5, x$6);
        Seq<NamedExpression> seq = res = byName ? this.reorderColumnsByName(tableName, (Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{param}))), (Seq<Attribute>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{fakeAttr}))), conf, addError, colPath, this.reorderColumnsByName$default$7()) : this.resolveColumnsByPosition(tableName, (Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{param}))), (Seq<Attribute>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{fakeAttr}))), conf, addError, colPath);
        if (res.length() == 1) {
            Object object = res.head();
            NamedLambdaVariable namedLambdaVariable = param;
            if (!(object != null ? !object.equals(namedLambdaVariable) : namedLambdaVariable != null)) {
                Expression x$7 = nullCheckedInput;
                String x$8 = expected.name();
                Seq x$9 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{CharVarcharUtils$.MODULE$.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY()}));
                ExprId x$10 = Alias$.MODULE$.apply$default$3(x$7, x$8);
                Seq<String> x$11 = Alias$.MODULE$.apply$default$4(x$7, x$8);
                Option<Metadata> x$12 = Alias$.MODULE$.apply$default$5(x$7, x$8);
                Some some = new Some((Object)new Alias(x$7, x$8, x$10, x$11, x$12, (Seq<String>)x$9));
                none$ = some;
            } else {
                LambdaFunction func = new LambdaFunction((Expression)res.head(), (Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{param}))), LambdaFunction$.MODULE$.apply$default$3());
                ArrayTransform x$13 = new ArrayTransform(nullCheckedInput, func);
                String x$14 = expected.name();
                ExprId x$15 = Alias$.MODULE$.apply$default$3(x$13, x$14);
                Seq<String> x$16 = Alias$.MODULE$.apply$default$4(x$13, x$14);
                Option<Metadata> x$17 = Alias$.MODULE$.apply$default$5(x$13, x$14);
                Seq<String> x$18 = Alias$.MODULE$.apply$default$6(x$13, x$14);
                Some some = new Some((Object)new Alias(x$13, x$14, x$15, x$16, x$17, x$18));
                none$ = some;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Option<NamedExpression> resolveMapType(String tableName, Expression input, MapType inputType, Attribute expected, MapType expectedType, boolean byName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        None$ none$;
        Seq<NamedExpression> resValue;
        Expression nullCheckedInput = this.checkNullability(input, expected, conf, colPath);
        NamedLambdaVariable keyParam = new NamedLambdaVariable("key", inputType.keyType(), false, NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        String x$1 = "key";
        DataType x$2 = expectedType.keyType();
        boolean x$3 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("key", x$2, false, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("key", x$2, false, x$4);
        AttributeReference fakeKeyAttr = new AttributeReference("key", x$2, false, x$4, x$5, x$6);
        Seq<NamedExpression> resKey = byName ? this.reorderColumnsByName(tableName, (Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{keyParam}))), (Seq<Attribute>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{fakeKeyAttr}))), conf, addError, colPath, this.reorderColumnsByName$default$7()) : this.resolveColumnsByPosition(tableName, (Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{keyParam}))), (Seq<Attribute>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{fakeKeyAttr}))), conf, addError, colPath);
        NamedLambdaVariable valueParam = new NamedLambdaVariable("value", inputType.valueType(), inputType.valueContainsNull(), NamedLambdaVariable$.MODULE$.apply$default$4(), NamedLambdaVariable$.MODULE$.apply$default$5());
        String x$7 = "value";
        DataType x$8 = expectedType.valueType();
        boolean x$9 = expectedType.valueContainsNull();
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5("value", x$8, x$9, x$10);
        Seq<String> x$12 = AttributeReference$.MODULE$.apply$default$6("value", x$8, x$9, x$10);
        AttributeReference fakeValueAttr = new AttributeReference("value", x$8, x$9, x$10, x$11, x$12);
        Seq<NamedExpression> seq = resValue = byName ? this.reorderColumnsByName(tableName, (Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{valueParam}))), (Seq<Attribute>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{fakeValueAttr}))), conf, addError, colPath, this.reorderColumnsByName$default$7()) : this.resolveColumnsByPosition(tableName, (Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{valueParam}))), (Seq<Attribute>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AttributeReference[]{fakeValueAttr}))), conf, addError, colPath);
        if (resKey.length() == 1 && resValue.length() == 1) {
            Expression expression;
            Expression expression2;
            Object object = resKey.head();
            NamedLambdaVariable namedLambdaVariable = keyParam;
            if (!(object != null ? !object.equals(namedLambdaVariable) : namedLambdaVariable != null)) {
                Object object2 = resValue.head();
                NamedLambdaVariable namedLambdaVariable2 = valueParam;
                if (!(object2 != null ? !object2.equals(namedLambdaVariable2) : namedLambdaVariable2 != null)) {
                    Expression x$13 = nullCheckedInput;
                    String x$14 = expected.name();
                    Seq x$15 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{CharVarcharUtils$.MODULE$.CHAR_VARCHAR_TYPE_STRING_METADATA_KEY()}));
                    ExprId x$16 = Alias$.MODULE$.apply$default$3(x$13, x$14);
                    Seq<String> x$17 = Alias$.MODULE$.apply$default$4(x$13, x$14);
                    Option<Metadata> x$18 = Alias$.MODULE$.apply$default$5(x$13, x$14);
                    Some some = new Some((Object)new Alias(x$13, x$14, x$16, x$17, x$18, (Seq<String>)x$15));
                    none$ = some;
                    return none$;
                }
            }
            Object object3 = resKey.head();
            NamedLambdaVariable namedLambdaVariable3 = keyParam;
            if (object3 == null ? namedLambdaVariable3 != null : !object3.equals(namedLambdaVariable3)) {
                LambdaFunction keyFunc = new LambdaFunction((Expression)resKey.head(), (Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{keyParam}))), LambdaFunction$.MODULE$.apply$default$3());
                expression2 = new ArrayTransform(new MapKeys(nullCheckedInput), keyFunc);
            } else {
                expression2 = new MapKeys(nullCheckedInput);
            }
            MapKeys newKeys = expression2;
            Object object4 = resValue.head();
            NamedLambdaVariable namedLambdaVariable4 = valueParam;
            if (object4 == null ? namedLambdaVariable4 != null : !object4.equals(namedLambdaVariable4)) {
                LambdaFunction valueFunc = new LambdaFunction((Expression)resValue.head(), (Seq<NamedExpression>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NamedLambdaVariable[]{valueParam}))), LambdaFunction$.MODULE$.apply$default$3());
                expression = new ArrayTransform(new MapValues(nullCheckedInput), valueFunc);
            } else {
                expression = new MapValues(nullCheckedInput);
            }
            MapValues newValues = expression;
            MapFromArrays x$19 = new MapFromArrays(newKeys, newValues);
            String x$20 = expected.name();
            ExprId x$21 = Alias$.MODULE$.apply$default$3(x$19, x$20);
            Seq<String> x$22 = Alias$.MODULE$.apply$default$4(x$19, x$20);
            Option<Metadata> x$23 = Alias$.MODULE$.apply$default$5(x$19, x$20);
            Seq<String> x$24 = Alias$.MODULE$.apply$default$6(x$19, x$20);
            Some some = new Some((Object)new Alias(x$19, x$20, x$21, x$22, x$23, x$24));
            none$ = some;
            return none$;
        }
        none$ = None$.MODULE$;
        return none$;
    }

    public Expression checkCastOverflowInTableInsert(Cast cast, String columnName) {
        return this.canCauseCastOverflow(cast) ? new CheckOverflowInTableInsert(cast, columnName) : cast;
    }

    private boolean containsIntegralOrDecimalType(DataType dt) {
        boolean bl;
        block5: {
            DataType dataType;
            block6: {
                while (true) {
                    boolean bl2;
                    if (bl2 = (dataType = dt) instanceof IntegralType ? true : dataType instanceof DecimalType) {
                        bl = true;
                        break block5;
                    }
                    if (dataType instanceof ArrayType) {
                        ArrayType arrayType = (ArrayType)dataType;
                        dt = arrayType.elementType();
                        continue;
                    }
                    if (!(dataType instanceof MapType)) break block6;
                    MapType mapType = (MapType)dataType;
                    if (this.containsIntegralOrDecimalType(mapType.keyType())) break;
                    dt = mapType.valueType();
                }
                bl = true;
                break block5;
            }
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                bl = ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)sf -> BoxesRunTime.boxToBoolean((boolean)TableOutputResolver$.MODULE$.containsIntegralOrDecimalType(sf.dataType())));
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private boolean canCauseCastOverflow(Cast cast) {
        return this.containsIntegralOrDecimalType(cast.dataType()) && !Cast$.MODULE$.canUpCast(cast.child().dataType(), cast.dataType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCompatible(Attribute tableAttr, NamedExpression queryExpr) {
        if (!DataTypeUtils$.MODULE$.sameType(tableAttr.dataType(), ((Expression)((Object)queryExpr)).dataType())) return false;
        String string = tableAttr.name();
        String string2 = queryExpr.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Metadata metadata = tableAttr.metadata();
        Metadata metadata2 = queryExpr.metadata();
        if (metadata == null) {
            if (metadata2 == null) return true;
            return false;
        } else {
            if (!metadata.equals(metadata2)) return false;
            return true;
        }
    }

    private Option<NamedExpression> checkField(String tableName, Attribute tableAttr, NamedExpression queryExpr, boolean byName, SQLConf conf, Function1<String, BoxedUnit> addError, Seq<String> colPath) {
        LazyRef outputField$lzy = new LazyRef();
        boolean attrTypeHasCharVarchar = CharVarcharUtils$.MODULE$.hasCharVarchar(tableAttr.dataType());
        DataType attrTypeWithoutCharVarchar = attrTypeHasCharVarchar ? CharVarcharUtils$.MODULE$.replaceCharVarcharWithString(tableAttr.dataType()) : tableAttr.dataType();
        boolean canWriteExpr = this.canWrite(tableName, ((Expression)((Object)queryExpr)).dataType(), attrTypeWithoutCharVarchar, byName, conf, addError, colPath);
        return canWriteExpr ? this.outputField$1(outputField$lzy, tableAttr, queryExpr, conf, colPath, attrTypeWithoutCharVarchar, attrTypeHasCharVarchar) : None$.MODULE$;
    }

    private Expression cast(Expression expr, DataType expectedType, SQLConf conf, String colName) {
        Expression expression;
        Enumeration.Value value = conf.storeAssignmentPolicy();
        Enumeration.Value value2 = SQLConf$StoreAssignmentPolicy$.MODULE$.ANSI();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Cast cast = Cast$.MODULE$.apply(expr, expectedType, (Option<String>)Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()), true);
            cast.setTagValue(Cast$.MODULE$.BY_TABLE_INSERTION(), BoxedUnit.UNIT);
            expression = this.checkCastOverflowInTableInsert(cast, colName);
        } else {
            Enumeration.Value value4 = SQLConf$StoreAssignmentPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            expression = !(value4 != null ? !value4.equals(value5) : value5 != null) ? Cast$.MODULE$.apply(expr, expectedType, (Option<String>)Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()), false) : new Cast(expr, expectedType, (Option<String>)Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()), Cast$.MODULE$.apply$default$4());
        }
        return expression;
    }

    public static final /* synthetic */ boolean $anonfun$reorderColumnsByName$2(SQLConf conf$1, Attribute expectedCol$1, NamedExpression col) {
        return BoxesRunTime.unboxToBoolean((Object)conf$1.resolver().apply((Object)col.name(), (Object)expectedCol$1.name()));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Option $anonfun$reorderColumnsByName$1(Seq inputCols$1, SQLConf conf$1, Seq colPath$1, boolean fillDefaultValue$1, String tableName$1, HashSet matchedCols$1, Function1 addError$1, Attribute expectedCol) {
        block9: {
            block11: {
                block12: {
                    block10: {
                        block8: {
                            matched = (Seq)inputCols$1.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$reorderColumnsByName$2$adapted(org.apache.spark.sql.internal.SQLConf org.apache.spark.sql.catalyst.expressions.Attribute org.apache.spark.sql.catalyst.expressions.NamedExpression ), (Lorg/apache/spark/sql/catalyst/expressions/NamedExpression;)Ljava/lang/Object;)((SQLConf)conf$1, (Attribute)expectedCol));
                            newColPath = (Seq)colPath$1.$colon$plus((Object)expectedCol.name());
                            if (!matched.isEmpty()) break block8;
                            v0 = defaultExpr = fillDefaultValue$1 != false ? ResolveDefaultColumns$.MODULE$.getDefaultValueExprOrNullLit(expectedCol, conf$1.useNullsForMissingDefaultColumnValues()) : None$.MODULE$;
                            if (defaultExpr.isEmpty()) {
                                throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableCannotFindDataError(tableName$1, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper((Seq<String>)newColPath).quoted());
                            }
                            v1 = defaultExpr;
                            break block9;
                        }
                        if (matched.length() > 1) {
                            throw QueryCompilationErrors$.MODULE$.incompatibleDataToTableAmbiguousColumnNameError(tableName$1, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper((Seq<String>)newColPath).quoted());
                        }
                        matchedCols$1.$plus$eq((Object)((NamedExpression)matched.head()).name());
                        expectedName = expectedCol.name();
                        var15_12 = (NamedExpression)matched.head();
                        if (var15_12 instanceof Attribute) {
                            var16_13 = (Attribute)var15_12;
                            var9_14 /* !! */  = var16_13.withName(expectedName);
                        } else if (var15_12 instanceof Alias) {
                            var17_15 = (Alias)var15_12;
                            var9_14 /* !! */  = var17_15.withName(expectedName);
                        } else {
                            var9_14 /* !! */  = var15_12;
                        }
                        matchedCol /* !! */  = var9_14 /* !! */ ;
                        var18_17 = new Tuple2((Object)((Expression)matchedCol /* !! */ ).dataType(), (Object)expectedCol.dataType());
                        if (var18_17 == null) break block10;
                        matchedType = (DataType)var18_17._1();
                        expectedType = (DataType)var18_17._2();
                        if (!(matchedType instanceof StructType)) break block10;
                        var21_20 = (StructType)matchedType;
                        if (!(expectedType instanceof StructType)) break block10;
                        var22_21 = (StructType)expectedType;
                        var8_22 = TableOutputResolver$.MODULE$.resolveStructType(tableName$1, matchedCol /* !! */ , var21_20, expectedCol, var22_21, true, conf$1, (Function1<String, BoxedUnit>)addError$1, (Seq<String>)newColPath);
                        break block11;
                    }
                    if (var18_17 == null) break block12;
                    matchedType = (DataType)var18_17._1();
                    expectedType = (DataType)var18_17._2();
                    if (!(matchedType instanceof ArrayType)) break block12;
                    var25_25 = (ArrayType)matchedType;
                    if (!(expectedType instanceof ArrayType)) break block12;
                    var26_26 = (ArrayType)expectedType;
                    var8_22 = TableOutputResolver$.MODULE$.resolveArrayType(tableName$1, matchedCol /* !! */ , var25_25, expectedCol, var26_26, true, conf$1, (Function1<String, BoxedUnit>)addError$1, (Seq<String>)newColPath);
                    break block11;
                }
                if (var18_17 == null) ** GOTO lbl-1000
                matchedType = (DataType)var18_17._1();
                expectedType = (DataType)var18_17._2();
                if (!(matchedType instanceof MapType)) ** GOTO lbl-1000
                var29_29 = (MapType)matchedType;
                if (expectedType instanceof MapType) {
                    var30_30 = (MapType)expectedType;
                    var8_22 = TableOutputResolver$.MODULE$.resolveMapType(tableName$1, matchedCol /* !! */ , var29_29, expectedCol, var30_30, true, conf$1, (Function1<String, BoxedUnit>)addError$1, (Seq<String>)newColPath);
                } else lbl-1000:
                // 3 sources

                {
                    var8_22 = TableOutputResolver$.MODULE$.checkField(tableName$1, expectedCol, matchedCol /* !! */ , true, conf$1, (Function1<String, BoxedUnit>)addError$1, (Seq<String>)newColPath);
                }
            }
            v1 = var8_22;
        }
        return v1;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ IterableOnce $anonfun$resolveColumnsByPosition$7(Seq colPath$2, String tableName$2, SQLConf conf$2, Function1 addError$2, Tuple2 x0$1) {
        block4: {
            block2: {
                block5: {
                    block3: {
                        var7_5 = x0$1;
                        if (var7_5 == null) break block2;
                        inputCol = (NamedExpression)var7_5._1();
                        expectedCol = (Attribute)var7_5._2();
                        newColPath = (Seq)colPath$2.$colon$plus((Object)expectedCol.name());
                        var11_9 = new Tuple2((Object)((Expression)inputCol).dataType(), (Object)expectedCol.dataType());
                        if (var11_9 == null) break block3;
                        inputType = (DataType)var11_9._1();
                        expectedType = (DataType)var11_9._2();
                        if (!(inputType instanceof StructType)) break block3;
                        var14_12 = (StructType)inputType;
                        if (!(expectedType instanceof StructType)) break block3;
                        var15_13 = (StructType)expectedType;
                        var6_14 = TableOutputResolver$.MODULE$.resolveStructType(tableName$2, (Expression)inputCol, var14_12, expectedCol, var15_13, false, conf$2, (Function1<String, BoxedUnit>)addError$2, (Seq<String>)newColPath);
                        break block4;
                    }
                    if (var11_9 == null) break block5;
                    inputType = (DataType)var11_9._1();
                    expectedType = (DataType)var11_9._2();
                    if (!(inputType instanceof ArrayType)) break block5;
                    var18_17 = (ArrayType)inputType;
                    if (!(expectedType instanceof ArrayType)) break block5;
                    var19_18 = (ArrayType)expectedType;
                    var6_14 = TableOutputResolver$.MODULE$.resolveArrayType(tableName$2, (Expression)inputCol, var18_17, expectedCol, var19_18, false, conf$2, (Function1<String, BoxedUnit>)addError$2, (Seq<String>)newColPath);
                    break block4;
                }
                if (var11_9 == null) ** GOTO lbl-1000
                inputType = (DataType)var11_9._1();
                expectedType = (DataType)var11_9._2();
                if (!(inputType instanceof MapType)) ** GOTO lbl-1000
                var22_21 = (MapType)inputType;
                if (expectedType instanceof MapType) {
                    var23_22 = (MapType)expectedType;
                    var6_14 = TableOutputResolver$.MODULE$.resolveMapType(tableName$2, (Expression)inputCol, var22_21, expectedCol, var23_22, false, conf$2, (Function1<String, BoxedUnit>)addError$2, (Seq<String>)newColPath);
                } else lbl-1000:
                // 3 sources

                {
                    var6_14 = TableOutputResolver$.MODULE$.checkField(tableName$2, expectedCol, inputCol, false, conf$2, (Function1<String, BoxedUnit>)addError$2, (Seq<String>)newColPath);
                }
                break block4;
            }
            throw new MatchError((Object)var7_5);
        }
        var5_23 = var6_14;
        return var5_23;
    }

    private final /* synthetic */ Some outputField$lzycompute$1(LazyRef outputField$lzy$1, Attribute tableAttr$1, NamedExpression queryExpr$1, SQLConf conf$3, Seq colPath$3, DataType attrTypeWithoutCharVarchar$1, boolean attrTypeHasCharVarchar$1) {
        Some some;
        LazyRef lazyRef = outputField$lzy$1;
        synchronized (lazyRef) {
            Some some2;
            if (outputField$lzy$1.initialized()) {
                some2 = (Some)outputField$lzy$1.value();
            } else {
                Some some3;
                if (this.isCompatible(tableAttr$1, queryExpr$1)) {
                    if (this.requiresNullChecks((Expression)((Object)queryExpr$1), tableAttr$1, conf$3)) {
                        AssertNotNull assertNotNull;
                        AssertNotNull x$1 = assertNotNull = new AssertNotNull((Expression)((Object)queryExpr$1), (Seq<String>)colPath$3);
                        String x$2 = tableAttr$1.name();
                        Some x$3 = new Some((Object)tableAttr$1.metadata());
                        ExprId x$4 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                        Seq<String> x$5 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                        Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
                        Some some4 = new Some((Object)new Alias(x$1, x$2, x$4, x$5, (Option<Metadata>)x$3, x$6));
                        some3 = some4;
                    } else {
                        some3 = new Some((Object)queryExpr$1);
                    }
                } else {
                    Expression exprWithStrLenCheck;
                    Expression nullCheckedQueryExpr = this.checkNullability((Expression)((Object)queryExpr$1), tableAttr$1, conf$3, (Seq<String>)colPath$3);
                    Expression casted = this.cast(nullCheckedQueryExpr, attrTypeWithoutCharVarchar$1, conf$3, CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper((Seq<String>)colPath$3).quoted());
                    Expression x$7 = exprWithStrLenCheck = conf$3.charVarcharAsString() || !attrTypeHasCharVarchar$1 ? casted : CharVarcharUtils$.MODULE$.stringLengthCheck(casted, tableAttr$1.dataType());
                    String x$8 = tableAttr$1.name();
                    Some x$9 = new Some((Object)tableAttr$1.metadata());
                    ExprId x$10 = Alias$.MODULE$.apply$default$3(x$7, x$8);
                    Seq<String> x$11 = Alias$.MODULE$.apply$default$4(x$7, x$8);
                    Seq<String> x$12 = Alias$.MODULE$.apply$default$6(x$7, x$8);
                    Some some5 = new Some((Object)new Alias(x$7, x$8, x$10, x$11, (Option<Metadata>)x$9, x$12));
                    some3 = some5;
                }
                some2 = (Some)outputField$lzy$1.initialize((Object)some3);
            }
            some = some2;
        }
        return some;
    }

    private final Some outputField$1(LazyRef outputField$lzy$1, Attribute tableAttr$1, NamedExpression queryExpr$1, SQLConf conf$3, Seq colPath$3, DataType attrTypeWithoutCharVarchar$1, boolean attrTypeHasCharVarchar$1) {
        return outputField$lzy$1.initialized() ? (Some)outputField$lzy$1.value() : this.outputField$lzycompute$1(outputField$lzy$1, tableAttr$1, queryExpr$1, conf$3, colPath$3, attrTypeWithoutCharVarchar$1, attrTypeHasCharVarchar$1);
    }

    private TableOutputResolver$() {
    }

    public static final /* synthetic */ Object $anonfun$reorderColumnsByName$2$adapted(SQLConf conf$1, Attribute expectedCol$1, NamedExpression col) {
        return BoxesRunTime.boxToBoolean((boolean)TableOutputResolver$.$anonfun$reorderColumnsByName$2(conf$1, expectedCol$1, col));
    }
}

