/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.BinaryRandomForestClassificationSummaryImpl;
import org.apache.spark.ml.classification.BinaryRandomForestClassificationTrainingSummary;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.classification.RandomForestClassificationModel$;
import org.apache.spark.ml.classification.RandomForestClassificationSummary;
import org.apache.spark.ml.classification.RandomForestClassificationSummaryImpl;
import org.apache.spark.ml.classification.RandomForestClassificationTrainingSummary;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.RandomForestClassifierParams;
import org.apache.spark.ml.tree.RandomForestParams;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t}h\u0001B\u0017/\u0001eB\u0001b\u001b\u0001\u0003\u0006\u0004%\t\u0005\u001c\u0005\t}\u0002\u0011\t\u0011)A\u0005[\"Q\u0011\u0011\u0001\u0001\u0003\u0006\u0004%I!a\u0001\t\u0015\u00055\u0001A!A!\u0002\u0013\t)\u0001\u0003\u0006\u0002\u0010\u0001\u0011)\u0019!C!\u0003#A!\"a\b\u0001\u0005\u0003\u0005\u000b\u0011BA\n\u0011)\t\u0019\u0003\u0001BC\u0002\u0013\u0005\u0013\u0011\u0003\u0005\u000b\u0003O\u0001!\u0011!Q\u0001\n\u0005M\u0001\u0002CA\u0016\u0001\u0011\u0005\u0001'!\f\t\u0011\u0005-\u0002\u0001\"\u00011\u0003{Aq!!\u0011\u0001\t\u0003\n\u0019\u0001\u0003\u0006\u0002N\u0001A)\u0019!C\u0005\u0003\u001fBq!!\u0017\u0001\t\u0003\ny\u0005C\u0004\u0002^\u0001!\t%a\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j!9\u00111\u000f\u0001\u0005\u0002\u0005U\u0004bBAT\u0001\u0011\u0005\u0013\u0011\u0016\u0005\b\u0003{\u0003A\u0011IA`\u0011\u001d\tI\u000f\u0001C!\u0003WDq!a>\u0001\t#\nI\u0010C\u0004\u0002\u0000\u0002!\tE!\u0001\t\u000f\tU\u0001\u0001\"\u0011\u0003\u0018!Q!1\u0004\u0001\t\u0006\u0004%\tA!\b\t\u0011\t\u0005\u0002\u0001\"\u00011\u0005GAqAa\u000e\u0001\t\u0003\u0012IdB\u0004\u0003J9B\tAa\u0013\u0007\r5r\u0003\u0012\u0001B'\u0011\u001d\tYc\u0007C\u0001\u0005SBqAa\u001b\u001c\t\u0003\u0012i\u0007C\u0004\u0003xm!\tE!\u001f\u0007\u000f\t\u00055\u0004A\u000e\u0003\u0004\"I!QQ\u0010\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\b\u0003WyB\u0011\u0001BD\u0011\u001d\u0011yi\bC)\u0005#3aAa'\u001c\t\tu\u0005bBA\u0016G\u0011\u0005!q\u0014\u0005\n\u0005G\u001b#\u0019!C\u0005\u0005KC\u0001B!-$A\u0003%!q\u0015\u0005\n\u0005g\u001b#\u0019!C\u0005\u0005KC\u0001B!.$A\u0003%!q\u0015\u0005\b\u0005o\u001aC\u0011\tB\\\u0011!\u0011Yl\u0007C\u0001a\tu\u0006B\u0003Bn7E\u0005I\u0011\u0001\u0019\u0003^\"I!\u0011_\u000e\u0002\u0002\u0013%!1\u001f\u0002 %\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d'BA\u00181\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!!\r\u001a\u0002\u00055d'BA\u001a5\u0003\u0015\u0019\b/\u0019:l\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\u0004\u0001M9\u0001AO#L#^+\u0007\u0003B\u001e=}\u0011k\u0011AL\u0005\u0003{9\u0012\u0001\u0005\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017nY1uS>tWj\u001c3fYB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tM\u0001\u0007Y&t\u0017\r\\4\n\u0005\r\u0003%A\u0002,fGR|'\u000f\u0005\u0002<\u0001A\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nM\u0001\u0005iJ,W-\u0003\u0002K\u000f\na\"+\u00198e_64uN]3ti\u000ec\u0017m]:jM&,'\u000fU1sC6\u001c\bc\u0001$M\u001d&\u0011Qj\u0012\u0002\u0012)J,W-\u00128tK6\u0014G.Z'pI\u0016d\u0007CA\u001eP\u0013\t\u0001fFA\u0010EK\u000eL7/[8o)J,Wm\u00117bgNLg-[2bi&|g.T8eK2\u0004\"AU+\u000e\u0003MS!\u0001\u0016\u0019\u0002\tU$\u0018\u000e\\\u0005\u0003-N\u0013!\"\u0014'Xe&$\u0018M\u00197f!\tA&M\u0004\u0002Z?:\u0011!,X\u0007\u00027*\u0011A\fO\u0001\u0007yI|w\u000e\u001e \n\u0003y\u000bQa]2bY\u0006L!\u0001Y1\u0002\u000fA\f7m[1hK*\ta,\u0003\u0002dI\na1+\u001a:jC2L'0\u00192mK*\u0011\u0001-\u0019\t\u0004%\u001aD\u0017BA4T\u0005IA\u0015m\u001d+sC&t\u0017N\\4Tk6l\u0017M]=\u0011\u0005mJ\u0017B\u00016/\u0005%\u0012\u0016M\u001c3p[\u001a{'/Z:u\u00072\f7o]5gS\u000e\fG/[8o)J\f\u0017N\\5oON+X.\\1ss\u0006\u0019Q/\u001b3\u0016\u00035\u0004\"A\u001c:\u000f\u0005=\u0004\bC\u0001.b\u0013\t\t\u0018-\u0001\u0004Qe\u0016$WMZ\u0005\u0003gR\u0014aa\u0015;sS:<'BA9bQ\r\ta\u000f \t\u0003ojl\u0011\u0001\u001f\u0006\u0003sJ\n!\"\u00198o_R\fG/[8o\u0013\tY\bPA\u0003TS:\u001cW-I\u0001~\u0003\u0015\td&\u000e\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\t1H0\u0001\u0004`iJ,Wm]\u000b\u0003\u0003\u000b\u0001R!a\u0002\u0002\n9k\u0011!Y\u0005\u0004\u0003\u0017\t'!B!se\u0006L\u0018aB0ue\u0016,7\u000fI\u0001\f]Vlg)Z1ukJ,7/\u0006\u0002\u0002\u0014A!\u0011qAA\u000b\u0013\r\t9\"\u0019\u0002\u0004\u0013:$\b\u0006B\u0003w\u00037\t#!!\b\u0002\u000bErcG\f\u0019\u0002\u00199,XNR3biV\u0014Xm\u001d\u0011)\t\u00191\u00181D\u0001\u000b]Vl7\t\\1tg\u0016\u001c\bfA\u0004wy\u0006Ya.^7DY\u0006\u001c8/Z:!Q\rAa\u000f`\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013\u0011\u000by#a\r\u00026\u0005e\u0002\"B6\n\u0001\u0004i\u0007\u0006BA\u0018mrDq!!\u0001\n\u0001\u0004\t)\u0001C\u0004\u0002\u0010%\u0001\r!a\u0005)\u000b\u0005Ub/a\u0007\t\u000f\u0005\r\u0012\u00021\u0001\u0002\u0014!\"\u0011\u0011\b<})\u001d!\u0015qHA\"\u0003\u000bBq!!\u0011\u000b\u0001\u0004\t)!A\u0003ue\u0016,7\u000fC\u0004\u0002\u0010)\u0001\r!a\u0005\t\u000f\u0005\r\"\u00021\u0001\u0002\u0014!\"1B^A%C\t\tY%A\u00032]Qr\u0003'\u0001\u0007`iJ,WmV3jO\"$8/\u0006\u0002\u0002RA1\u0011qAA\u0005\u0003'\u0002B!a\u0002\u0002V%\u0019\u0011qK1\u0003\r\u0011{WO\u00197f\u0003-!(/Z3XK&<\u0007\u000e^:)\t51\u0018\u0011J\u0001\bgVlW.\u0019:z+\u0005A\u0007\u0006\u0002\bw\u0003G\n#!!\u001a\u0002\u000bMr\u0013G\f\u0019\u0002\u001b\tLg.\u0019:z'VlW.\u0019:z+\t\tY\u0007E\u0002<\u0003[J1!a\u001c/\u0005=\u0012\u0015N\\1ssJ\u000bg\u000eZ8n\r>\u0014Xm\u001d;DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8Ue\u0006Lg.\u001b8h'VlW.\u0019:zQ\u0011ya/a\u0019\u0002\u0011\u00154\u0018\r\\;bi\u0016$B!a\u001e\u0002~A\u00191(!\u001f\n\u0007\u0005mdFA\u0011SC:$w.\u001c$pe\u0016\u001cHo\u00117bgNLg-[2bi&|gnU;n[\u0006\u0014\u0018\u0010C\u0004\u0002\u0000A\u0001\r!!!\u0002\u000f\u0011\fG/Y:fiB\"\u00111QAJ!\u0019\t))a#\u0002\u00106\u0011\u0011q\u0011\u0006\u0004\u0003\u0013\u0013\u0014aA:rY&!\u0011QRAD\u0005\u001d!\u0015\r^1tKR\u0004B!!%\u0002\u00142\u0001A\u0001DAK\u0003{\n\t\u0011!A\u0003\u0002\u0005]%aA0%gE!\u0011\u0011TAP!\u0011\t9!a'\n\u0007\u0005u\u0015MA\u0004O_RD\u0017N\\4\u0011\t\u0005\u001d\u0011\u0011U\u0005\u0004\u0003G\u000b'aA!os\"\"\u0001C^A2\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BAV\u0003o\u0003B!!,\u000246\u0011\u0011q\u0016\u0006\u0005\u0003c\u000b9)A\u0003usB,7/\u0003\u0003\u00026\u0006=&AC*ueV\u001cG\u000fV=qK\"9\u0011\u0011X\tA\u0002\u0005-\u0016AB:dQ\u0016l\u0017\r\u000b\u0003\u0012m\u0006%\u0013!\u0003;sC:\u001chm\u001c:n)\u0011\t\t-!8\u0011\t\u0005\r\u0017q\u001b\b\u0005\u0003\u000b\f)N\u0004\u0003\u0002H\u0006Mg\u0002BAe\u0003#tA!a3\u0002P:\u0019!,!4\n\u0003]J!!\u000e\u001c\n\u0005M\"\u0014bAAEe%\u0019\u0001-a\"\n\t\u0005e\u00171\u001c\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1\u0001YAD\u0011\u001d\tyH\u0005a\u0001\u0003?\u0004D!!9\u0002fB1\u0011QQAF\u0003G\u0004B!!%\u0002f\u0012a\u0011q]Ao\u0003\u0003\u0005\tQ!\u0001\u0002\u0018\n\u0019q\f\n\u001b\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000fF\u0002?\u0003[Da!a<\u0014\u0001\u0004q\u0014\u0001\u00034fCR,(/Z:)\tM1\u00181_\u0011\u0003\u0003k\fQa\r\u00181]A\naC]1xeA\u0014xNY1cS2LG/_%o!2\f7-\u001a\u000b\u0004}\u0005m\bBBA\u007f)\u0001\u0007a(A\u0007sC^\u0004&/\u001a3jGRLwN\\\u0001\u0005G>\u0004\u0018\u0010F\u0002E\u0005\u0007AqA!\u0002\u0016\u0001\u0004\u00119!A\u0003fqR\u0014\u0018\r\u0005\u0003\u0003\n\t=QB\u0001B\u0006\u0015\r\u0011i\u0001M\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0005#\u0011YA\u0001\u0005QCJ\fW.T1qQ\u0011)b/!\u0013\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u001c\u0015\u0005-Y\fI%\u0001\ngK\u0006$XO]3J[B|'\u000f^1oG\u0016\u001cX#\u0001 )\u0007]1H0A\u0003u_>cG-\u0006\u0002\u0003&A!!q\u0005B\u001a\u001b\t\u0011IC\u0003\u0003\u0003,\t5\u0012!B7pI\u0016d'b\u0001%\u00030)\u0019!\u0011\u0007\u001a\u0002\u000b5dG.\u001b2\n\t\tU\"\u0011\u0006\u0002\u0012%\u0006tGm\\7G_J,7\u000f^'pI\u0016d\u0017!B<sSR,WC\u0001B\u001e!\r\u0011&QH\u0005\u0004\u0005\u007f\u0019&\u0001C'M/JLG/\u001a:)\te1(1I\u0011\u0003\u0005\u000b\nQA\r\u00181]ABC\u0001\u0001<\u0002J\u0005y\"+\u00198e_64uN]3ti\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005mZ2cB\u000e\u0003P\tU#1\f\t\u0005\u0003\u000f\u0011\t&C\u0002\u0003T\u0005\u0014a!\u00118z%\u00164\u0007\u0003\u0002*\u0003X\u0011K1A!\u0017T\u0005)iEJU3bI\u0006\u0014G.\u001a\t\u0005\u0005;\u00129'\u0004\u0002\u0003`)!!\u0011\rB2\u0003\tIwN\u0003\u0002\u0003f\u0005!!.\u0019<b\u0013\r\u0019'q\f\u000b\u0003\u0005\u0017\nAA]3bIV\u0011!q\u000e\t\u0005%\nED)C\u0002\u0003tM\u0013\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u0005;Y\u0014\u0019%\u0001\u0003m_\u0006$Gc\u0001#\u0003|!1!Q\u0010\u0010A\u00025\fA\u0001]1uQ\"\"aD\u001eB\"\u0005\u0015\u0012\u0016M\u001c3p[\u001a{'/Z:u\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\\,sSR,'oE\u0002 \u0005w\t\u0001\"\u001b8ti\u0006t7-\u001a\u000b\u0005\u0005\u0013\u0013i\tE\u0002\u0003\f~i\u0011a\u0007\u0005\u0007\u0005\u000b\u000b\u0003\u0019\u0001#\u0002\u0011M\fg/Z%na2$BAa%\u0003\u001aB!\u0011q\u0001BK\u0013\r\u00119*\u0019\u0002\u0005+:LG\u000f\u0003\u0004\u0003~\t\u0002\r!\u001c\u0002&%\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d'+Z1eKJ\u001c2a\tB8)\t\u0011\t\u000bE\u0002\u0003\f\u000e\n\u0011b\u00197bgNt\u0015-\\3\u0016\u0005\t\u001d\u0006\u0003\u0002BU\u0005_k!Aa+\u000b\t\t5&1M\u0001\u0005Y\u0006tw-C\u0002t\u0005W\u000b!b\u00197bgNt\u0015-\\3!\u00035!(/Z3DY\u0006\u001c8OT1nK\u0006qAO]3f\u00072\f7o\u001d(b[\u0016\u0004Cc\u0001#\u0003:\"1!QP\u0015A\u00025\fqA\u001a:p[>cG\rF\u0006E\u0005\u007f\u0013\u0019M!4\u0003X\ne\u0007b\u0002BaU\u0001\u0007!QE\u0001\t_2$Wj\u001c3fY\"9!Q\u0019\u0016A\u0002\t\u001d\u0017A\u00029be\u0016tG\u000fE\u0002<\u0005\u0013L1Aa3/\u0005Y\u0011\u0016M\u001c3p[\u001a{'/Z:u\u00072\f7o]5gS\u0016\u0014\bb\u0002BhU\u0001\u0007!\u0011[\u0001\u0014G\u0006$XmZ8sS\u000e\fGNR3biV\u0014Xm\u001d\t\b]\nM\u00171CA\n\u0013\r\u0011)\u000e\u001e\u0002\u0004\u001b\u0006\u0004\bbBA\u0012U\u0001\u0007\u00111\u0003\u0005\n\u0003\u001fQ\u0003\u0013!a\u0001\u0003'\t\u0011C\u001a:p[>cG\r\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011yN\u000b\u0003\u0002\u0014\t\u00058F\u0001Br!\u0011\u0011)O!<\u000e\u0005\t\u001d(\u0002\u0002Bu\u0005W\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005e\f\u0017\u0002\u0002Bx\u0005O\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011)\u0010\u0005\u0003\u0003*\n]\u0018\u0002\u0002B}\u0005W\u0013aa\u00142kK\u000e$\b\u0006B\u000ew\u0005\u0007BCA\u0007<\u0003D\u0001")
public class RandomForestClassificationModel
extends ProbabilisticClassificationModel<Vector, RandomForestClassificationModel>
implements RandomForestClassifierParams,
TreeEnsembleModel<DecisionTreeClassificationModel>,
MLWritable,
HasTrainingSummary<RandomForestClassificationTrainingSummary> {
    private double[] _treeWeights;
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeClassificationModel[] _trees;
    private final int numFeatures;
    private final int numClasses;
    private Option<RandomForestClassificationTrainingSummary> trainingSummary;
    private int totalNumNodes;
    private Param<String> impurity;
    private IntParam numTrees;
    private BooleanParam bootstrap;
    private DoubleParam subsamplingRate;
    private Param<String> featureSubsetStrategy;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static RandomForestClassificationModel load(String path) {
        return RandomForestClassificationModel$.MODULE$.load(path);
    }

    public static MLReader<RandomForestClassificationModel> read() {
        return RandomForestClassificationModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<RandomForestClassificationTrainingSummary> setSummary(Option<RandomForestClassificationTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams.getNumTrees$(this);
    }

    @Override
    public final boolean getBootstrap() {
        return RandomForestParams.getBootstrap$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public final Option<RandomForestClassificationTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<RandomForestClassificationTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    private int totalNumNodes$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final BooleanParam bootstrap() {
        return this.bootstrap;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$bootstrap_$eq(BooleanParam x$1) {
        this.bootstrap = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeClassificationModel[] _trees() {
        return this._trees;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public DecisionTreeClassificationModel[] trees() {
        return this._trees();
    }

    private double[] _treeWeights$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._treeWeights = (double[])Array$.MODULE$.fill(this._trees().length, (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0, (ClassTag)ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._treeWeights;
    }

    private double[] _treeWeights() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._treeWeights$lzycompute() : this._treeWeights;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public RandomForestClassificationTrainingSummary summary() {
        return (RandomForestClassificationTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public BinaryRandomForestClassificationTrainingSummary binarySummary() {
        BinaryRandomForestClassificationTrainingSummary binaryRandomForestClassificationTrainingSummary;
        RandomForestClassificationTrainingSummary randomForestClassificationTrainingSummary = this.summary();
        if (!(randomForestClassificationTrainingSummary instanceof BinaryRandomForestClassificationTrainingSummary)) {
            throw new RuntimeException(new StringBuilder(53).append("Cannot create a binary summary for a non-binary model").append(new StringBuilder(35).append("(numClasses=").append(this.numClasses()).append("), use summary instead.").toString()).toString());
        }
        BinaryRandomForestClassificationTrainingSummary binaryRandomForestClassificationTrainingSummary2 = binaryRandomForestClassificationTrainingSummary = (BinaryRandomForestClassificationTrainingSummary)randomForestClassificationTrainingSummary;
        return binaryRandomForestClassificationTrainingSummary2;
    }

    public RandomForestClassificationSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        Tuple3 tuple33 = tuple32;
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple33._1();
        String probabilityColName2 = (String)tuple33._2();
        String predictionColName2 = (String)tuple33._3();
        return this.numClasses() > 2 ? new RandomForestClassificationSummaryImpl(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), weightColName) : new BinaryRandomForestClassificationSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), weightColName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block0: {
            StructType outputSchema = super.transformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Dataset<Row> outputData = super.transform(dataset);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RandomForestClassificationModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RandomForestClassificationModel.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1(RandomForestClassificationModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1(RandomForestClassificationModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> this.predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1(null)));
            dataset2 = outputData.withColumn(this.$(this.leafCol()), leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})), outputSchema.apply(this.$(this.leafCol())).metadata());
        } else {
            void var3_3;
            dataset2 = var3_3;
        }
        return dataset2;
    }

    @Override
    public Vector predictRaw(Vector features) {
        double[] votes = (double[])Array$.MODULE$.ofDim(this.numClasses(), (ClassTag)ClassTag$.MODULE$.Double());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)tree -> {
            RandomForestClassificationModel.$anonfun$predictRaw$1(this, features, votes, tree);
            return BoxedUnit.UNIT;
        });
        return Vectors$.MODULE$.dense(votes);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (!(vector instanceof DenseVector)) {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in RandomForestClassificationModel: raw2probabilityInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector = (DenseVector)vector;
        ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    @Override
    public RandomForestClassificationModel copy(ParamMap extra) {
        return (RandomForestClassificationModel)((Model)this.copyValues(new RandomForestClassificationModel(this.uid(), this._trees(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(0).append(new StringBuilder(63).append("RandomForestClassificationModel: uid=").append(this.uid()).append(", numTrees=").append(this.getNumTrees()).append(", numClasses=").append(this.numClasses()).append(", ").toString()).append(new StringBuilder(12).append("numFeatures=").append(this.numFeatures()).toString()).toString();
    }

    private Vector featureImportances$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), TreeEnsembleModel$.MODULE$.featureImportances$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public RandomForestModel toOld() {
        return new RandomForestModel(Algo$.MODULE$.Classification(), (DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$5 -> x$5.toOld(), ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
    }

    @Override
    public MLWriter write() {
        return new RandomForestClassificationModelWriter(this);
    }

    public static final /* synthetic */ void $anonfun$predictRaw$1(RandomForestClassificationModel $this, Vector features$1, double[] votes$1, DecisionTreeClassificationModel tree) {
        double[] classCounts = tree.rootNode().predictImpl(features$1).impurityStats().stats();
        double total = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(classCounts).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        if (total != 0.0) {
            for (int i = 0; i < $this.numClasses(); ++i) {
                int n = i;
                votes$1[n] = votes$1[n] + classCounts[i] / total;
            }
        }
    }

    public RandomForestClassificationModel(String uid, DecisionTreeClassificationModel[] _trees, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        RandomForestParams.$init$(this);
        TreeEnsembleClassifierParams.$init$(this);
        TreeClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])_trees)), (Function0 & Serializable)() -> "RandomForestClassificationModel requires at least 1 tree.");
        Statics.releaseFence();
    }

    public RandomForestClassificationModel(DecisionTreeClassificationModel[] trees, int numFeatures, int numClasses) {
        this(Identifiable$.MODULE$.randomUID("rfc"), trees, numFeatures, numClasses);
    }

    private static class RandomForestClassificationModelReader
    extends MLReader<RandomForestClassificationModel> {
        private final String className = RandomForestClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeClassificationModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public RandomForestClassificationModel load(String path) {
            DefaultParamsReader.Metadata metadata;
            Tuple2[] treesData;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    treesData = (Tuple2[])tuple3._2();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            Tuple2[] tuple2Array = treesData;
            Tuple2 tuple2 = new Tuple2((Object)metadata, (Object)tuple2Array);
            Tuple2 tuple22 = tuple2;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple22._1();
            Tuple2[] treesData2 = (Tuple2[])tuple22._2();
            int numFeatures = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numClasses = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numClasses")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeClassificationModel[] trees = (DecisionTreeClassificationModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesData2), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeClassificationModel tree = new DecisionTreeClassificationModel(treeMetadata.uid(), root, numFeatures, numClasses);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeClassificationModel decisionTreeClassificationModel = tree;
                return decisionTreeClassificationModel;
            }, ClassTag$.MODULE$.apply(DecisionTreeClassificationModel.class));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(46).append("RandomForestClassificationModel.load expected ").append(numTrees).toString()).append(new StringBuilder(42).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString()).toString());
            RandomForestClassificationModel model = new RandomForestClassificationModel(metadata3.uid(), trees, numFeatures, numClasses);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class RandomForestClassificationModelWriter
    extends MLWriter {
        private final RandomForestClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numClasses"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numClasses())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public RandomForestClassificationModelWriter(RandomForestClassificationModel instance) {
            this.instance = instance;
        }
    }
}

