/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.IOException;
import java.io.Serializable;
import java.util.ServiceLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.CompactedEventLogFileWriter;
import org.apache.spark.deploy.history.CompactionResult;
import org.apache.spark.deploy.history.CompactionResultCode$;
import org.apache.spark.deploy.history.EventFilter;
import org.apache.spark.deploy.history.EventFilter$;
import org.apache.spark.deploy.history.EventFilterBuilder;
import org.apache.spark.deploy.history.EventLogFileReader$;
import org.apache.spark.deploy.history.EventLogFileWriter$;
import org.apache.spark.deploy.history.RollingEventLogFilesWriter$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ReplayListenerBus;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001\u0002\b\u0010\u0001iA\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\"B\"\u0001\t\u0003!\u0005\"\u0002'\u0001\t\u0003i\u0005\"\u00022\u0001\t\u0013\u0019\u0007\"\u00025\u0001\t\u0013I\u0007\"B;\u0001\t\u00131\b\u0002CA\u000b\u0001\u0011\u0005q\"a\u0006\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u0011Q\b\u0001\u0005\n\u0005}\"!F#wK:$Hj\\4GS2,7i\\7qC\u000e$xN\u001d\u0006\u0003!E\tq\u0001[5ti>\u0014\u0018P\u0003\u0002\u0013'\u00051A-\u001a9m_fT!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\r\u00011$\t\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011\u001a\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0019\u001a#a\u0002'pO\u001eLgnZ\u0001\ngB\f'o[\"p]\u001a\u0004\"!\u000b\u0016\u000e\u0003MI!aK\n\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u00035bI>|\u0007oQ8oMB\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0005G>tgM\u0003\u00023+\u00051\u0001.\u00193p_BL!\u0001N\u0018\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\t17\u000f\u0005\u00028s5\t\u0001H\u0003\u00026c%\u0011!\b\u000f\u0002\u000b\r&dWmU=ti\u0016l\u0017\u0001E7bq\u001aKG.Z:U_J+G/Y5o!\taR(\u0003\u0002?;\t\u0019\u0011J\u001c;\u00021\r|W\u000e]1di&|g\u000e\u00165sKNDw\u000e\u001c3TG>\u0014X\r\u0005\u0002\u001d\u0003&\u0011!)\b\u0002\u0007\t>,(\r\\3\u0002\rqJg.\u001b;?)\u0019)u\tS%K\u0017B\u0011a\tA\u0007\u0002\u001f!)qE\u0002a\u0001Q!)AF\u0002a\u0001[!)QG\u0002a\u0001m!)1H\u0002a\u0001y!)qH\u0002a\u0001\u0001\u000691m\\7qC\u000e$HC\u0001(R!\t1u*\u0003\u0002Q\u001f\t\u00012i\\7qC\u000e$\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0006%\u001e\u0001\raU\u0001\u000eKZ,g\u000e\u001e'pO\u001aKG.Z:\u0011\u0007QcvL\u0004\u0002V5:\u0011a+W\u0007\u0002/*\u0011\u0001,G\u0001\u0007yI|w\u000e\u001e \n\u0003yI!aW\u000f\u0002\u000fA\f7m[1hK&\u0011QL\u0018\u0002\u0004'\u0016\f(BA.\u001e!\t9\u0004-\u0003\u0002bq\tQa)\u001b7f'R\fG/^:\u0002%\u0005\u001c8/\u001a:u!J,7m\u001c8eSRLwN\u001c\u000b\u0003I\u001e\u0004\"\u0001H3\n\u0005\u0019l\"\u0001B+oSRDQA\u0015\u0005A\u0002M\u000b!#\u001b8ji&\fG.\u001b>f\u0005VLG\u000eZ3sgR\u0019!N\\8\u0011\u0007Qc6\u000e\u0005\u0002GY&\u0011Qn\u0004\u0002\u0013\u000bZ,g\u000e\u001e$jYR,'OQ;jY\u0012,'\u000fC\u00036\u0013\u0001\u0007a\u0007C\u0003q\u0013\u0001\u0007\u0011/A\u0003gS2,7\u000fE\u0002U9J\u0004\"aN:\n\u0005QD$\u0001\u0002)bi\"\fabY1mGVd\u0017\r^3TG>\u0014X\r\u0006\u0002Ao\")\u0001P\u0003a\u0001s\u0006)1\u000f^1ugB\u0019!0a\u0004\u000f\u0007m\fYAD\u0002}\u0003\u0013q1!`A\u0004\u001d\rq\u0018Q\u0001\b\u0004\u007f\u0006\rab\u0001,\u0002\u0002%\t\u0001$\u0003\u0002\u0017/%\u0011A#F\u0005\u0003%MI!\u0001E\t\n\u0007\u00055q\"A\u0006Fm\u0016tGOR5mi\u0016\u0014\u0018\u0002BA\t\u0003'\u0011\u0001CR5mi\u0016\u00148\u000b^1uSN$\u0018nY:\u000b\u0007\u00055q\"A\u0004sK^\u0014\u0018\u000e^3\u0015\r\u0005e\u0011\u0011FA\u001b!\u0011\tY\"a\t\u000f\t\u0005u\u0011q\u0004\t\u0003-vI1!!\t\u001e\u0003\u0019\u0001&/\u001a3fM&!\u0011QEA\u0014\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011E\u000f\t\u000f\u0005-2\u00021\u0001\u0002.\u00059a-\u001b7uKJ\u001c\b\u0003\u0002+]\u0003_\u00012ARA\u0019\u0013\r\t\u0019d\u0004\u0002\f\u000bZ,g\u000e\u001e$jYR,'\u000fC\u0003S\u0017\u0001\u00071+A\u000bdY\u0016\fg.\u001e9D_6\u0004\u0018m\u0019;fI\u001aKG.Z:\u0015\u0007\u0011\fY\u0004C\u0003q\u0019\u0001\u00071+\u0001\ngS:$g)\u001b7fgR{7i\\7qC\u000e$HcA*\u0002B!)!+\u0004a\u0001'\u0002")
public class EventLogFileCompactor
implements Logging {
    private final SparkConf sparkConf;
    private final Configuration hadoopConf;
    private final FileSystem fs;
    private final int maxFilesToRetain;
    private final double compactionThresholdScore;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CompactionResult compact(Seq<FileStatus> eventLogFiles) {
        CompactionResult compactionResult;
        this.assertPrecondition(eventLogFiles);
        if (eventLogFiles.length() < this.maxFilesToRetain) {
            return new CompactionResult(CompactionResultCode$.MODULE$.NOT_ENOUGH_FILES(), (Option<Object>)None$.MODULE$);
        }
        Seq<FileStatus> filesToCompact = this.findFilesToCompact(eventLogFiles);
        if (filesToCompact.isEmpty()) {
            compactionResult = new CompactionResult(CompactionResultCode$.MODULE$.NOT_ENOUGH_FILES(), (Option<Object>)None$.MODULE$);
        } else {
            Seq<EventFilterBuilder> builders = this.initializeBuilders(this.fs, (Seq<Path>)((Seq)filesToCompact.map((Function1 & Serializable)x$1 -> x$1.getPath())));
            Seq filters = (Seq)builders.map((Function1 & Serializable)x$2 -> x$2.createFilter());
            double minScore = BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)filters.flatMap((Function1 & Serializable)x$3 -> x$3.statistics())).map((Function1 & Serializable)stats -> BoxesRunTime.boxToDouble((double)this.calculateScore(stats)))).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$));
            if (minScore < this.compactionThresholdScore) {
                compactionResult = new CompactionResult(CompactionResultCode$.MODULE$.LOW_SCORE_FOR_COMPACTION(), (Option<Object>)None$.MODULE$);
            } else {
                this.rewrite((Seq<EventFilter>)filters, filesToCompact);
                this.cleanupCompactedFiles(filesToCompact);
                compactionResult = new CompactionResult(CompactionResultCode$.MODULE$.SUCCESS(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)RollingEventLogFilesWriter$.MODULE$.getEventLogFileIndex(((FileStatus)filesToCompact.last()).getPath().getName()))));
            }
        }
        return compactionResult;
    }

    private void assertPrecondition(Seq<FileStatus> eventLogFiles) {
        Seq idxCompactedFiles = (Seq)((IterableOps)eventLogFiles.zipWithIndex()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)EventLogFileCompactor.$anonfun$assertPrecondition$1(x0$1)));
        Predef$.MODULE$.require(idxCompactedFiles.size() < 2 && idxCompactedFiles.headOption().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)EventLogFileCompactor.$anonfun$assertPrecondition$2(x$4))), (Function0 & Serializable)() -> "The number of compact files should be at most 1, and should be placed first if exists.");
    }

    private Seq<EventFilterBuilder> initializeBuilders(FileSystem fs, Seq<Path> files) {
        ReplayListenerBus bus = new ReplayListenerBus();
        Seq builders = ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(EventFilterBuilder.class, Utils$.MODULE$.getContextOrSparkClassLoader())).asScala()).toSeq();
        builders.foreach((Function1 & Serializable)listener -> {
            bus.addListener(listener);
            return BoxedUnit.UNIT;
        });
        files.foreach((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)EventLogFileCompactor.$anonfun$initializeBuilders$2(fs, bus, log)));
        return builders;
    }

    private double calculateScore(EventFilter.FilterStatistics stats) {
        return (double)(stats.totalTasks() - stats.liveTasks()) * 1.0 / (double)stats.totalTasks();
    }

    public String rewrite(Seq<EventFilter> filters, Seq<FileStatus> eventLogFiles) {
        Predef$.MODULE$.require(eventLogFiles.nonEmpty());
        Path lastIndexEventLogPath = ((FileStatus)eventLogFiles.last()).getPath();
        CompactedEventLogFileWriter logWriter = new CompactedEventLogFileWriter(lastIndexEventLogPath, "dummy", (Option<String>)None$.MODULE$, lastIndexEventLogPath.getParent().toUri(), this.sparkConf, this.hadoopConf);
        logWriter.start();
        eventLogFiles.foreach((Function1 & Serializable)file -> {
            EventFilter$.MODULE$.applyFilterToFile(this.fs, (Seq<EventFilter>)filters, file.getPath(), (Function2<String, SparkListenerEvent, BoxedUnit>)(Function2 & Serializable)(line, x$5) -> {
                logWriter$1.writeEvent(line, true);
                return BoxedUnit.UNIT;
            }, (Function2<String, SparkListenerEvent, BoxedUnit>)(Function2 & Serializable)(x$6, x$7) -> {
                EventLogFileCompactor.$anonfun$rewrite$3(x$6, x$7);
                return BoxedUnit.UNIT;
            }, (Function1<String, BoxedUnit>)(Function1 & Serializable)line -> {
                logWriter$1.writeEvent(line, true);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        logWriter.stop();
        return logWriter.logPath();
    }

    private void cleanupCompactedFiles(Seq<FileStatus> files) {
        files.foreach((Function1 & Serializable)file -> {
            EventLogFileCompactor.$anonfun$cleanupCompactedFiles$1(this, file);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<FileStatus> findFilesToCompact(Seq<FileStatus> eventLogFiles) {
        int numNormalEventLogFiles = EventLogFileWriter$.MODULE$.isCompacted(((FileStatus)eventLogFiles.head()).getPath()) ? eventLogFiles.length() - 1 : eventLogFiles.length();
        return numNormalEventLogFiles > this.maxFilesToRetain ? (Seq)eventLogFiles.dropRight(this.maxFilesToRetain) : (Seq)package$.MODULE$.Seq().empty();
    }

    public static final /* synthetic */ boolean $anonfun$assertPrecondition$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        FileStatus file = (FileStatus)tuple2._1();
        boolean bl = EventLogFileWriter$.MODULE$.isCompacted(file.getPath());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$assertPrecondition$2(Tuple2 x$4) {
        return x$4._2$mcI$sp() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$initializeBuilders$2(FileSystem fs$1, ReplayListenerBus bus$1, Path log) {
        return BoxesRunTime.unboxToBoolean(Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> EventLogFileReader$.MODULE$.openEventLog(log, fs$1), (Function1 & Serializable)in -> BoxesRunTime.boxToBoolean((boolean)bus$1.replay(in, log.getName(), bus$1.replay$default$3(), bus$1.replay$default$4()))));
    }

    public static final /* synthetic */ void $anonfun$rewrite$3(String x$6, SparkListenerEvent x$7) {
    }

    public static final /* synthetic */ void $anonfun$cleanupCompactedFiles$1(EventLogFileCompactor $this, FileStatus file) {
        block2: {
            boolean deleted = false;
            try {
                deleted = $this.fs.delete(file.getPath(), true);
            }
            catch (IOException iOException) {}
            if (deleted) break block2;
            $this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Failed to remove ").append(file.getPath()).append(" / skip removing.").toString());
        }
    }

    public EventLogFileCompactor(SparkConf sparkConf, Configuration hadoopConf, FileSystem fs, int maxFilesToRetain, double compactionThresholdScore) {
        this.sparkConf = sparkConf;
        this.hadoopConf = hadoopConf;
        this.fs = fs;
        this.maxFilesToRetain = maxFilesToRetain;
        this.compactionThresholdScore = compactionThresholdScore;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(maxFilesToRetain > 0, (Function0 & Serializable)() -> "Max event log files to retain should be higher than 0.");
    }
}

