/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.read.streaming.ContinuousPartitionReader;
import org.apache.spark.sql.connector.read.streaming.PartitionOffset;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamPartitionOffset;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4AAF\f\u0001M!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003@\u0011!1\u0005A!A!\u0002\u00139\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011-\u0003!\u0011!Q\u0001\n1CQa\u0014\u0001\u0005\u0002ACq\u0001\u0017\u0001A\u0002\u0013%\u0011\fC\u0004[\u0001\u0001\u0007I\u0011B.\t\r\u0005\u0004\u0001\u0015)\u0003@\u0011\u001d\u0011\u0007A1A\u0005\neCaa\u0019\u0001!\u0002\u0013y\u0004b\u00023\u0001\u0001\u0004%I!\u0017\u0005\bK\u0002\u0001\r\u0011\"\u0003g\u0011\u0019A\u0007\u0001)Q\u0005\u007f!9\u0011\u000e\u0001a\u0001\n\u0013Q\u0007bB6\u0001\u0001\u0004%I\u0001\u001c\u0005\u0007]\u0002\u0001\u000b\u0015\u0002\u001d\t\u000b=\u0004A\u0011\t9\t\u000bQ\u0004A\u0011I;\t\u000bY\u0004A\u0011I<\t\u000ba\u0004A\u0011I=\u0003GI\u000bG/Z*ue\u0016\fWnQ8oi&tWo\\;t!\u0006\u0014H/\u001b;j_:\u0014V-\u00193fe*\u0011\u0001$G\u0001\u000bG>tG/\u001b8v_V\u001c(B\u0001\u000e\u001c\u0003%\u0019HO]3b[&twM\u0003\u0002\u001d;\u0005IQ\r_3dkRLwN\u001c\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0004\u0001\u001dz\u0003C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0011a\u0017M\\4\u000b\u00031\nAA[1wC&\u0011a&\u000b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007A2\u0004(D\u00012\u0015\tQ\"G\u0003\u00024i\u0005!!/Z1e\u0015\t)T$A\u0005d_:tWm\u0019;pe&\u0011q'\r\u0002\u001a\u0007>tG/\u001b8v_V\u001c\b+\u0019:uSRLwN\u001c*fC\u0012,'\u000f\u0005\u0002:y5\t!H\u0003\u0002<;\u0005A1-\u0019;bYf\u001cH/\u0003\u0002>u\tY\u0011J\u001c;fe:\fGNU8x\u0003)\u0019H/\u0019:u-\u0006dW/\u001a\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0005\u0019>tw-A\u0006ti\u0006\u0014H\u000fV5nK6\u001b\u0018A\u00049beRLG/[8o\u0013:$W\r\u001f\t\u0003\u0001\"K!!S!\u0003\u0007%sG/A\u0005j]\u000e\u0014X-\\3oi\u0006i!o\\<t!\u0016\u00148+Z2p]\u0012\u0004\"\u0001Q'\n\u00059\u000b%A\u0002#pk\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0007#N#VKV,\u0011\u0005I\u0003Q\"A\f\t\u000by2\u0001\u0019A \t\u000b\u00153\u0001\u0019A \t\u000b\u00193\u0001\u0019A$\t\u000b)3\u0001\u0019A \t\u000b-3\u0001\u0019\u0001'\u0002\u00199,\u0007\u0010\u001e*fC\u0012$\u0016.\\3\u0016\u0003}\n\u0001C\\3yiJ+\u0017\r\u001a+j[\u0016|F%Z9\u0015\u0005q{\u0006C\u0001!^\u0013\tq\u0016I\u0001\u0003V]&$\bb\u00021\t\u0003\u0003\u0005\raP\u0001\u0004q\u0012\n\u0014!\u00048fqR\u0014V-\u00193US6,\u0007%A\tsK\u0006$G+[7f\u0013:\u001c'/Z7f]R\f!C]3bIRKW.Z%oGJ,W.\u001a8uA\u0005a1-\u001e:sK:$h+\u00197vK\u0006\u00012-\u001e:sK:$h+\u00197vK~#S-\u001d\u000b\u00039\u001eDq\u0001Y\u0007\u0002\u0002\u0003\u0007q(A\u0007dkJ\u0014XM\u001c;WC2,X\rI\u0001\u000bGV\u0014(/\u001a8u%><X#\u0001\u001d\u0002\u001d\r,(O]3oiJ{wo\u0018\u0013fcR\u0011A,\u001c\u0005\bAB\t\t\u00111\u00019\u0003-\u0019WO\u001d:f]R\u0014vn\u001e\u0011\u0002\t9,\u0007\u0010\u001e\u000b\u0002cB\u0011\u0001I]\u0005\u0003g\u0006\u0013qAQ8pY\u0016\fg.A\u0002hKR$\u0012\u0001O\u0001\u0006G2|7/\u001a\u000b\u00029\u0006Iq-\u001a;PM\u001a\u001cX\r\u001e\u000b\u0002uB\u0011\u0001g_\u0005\u0003yF\u0012q\u0002U1si&$\u0018n\u001c8PM\u001a\u001cX\r\u001e")
public class RateStreamContinuousPartitionReader
implements ContinuousPartitionReader<InternalRow> {
    private final int partitionIndex;
    private final long increment;
    private long nextReadTime;
    private final long readTimeIncrement;
    private long currentValue;
    private InternalRow currentRow;

    private long nextReadTime() {
        return this.nextReadTime;
    }

    private void nextReadTime_$eq(long x$1) {
        this.nextReadTime = x$1;
    }

    private long readTimeIncrement() {
        return this.readTimeIncrement;
    }

    private long currentValue() {
        return this.currentValue;
    }

    private void currentValue_$eq(long x$1) {
        this.currentValue = x$1;
    }

    private InternalRow currentRow() {
        return this.currentRow;
    }

    private void currentRow_$eq(InternalRow x$1) {
        this.currentRow = x$1;
    }

    public boolean next() {
        this.currentValue_$eq(this.currentValue() + this.increment);
        this.nextReadTime_$eq(this.nextReadTime() + this.readTimeIncrement());
        try {
            long toWaitMs = this.nextReadTime() - System.currentTimeMillis();
            while (toWaitMs > 0L) {
                Thread.sleep(toWaitMs);
                toWaitMs = this.nextReadTime() - System.currentTimeMillis();
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        this.currentRow_$eq(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.millisToMicros(this.nextReadTime())), BoxesRunTime.boxToLong((long)this.currentValue())})));
        return true;
    }

    public InternalRow get() {
        return this.currentRow();
    }

    public void close() {
    }

    public PartitionOffset getOffset() {
        return new RateStreamPartitionOffset(this.partitionIndex, this.currentValue(), this.nextReadTime());
    }

    public RateStreamContinuousPartitionReader(long startValue, long startTimeMs, int partitionIndex, long increment, double rowsPerSecond) {
        this.partitionIndex = partitionIndex;
        this.increment = increment;
        this.nextReadTime = startTimeMs;
        this.readTimeIncrement = (long)((double)1000 / rowsPerSecond);
        this.currentValue = startValue;
        this.currentRow = null;
    }
}

