/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RegExpCount$;
import org.apache.spark.sql.catalyst.expressions.RegExpExtractAll;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.Size;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str, regexp) - Returns a count of the number of times that the regular expression pattern `regexp` is matched in the string `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Steven Jones and Stephen Smith are the best players', 'Ste(v|ph)en');\n       2\n      > SELECT _FUNC_('abcdefghijklmnopqrstuvwxyz', '[a-z]{3}');\n       8\n  ", since="3.4.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u000e\u001d\u0001&B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u007f\u0001\u0011\t\u0012)A\u0005U!A\u0001\t\u0001BK\u0002\u0013\u0005a\b\u0003\u0005B\u0001\tE\t\u0015!\u0003+\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011!9\u0005\u0001#b\u0001\n\u0003r\u0004\"\u0002%\u0001\t\u0003J\u0005\"B+\u0001\t\u00032\u0006\"\u00021\u0001\t\u0003\n\u0007\"B5\u0001\t#R\u0007b\u00029\u0001\u0003\u0003%\t!\u001d\u0005\bi\u0002\t\n\u0011\"\u0001v\u0011!\t\t\u0001AI\u0001\n\u0003)\b\"CA\u0002\u0001\u0005\u0005I\u0011IA\u0003\u0011%\t)\u0002AA\u0001\n\u0003\t9\u0002C\u0005\u0002 \u0001\t\t\u0011\"\u0001\u0002\"!I\u0011Q\u0006\u0001\u0002\u0002\u0013\u0005\u0013q\u0006\u0005\n\u0003{\u0001\u0011\u0011!C\u0001\u0003\u007fA\u0011\"!\u0013\u0001\u0003\u0003%\t%a\u0013\b\u0013\u0005UD$!A\t\u0002\u0005]d\u0001C\u000e\u001d\u0003\u0003E\t!!\u001f\t\r\t+B\u0011AAD\u0011%\tI)FA\u0001\n\u000b\nY\tC\u0005\u0002\u000eV\t\t\u0011\"!\u0002\u0010\"I\u0011QS\u000b\u0002\u0002\u0013\u0005\u0015q\u0013\u0005\n\u0003S+\u0012\u0011!C\u0005\u0003W\u00131BU3h\u000bb\u00048i\\;oi*\u0011QDH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002 A\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001U9\nDG\u000f\t\u0003W1j\u0011\u0001H\u0005\u0003[q\u0011!\"\u0012=qe\u0016\u001c8/[8o!\tYs&\u0003\u000219\t\u0011\"+\u001e8uS6,'+\u001a9mC\u000e,\u0017M\u00197f!\tY#'\u0003\u000249\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdGA\u0004Qe>$Wo\u0019;\u0011\u0005UZ\u0014B\u0001\u001f7\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003)\nQ\u0001\\3gi\u0002\nQA]5hQR\faA]5hQR\u0004\u0013A\u0002\u001fj]&$h\bF\u0002E\u000b\u001a\u0003\"a\u000b\u0001\t\u000bu*\u0001\u0019\u0001\u0016\t\u000b\u0001+\u0001\u0019\u0001\u0016\u0002\u0017I,\u0007\u000f\\1dK6,g\u000e^\u0001\u000baJ,G\u000f^=OC6,W#\u0001&\u0011\u0005-\u0013fB\u0001'Q!\tie'D\u0001O\u0015\ty\u0005&\u0001\u0004=e>|GOP\u0005\u0003#Z\na\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011KN\u0001\tG\"LG\u000e\u001a:f]V\tq\u000bE\u0002Y;*r!!W.\u000f\u00055S\u0016\"A\u001c\n\u0005q3\u0014a\u00029bG.\fw-Z\u0005\u0003=~\u00131aU3r\u0015\taf'\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0019\t\u00041v\u001b\u0007C\u00013h\u001b\u0005)'B\u00014!\u0003\u0015!\u0018\u0010]3t\u0013\tAWM\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0003\t.DQ\u0001\u001c\u0006A\u00025\f1B\\3x\u0007\"LG\u000e\u001a:f]B\u0019\u0001L\u001c\u0016\n\u0005=|&AC%oI\u0016DX\rZ*fc\u0006!1m\u001c9z)\r!%o\u001d\u0005\b{-\u0001\n\u00111\u0001+\u0011\u001d\u00015\u0002%AA\u0002)\nabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001wU\tQsoK\u0001y!\tIh0D\u0001{\u0015\tYH0A\u0005v]\u000eDWmY6fI*\u0011QPN\u0001\u000bC:tw\u000e^1uS>t\u0017BA@{\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0001\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0011\u0001\u00026bm\u0006L1aUA\u0006\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u0002E\u00026\u00037I1!!\b7\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\u0019#!\u000b\u0011\u0007U\n)#C\u0002\u0002(Y\u00121!\u00118z\u0011%\tY\u0003EA\u0001\u0002\u0004\tI\"A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003c\u0001b!a\r\u0002:\u0005\rRBAA\u001b\u0015\r\t9DN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001e\u0003k\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011IA$!\r)\u00141I\u0005\u0004\u0003\u000b2$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003W\u0011\u0012\u0011!a\u0001\u0003G\ta!Z9vC2\u001cH\u0003BA!\u0003\u001bB\u0011\"a\u000b\u0014\u0003\u0003\u0005\r!a\t)/\u0001\t\t&a\u0016\u0002Z\u0005u\u0013qLA2\u0003K\nI'a\u001b\u0002p\u0005E\u0004cA\u0016\u0002T%\u0019\u0011Q\u000b\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111L\u0001\u0002$)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJd\u0003E]3hKb\u0004\u0018\u0006I\u0017!%\u0016$XO\u001d8tA\u0005\u00043m\\;oi\u0002zg\r\t;iK\u0002rW/\u001c2fe\u0002zg\r\t;j[\u0016\u001c\b\u0005\u001e5bi\u0002\"\b.\u001a\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t\u0007\u0005]1ui\u0016\u0014h\u000e\t1sK\u001e,\u0007\u0010\u001d1!SN\u0004S.\u0019;dQ\u0016$\u0007%\u001b8!i\",\u0007e\u001d;sS:<\u0007\u0005Y:ue\u0002t#\u0002\t\u0011\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018EAA1\u0003\u0005\u0015$\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tiJ\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>tgF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011sK\u001e,\u0007\u0010\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004#/\u001a9sKN,g\u000e^5oO\u0002\n\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]:\u0002C\u000b[3!e\u0016<W\r\u001f\u0011tiJLgn\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002\n'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\u0015\u00064\u0018\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u001a\u0002\u0003\u0007S\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*uKZ,g\u000e\t&p]\u0016\u001c\b%\u00198eAM#X\r\u001d5f]\u0002\u001aV.\u001b;iA\u0005\u0014X\r\t;iK\u0002\u0012Wm\u001d;!a2\f\u00170\u001a:tO1\u0002se\u0015;fQYd\b\u000f[\u0015f]\u001eJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n'm\u00193fM\u001eD\u0017N[6m[:|\u0007/\u001d:tiV4x\u000f_={O1\u0002seW1.uv[8'`\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001B$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u00055\u0014!B\u001a/i9\u0002\u0014!B4s_V\u0004\u0018EAA:\u00031\u0019HO]5oO~3WO\\2t\u0003-\u0011VmZ#ya\u000e{WO\u001c;\u0011\u0005-*2\u0003B\u000b\u0002|i\u0002r!! \u0002\u0004*RC)\u0004\u0002\u0002\u0000)\u0019\u0011\u0011\u0011\u001c\u0002\u000fI,h\u000e^5nK&!\u0011QQA@\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003o\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000f\tQ!\u00199qYf$R\u0001RAI\u0003'CQ!\u0010\rA\u0002)BQ\u0001\u0011\rA\u0002)\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u001a\u0006\u0015\u0006#B\u001b\u0002\u001c\u0006}\u0015bAAOm\t1q\n\u001d;j_:\u0004R!NAQU)J1!a)7\u0005\u0019!V\u000f\u001d7fe!A\u0011qU\r\u0002\u0002\u0003\u0007A)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0016\t\u0005\u0003\u0013\ty+\u0003\u0003\u00022\u0006-!AB(cU\u0016\u001cG\u000f")
public class RegExpCount
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Expression right;
    private final Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(RegExpCount regExpCount) {
        return RegExpCount$.MODULE$.unapply(regExpCount);
    }

    public static Function1<Tuple2<Expression, Expression>, RegExpCount> tupled() {
        return RegExpCount$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RegExpCount>> curried() {
        return RegExpCount$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        RegExpCount regExpCount = this;
        synchronized (regExpCount) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression left() {
        return this.left;
    }

    public Expression right() {
        return this.right;
    }

    private Expression replacement$lzycompute() {
        RegExpCount regExpCount = this;
        synchronized (regExpCount) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = new Size(new RegExpExtractAll(this.left(), this.right(), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)0))), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "regexp_count";
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)new .colon.colon((Object)this.left(), (List)new .colon.colon((Object)this.right(), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public RegExpCount withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1));
    }

    public RegExpCount copy(Expression left, Expression right) {
        return new RegExpCount(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RegExpCount";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpCount)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpCount regExpCount = (RegExpCount)x$1;
        Expression expression = this.left();
        Expression expression2 = regExpCount.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = regExpCount.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!regExpCount.canEqual(this)) return false;
        return true;
    }

    public RegExpCount(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

