/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DoublesArrayAccessor;
import org.apache.datasketches.quantiles.DoublesBufferAccessor;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.DoublesUpdateImpl;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;

final class DoublesMergeImpl {
    private DoublesMergeImpl() {
    }

    static void mergeInto(DoublesSketch src, UpdateDoublesSketch tgt) {
        long srcBitPattern;
        int tgtCombBufItemCap;
        int srcK = src.getK();
        int tgtK = tgt.getK();
        long srcN = src.getN();
        long tgtN = tgt.getN();
        if (srcK != tgtK) {
            DoublesMergeImpl.downSamplingMergeInto(src, tgt);
            return;
        }
        DoublesSketchAccessor srcSketchBuf = DoublesSketchAccessor.wrap(src);
        long nFinal = tgtN + srcN;
        for (int i = 0; i < srcSketchBuf.numItems(); ++i) {
            tgt.update(srcSketchBuf.get(i));
        }
        int spaceNeeded = DoublesUpdateImpl.getRequiredItemCapacity(tgtK, nFinal);
        if (spaceNeeded > (tgtCombBufItemCap = tgt.getCombinedBufferItemCapacity())) {
            tgt.growCombinedBuffer(tgtCombBufItemCap, spaceNeeded);
        }
        DoublesArrayAccessor scratch2KAcc = DoublesArrayAccessor.initialize(2 * tgtK);
        assert (srcBitPattern == srcN / (2L * (long)srcK));
        DoublesSketchAccessor tgtSketchBuf = DoublesSketchAccessor.wrap(tgt, true);
        long newTgtBitPattern = tgt.getBitPattern();
        int srcLvl = 0;
        for (srcBitPattern = src.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                newTgtBitPattern = DoublesUpdateImpl.inPlacePropagateCarry(srcLvl, srcSketchBuf.setLevel(srcLvl), scratch2KAcc, false, tgtK, tgtSketchBuf, newTgtBitPattern);
            }
            ++srcLvl;
        }
        if (tgt.isDirect() && nFinal > 0L) {
            WritableMemory mem = tgt.getMemory();
            mem.clearBits(3L, (byte)4);
        }
        tgt.putN(nFinal);
        tgt.putBitPattern(newTgtBitPattern);
        assert (tgt.getN() / (2L * (long)tgtK) == tgt.getBitPattern());
        double srcMax = src.getMaxValue();
        srcMax = Double.isNaN(srcMax) ? Double.NEGATIVE_INFINITY : srcMax;
        double srcMin = src.getMinValue();
        srcMin = Double.isNaN(srcMin) ? Double.POSITIVE_INFINITY : srcMin;
        double tgtMax = tgt.getMaxValue();
        tgtMax = Double.isNaN(tgtMax) ? Double.NEGATIVE_INFINITY : tgtMax;
        double tgtMin = tgt.getMinValue();
        tgtMin = Double.isNaN(tgtMin) ? Double.POSITIVE_INFINITY : tgtMin;
        tgt.putMaxValue(Math.max(srcMax, tgtMax));
        tgt.putMinValue(Math.min(srcMin, tgtMin));
    }

    static void downSamplingMergeInto(DoublesSketch src, UpdateDoublesSketch tgt) {
        int curCombBufCap;
        int srcK = src.getK();
        int tgtK = tgt.getK();
        long tgtN = tgt.getN();
        if (srcK % tgtK != 0) {
            throw new SketchesArgumentException("source.getK() must equal target.getK() * 2^(nonnegative integer).");
        }
        int downFactor = srcK / tgtK;
        Util.checkIfPowerOf2(downFactor, "source.getK()/target.getK() ratio");
        int lgDownFactor = Integer.numberOfTrailingZeros(downFactor);
        if (src.isEmpty()) {
            return;
        }
        DoublesSketchAccessor srcSketchBuf = DoublesSketchAccessor.wrap(src);
        long nFinal = tgtN + src.getN();
        for (int i = 0; i < srcSketchBuf.numItems(); ++i) {
            tgt.update(srcSketchBuf.get(i));
        }
        int spaceNeeded = DoublesUpdateImpl.getRequiredItemCapacity(tgtK, nFinal);
        if (spaceNeeded > (curCombBufCap = tgt.getCombinedBufferItemCapacity())) {
            tgt.growCombinedBuffer(curCombBufCap, spaceNeeded);
        }
        DoublesArrayAccessor scratch2KAcc = DoublesArrayAccessor.initialize(2 * tgtK);
        DoublesArrayAccessor downScratchKAcc = DoublesArrayAccessor.initialize(tgtK);
        DoublesSketchAccessor tgtSketchBuf = DoublesSketchAccessor.wrap(tgt, true);
        long newTgtBitPattern = tgt.getBitPattern();
        int srcLvl = 0;
        for (long srcBitPattern = src.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                DoublesMergeImpl.justZipWithStride(srcSketchBuf.setLevel(srcLvl), downScratchKAcc, tgtK, downFactor);
                newTgtBitPattern = DoublesUpdateImpl.inPlacePropagateCarry(srcLvl + lgDownFactor, downScratchKAcc, scratch2KAcc, false, tgtK, tgtSketchBuf, newTgtBitPattern);
                tgt.putBitPattern(newTgtBitPattern);
            }
            ++srcLvl;
        }
        if (tgt.isDirect() && nFinal > 0L) {
            WritableMemory mem = tgt.getMemory();
            mem.clearBits(3L, (byte)4);
        }
        tgt.putN(nFinal);
        assert (tgt.getN() / (2L * (long)tgtK) == newTgtBitPattern);
        double srcMax = src.getMaxValue();
        srcMax = Double.isNaN(srcMax) ? Double.NEGATIVE_INFINITY : srcMax;
        double srcMin = src.getMinValue();
        srcMin = Double.isNaN(srcMin) ? Double.POSITIVE_INFINITY : srcMin;
        double tgtMax = tgt.getMaxValue();
        tgtMax = Double.isNaN(tgtMax) ? Double.NEGATIVE_INFINITY : tgtMax;
        double tgtMin = tgt.getMinValue();
        double d = tgtMin = Double.isNaN(tgtMin) ? Double.POSITIVE_INFINITY : tgtMin;
        if (srcMax > tgtMax) {
            tgt.putMaxValue(srcMax);
        }
        if (srcMin < tgtMin) {
            tgt.putMinValue(srcMin);
        }
    }

    private static void justZipWithStride(DoublesBufferAccessor bufA, DoublesBufferAccessor bufC, int kC, int stride) {
        int randomOffset;
        int a = randomOffset = DoublesSketch.rand.nextInt(stride);
        for (int c = 0; c < kC; ++c) {
            bufC.set(c, bufA.get(a));
            a += stride;
        }
    }
}

