/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.hadoop.hive.common.type.HiveDecimal;

public class RoundUtils {
    private RoundUtils() {
    }

    public static double round(double input, int scale) {
        if (Double.isNaN(input) || Double.isInfinite(input)) {
            return input;
        }
        return BigDecimal.valueOf(input).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static double bround(double input, int scale) {
        if (Double.isNaN(input) || Double.isInfinite(input)) {
            return input;
        }
        return BigDecimal.valueOf(input).setScale(scale, RoundingMode.HALF_EVEN).doubleValue();
    }

    public static long round(long input, int scale) {
        return BigDecimal.valueOf(input).setScale(scale, RoundingMode.HALF_UP).longValue();
    }

    public static long bround(long input, int scale) {
        return BigDecimal.valueOf(input).setScale(scale, RoundingMode.HALF_EVEN).longValue();
    }

    public static HiveDecimal round(HiveDecimal input, int scale) {
        return input.setScale(scale, 4);
    }

    public static HiveDecimal bround(HiveDecimal input, int scale) {
        return input.setScale(scale, 6);
    }
}

